/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.Context;
import com.bmc.ctmconvert.GenericConvertor;
import com.bmc.ctmconvert.GenericCreator;
import com.bmc.ctmconvert.MultiDataSupplier;
import com.bmc.ctmconvert.base.AssesmentReportAdapter;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.convertor.Convertor;
import com.bmc.ctmconvert.dataimport.DynamicDataImportPanel;
import com.bmc.ctmconvert.dataimport.EntriesImporter;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.VendorImporter;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.rule.RulesProvider;
import com.bmc.ctmconvert.rule.XmlRulesProvider;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.settings.Feature;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.sourceDefinitions.GeneralSourceDefinitions;
import com.bmc.ctmconvert.xml.ElementWalker;
import com.bmc.ctmconvert.xml.MultiElementWalker;
import com.bmc.ctmconvert.xml.XmlWalker;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AppData
implements VendorData {
    public String getName() {
        return "SelfConversionBuilder";
    }

    public String getDisplayName() {
        return "Self Conversion Builder";
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Other;
    }

    public DataImportVendor getDataImport() {
        return new DynamicDataImportPanel(this.generateImporter(), "");
    }

    private EntriesImporter generateImporter() {
        ImportEntryList entries = this.getImportEntries();
        Path destinationPath = Paths.get(ConversionEntitiesService.getCurrentProjectDataDirectory(), new String[0]);
        return new VendorImporter(entries, destinationPath);
    }

    public CliImporter getCLIImporter() {
        return null;
    }

    public BasePanel getAssessmentReport(String path) {
        return new AssesmentReportAdapter();
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) throws ConvertorCancelClickException {
        try {
            this.initWorkspace();
            return this.createSourceDefinitions();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void initWorkspace() {
        Workspace createWorkspace = this.createWorkspace();
        Context.setWorkspace(createWorkspace);
    }

    Workspace createWorkspace() {
        return new Workspace();
    }

    SourceDefinitions createSourceDefinitions() throws IOException {
        RulesProvider rulesProvider = this.getRulesProvider();
        GenericCreator creator = new GenericCreator(rulesProvider);
        Path xmlDir = this.getInputXmlPath();
        MultiDataSupplier dataSuplier = new MultiDataSupplier(xmlDir);
        List<Supplier<InputStream>> suplier = dataSuplier.suplyData();
        List<XmlWalker> walkers = suplier.stream().map(ElementWalker::new).collect(Collectors.toList());
        MultiElementWalker walker = new MultiElementWalker(walkers);
        GenericConvertor convertor = creator.createConvertor(walker);
        GeneralSourceDefinitions sourceDefinitions = new GeneralSourceDefinitions((Convertor)convertor, (IWorkspace)Context.getWorkspace().getWorkspace());
        return sourceDefinitions;
    }

    RulesProvider getRulesProvider() {
        InputStream rules = this.getRules();
        return new XmlRulesProvider(rules);
    }

    private InputStream getRules() {
        InputStream configurationRules;
        try {
            Path configurationFilePath = this.getDataSourceDir().resolve("XmlConversionRules.xml");
            configurationRules = Files.newInputStream(configurationFilePath, new OpenOption[0]);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            throw new RuntimeException(e);
        }
        return configurationRules;
    }

    public boolean shouldBeLoaded() {
        return SettingsTable.instance().getProperty((Feature)SettingsBooleanKeys.ENABLE_CONVERSION_BUILDER);
    }

    public Path getInputXmlPath() {
        ImportEntry xmlFileEntry = this.getImportEntries().first();
        String xmlFileName = xmlFileEntry.getDestinationFileName();
        return this.getDataSourceDir().resolve(xmlFileName);
    }

    protected Path getDataSourceDir() {
        return Paths.get(ConversionEntitiesService.getCurrentProjectDataDirectory(), new String[0]);
    }
}

