/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class SCLsTrackerOfMEMBERs {
    private static BufferedWriter m_writer;
    private static final String m_sSeparator = "************************";
    private static final String m_sSCLName = "SCL NAME : ";
    private static int m_iNumMEMBERs;
    public static String m_fileName;
    private static HashMap<String, ArrayList<String>> m_SCL_MEMBERsList;

    public static String getMEMBERsFileName() {
        return m_fileName;
    }

    public static int getNumberOfMEMBERsOfAllSCLs() {
        return m_iNumMEMBERs;
    }

    public static void initSCLsTrackerOfMEMBERs(String sFileName) {
        m_fileName = sFileName;
        if (m_SCL_MEMBERsList.size() > 0) {
            m_SCL_MEMBERsList.clear();
        }
        try {
            m_writer = new BufferedWriter(new FileWriter(m_fileName));
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in SCLsTrackerOfMEMBERs - initSCLsTrackerOfMEMBERs");
            ExceptionHandler.writeToExceptionFile((String)("Error while creating a file : " + m_fileName));
            ExceptionHandler.writeToExceptionFile((String)("Exception : " + String.valueOf(e)));
        }
    }

    public static void writeDataToFile(String sSCLName, ArrayList<String> listOfMEMBERs) {
        if (null != m_writer) {
            try {
                if (null != listOfMEMBERs) {
                    m_iNumMEMBERs += listOfMEMBERs.size();
                }
                m_writer.write(m_sSCLName + sSCLName);
                m_writer.newLine();
                for (String sNameOfMEMBER : listOfMEMBERs) {
                    m_writer.write(sNameOfMEMBER);
                    m_writer.newLine();
                }
                m_writer.write(m_sSeparator);
                m_writer.newLine();
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((String)"Error in SCLsTrackerOfMEMBERs - writeDataToFile");
                ExceptionHandler.writeToExceptionFile((String)("Error while writing to file : " + m_fileName));
                ExceptionHandler.writeToExceptionFile((String)("Exception : " + String.valueOf(e)));
            }
        }
    }

    public static void closeSCLsTrackerOfMEMBERs() {
        if (null != m_writer) {
            try {
                m_writer.close();
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((String)"Error in SCLsTrackerOfMEMBERs - closeSCLsTrackerOfMEMBERs");
                ExceptionHandler.writeToExceptionFile((String)("Error while closing file : " + m_fileName));
                ExceptionHandler.writeToExceptionFile((String)("Exception : " + String.valueOf(e)));
            }
        }
    }

    public static boolean loadMEMBERsFile() {
        if (null != m_SCL_MEMBERsList && m_SCL_MEMBERsList.size() > 0) {
            m_SCL_MEMBERsList.clear();
        }
        try {
            String sLine;
            BufferedReader reader = new BufferedReader(new FileReader(m_fileName));
            String sSCLName = "";
            ArrayList<String> tempArr = new ArrayList<String>();
            m_iNumMEMBERs = 0;
            while ((sLine = reader.readLine()) != null) {
                if (sLine.startsWith(m_sSCLName)) {
                    sSCLName = sLine.replaceAll(m_sSCLName, "");
                    continue;
                }
                if (sLine.equalsIgnoreCase(m_sSeparator)) {
                    m_SCL_MEMBERsList.put(sSCLName, tempArr);
                    tempArr = new ArrayList();
                    continue;
                }
                tempArr.add(sLine);
                ++m_iNumMEMBERs;
            }
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in SCLsTrackerOfMEMBERs - loadMEMBERsFile");
            ExceptionHandler.writeToExceptionFile((String)("Error while reading from file : " + m_fileName));
            ExceptionHandler.writeToExceptionFile((String)("Exception : " + String.valueOf(e)));
            return false;
        }
        return true;
    }

    public static ArrayList<String> getListOfAllMEMBERsOfSCL(String sSCLName) {
        return m_SCL_MEMBERsList.get(sSCLName);
    }

    public static ArrayList<String> getListOfAllSCLs() {
        return new ArrayList<String>(m_SCL_MEMBERsList.keySet());
    }

    static {
        m_iNumMEMBERs = 0;
        m_SCL_MEMBERsList = new HashMap();
    }
}

