/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.jobtrac.ConvertADRToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertAMRToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertAbstractToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertCCPFToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertRESOURCEToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertSCLToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertSCSToCSV;
import com.bmc.ctmconvert.jobtrac.JobTracAssessmentReport;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import com.bmc.ctmconvert.jobtrac.JobTracInputFileParser;
import com.bmc.ctmconvert.jobtrac.MergeCSVFilesIntoOne;
import com.bmc.ctmconvert.jobtrac.SCLsTrackerOfMEMBERs;
import java.util.ArrayList;

public class MiniRunExample {
    public static final long MB = 0x100000L;

    public static void main(String[] argsList) {
        ExceptionHandler.initExceptionFile();
        long startT = System.currentTimeMillis();
        long allT = 0L;
        long maxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        System.out.println("Total Memory : " + Runtime.getRuntime().totalMemory() / 0x100000L + "MB");
        System.out.println("Max Memory : " + maxMemory + "MB");
        System.out.println("Before running : Free Memory : " + Runtime.getRuntime().freeMemory() / 0x100000L + "MB");
        System.out.println("Buffer length (in lines) : " + JobTracGlobals.MaxBufferLines);
        System.out.println("...");
        String sPath = "C:\\JobTrac_Tests\\OutLargeAfterChanges\\";
        long startX = System.currentTimeMillis();
        JobTracInputFileParser inputParser = new JobTracInputFileParser("C:\\JobTrac_Tests\\Input.txt", sPath);
        try {
            inputParser.SplitJobTracFile();
        }
        catch (ConvertorCancelClickException e) {
            ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            e.printStackTrace();
        }
        allT = (System.currentTimeMillis() - startX) / 1000L;
        System.out.println("Split in seconds : " + allT);
        ArrayList<String> listOfFiles = inputParser.getListOfOutputFileNames();
        inputParser = null;
        startX = System.currentTimeMillis();
        SCLsTrackerOfMEMBERs.initSCLsTrackerOfMEMBERs(sPath + Globs.DIRSEP + "MEMBERs_SCL.txt");
        ConvertAbstractToCSV convertorToCSV = null;
        for (String string : listOfFiles) {
            String fullFileName = sPath + Globs.DIRSEP + string;
            String filePath = sPath + Globs.DIRSEP;
            boolean bIsSCLFile = false;
            if (string.startsWith("ADR_")) {
                convertorToCSV = new ConvertADRToCSV(fullFileName, filePath + "ADR_Tables.csv");
            } else if (string.startsWith("AMR_")) {
                convertorToCSV = new ConvertAMRToCSV(fullFileName, filePath + "AMR_Tables.csv");
            } else if (string.startsWith("CCPF_")) {
                convertorToCSV = new ConvertCCPFToCSV(fullFileName, fullFileName + "CCPF_Tables.csv");
            } else if (string.startsWith("SCS_")) {
                convertorToCSV = new ConvertSCSToCSV(fullFileName, filePath + "SCS_Tables.csv");
            } else if (string.startsWith("RES.")) {
                convertorToCSV = new ConvertRESOURCEToCSV(fullFileName, filePath + "RESOURCE_Table.csv");
            } else if (string.startsWith("SCL_")) {
                convertorToCSV = new ConvertSCLToCSV(fullFileName, fullFileName + ".csv");
                bIsSCLFile = true;
            }
            if (null == convertorToCSV) continue;
            convertorToCSV.doConversion();
            if (bIsSCLFile) {
                ConvertSCLToCSV tempSCL = (ConvertSCLToCSV)convertorToCSV;
                SCLsTrackerOfMEMBERs.writeDataToFile(string.replaceAll("SCL_", ""), tempSCL.getListOfMEMBERs());
            }
            convertorToCSV = null;
        }
        SCLsTrackerOfMEMBERs.closeSCLsTrackerOfMEMBERs();
        allT = (System.currentTimeMillis() - startX) / 1000L;
        System.out.println("Converting to CSVs in seconds : " + allT);
        ArrayList<String> listOfSCLs = new ArrayList<String>();
        for (String fileName : listOfFiles) {
            if (!fileName.startsWith("SCL_")) continue;
            listOfSCLs.add(sPath + Globs.DIRSEP + fileName + ".csv");
        }
        startX = System.currentTimeMillis();
        String string = sPath + Globs.DIRSEP + "MergedSCLs.csv";
        MergeCSVFilesIntoOne merger = new MergeCSVFilesIntoOne(listOfSCLs, string);
        merger.mergeFiles();
        merger = null;
        allT = (System.currentTimeMillis() - startX) / 1000L;
        System.out.println("Merge all CSVs of SCLs in 1 file in seconds : " + allT);
        allT = (System.currentTimeMillis() - startT) / 1000L;
        System.out.println("Total jobs found : " + ConvertSCLToCSV.getJobsCounter());
        System.out.println("Total Memory : " + Runtime.getRuntime().totalMemory() / 0x100000L);
        System.out.println("After running : Free Memory : " + Runtime.getRuntime().freeMemory() / 0x100000L);
        System.out.println("Total time in seconds : " + allT);
        JobTracAssessmentReport as = new JobTracAssessmentReport(sPath, "C:\\cmsynergy\\gazzam\\ccm_wa\\ctm1\\Conversion_DSGeorge_JobTrac_FP3\\Conversion_DS\\ctmconvert\\data_files\\AssessmentReportDescription.xml", sPath + Globs.DIRSEP + "EXC.EXC");
        as.setVisible(true);
    }
}

