/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.draftwriter.DraftFormat;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.jobtrac.JobtracDefs;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JobtracMemberModifier {
    private final JobtracDefs sourceDefs;
    private String m_membersFileNameInput = "inFileName";
    private boolean[] m_memberActions;
    private InputStream m_instream = null;
    private PrintStream m_outstream = null;
    private String m_INCLIB;
    private boolean m_INCLIB_DYNAMIC_included_for_member = false;
    private boolean m_INCLIB_JMF_included_for_member = false;
    String newLine = System.getProperty("line.separator");
    private final String JMF_VARNAME_DELIMITER = "['&(),/*%-+=?. ]";
    private final String ADI_CNTLNAME_DELIMITER = "[() ]";
    private final String AJO_OPERATOR_CHAR = "[IDAR]";
    private final String AJO_PROCESS_PERIOD = "SCHD";
    private final String MEMBER_AJO_IF_FORMAT = "%%%%IF %s %s %s";
    private RulesDataSet m_rules = null;
    private boolean foundGJTRABTR = false;
    private boolean underCont = false;
    private boolean underDDCont = false;
    private boolean underSysin = false;
    private boolean parmProcessed = false;
    private String parmOutLine = null;
    private HashMap<String, ArrayList<String>> m_jobMessages = new HashMap();
    private Integer MemberActionCount = MemberAction.values().length - 2;

    public JobtracMemberModifier(String membersFileNameInput, InputStream instream, PrintStream outstream, String incLib, MemberAction memberAction, RulesDataSet rulesDataSet, JobtracDefs sourceDefs) {
        this.m_outstream = outstream;
        this.m_instream = instream;
        this.m_membersFileNameInput = membersFileNameInput;
        this.m_rules = rulesDataSet;
        this.m_INCLIB = incLib;
        this.sourceDefs = sourceDefs;
        this.initMemberAction(memberAction);
        this.setMemberAction(memberAction);
    }

    private void initMemberAction(MemberAction memberAction) {
        this.m_memberActions = new boolean[this.MemberActionCount.intValue()];
        Integer i = 0;
        while (i < this.m_memberActions.length) {
            this.m_memberActions[i.intValue()] = memberAction == MemberAction.ALL;
            Integer n = i;
            i = i + 1;
        }
    }

    public void setMemberAction(MemberAction memberAction) {
        if (memberAction.ordinal() < this.m_memberActions.length) {
            this.m_memberActions[memberAction.ordinal()] = true;
        }
    }

    public void unsetMemberAction(MemberAction memberAction) {
        if (memberAction.ordinal() < this.m_memberActions.length) {
            this.m_memberActions[memberAction.ordinal()] = false;
        }
    }

    public boolean getMemberAction(MemberAction memberAction) {
        if (memberAction.ordinal() < this.m_memberActions.length) {
            return this.m_memberActions[memberAction.ordinal()];
        }
        return false;
    }

    public void modifyMembers() {
        Scanner inputLine = new Scanner(this.m_instream, DraftFormat.getDraftCharSet());
        Object outputLine = "";
        Integer lineNumber = 0;
        String currentMemberName = "";
        Integer membersCount = 0;
        while (inputLine.hasNext()) {
            String line = inputLine.nextLine();
            lineNumber = lineNumber + 1;
            Integer originalLen = line.length();
            outputLine = line.toString();
            if (line.startsWith("MEMBER NAME")) {
                String[] memberNameLine = line.split(" +");
                currentMemberName = memberNameLine[2];
                this.m_INCLIB_DYNAMIC_included_for_member = false;
                this.m_INCLIB_JMF_included_for_member = false;
                this.foundGJTRABTR = false;
                this.underCont = false;
                this.underSysin = false;
                if (this.parmOutLine != null) {
                    this.m_outstream.println(this.parmOutLine);
                    this.parmOutLine = null;
                }
                Integer n = membersCount;
                membersCount = membersCount + 1;
                if (this.getMemberAction(MemberAction.MEMBER_NAME)) {
                    outputLine = "./ ADD NAME=" + currentMemberName;
                }
            } else {
                if (this.getMemberAction(MemberAction.GJTRABTR) && (outputLine = this.modifyMemberGJTRABTR(currentMemberName, line)) != null) {
                    line = this.setOutlineLenToOriginalLen((String)outputLine, originalLen);
                }
                if (outputLine != null) {
                    if (this.getMemberAction(MemberAction.JMF)) {
                        outputLine = this.modifyMemberJMF(currentMemberName, line);
                        line = this.setOutlineLenToOriginalLen((String)outputLine, originalLen);
                    }
                    if (this.getMemberAction(MemberAction.ADI)) {
                        outputLine = this.modifyMemberADI(currentMemberName, line);
                        line = this.setOutlineLenToOriginalLen((String)outputLine, originalLen);
                    }
                    if (this.getMemberAction(MemberAction.AJO)) {
                        outputLine = this.modifyMemberAJO(currentMemberName, line);
                        line = this.setOutlineLenToOriginalLen((String)outputLine, originalLen);
                    }
                    if (this.getMemberAction(MemberAction.IEBUPDTE)) {
                        outputLine = this.modifyMemberIEBUPDTE(currentMemberName, line);
                        line = this.setOutlineLenToOriginalLen((String)outputLine, originalLen);
                    }
                }
            }
            if (outputLine == null) continue;
            this.m_outstream.println((String)outputLine);
        }
        if (this.parmOutLine != null) {
            this.m_outstream.println(this.parmOutLine);
        }
        this.m_outstream.close();
        try {
            this.m_instream.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        inputLine.close();
    }

    private String setOutlineLenToOriginalLen(String inline, Integer originalLen) {
        Object outline = inline.toString();
        if (inline.length() > originalLen) {
            Integer diff = inline.length() - originalLen;
            if (inline.length() > 71 + diff && inline.substring(71, 71 + diff).trim().isEmpty()) {
                outline = inline.substring(0, 71) + inline.substring(71 + diff);
            }
        } else if (inline.length() < originalLen && inline.length() > 72) {
            Integer diff = originalLen - inline.length();
            outline = inline.substring(0, 71);
            Integer i = 0;
            while (i < diff) {
                outline = ((String)outline).concat(" ");
                Integer n = i;
                i = i + 1;
            }
            outline = ((String)outline).concat(inline.substring(71));
        }
        if (((String)outline).length() > 80) {
            ConversionLogger.getLogger().info("output line is longer than 80");
        }
        return outline;
    }

    private String modifyMemberGJTRABTR(String currentMemberName, String inline) {
        String outline = inline.toString();
        String[] jclItems = inline.split("[ ,]+");
        if (this.foundGJTRABTR) {
            if (this.underCont) {
                if (!jclItems[0].startsWith("//*")) {
                    String[] jclStmtPart = inline.split(" +");
                    if (jclStmtPart.length < 2) {
                        if (!this.m_jobMessages.containsKey(currentMemberName)) {
                            this.m_jobMessages.put(currentMemberName, new ArrayList());
                        }
                        Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5018", (String)currentMemberName, (String[])new String[]{inline});
                        this.underCont = false;
                    } else {
                        if (!jclStmtPart[1].substring(jclStmtPart[1].length() - 1).equals(",")) {
                            this.underCont = false;
                        }
                        String[] jclContFields = jclStmtPart[1].split(",");
                        for (int keyword = 0; keyword < jclContFields.length; ++keyword) {
                            if (!jclContFields[keyword].startsWith("PARM=")) continue;
                            outline = this.modifyMemberGJTRABTRProcessParm(currentMemberName, inline);
                            this.parmProcessed = true;
                            break;
                        }
                    }
                }
                return outline;
            }
            if (this.underDDCont) {
                if (inline.startsWith("//*") || inline.startsWith("// ")) {
                    outline = null;
                } else {
                    if (!this.m_jobMessages.containsKey(currentMemberName)) {
                        this.m_jobMessages.put(currentMemberName, new ArrayList());
                    }
                    Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5018", (String)currentMemberName, (String[])new String[]{inline});
                }
                this.underDDCont = false;
                return outline;
            }
            if (inline.startsWith("// ") || jclItems.length > 1 && jclItems[1].equals("ENDIF")) {
                if (this.underSysin || this.parmProcessed) {
                    if (this.parmOutLine != null) {
                        this.m_outstream.println(this.parmOutLine);
                        this.parmOutLine = null;
                    }
                    this.underSysin = false;
                    this.foundGJTRABTR = false;
                }
                return outline;
            }
            if (jclItems.length >= 1 && (jclItems[0].startsWith("//*") || jclItems[0].startsWith("/*"))) {
                if (this.underSysin) {
                    if (this.parmOutLine != null) {
                        this.m_outstream.println(this.parmOutLine);
                        this.parmOutLine = null;
                    }
                    this.underSysin = false;
                }
                return outline;
            }
            if (jclItems.length > 1) {
                String jclType = jclItems[1];
                if (jclType.equals("EXEC")) {
                    if (this.parmOutLine != null) {
                        this.m_outstream.println(this.parmOutLine);
                        this.parmOutLine = null;
                    }
                    if (!this.parmProcessed) {
                        if (!this.m_jobMessages.containsKey(currentMemberName)) {
                            this.m_jobMessages.put(currentMemberName, new ArrayList());
                        }
                        Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5020", (String)currentMemberName, (String[])new String[0]);
                    }
                    this.foundGJTRABTR = false;
                    outline = this.modifyMemberGJTRABTRProcessExec(currentMemberName, inline);
                    return outline;
                }
                if (jclType.equals("DD")) {
                    if (this.underSysin) {
                        this.underSysin = false;
                    }
                    if (jclItems[0].equals("//SYSIN")) {
                        if (jclItems[2].equals("*")) {
                            this.underSysin = true;
                        } else {
                            if (!this.m_jobMessages.containsKey(currentMemberName)) {
                                this.m_jobMessages.put(currentMemberName, new ArrayList());
                            }
                            Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5019", (String)currentMemberName, (String[])new String[]{inline});
                        }
                        return outline;
                    }
                    outline = null;
                    String[] jclStmtPart = inline.split(" +");
                    if (jclStmtPart.length < 3) {
                        if (!this.m_jobMessages.containsKey(currentMemberName)) {
                            this.m_jobMessages.put(currentMemberName, new ArrayList());
                        }
                        Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5018", (String)currentMemberName, (String[])new String[]{inline});
                    } else if (jclStmtPart[2].substring(jclStmtPart[2].length() - 1).equals(",")) {
                        this.underDDCont = true;
                    }
                } else if (!inline.startsWith("//")) {
                    this.underSysin = true;
                }
                if (this.underSysin) {
                    String reqLine = this.modifyMemberGJTRABTRProcessRequest(currentMemberName, inline);
                    this.parmOutLine = this.parmOutLine != null ? this.parmOutLine + "\n" + reqLine : reqLine;
                    outline = null;
                }
            }
        } else if (jclItems.length > 1) {
            String jclType = jclItems[1];
            if (jclType.equals("EXEC")) {
                outline = this.modifyMemberGJTRABTRProcessExec(currentMemberName, inline);
                return outline;
            }
            return outline;
        }
        return outline;
    }

    private String modifyMemberGJTRABTRProcessExec(String currentMemberName, String inline) {
        String pgm = "";
        String proc = "";
        Object outline = inline.toString();
        String[] jclItems = inline.split("[ ,]+");
        String exec = "PGM=IEFBR14";
        String extraProg = this.m_rules.getStringRule("Jobtrac rules", new String[]{"JOBTRACUTILS"});
        if (jclItems.length < 3) {
            if (!this.m_jobMessages.containsKey(currentMemberName)) {
                this.m_jobMessages.put(currentMemberName, new ArrayList());
            }
            Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5018", (String)currentMemberName, (String[])new String[]{inline});
        } else {
            exec = jclItems[2];
        }
        String[] pp = exec.split("=");
        int restOffset = 0;
        if (pp[0].equals("PGM")) {
            if (pp.length < 2) {
                if (!this.m_jobMessages.containsKey(currentMemberName)) {
                    this.m_jobMessages.put(currentMemberName, new ArrayList());
                }
                Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5018", (String)currentMemberName, (String[])new String[]{inline});
            } else {
                pgm = pp[1];
            }
        } else if (pp[0].equals("PROC")) {
            if (pp.length < 2) {
                if (!this.m_jobMessages.containsKey(currentMemberName)) {
                    this.m_jobMessages.put(currentMemberName, new ArrayList());
                }
                Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5018", (String)currentMemberName, (String[])new String[]{inline});
            } else {
                proc = pp[1];
            }
        } else {
            proc = pp[0];
        }
        if (pgm.equals("GJTRABTR") || proc.equals("GJTRABTR") || pgm.equals("SRVBATCH") || proc.equals("SRVBATCH") || pgm.equals("JTSRVBT") || proc.equals("JTSRVBT") || !pgm.isEmpty() && extraProg.contains(pgm) || !proc.isEmpty() && extraProg.contains(proc)) {
            this.foundGJTRABTR = true;
            this.underCont = false;
            this.underSysin = false;
            this.parmProcessed = false;
            restOffset = jclItems.length < 4 ? inline.indexOf(jclItems[2]) + jclItems[2].length() : inline.indexOf(jclItems[3]) - 1;
            outline = jclItems[0] + " EXEC CTMUTIL" + inline.substring(restOffset);
            String[] jclStmtPart = inline.split(" +");
            if (jclStmtPart[2].substring(jclStmtPart[2].length() - 1).equals(",")) {
                this.underCont = true;
            }
            for (int keyword = 3; keyword < jclItems.length; ++keyword) {
                if (!jclItems[keyword].startsWith("PARM=") || (outline = this.modifyMemberGJTRABTRProcessParm(currentMemberName, (String)outline)) == null) continue;
                this.parmProcessed = true;
            }
        }
        return outline;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String modifyMemberGJTRABTRProcessRequest(String currentMemberName, String inline) {
        Object inJclMessage;
        Object outline;
        block37: {
            Matcher matcherGjtrabtrComamnd;
            String jobname;
            block39: {
                String sJCLLib;
                block38: {
                    String verb = "";
                    outline = null;
                    jobname = "";
                    sJCLLib = this.m_rules.getStringRule("Mainframe", new String[]{"RUNJCLLIBRARY"});
                    inJclMessage = "";
                    if (inline.equals("STACK()")) {
                        return null;
                    }
                    if (inline.equals("BATCH")) {
                        return null;
                    }
                    String regexGjtrabtrComamnd = "(\\w*)\\s*\\(?'?(\\w*)(\\(?(\\w*)\\(([\\w.$@#]*)(\\))?)*(\\))?";
                    Pattern patternGjtrabtrComamnd = Pattern.compile(regexGjtrabtrComamnd);
                    matcherGjtrabtrComamnd = patternGjtrabtrComamnd.matcher(inline.trim().replaceAll("L=", "L(").replaceAll("LOC=", "LOC("));
                    matcherGjtrabtrComamnd.find();
                    verb = matcherGjtrabtrComamnd.group(1);
                    if (matcherGjtrabtrComamnd.group(2).isEmpty()) {
                        matcherGjtrabtrComamnd.find();
                    }
                    if (verb.equals("JOBTRAC/ADD") || verb.equals("ADD")) break block38;
                    if (verb.equals("JOBTRAC/MOD") || verb.equals("MOD") || verb.equals("MODIFY") || verb.equals("JOBTRAC/POST") || verb.equals("POST")) break block39;
                    if (verb.equals("JOBTRAC/PUR") || verb.equals("PUR") || verb.equals("JOBTRAC/PRG") || verb.equals("PRG") || verb.equals("JOBTRAC/PURGE") || verb.equals("PURGE")) {
                        outline = "AJF BYPJCL MEM=";
                        do {
                            String key = matcherGjtrabtrComamnd.group(2);
                            String value = matcherGjtrabtrComamnd.group(5);
                            if (value == null) {
                                key = matcherGjtrabtrComamnd.group(1);
                                value = matcherGjtrabtrComamnd.group(2);
                            }
                            if (!key.equals("JOB")) continue;
                            jobname = value;
                            outline = (String)outline + jobname;
                        } while (matcherGjtrabtrComamnd.find());
                        break block37;
                    } else if (verb.equals("JOBTRAC/DEL") || verb.equals("DEL") || verb.equals("JOBTRAC/DELETE") || verb.equals("DELETE")) {
                        outline = "AJF DELETE MEM=";
                        do {
                            String key = matcherGjtrabtrComamnd.group(2);
                            String value = matcherGjtrabtrComamnd.group(5);
                            if (value == null) {
                                key = matcherGjtrabtrComamnd.group(1);
                                value = matcherGjtrabtrComamnd.group(2);
                            }
                            if (!key.equals("JOB")) continue;
                            jobname = value;
                            outline = (String)outline + jobname;
                        } while (matcherGjtrabtrComamnd.find());
                        break block37;
                    } else {
                        if (!this.m_jobMessages.containsKey(currentMemberName)) {
                            this.m_jobMessages.put(currentMemberName, new ArrayList());
                        }
                        Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5015", (String)currentMemberName, (String[])new String[]{inline});
                        return "//*CTMUTIL - Unsupported Command " + inline;
                    }
                }
                outline = "MEM-OVERWRITE=FORCE\nLIBRARY=ORDER.ON.THE.FLY";
                outline = (String)outline + "\nMEMLIB=" + sJCLLib;
                boolean jobFound = false;
                do {
                    String key = matcherGjtrabtrComamnd.group(2);
                    String value = matcherGjtrabtrComamnd.group(5);
                    if (value == null) {
                        key = matcherGjtrabtrComamnd.group(1);
                        value = matcherGjtrabtrComamnd.group(2);
                    }
                    if (key.isEmpty()) continue;
                    if (key.equals("JOB")) {
                        jobFound = true;
                        jobname = value;
                        if (jobname.indexOf(".") > 0) {
                            String version = jobname.substring(jobname.indexOf(".") + 1);
                            jobname = jobname.substring(0, jobname.indexOf("."));
                            inJclMessage = (String)inJclMessage + "\n//* CTMUTIL - JOB WITH VERSION FOUND. VERSION IGNORED.";
                            if (!this.m_jobMessages.containsKey(currentMemberName)) {
                                this.m_jobMessages.put(currentMemberName, new ArrayList());
                            }
                            Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"INF5002", (String)currentMemberName, (String[])new String[]{"VERSION", version});
                        }
                        if (jobname.startsWith("0")) {
                            String orderedFolder = jobname.substring(1);
                            this.sourceDefs.addFolderToListOfDynamicallyOrdered(orderedFolder);
                        }
                        outline = (String)outline + "\nTABLE=" + jobname;
                        outline = (String)outline + "\nMEMNAME=" + jobname;
                        continue;
                    }
                    if (key.equals("LOC") || key.equals("L")) {
                        outline = (String)outline + "\nAPPL=" + value;
                        continue;
                    }
                    if (key.equals("BUSGRP") || key.equals("BUSG")) {
                        outline = (String)outline + "\nGROUP=" + value;
                        continue;
                    }
                    if (key.equals("SUB")) continue;
                    if (key.equals("MAXCC")) {
                        if (!this.m_jobMessages.containsKey(currentMemberName)) {
                            this.m_jobMessages.put(currentMemberName, new ArrayList());
                        }
                        Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"INF5002", (String)currentMemberName, (String[])new String[]{key, value});
                        continue;
                    }
                    if (key.equals("DEP")) {
                        if (value.equals("M")) {
                            outline = (String)outline + "\nIN=MANUAL-DEP_" + jobname;
                            continue;
                        }
                        if (!value.equals("NONE")) continue;
                        continue;
                    }
                    if (!this.m_jobMessages.containsKey(currentMemberName)) {
                        this.m_jobMessages.put(currentMemberName, new ArrayList());
                    }
                    Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5011", (String)currentMemberName, (String[])new String[]{key});
                    return "//*CTMUTIL - Unsupported Parameter " + inline;
                } while (matcherGjtrabtrComamnd.find());
                if (!jobFound) {
                    if (!this.m_jobMessages.containsKey(currentMemberName)) {
                        this.m_jobMessages.put(currentMemberName, new ArrayList());
                    }
                    Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5011", (String)currentMemberName, (String[])new String[]{inline});
                    return "//*CTMUTIL - No JOB found" + inline;
                }
                outline = (String)outline + "\nEND";
                if (jobname.startsWith("0")) {
                    String orderedFolder = jobname.substring(1);
                    String schedtab = this.m_rules.getStringRule("Mainframe", new String[]{"SCHEDTAB"});
                    outline = "ORDER MEM=" + orderedFolder + " DSN=" + schedtab;
                }
                break block37;
            }
            outline = "ADD COND Q-RELEAS-";
            boolean depQ = false;
            boolean depNone = false;
            do {
                String key = matcherGjtrabtrComamnd.group(2);
                String value = matcherGjtrabtrComamnd.group(5);
                if (value == null) {
                    key = matcherGjtrabtrComamnd.group(1);
                    value = matcherGjtrabtrComamnd.group(2);
                }
                if (key.equals("JOB")) {
                    jobname = value;
                    continue;
                }
                if (!key.startsWith("DEP")) continue;
                if (value.equals("-Q")) {
                    depQ = true;
                    continue;
                }
                if (value.equals("NONE")) {
                    depNone = true;
                    continue;
                }
                if (!this.m_jobMessages.containsKey(currentMemberName)) {
                    this.m_jobMessages.put(currentMemberName, new ArrayList());
                }
                Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5013", (String)currentMemberName, (String[])new String[]{value, inline});
                return "//*CTMUTIL - Unsupported DEP value " + inline;
            } while (matcherGjtrabtrComamnd.find());
            if (depQ | depNone) {
                outline = (String)outline + jobname;
            } else {
                if (!this.m_jobMessages.containsKey(currentMemberName)) {
                    this.m_jobMessages.put(currentMemberName, new ArrayList());
                }
                Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5014", (String)currentMemberName, (String[])new String[]{inline});
                return "//*CTMUTIL - Unsupported MOD/POST Command " + inline;
            }
        }
        outline = (String)outline + "\n*CTMUTIL - " + inline.toString();
        return (String)outline + (String)inJclMessage;
    }

    private String modifyMemberGJTRABTRProcessParm(String currentMemberName, String inline) {
        Object outline = inline.toString();
        int parmIndex = inline.indexOf("PARM=") + 5;
        String parmValue = "";
        int parmEnd = 0;
        String afterParm = null;
        if (inline.substring(parmIndex).startsWith("(")) {
            ++parmIndex;
        }
        if (inline.substring(parmIndex).startsWith("'")) {
            parmEnd = inline.substring(parmIndex + 1).indexOf("'");
            if (parmEnd < 0) {
                if (!this.m_jobMessages.containsKey(currentMemberName)) {
                    this.m_jobMessages.put(currentMemberName, new ArrayList());
                }
                Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5018", (String)currentMemberName, (String[])new String[]{inline});
                parmEnd = inline.length() - parmIndex - 2;
            }
            parmValue = inline.substring(parmIndex + 1, parmIndex + 1 + parmEnd);
            if (inline.substring(parmIndex + parmEnd + 2).startsWith(",")) {
                afterParm = inline.substring(parmIndex + parmEnd + 2);
            }
        } else {
            parmEnd = inline.substring(parmIndex).indexOf(" ");
            if (parmEnd < 0) {
                parmEnd = inline.substring(parmIndex).indexOf(",");
                afterParm = inline.substring(parmIndex + parmEnd + 2);
            }
            parmValue = inline.substring(parmIndex, parmIndex + parmEnd);
        }
        this.parmOutLine = this.modifyMemberGJTRABTRProcessRequest(currentMemberName, parmValue);
        if (inline.substring(parmIndex - 1).startsWith("(")) {
            --parmIndex;
        }
        outline = inline.substring(0, parmIndex);
        if (afterParm != null) {
            if (afterParm.indexOf(", ") >= 0 && afterParm.indexOf(", ") < afterParm.indexOf(" ")) {
                this.underCont = true;
            }
            outline = (String)outline + afterParm;
        }
        return outline;
    }

    private String modifyMemberJMF(String currentMemberName, String inline) {
        String outline = inline.toString();
        if (inline.contains("&:")) {
            if (!this.m_INCLIB_DYNAMIC_included_for_member) {
                outline = String.format("%%%%INCLIB %s %%%%INCMEM %s", this.m_INCLIB, "DYNAMIC");
                this.m_outstream.println(outline);
                this.m_INCLIB_DYNAMIC_included_for_member = true;
            }
            if (!this.m_INCLIB_JMF_included_for_member) {
                outline = String.format("%%%%INCLIB %s %%%%INCMEM %s", this.m_INCLIB, "JMFSYM01");
                this.m_outstream.println(outline);
                this.m_INCLIB_JMF_included_for_member = true;
            }
            Integer inline_current_index = 0;
            outline = "";
            while (inline.indexOf("&:", (int)inline_current_index) > -1) {
                outline = outline.concat(inline.substring(inline_current_index, inline.indexOf("&:", (int)inline_current_index)));
                inline_current_index = inline.indexOf("&:", (int)inline_current_index);
                Integer inline_varname_endpos = inline.length();
                String varName = "";
                String afterVar = "";
                Object outlineAppend = inline.substring(inline_current_index);
                String[] inline_vars = inline.substring(inline_current_index + "&:".length()).split("['&(),/*%-+=?. ]");
                if (inline_vars != null && inline_vars.length > 0) {
                    varName = inline_vars[0];
                    inline_varname_endpos = inline_current_index + varName.length() + "&:".length();
                }
                if (inline.length() > inline_varname_endpos) {
                    afterVar = inline.substring(inline_varname_endpos);
                }
                if (afterVar.startsWith("..&:")) {
                    outlineAppend = "%%" + varName + "..";
                    inline_current_index = inline_current_index + varName.length() + 4;
                } else if (afterVar.startsWith("..")) {
                    outlineAppend = "%%" + varName + ".";
                    inline_current_index = inline_current_index + varName.length() + 4;
                } else if (afterVar.startsWith(".&:")) {
                    outlineAppend = "%%" + varName + ".";
                    inline_current_index = inline_current_index + varName.length() + 3;
                } else if (afterVar.length() > 1 && afterVar.substring(0, 1).equals(".") && afterVar.substring(1, 2).matches("['&(),/*%-+=?. ]")) {
                    outlineAppend = "%%" + varName + afterVar.substring(1, 2);
                    inline_current_index = inline_current_index + varName.length() + 4;
                } else if (afterVar.startsWith(".")) {
                    outlineAppend = "%%" + varName + "%%.";
                    inline_current_index = inline_current_index + varName.length() + 3;
                } else {
                    outlineAppend = "%%" + varName;
                    inline_current_index = inline_current_index + varName.length() + 2;
                }
                outline = outline.concat((String)outlineAppend);
            }
            if (inline_current_index < inline.length()) {
                outline = outline.concat(inline.substring(inline_current_index));
            }
        }
        return outline;
    }

    private String modifyMemberADI(String currentMemberName, String inline) {
        String outline = inline.toString();
        if (inline.startsWith("//:(")) {
            if (!this.m_INCLIB_DYNAMIC_included_for_member) {
                outline = String.format("%%%%INCLIB %s %%%%INCMEM %s", this.m_INCLIB, "DYNAMIC");
                this.m_outstream.println(outline);
                this.m_INCLIB_DYNAMIC_included_for_member = true;
            }
            String cntlName = "";
            String[] inline_split = inline.substring("//:(".length()).split("[() ]");
            if (inline_split != null) {
                cntlName = inline_split[0];
            }
            outline = String.format("%%%%INCLIB %s %%%%INCMEM %s", this.m_INCLIB, cntlName);
        }
        return outline;
    }

    private String modifyMemberAJO(String currentMemberName, String inline) {
        String outline = inline.toString();
        String dateFormat = this.m_rules.getStringRule("Jobtrac rules", new String[]{"DATE_FORMAT"});
        String ifStatement = "";
        String valStatement = "";
        Object ajoDate = "";
        int extraIfCount = 0;
        int dayOffsetInDateString = 0;
        int monthOffsetInDateString = 2;
        String[] weekDaysList = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
        Integer weekDayIndex = -1;
        String weekDayNumber = "";
        if (inline.length() > 74 && inline.substring(72, 73).matches("[IDAR]") && inline.substring(73, 74).equals("=")) {
            String ajoOperator = inline.substring(72, 73);
            String operStatement = "EQ";
            if (ajoOperator.equalsIgnoreCase("D")) {
                operStatement = "NE";
            } else if (ajoOperator.equalsIgnoreCase("A")) {
                operStatement = "GE";
            } else if (ajoOperator.equalsIgnoreCase("R")) {
                operStatement = "LT";
            }
            ajoDate = "******";
            if (inline.length() > 75) {
                ajoDate = inline.substring(74);
            }
            if (dateFormat.equals("ddmm")) {
                dayOffsetInDateString = 0;
                monthOffsetInDateString = 2;
            } else {
                dayOffsetInDateString = 2;
                monthOffsetInDateString = 0;
            }
            if (((String)ajoDate).trim().startsWith("SCHD")) {
                ajoDate = "";
                if (inline.substring(61, 62).equals("/")) {
                    ajoDate = inline.substring(59, 61) + inline.substring(62, 64) + inline.substring(65, 67);
                } else if (inline.substring(59, 60).equals("=")) {
                    String daysSpec = inline.substring(60, 67);
                    if (daysSpec.equals(".......")) {
                        // empty if block
                    }
                    weekDayIndex = 1;
                    while (weekDayIndex <= daysSpec.length()) {
                        if (!daysSpec.substring(weekDayIndex - 1, weekDayIndex).equals(".")) {
                            if (outline.equals("%%ENDIF")) {
                                this.m_outstream.println(outline);
                            }
                            weekDayNumber = weekDayIndex.equals(7) ? "0" : weekDayIndex.toString();
                            this.m_outstream.println("%%IF %%OWDAY EQ " + weekDayNumber);
                            outline = inline.substring(0, 80);
                            this.m_outstream.println(outline);
                            outline = "%%ENDIF";
                            ifStatement = "";
                        }
                        Integer n = weekDayIndex;
                        weekDayIndex = weekDayIndex + 1;
                    }
                } else if (inline.substring(59, 66).equalsIgnoreCase("LASTDAY") || inline.substring(59, 62).equalsIgnoreCase("EOM")) {
                    this.m_outstream.println("%%SET %%0=%%$CALCDTE %%$OYEAR.%%OMONTH%%.01 +M");
                    if (inline.substring(59, 66).equalsIgnoreCase("LASTDAY")) {
                        this.m_outstream.println("%%SET %%0=%%$CALCDTE %%0 -1");
                    } else {
                        this.m_outstream.println("%%SET %%0=%%$WCALC %%0 -1 MTWTF");
                    }
                    ifStatement = "%%$ODATE";
                    valStatement = "%%0";
                } else if (inline.substring(59, 62).equalsIgnoreCase("FOM")) {
                    this.m_outstream.println("%%SET %%0=%%$WCALC %%$OYEAR.%%OMONTH%%.01 > MTWTF");
                    ifStatement = "%%$ODATE";
                    valStatement = "%%0";
                } else if (inline.substring(59, 66).equalsIgnoreCase("WORKDAY")) {
                    workDayOp = inline.substring(66, 67);
                    String workDayNum = inline.substring(67, 69);
                    operStatement = operStatement.equals("NE") ? (((String)workDayOp).equals("<") ? "GT" : (((String)workDayOp).equals(">") ? "LT" : "NE")) : (((String)workDayOp).equals("<") ? "LT" : (((String)workDayOp).equals(">") ? "GT" : "EQ"));
                    this.m_outstream.println("%%SET %%0=%%$WCALC %%$ODATE > MTWTF");
                    this.m_outstream.println("%%IF %%0 EQ %%$ODATE");
                    ++extraIfCount;
                    this.m_outstream.println("%%SET %%0=%%$CALCDTE %%$OYEAR.%%OMONTH%%.01 -01");
                    this.m_outstream.println("%%SET %%0=%%$WCALC %%0 +" + workDayNum + " MTWTF");
                    ifStatement = "%%$ODATE";
                    valStatement = "%%0";
                } else {
                    weekDayIndex = -1;
                    weekDayNumber = "";
                    weekDayIndex = 0;
                    while (weekDayIndex < weekDaysList.length) {
                        if (weekDaysList[weekDayIndex].equalsIgnoreCase(inline.substring(59, 68).trim())) {
                            weekDayNumber = weekDayIndex.toString();
                        }
                        workDayOp = weekDayIndex;
                        weekDayIndex = weekDayIndex + 1;
                    }
                    if (!weekDayNumber.isEmpty()) {
                        ifStatement = "%%OWDAY";
                        valStatement = weekDayNumber;
                    } else {
                        if (!this.m_jobMessages.containsKey(currentMemberName)) {
                            this.m_jobMessages.put(currentMemberName, new ArrayList());
                        }
                        Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5021", (String)currentMemberName, (String[])new String[]{inline.substring(59, 68).trim()});
                    }
                }
            }
            if (!((String)ajoDate).isEmpty()) {
                String ajoYear = "**";
                String ajoMonth = "**";
                String ajoDay = "**";
                if (((String)ajoDate).length() > 5) {
                    ajoYear = ((String)ajoDate).substring(4, 6);
                }
                if (((String)ajoDate).length() > monthOffsetInDateString + 1) {
                    ajoMonth = ((String)ajoDate).substring(monthOffsetInDateString, monthOffsetInDateString + 2);
                }
                if (((String)ajoDate).length() > dayOffsetInDateString + 1) {
                    ajoDay = ((String)ajoDate).substring(dayOffsetInDateString, dayOffsetInDateString + 2);
                }
                ifStatement = "";
                valStatement = "";
                if (!ajoYear.equals("**")) {
                    ifStatement = ifStatement.concat("%%YEAR");
                    valStatement = valStatement.concat(ajoYear);
                }
                if (!ajoMonth.equals("**")) {
                    if (!ifStatement.isEmpty()) {
                        ifStatement = ifStatement.concat(".");
                    }
                    ifStatement = ifStatement.concat("%%MONTH");
                    valStatement = valStatement.concat(ajoMonth);
                }
                if (!ajoDay.equals("**")) {
                    if (!ifStatement.isEmpty()) {
                        ifStatement = ifStatement.concat(".");
                    }
                    ifStatement = ifStatement.concat("%%DAY");
                    valStatement = valStatement.concat(ajoDay);
                }
            }
            if (!ifStatement.isEmpty()) {
                outline = String.format("%%%%IF %s %s %s", ifStatement, operStatement, valStatement);
                this.m_outstream.println(outline);
                outline = inline.substring(0, Math.min(inline.length(), 80));
                this.m_outstream.println(outline);
                while (extraIfCount > 0) {
                    this.m_outstream.println("%%ENDIF");
                    --extraIfCount;
                }
                outline = "%%ENDIF";
            }
        }
        return outline;
    }

    private String modifyMemberIEBUPDTE(String currentMemberName, String inline) {
        String outline = inline.toString();
        if (inline.startsWith("./")) {
            outline = inline.replaceFirst("\\./", "@/");
            Path p = Paths.get(this.m_membersFileNameInput, new String[0]);
            String library = p.getFileName().toString().substring(4);
            if (!this.m_jobMessages.containsKey(currentMemberName)) {
                this.m_jobMessages.put(currentMemberName, new ArrayList());
            }
            Reporter.addMessage((List)this.m_jobMessages.get(currentMemberName), (String)"WRN5029", (String)currentMemberName, (String[])new String[]{currentMemberName, library, inline.trim()});
        }
        return outline;
    }

    public HashMap<String, ArrayList<String>> getM_jobMessages() {
        return this.m_jobMessages;
    }

    public static enum MemberAction {
        MEMBER_NAME,
        JMF,
        AJO,
        ADI,
        GJTRABTR,
        IEBUPDTE,
        NONE,
        ALL;

    }
}

