/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Scanner;

public class JobtracJMFConvertor {
    private String m_JMFInputFile;
    private String m_JMFOutputFile;
    private PrintStream m_outstream = null;
    private FileInputStream m_instream = null;
    private FileInputStream m_dynamicInstream = null;
    private ByteArrayOutputStream m_jSCSFoutputStream = null;
    private String m_JMFINCLIB;
    private ArrayList<String> m_messages = null;
    private boolean jmfSupplied = true;
    String newLine = System.getProperty("line.separator");

    public JobtracJMFConvertor(String inputFile, String outputFile, String inclibName, ByteArrayOutputStream jSCSFoutputStream) throws FileNotFoundException {
        this.m_JMFInputFile = inputFile;
        this.m_JMFOutputFile = outputFile;
        this.m_outstream = new PrintStream(this.m_JMFOutputFile);
        this.m_JMFINCLIB = inclibName;
        this.m_jSCSFoutputStream = jSCSFoutputStream;
        this.m_messages = new ArrayList();
        this.m_dynamicInstream = new FileInputStream(Globs.MODULES_DATA_DIR + Globs.DIRSEP + Params.instance().getVendorName() + Globs.DIRSEP + "dynamic.txt");
        try {
            this.m_instream = new FileInputStream(this.m_JMFInputFile);
        }
        catch (FileNotFoundException e) {
            this.jmfSupplied = false;
        }
    }

    public void convert() throws IOException {
        Object jclCommand = "";
        jclCommand = "//JMF EXEC PGM=IEBUPDTE,PARM=NEW" + this.newLine;
        jclCommand = (String)jclCommand + "//SYSPRINT  DD SYSOUT=*" + this.newLine;
        jclCommand = (String)jclCommand + "//SYSUT2   DD DISP=SHR,DSN=" + this.m_JMFINCLIB + this.newLine;
        jclCommand = (String)jclCommand + "//SYSIN    DD DATA,DLM=@@";
        this.m_outstream.println((String)jclCommand);
        jclCommand = "";
        if (this.jmfSupplied) {
            Scanner sc = new Scanner(this.m_instream);
            String outputLine = "";
            Integer lineNumber = 0;
            jclCommand = (String)jclCommand + "./ ADD NAME=JMFSYM01";
            this.m_outstream.println((String)jclCommand);
            this.m_outstream.println("%%SET %%0 = %%BLANK");
            while (sc.hasNext()) {
                String line = sc.nextLine().trim();
                lineNumber = lineNumber + 1;
                if (this.skipThisLine(line)) continue;
                if (line.contains("=&:")) {
                    outputLine = this.convertSimpleLine(line);
                }
                if (line.contains("=") && !line.contains("&:")) {
                    outputLine = this.convertDatesLine(line);
                }
                this.m_outstream.println(outputLine);
            }
            sc.close();
            this.m_instream.close();
        }
        this.appendDynamicFile();
        jclCommand = "";
        jclCommand = (String)jclCommand + "./ ENDUP" + this.newLine;
        jclCommand = (String)jclCommand + "@@" + this.newLine;
        jclCommand = (String)jclCommand + "/*";
        this.m_outstream.println((String)jclCommand);
        this.m_outstream.println(this.m_jSCSFoutputStream);
        this.m_jSCSFoutputStream.close();
        this.m_outstream.close();
    }

    private void appendDynamicFile() throws IOException {
        Scanner sc = new Scanner(this.m_dynamicInstream);
        this.m_outstream.println("./ ADD NAME=DYNAMIC");
        while (sc.hasNext()) {
            String line = sc.nextLine().trim();
            if (this.skipThisLine(line)) continue;
            this.m_outstream.println(line);
        }
        this.m_dynamicInstream.close();
        sc.close();
    }

    private String convertSimpleLine(String line) {
        Object output = "";
        output = line.replace("&:", "%%");
        output = "%%SET %%" + (String)output;
        return output;
    }

    public static void main(String[] args) {
        try {
            JobtracJMFConvertor jmf = new JobtracJMFConvertor("C:\\Jobtrac\\JMF.txt", "C:\\JMFOUTPUT", "MYINCLIB", null);
            jmf.convert();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private boolean skipThisLine(String line) {
        if (line.isEmpty()) {
            return true;
        }
        if (line.startsWith("*")) {
            return true;
        }
        if (line.startsWith("OSDDATE:")) {
            return true;
        }
        if (line.startsWith("TODDATE:")) {
            return true;
        }
        if (line.startsWith("JLOC")) {
            return true;
        }
        return line.startsWith("::");
    }

    private String convertDatesLine(String line) {
        String minDate = "";
        String maxDate = "";
        Object output = "";
        String newLine = System.getProperty("line.separator");
        Object varvalue = "";
        line = line.trim();
        while (line.lastIndexOf(32) > line.lastIndexOf(39)) {
            line = line.substring(0, line.lastIndexOf(32));
        }
        String varname = line.substring(0, line.indexOf(61));
        varvalue = line.endsWith(")") && line.charAt(line.lastIndexOf(40) - 1) == ',' ? line.substring(line.indexOf("=") + 1, line.lastIndexOf(",(")) : line.substring(line.indexOf("=") + 1);
        if (((String)varvalue).charAt(0) == '\'') {
            varvalue = ((String)varvalue).substring(1, ((String)varvalue).length() - 1);
        }
        varvalue = this.replaceSpaces((String)varvalue);
        if (!line.endsWith(")") || line.charAt(line.lastIndexOf(40) - 1) != ',') {
            output = "%%SET %%" + varname + "=" + (String)varvalue;
            return output;
        }
        maxDate = this.convertDates(line.substring(line.lastIndexOf(",(") + 2, line.lastIndexOf(")")));
        if (maxDate.isEmpty()) {
            minDate = this.convertDates(line.substring(line.lastIndexOf(",(") + 2, line.lastIndexOf(",")));
            maxDate = this.convertDates(line.substring(line.lastIndexOf(",") + 1, line.lastIndexOf(")")));
        }
        if (!minDate.isEmpty()) {
            output = "%%IF %%$JULDAY GE " + minDate + newLine + "%%IF %%$JULDAY LE " + maxDate;
            output = (String)output + newLine + "%%SET %%" + varname + " =" + (String)varvalue;
            varvalue = "%%SET %%" + varname + " =" + (String)varvalue;
            output = (String)output + newLine + "%%ENDIF" + newLine + "%%ENDIF";
        } else {
            output = "%%IF %%$JULDAY EQ " + maxDate;
            output = (String)output + newLine + "%%SET %%" + varname + " =" + (String)varvalue;
            varvalue = "%%SET %%" + varname + " =" + (String)varvalue;
            output = (String)output + newLine + "%%ENDIF";
        }
        if (((String)varvalue).length() > 80) {
            Reporter.addMessage(this.m_messages, (String)"WRN5000", (String)"$$$_JMF", (String[])new String[]{"JMF", varname});
        }
        return output;
    }

    private String replaceSpaces(String token) {
        Object convertedToken = "";
        if (token.contains(" ")) {
            int counter = 0;
            for (int i = 0; i < token.length(); ++i) {
                if (token.charAt(i) == ' ') {
                    while (i < token.length() && token.charAt(i) == ' ') {
                        ++counter;
                        ++i;
                    }
                    convertedToken = (String)convertedToken + "%%BLANK" + counter + "%%.";
                    counter = 0;
                }
                if (i >= token.length()) continue;
                convertedToken = (String)convertedToken + token.charAt(i);
            }
        } else {
            convertedToken = token;
        }
        return convertedToken;
    }

    private String convertDates(String token) {
        String date = "";
        if (GlobalFunctions.isNumber((String)token) && (token.length() == 5 || token.length() == 7)) {
            int yearLength = token.length() - 3;
            Integer year = Integer.valueOf(token.substring(0, yearLength)) + 1900;
            String julDay = token.substring(yearLength);
            date = String.format("%d%s", year, julDay);
        }
        return date;
    }

    public ArrayList<String> getMessages() {
        return this.m_messages;
    }
}

