/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.jobtrac.ConvertADRToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertAMRToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertAbstractToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertCCPFToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertJCLToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertRESOURCEToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertSCLToCSV;
import com.bmc.ctmconvert.jobtrac.ConvertSCSToCSV;
import com.bmc.ctmconvert.jobtrac.DataImportJobTracParameters;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import com.bmc.ctmconvert.jobtrac.JobTracInputFileParser;
import com.bmc.ctmconvert.jobtrac.MergeCSVFilesIntoOne;
import com.bmc.ctmconvert.jobtrac.SCLsLargeCSVFilesSplitter;
import com.bmc.ctmconvert.jobtrac.SCLsTrackerOfMEMBERs;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JobtracExecuter {
    private static String endOfLine;
    private static int sclCounter;
    private static int jclCounter;
    String fileNameData;
    String jobCard;
    String unit;
    String volser;
    String data;
    String storage;
    String management;
    String primaryAllocation;
    String secondaryAllocation;
    DataImportJobTracParameters jobTracEnvironment;

    public JobtracExecuter() {
        endOfLine = GlobalFunctions.isWindows() ? "\r\n" : "\n";
    }

    private void initCounters() {
        sclCounter = 0;
        jclCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCollectDataScript(DataImportJobTracParameters jobTracEnvironment) {
        this.jobTracEnvironment = jobTracEnvironment;
        this.initCounters();
        this.fileNameData = jobTracEnvironment.getOUTPUT_FILE_NAME();
        this.jobCard = this.buildJobCardStr(jobTracEnvironment.getJOB_CARD());
        this.unit = jobTracEnvironment.getUNIT();
        this.volser = jobTracEnvironment.getVOLSER();
        this.data = jobTracEnvironment.getSMS_DATA_CLASS();
        this.storage = jobTracEnvironment.getSMS_STORAGE_CLASS();
        this.management = jobTracEnvironment.getSMS_MANAGMENT_CLASS();
        this.primaryAllocation = jobTracEnvironment.getPRIMARY_ALLOCATION();
        this.secondaryAllocation = jobTracEnvironment.getSECONDERY_ALLOCATION();
        File outputFile = new File(ConversionEntitiesService.getCurrentProjectDataDirectory() + Globs.DIRSEP + jobTracEnvironment.getJCL());
        File templateFile = new File(Globs.MODULES_DATA_DIR + Globs.DIRSEP + Params.instance().getVendorName() + Globs.DIRSEP + "JCL-template.txt");
        try (Scanner m_scanner = null;){
            FileWriter m_fileWriter = new FileWriter(outputFile);
            m_scanner = new Scanner(templateFile);
            Pattern pattern = Pattern.compile("[^<]*(<[^>]*>)(.*)");
            while (m_scanner.hasNextLine()) {
                ArrayList<String> replacementsList;
                String currLine;
                ArrayList<String> outputLines;
                String line = m_scanner.nextLine();
                if (line == null || line.isEmpty()) continue;
                if (line.equalsIgnoreCase("<VOLSER_BLOCK_START>")) {
                    String volserBlockLine;
                    outputLines = new ArrayList<String>();
                    while (m_scanner.hasNextLine() && !(volserBlockLine = m_scanner.nextLine()).equalsIgnoreCase("<VOLSER_BLOCK_END>")) {
                        outputLines.add(volserBlockLine);
                    }
                    boolean isVolserGiven = !this.volser.isEmpty();
                    for (int i = 0; i < outputLines.size(); ++i) {
                        currLine = (String)outputLines.get(i);
                        if (!isVolserGiven ? currLine.contains("<UNIT>") || currLine.contains("<VOLSER>") : currLine.contains("<SMS_DATA_CLASS>") || currLine.contains("<SMS_STORAGE_CLASS>") || currLine.contains("<SMS_MANAGEMENT_CLASS>")) continue;
                        replacementsList = this.getReplacementsList(pattern, currLine);
                        if (!replacementsList.isEmpty()) {
                            currLine = this.resolveLine(currLine, replacementsList);
                        }
                        if (currLine.isEmpty()) continue;
                        m_fileWriter.write(currLine.toUpperCase() + endOfLine);
                    }
                    continue;
                }
                if (line.equalsIgnoreCase("<SCL_BLOCK_START>")) {
                    String sclLine;
                    outputLines = new ArrayList();
                    while (m_scanner.hasNextLine() && !(sclLine = m_scanner.nextLine()).equalsIgnoreCase("<SCL_BLOCK_END>")) {
                        outputLines.add(sclLine);
                    }
                    if (jobTracEnvironment.getSCLList() == null || jobTracEnvironment.getSCLList().size() <= 0) continue;
                    for (int i = 0; i < jobTracEnvironment.getSCLList().size(); ++i) {
                        for (int j = 0; j < outputLines.size(); ++j) {
                            currLine = (String)outputLines.get(j);
                            replacementsList = this.getReplacementsList(pattern, currLine);
                            if (!replacementsList.isEmpty()) {
                                currLine = this.resolveLine(currLine, replacementsList);
                            }
                            if (currLine.isEmpty()) continue;
                            m_fileWriter.write(currLine.toUpperCase().toUpperCase() + endOfLine);
                        }
                        ++sclCounter;
                    }
                    continue;
                }
                if (line.equalsIgnoreCase("<JCL_BLOCK_START>")) {
                    String jclLine;
                    outputLines = new ArrayList();
                    while (m_scanner.hasNextLine() && !(jclLine = m_scanner.nextLine()).equalsIgnoreCase("<JCL_BLOCK_END>")) {
                        outputLines.add(jclLine);
                    }
                    if (jobTracEnvironment.getJCLList() == null || jobTracEnvironment.getJCLList().size() <= 0) continue;
                    for (int i = 0; i < jobTracEnvironment.getJCLList().size(); ++i) {
                        for (int j = 0; j < outputLines.size(); ++j) {
                            currLine = (String)outputLines.get(j);
                            replacementsList = this.getReplacementsList(pattern, currLine);
                            if (!replacementsList.isEmpty()) {
                                currLine = this.resolveLine(currLine, replacementsList);
                            }
                            if (currLine.isEmpty()) continue;
                            m_fileWriter.write(currLine.toUpperCase() + endOfLine);
                        }
                        ++jclCounter;
                    }
                    continue;
                }
                if (line.equalsIgnoreCase("<JMF_BLOCK_START>")) {
                    String jmfLine;
                    String jmf = jobTracEnvironment.getJMF().trim();
                    ArrayList<String> outputLines2 = new ArrayList<String>();
                    while (m_scanner.hasNextLine() && !(jmfLine = m_scanner.nextLine()).equalsIgnoreCase("<JMF_BLOCK_END>")) {
                        outputLines2.add(jmfLine);
                    }
                    if (jmf.isEmpty()) continue;
                    for (int i = 0; i < outputLines2.size(); ++i) {
                        currLine = (String)outputLines2.get(i);
                        replacementsList = this.getReplacementsList(pattern, currLine);
                        if (!replacementsList.isEmpty()) {
                            currLine = this.resolveLine(currLine, replacementsList);
                        }
                        if (currLine.isEmpty()) continue;
                        m_fileWriter.write(currLine.toUpperCase() + endOfLine);
                    }
                    continue;
                }
                if (line.equalsIgnoreCase("<ADI_BLOCK_START>")) {
                    String adiLine;
                    String adi = jobTracEnvironment.getADI().trim();
                    ArrayList<String> outputLines3 = new ArrayList<String>();
                    while (m_scanner.hasNextLine() && !(adiLine = m_scanner.nextLine()).equalsIgnoreCase("<ADI_BLOCK_END>")) {
                        outputLines3.add(adiLine);
                    }
                    if (adi.isEmpty()) continue;
                    for (int i = 0; i < outputLines3.size(); ++i) {
                        currLine = (String)outputLines3.get(i);
                        replacementsList = this.getReplacementsList(pattern, currLine);
                        if (!replacementsList.isEmpty()) {
                            currLine = this.resolveLine(currLine, replacementsList);
                        }
                        if (currLine.isEmpty()) continue;
                        m_fileWriter.write(currLine.toUpperCase() + endOfLine);
                    }
                    continue;
                }
                if (line.equalsIgnoreCase("<CCPF_BLOCK_START>")) {
                    String ccpfLine;
                    String ccpf = jobTracEnvironment.getCCPF().trim();
                    ArrayList<String> outputLines4 = new ArrayList<String>();
                    while (m_scanner.hasNextLine() && !(ccpfLine = m_scanner.nextLine()).equalsIgnoreCase("<CCPF_BLOCK_END>")) {
                        outputLines4.add(ccpfLine);
                    }
                    if (ccpf.isEmpty()) continue;
                    for (int i = 0; i < outputLines4.size(); ++i) {
                        currLine = (String)outputLines4.get(i);
                        replacementsList = this.getReplacementsList(pattern, currLine);
                        if (!replacementsList.isEmpty()) {
                            currLine = this.resolveLine(currLine, replacementsList);
                        }
                        if (currLine.isEmpty()) continue;
                        m_fileWriter.write(currLine.toUpperCase() + endOfLine);
                    }
                    continue;
                }
                if (line.equalsIgnoreCase("<ADR_BLOCK_START>")) {
                    String adrLine;
                    String adr = jobTracEnvironment.getADR().trim();
                    ArrayList<String> outputLines5 = new ArrayList<String>();
                    while (m_scanner.hasNextLine() && !(adrLine = m_scanner.nextLine()).equalsIgnoreCase("<ADR_BLOCK_END>")) {
                        outputLines5.add(adrLine);
                    }
                    if (adr.isEmpty()) continue;
                    for (int i = 0; i < outputLines5.size(); ++i) {
                        currLine = (String)outputLines5.get(i);
                        replacementsList = this.getReplacementsList(pattern, currLine);
                        if (!replacementsList.isEmpty()) {
                            currLine = this.resolveLine(currLine, replacementsList);
                        }
                        if (currLine.isEmpty()) continue;
                        m_fileWriter.write(currLine.toUpperCase() + endOfLine);
                    }
                    continue;
                }
                if (line.equalsIgnoreCase("<AMR_BLOCK_START>")) {
                    String amrLine;
                    String amr = jobTracEnvironment.getAMR().trim();
                    ArrayList<String> outputLines6 = new ArrayList<String>();
                    while (m_scanner.hasNextLine() && !(amrLine = m_scanner.nextLine()).equalsIgnoreCase("<AMR_BLOCK_END>")) {
                        outputLines6.add(amrLine);
                    }
                    if (amr.isEmpty()) continue;
                    for (int i = 0; i < outputLines6.size(); ++i) {
                        currLine = (String)outputLines6.get(i);
                        replacementsList = this.getReplacementsList(pattern, currLine);
                        if (!replacementsList.isEmpty()) {
                            currLine = this.resolveLine(currLine, replacementsList);
                        }
                        if (currLine.isEmpty()) continue;
                        m_fileWriter.write(currLine.toUpperCase() + endOfLine);
                    }
                    continue;
                }
                if (line.equalsIgnoreCase("<SCS_BLOCK_START>")) {
                    String scsLine;
                    String scs = jobTracEnvironment.getSCS().trim();
                    ArrayList<String> outputLines7 = new ArrayList<String>();
                    while (m_scanner.hasNextLine() && !(scsLine = m_scanner.nextLine()).equalsIgnoreCase("<SCS_BLOCK_END>")) {
                        outputLines7.add(scsLine);
                    }
                    if (scs.isEmpty()) continue;
                    for (int i = 0; i < outputLines7.size(); ++i) {
                        currLine = (String)outputLines7.get(i);
                        replacementsList = this.getReplacementsList(pattern, currLine);
                        if (!replacementsList.isEmpty()) {
                            currLine = this.resolveLine(currLine, replacementsList);
                        }
                        if (currLine.isEmpty()) continue;
                        m_fileWriter.write(currLine.toUpperCase() + endOfLine);
                    }
                    continue;
                }
                if (line.equalsIgnoreCase("<RESOURCE_BLOCK_START>")) {
                    String resourceLine;
                    String resource = jobTracEnvironment.getRESOURCE().trim();
                    ArrayList<String> outputLines8 = new ArrayList<String>();
                    while (m_scanner.hasNextLine() && !(resourceLine = m_scanner.nextLine()).equalsIgnoreCase("<RESOURCE_BLOCK_END>")) {
                        outputLines8.add(resourceLine);
                    }
                    if (resource.isEmpty()) continue;
                    for (int i = 0; i < outputLines8.size(); ++i) {
                        currLine = (String)outputLines8.get(i);
                        replacementsList = this.getReplacementsList(pattern, currLine);
                        if (!replacementsList.isEmpty()) {
                            currLine = this.resolveLine(currLine, replacementsList);
                        }
                        if (currLine.isEmpty()) continue;
                        m_fileWriter.write(currLine.toUpperCase() + endOfLine);
                    }
                    continue;
                }
                if (line.equalsIgnoreCase("<EXCLPARM_BLOCK_START>")) {
                    String exclparmLine;
                    String exclparm = jobTracEnvironment.getEXCLPARM().trim();
                    ArrayList<String> outputLines9 = new ArrayList<String>();
                    while (m_scanner.hasNextLine() && !(exclparmLine = m_scanner.nextLine()).equalsIgnoreCase("<EXCLPARM_BLOCK_END>")) {
                        outputLines9.add(exclparmLine);
                    }
                    if (exclparm.isEmpty()) continue;
                    for (int i = 0; i < outputLines9.size(); ++i) {
                        currLine = (String)outputLines9.get(i);
                        replacementsList = this.getReplacementsList(pattern, currLine);
                        if (!replacementsList.isEmpty()) {
                            currLine = this.resolveLine(currLine, replacementsList);
                        }
                        if (currLine.isEmpty()) continue;
                        m_fileWriter.write(currLine.toUpperCase() + endOfLine);
                    }
                    continue;
                }
                String currLine2 = line;
                ArrayList<String> replacementsList2 = this.getReplacementsList(pattern, currLine2);
                if (!replacementsList2.isEmpty()) {
                    currLine2 = this.resolveLine(currLine2, replacementsList2);
                }
                if (currLine2.isEmpty()) continue;
                m_fileWriter.write(currLine2.toUpperCase() + endOfLine);
            }
            m_fileWriter.close();
        }
        Params.instance().setJobTracFileNameData(this.fileNameData);
        Params.instance().setJobTracOutputFile(outputFile);
    }

    private String buildJobCardStr(String jobCard2) {
        StringBuilder sb = new StringBuilder();
        String[] jobCardLines = jobCard2.split("\n");
        for (int i = 0; i < jobCardLines.length; ++i) {
            String currLine = jobCardLines[i];
            if (!currLine.startsWith("//")) continue;
            sb.append(currLine + endOfLine);
        }
        String tmp = sb.toString();
        int lastNewLine = tmp.lastIndexOf(endOfLine);
        return tmp.substring(0, lastNewLine);
    }

    private ArrayList<String> getReplacementsList(Pattern pattern, String line) {
        String tmpStr = line;
        Matcher matcher = pattern.matcher(tmpStr);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.matches()) {
            String group = matcher.group(1).trim();
            if (!list.contains(group)) {
                list.add(group);
            }
            tmpStr = matcher.group(2).trim();
            matcher = pattern.matcher(tmpStr);
        }
        return list;
    }

    private String resolveLine(String line, ArrayList<String> list) {
        for (String pattern : list) {
            String replacement = this.resolvePattern(pattern);
            line = line.replaceAll(pattern, replacement);
        }
        return line;
    }

    private String resolvePattern(String pattern) {
        String ret = "";
        if (pattern.equalsIgnoreCase("<DATA_FILENAME>")) {
            return this.fileNameData;
        }
        if (pattern.equalsIgnoreCase("<JOB_CARD>")) {
            return this.jobCard;
        }
        if (pattern.equalsIgnoreCase("<UNIT>")) {
            return this.unit;
        }
        if (pattern.equalsIgnoreCase("<VOLSER>")) {
            return this.volser;
        }
        if (pattern.equalsIgnoreCase("<SMS_DATA_CLASS>")) {
            return this.data;
        }
        if (pattern.equalsIgnoreCase("<SMS_STORAGE_CLASS>")) {
            return this.storage;
        }
        if (pattern.equalsIgnoreCase("<SMS_MANAGEMENT_CLASS>")) {
            return this.management;
        }
        if (pattern.equalsIgnoreCase("<PRIMARY_ALLOCATION>")) {
            return this.primaryAllocation;
        }
        if (pattern.equalsIgnoreCase("<SECONDARY_ALLOCATION>")) {
            return this.secondaryAllocation;
        }
        if (pattern.equalsIgnoreCase("<SCL>")) {
            ret = this.jobTracEnvironment.getSCLList().get(sclCounter);
        } else if (pattern.equalsIgnoreCase("<SCL_COUNTER>")) {
            ret = String.valueOf(sclCounter);
        } else if (pattern.equalsIgnoreCase("<JCL>")) {
            ret = this.jobTracEnvironment.getJCLList().get(jclCounter);
        } else if (pattern.equalsIgnoreCase("<JCL_COUNTER>")) {
            ret = String.valueOf(jclCounter);
        } else if (pattern.equalsIgnoreCase("<ADR>")) {
            ret = this.jobTracEnvironment.getADR();
        } else if (pattern.equalsIgnoreCase("<AMR>")) {
            ret = this.jobTracEnvironment.getAMR();
        } else if (pattern.equalsIgnoreCase("<CCPF>")) {
            ret = this.jobTracEnvironment.getCCPF();
        } else if (pattern.equalsIgnoreCase("<ADI>")) {
            ret = this.jobTracEnvironment.getADI();
        } else if (pattern.equalsIgnoreCase("<JMF>")) {
            ret = this.jobTracEnvironment.getJMF();
        } else if (pattern.equalsIgnoreCase("<SCS>")) {
            ret = this.jobTracEnvironment.getSCS();
        } else if (pattern.equalsIgnoreCase("<EXCLPARM>")) {
            ret = this.jobTracEnvironment.getEXCLPARM();
        } else if (pattern.equalsIgnoreCase("<RESOURCE>")) {
            ret = this.jobTracEnvironment.getRESOURCE();
        }
        return ret.trim();
    }

    public boolean execute(String sInputFile, String sPath, BaseProgressBar progressBar) throws ConvertorCancelClickException {
        String string;
        MergeCSVFilesIntoOne merger;
        JobTracInputFileParser inputParser;
        if (progressBar != null) {
            progressBar.setProgressValue(5);
        }
        if (!(inputParser = new JobTracInputFileParser(sInputFile, sPath, progressBar)).SplitJobTracFile()) {
            return false;
        }
        if (progressBar != null) {
            progressBar.setProgressValue(20);
        }
        ArrayList<String> listOfFiles = inputParser.getListOfOutputFileNames();
        inputParser = null;
        SCLsTrackerOfMEMBERs.initSCLsTrackerOfMEMBERs(sPath + Globs.DIRSEP + "MEMBERs_SCL.txt");
        ConvertSCLToCSV.initSLCConvertors();
        ConvertAbstractToCSV convertorToCSV = null;
        double progress = 20.0;
        double delta = 3.0;
        String filePath = sPath + Globs.DIRSEP;
        for (String fileName : listOfFiles) {
            String fullFileName = sPath + Globs.DIRSEP + fileName;
            boolean bIsSCLFile = false;
            if (fileName.startsWith("ADR_")) {
                convertorToCSV = new ConvertADRToCSV(fullFileName, filePath + "ADR_Tables.csv");
            } else if (fileName.startsWith("AMR_")) {
                convertorToCSV = new ConvertAMRToCSV(fullFileName, filePath + "AMR_Tables.csv");
            } else if (fileName.startsWith("SCS_")) {
                convertorToCSV = new ConvertSCSToCSV(fullFileName, filePath + "SCS_Tables.csv");
            } else if (fileName.startsWith("RES.")) {
                convertorToCSV = new ConvertRESOURCEToCSV(fullFileName, filePath + "RESOURCE_Table.csv");
            } else if (fileName.startsWith("CCPF_")) {
                convertorToCSV = new ConvertCCPFToCSV(fullFileName, filePath + "CCPF_Tables.csv");
            } else if (fileName.startsWith("JCL_")) {
                ConvertJCLToCSV jclConvertor = new ConvertJCLToCSV(fileName.replaceAll("JCL_", ""), fullFileName, fullFileName.replaceAll("JCL_", "JCLCSV_") + ".csv");
                jclConvertor.convertData();
            } else if (fileName.startsWith("SCL_")) {
                convertorToCSV = new ConvertSCLToCSV(fullFileName, fullFileName + ".csv");
                bIsSCLFile = true;
            }
            if (null != convertorToCSV) {
                if (!convertorToCSV.doConversion()) {
                    SCLsTrackerOfMEMBERs.closeSCLsTrackerOfMEMBERs();
                    return false;
                }
                if (bIsSCLFile) {
                    ConvertSCLToCSV tempSCL = (ConvertSCLToCSV)convertorToCSV;
                    SCLsTrackerOfMEMBERs.writeDataToFile(fileName.replaceAll("SCL_", ""), tempSCL.getListOfMEMBERs());
                    if (tempSCL.getNumberOfJobsInSCL() >= JobTracGlobals.MAX_JOBS_IN_SCL_CSV_FILE) {
                        SCLsLargeCSVFilesSplitter splitter = new SCLsLargeCSVFilesSplitter();
                        splitter.splitLargeFile(fullFileName + ".csv", ".csv");
                    }
                }
                convertorToCSV = null;
            }
            progress += delta;
            if (progressBar != null && progress <= 80.0) {
                progressBar.setProgressValue((int)progress);
            }
            if (progressBar == null || !progressBar.isCancelled()) continue;
            SCLsTrackerOfMEMBERs.closeSCLsTrackerOfMEMBERs();
            throw new ConvertorCancelClickException();
        }
        SCLsTrackerOfMEMBERs.closeSCLsTrackerOfMEMBERs();
        ArrayList<String> listOfSCLs = new ArrayList<String>();
        for (String string2 : listOfFiles) {
            if (!string2.startsWith("SCL_")) continue;
            String CSVFname = sPath + Globs.DIRSEP + string2 + ".csv";
            String UnsplitFname = CSVFname + ".unsplit";
            File CSVFile = new File(CSVFname);
            File UnsplitFile = new File(UnsplitFname);
            if (!CSVFile.isFile() && UnsplitFile.isFile()) {
                listOfSCLs.add(UnsplitFname);
                continue;
            }
            listOfSCLs.add(CSVFname);
        }
        ArrayList<String> listOfJCLs = new ArrayList<String>();
        for (String fileName : listOfFiles) {
            if (!fileName.startsWith("JCL_")) continue;
            listOfJCLs.add(sPath + Globs.DIRSEP + fileName.replaceAll("JCL_", "JCLCSV_") + ".csv");
        }
        if (progressBar != null) {
            if (progressBar.isCancelled()) {
                throw new ConvertorCancelClickException();
            }
            progressBar.setProgressValue(80);
        }
        if (!(merger = new MergeCSVFilesIntoOne(listOfSCLs, string = sPath + Globs.DIRSEP + "MergedSCLs.csv")).mergeFiles()) {
            return false;
        }
        String string3 = sPath + Globs.DIRSEP + "MergedJCLs.csv";
        merger = new MergeCSVFilesIntoOne(listOfJCLs, string3);
        if (!merger.mergeFiles()) {
            return false;
        }
        merger = null;
        return true;
    }

    static {
        sclCounter = 0;
        jclCounter = 0;
    }
}

