/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.Reporter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Scanner;

public class JobtracADIConvertor {
    private PrintStream m_outstream = null;
    private InputStream m_instream = null;
    private String m_ADIINCLIB;
    private ArrayList<String> m_messages = null;
    String newLine = System.getProperty("line.separator");

    public JobtracADIConvertor(String inputFile, String outputFile, String inclibName) throws FileNotFoundException {
        this(new FileInputStream(inputFile), new PrintStream(outputFile), inclibName);
    }

    public JobtracADIConvertor(InputStream m_instream, PrintStream m_outstream, String inclibName) {
        this.m_instream = m_instream;
        this.m_outstream = m_outstream;
        this.m_ADIINCLIB = inclibName;
        this.m_messages = new ArrayList();
    }

    public void convert() {
        Scanner sc = new Scanner(this.m_instream);
        String outputLine = "";
        Integer lineNumber = 0;
        String varname = "";
        String varvalue = "";
        Object jclCommand = "";
        jclCommand = "//ADI EXEC PGM=IEBUPDTE,PARM=NEW" + this.newLine;
        jclCommand = (String)jclCommand + "//SYSABEND  DD SYSOUT=*" + this.newLine;
        jclCommand = (String)jclCommand + "//SYSMDUMP  DD SYSOUT=*" + this.newLine;
        jclCommand = (String)jclCommand + "//SYSUDUMP  DD SYSOUT=*" + this.newLine;
        jclCommand = (String)jclCommand + "//SYSPRINT  DD SYSOUT=*" + this.newLine;
        jclCommand = (String)jclCommand + "//SYSUT2   DD DISP=SHR,DSN=" + this.m_ADIINCLIB + this.newLine;
        jclCommand = (String)jclCommand + "//SYSIN    DD DATA,DLM=@@";
        this.m_outstream.println((String)jclCommand);
        while (sc.hasNext()) {
            String line = sc.nextLine();
            lineNumber = lineNumber + 1;
            if (this.skipThisLine(line)) continue;
            line.trim();
            varname = line.substring(0, 8).trim();
            varvalue = this.convertLine(line.substring(8).trim());
            if (varvalue.length() > 80) {
                Reporter.addMessage(this.m_messages, (String)"WRN5000", (String)"$$$_ADI", (String[])new String[]{"ADI", varname});
            }
            outputLine = this.createJCLCommand(varname, varvalue);
            this.m_outstream.println(outputLine);
        }
        jclCommand = "";
        jclCommand = (String)jclCommand + "./ ENDUP" + this.newLine;
        jclCommand = (String)jclCommand + "@@" + this.newLine;
        jclCommand = (String)jclCommand + "/*" + this.newLine;
        this.m_outstream.println((String)jclCommand);
        this.m_outstream.close();
        sc.close();
    }

    private String createJCLCommand(String varname, String varvalue) {
        Object jclCommand = "";
        jclCommand = "./ ADD NAME=" + varname + this.newLine;
        jclCommand = (String)jclCommand + varvalue;
        return jclCommand;
    }

    private String convertLine(String varvalue) {
        if (!varvalue.contains("=&:")) {
            varvalue = this.repVar(varvalue, "\\M3", "%%OSM3");
            varvalue = this.repVar(varvalue, "\\M9", "%%OSM9");
            varvalue = this.repVar(varvalue, "\\YDDD", "%%OYEAR.%%OJULDAY");
            varvalue = this.repVar(varvalue, "\\M", "%%OMONTH");
            varvalue = this.repVar(varvalue, "\\D", "%%ODAY");
            varvalue = this.repVar(varvalue, "\\YYY", "%%$OYEAR");
            varvalue = this.repVar(varvalue, "\\Y", "%%OYEAR");
        } else {
            varvalue = varvalue.replaceAll("&:", "%%");
        }
        return varvalue;
    }

    private String repVar(String varValue, String jobtracVar, String ctmVar) {
        String retValue = varValue;
        retValue = retValue.replace(jobtracVar + "\\", ctmVar + ".\\");
        retValue = retValue.replace(jobtracVar + "%", ctmVar + ".%");
        retValue = retValue.replace(jobtracVar, ctmVar);
        return retValue;
    }

    private boolean skipThisLine(String line) {
        return !Character.isLetter(line.charAt(0));
    }

    public ArrayList<String> getMessages() {
        return this.m_messages == null ? new ArrayList<String>() : this.m_messages;
    }
}

