/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.io.csv.CsvReader;
import com.bmc.ctmconvert.jobtrac.CSVReaderTable;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import java.util.ArrayList;
import java.util.HashMap;

public class JobTracAssessmentCSVDirectoryReader {
    private String[] m_jobColumnsHeaders;
    private int m_rowsCount = 0;
    private int m_jobsCount = 0;
    private static final String sPrefixCYC = "@CYC";
    private static final String sPrefixHOL = "@HOL";
    private HashMap<String, HashMap<String, ArrayList<String>>> m_AMR_Table_Info = new HashMap();
    private HashMap<String, HashMap<String, ArrayList<String>>> m_ADR_Table_Info = new HashMap();
    private HashMap<String, HashMap<String, ArrayList<String>>> m_SCS_Table_Info = new HashMap();
    private HashMap<String, ArrayList<Integer>> m_Location_JobsIDList = new HashMap();
    private HashMap<String, ArrayList<Integer>> m_BUSGRP_JobsIDList = new HashMap();
    private HashMap<String, ArrayList<Integer>> m_NODE_JobsIDList = new HashMap();
    private HashMap<String, ArrayList<Integer>> m_CAL_CYC_JobsIDList = new HashMap();
    private HashMap<String, ArrayList<Integer>> m_CAL_HOL_JobsIDList = new HashMap();
    private HashMap<String, ArrayList<String>> m_JobID_Info = new HashMap();
    private ArrayList<String> m_EventsNamesList = new ArrayList();

    public int getJobsNumber() {
        return this.m_jobsCount;
    }

    public String[] getJobColumnsHeaders() {
        return this.m_jobColumnsHeaders;
    }

    public ArrayList<String> getJobInfo(String jobName) {
        return this.m_JobID_Info.get(jobName);
    }

    public ArrayList<String> getAllJobsList() {
        return new ArrayList<String>(this.m_JobID_Info.keySet());
    }

    public ArrayList<String> getJobsListOfLocation(String locationID) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i : this.m_Location_JobsIDList.get(locationID)) {
            resultList.add(this.m_EventsNamesList.get(i));
        }
        return resultList;
    }

    public ArrayList<String> getAllLocationsList() {
        return new ArrayList<String>(this.m_Location_JobsIDList.keySet());
    }

    public ArrayList<String> getJobsListOfNODE(String nodeID) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i : this.m_NODE_JobsIDList.get(nodeID)) {
            resultList.add(this.m_EventsNamesList.get(i));
        }
        return resultList;
    }

    public ArrayList<String> getAllNODEsList() {
        return new ArrayList<String>(this.m_NODE_JobsIDList.keySet());
    }

    public ArrayList<String> getJobsListOfCalendarCYC(String calendarID) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i : this.m_CAL_CYC_JobsIDList.get(calendarID)) {
            resultList.add(this.m_EventsNamesList.get(i));
        }
        return resultList;
    }

    public ArrayList<String> getAllCalendarsCYCList() {
        return new ArrayList<String>(this.m_CAL_CYC_JobsIDList.keySet());
    }

    public ArrayList<String> getJobsListOfCalendarHOL(String calendarID) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i : this.m_CAL_HOL_JobsIDList.get(calendarID)) {
            resultList.add(this.m_EventsNamesList.get(i));
        }
        return resultList;
    }

    public ArrayList<String> getAllCalendarsHOLList() {
        return new ArrayList<String>(this.m_CAL_HOL_JobsIDList.keySet());
    }

    public ArrayList<String> getJobsListOfBUSGRP(String busgrpID) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i : this.m_BUSGRP_JobsIDList.get(busgrpID)) {
            resultList.add(this.m_EventsNamesList.get(i));
        }
        return resultList;
    }

    public ArrayList<String> getAllBUSGRPsList() {
        return new ArrayList<String>(this.m_BUSGRP_JobsIDList.keySet());
    }

    public JobTracAssessmentCSVDirectoryReader(String path) {
        this.loadMergedSCLFile(path + Globs.DIRSEP + "MergedSCLs.csv");
        CSVReaderTable tablesReader = new CSVReaderTable();
        boolean bLoaded = false;
        String tempFileName = path + Globs.DIRSEP + "SCS_Tables.csv";
        if (GlobalFunctions.isFileExist((String)tempFileName) && (bLoaded = tablesReader.loadTableFile(tempFileName, "SCS"))) {
            this.m_SCS_Table_Info = tablesReader.getAllTables();
        }
        if (GlobalFunctions.isFileExist((String)(tempFileName = path + Globs.DIRSEP + "ADR_Tables.csv")) && (bLoaded = tablesReader.loadTableFile(tempFileName, "ADR"))) {
            this.m_ADR_Table_Info = tablesReader.getAllTables();
        }
        if (GlobalFunctions.isFileExist((String)(tempFileName = path + Globs.DIRSEP + "AMR_Tables.csv")) && (bLoaded = tablesReader.loadTableFile(tempFileName, "AMR"))) {
            this.m_AMR_Table_Info = tablesReader.getAllTables();
        }
    }

    private void loadMergedSCLFile(String fileName) {
        try {
            CsvReader reader = new CsvReader(fileName);
            String sMemberName = "";
            int index_MemberName = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "SCLmember");
            Object sEventName = "";
            int index_EventName = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "EVENTNM");
            String sEventVersion = "";
            int index_EventVersion = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "EventVersion");
            Object sEventID = "";
            Object sPreviousEventID = "";
            String sLocation = "";
            int index_Location = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "LocationID");
            int index_G_Location = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "@SETLOC");
            String sNODE = "";
            int index_NODE = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "R_NODE");
            String s_G_BUSGRP = "";
            int index_G_BUSGRP = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "BUSGRP");
            Object sCAL_CYC = "";
            int index_CAL_G_CYC = JobTracGlobals.getIndexOfHeaderInCSV("SCL", sPrefixCYC);
            Object sCAL_HOL = "";
            int index_CAL_G_HOL = JobTracGlobals.getIndexOfHeaderInCSV("SCL", sPrefixHOL);
            String sCurrentJobID = "";
            String sPreviousJobID = "";
            int index_JobID = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "JobID");
            reader.readRecord();
            this.m_jobColumnsHeaders = new String[reader.getValues().length];
            for (int i = 0; i < this.m_jobColumnsHeaders.length; ++i) {
                this.m_jobColumnsHeaders[i] = reader.getValues()[i].replaceAll("\"", "");
            }
            ArrayList<Integer> sonsList = null;
            int iJobCounter = -1;
            String charsFormat8 = "%1$-8s";
            while (reader.readRecord()) {
                sMemberName = String.format(charsFormat8, reader.getValues()[index_MemberName]);
                sEventName = String.format(charsFormat8, reader.getValues()[index_EventName]);
                sEventVersion = reader.getValues()[index_EventVersion];
                sCurrentJobID = reader.getValues()[index_JobID];
                if (!sEventVersion.isEmpty()) {
                    sEventName = (String)sEventName + " - " + sEventVersion;
                }
                if (!((String)(sEventID = sMemberName + " - " + (String)sEventName)).equals(sPreviousEventID)) {
                    this.m_EventsNamesList.add((String)sEventID);
                    ++iJobCounter;
                }
                sLocation = !reader.getValues()[index_Location].isEmpty() ? reader.getValues()[index_Location] : reader.getValues()[index_G_Location];
                if (!sCurrentJobID.equalsIgnoreCase(sPreviousJobID) && !sLocation.isEmpty()) {
                    sonsList = this.m_Location_JobsIDList.get(sLocation);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add(iJobCounter);
                    this.m_Location_JobsIDList.put(sLocation, sonsList);
                }
                if (!(sNODE = reader.getValues()[index_NODE]).isEmpty()) {
                    sonsList = this.m_NODE_JobsIDList.get(sNODE = sNODE.split("=")[1]);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add(iJobCounter);
                    this.m_NODE_JobsIDList.put(sNODE, sonsList);
                }
                s_G_BUSGRP = reader.getValues()[index_G_BUSGRP];
                if (!(sCurrentJobID.equalsIgnoreCase(sPreviousJobID) || s_G_BUSGRP.isEmpty() || s_G_BUSGRP.isEmpty())) {
                    sonsList = this.m_BUSGRP_JobsIDList.get(s_G_BUSGRP);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add(iJobCounter);
                    this.m_BUSGRP_JobsIDList.put(s_G_BUSGRP, sonsList);
                }
                sCAL_CYC = !reader.getValues()[index_Location].isEmpty() ? sPrefixCYC + sLocation : (!reader.getValues()[index_CAL_G_CYC].isEmpty() ? (reader.getValues()[index_CAL_G_CYC].endsWith("(OVR)") ? reader.getValues()[index_CAL_G_CYC].replace("(OVR)", "") : reader.getValues()[index_CAL_G_CYC]) : (!reader.getValues()[index_G_Location].isEmpty() ? sPrefixCYC + reader.getValues()[index_G_Location] : ""));
                if (!sCurrentJobID.equalsIgnoreCase(sPreviousJobID) && !((String)sCAL_CYC).isEmpty()) {
                    sonsList = this.m_CAL_CYC_JobsIDList.get(sCAL_CYC);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add(iJobCounter);
                    this.m_CAL_CYC_JobsIDList.put((String)sCAL_CYC, sonsList);
                }
                sCAL_HOL = !reader.getValues()[index_Location].isEmpty() ? sPrefixHOL + sLocation : (!reader.getValues()[index_CAL_G_HOL].isEmpty() ? (reader.getValues()[index_CAL_G_HOL].endsWith("(OVR)") ? reader.getValues()[index_CAL_G_HOL].replace("(OVR)", "") : reader.getValues()[index_CAL_G_HOL]) : (!reader.getValues()[index_G_Location].isEmpty() ? sPrefixHOL + reader.getValues()[index_G_Location] : ""));
                if (!sCurrentJobID.equalsIgnoreCase(sPreviousJobID) && !((String)sCAL_HOL).isEmpty()) {
                    sonsList = this.m_CAL_HOL_JobsIDList.get(sCAL_HOL);
                    if (null == sonsList) {
                        sonsList = new ArrayList();
                    }
                    sonsList.add(iJobCounter);
                    this.m_CAL_HOL_JobsIDList.put((String)sCAL_HOL, sonsList);
                }
                ++this.m_rowsCount;
                sPreviousJobID = sCurrentJobID;
                sPreviousEventID = sEventID;
            }
            this.m_jobsCount = Integer.parseInt(sCurrentJobID);
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in loadSCLFiles");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + this.m_rowsCount));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
        }
    }

    public ArrayList<String> getTablesListOfType(String tableType) {
        if (tableType.equals("AMR")) {
            if (null != this.m_AMR_Table_Info) {
                return new ArrayList<String>(this.m_AMR_Table_Info.keySet());
            }
            return null;
        }
        if (tableType.equals("ADR")) {
            if (null != this.m_ADR_Table_Info) {
                return new ArrayList<String>(this.m_ADR_Table_Info.keySet());
            }
            return null;
        }
        if (tableType.equals("SCS")) {
            if (null != this.m_SCS_Table_Info) {
                return new ArrayList<String>(this.m_SCS_Table_Info.keySet());
            }
            return null;
        }
        ExceptionHandler.writeToExceptionFile((String)("Error in getTablesListOfType - Unknown Table Type : " + tableType));
        return null;
    }

    public HashMap<String, ArrayList<String>> getTableContent(String tableType, String tableName) {
        if (tableType.equals("AMR")) {
            return this.m_AMR_Table_Info.get(tableName);
        }
        if (tableType.equals("ADR")) {
            return this.m_ADR_Table_Info.get(tableName);
        }
        if (tableType.equals("SCS")) {
            return this.m_SCS_Table_Info.get(tableName);
        }
        ExceptionHandler.writeToExceptionFile((String)("Error in getTableContent - Unknown Table Type : " + tableType));
        return null;
    }
}

