/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.base.BaseBrowseTextField;
import com.bmc.ctmconvert.base.BaseButtonGroup;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseRadioButton;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTableAddRemoveWrapper;
import com.bmc.ctmconvert.base.BaseTextArea;
import com.bmc.ctmconvert.base.BaseTextContainer;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.jobtrac.DataImportJobTracParameters;
import com.bmc.ctmconvert.jobtrac.JobtracExecuter;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class DataImportJobtrac
extends DataImportVendor {
    private ImportPanels importPanels = ImportPanels.DEFAULT;
    private BaseContentPanel generateOrExistingPanel;
    private BaseContentPanel jclParamsPanel;
    private BaseContentPanel environmentPanel;
    private BaseContentPanel instructionPanel;
    private BaseRadioButton generateNew;
    private BaseRadioButton existingData;
    private BaseTextField outputFileNameData;
    private BaseTextArea jobCard;
    private BaseTextField unit;
    private BaseTextField volser;
    private BaseTextField data;
    private BaseTextField storage;
    private BaseTextField managment;
    private BaseTextField primaryAlloc;
    private BaseTextField secondaryAlloc;
    private BaseTextField JCLFileName;
    private BaseTableAddRemoveWrapper SCLTableWrapper;
    private DefaultTableModel SCLTableModel;
    private JTable SCLTable;
    private BaseTableAddRemoveWrapper JCLTableWrapper;
    private DefaultTableModel JCLTableModel;
    private JTable JCLTable;
    private BaseTextField JMF_textField;
    private BaseTextField ADI_textField;
    private BaseTextField CCPF_textField;
    private BaseTextField ADR_textField;
    private BaseTextField AMR_textField;
    private BaseTextField SCS_textField;
    private BaseTextField RESOURCE_textField;
    private BaseTextField EXCLPARM_textField;
    private BaseBrowseTextField jobDefinitions;
    private DataImportJobTracParameters jobTracParameters = new DataImportJobTracParameters();
    private JobtracExecuter jobtracExecuter = new JobtracExecuter();

    public DataImportJobtrac() {
        this.importPanel = new BaseContentPanel(new BaseTitlePanel(), new BaseFooterPanel(""));
        BaseSection section = new BaseSection(TextManager.instance().get("SECTION_IMPORT_DATA"));
        this.jobDefinitions = new BaseBrowseTextField(new String[]{"TXT"}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH));
        String strExist = String.format(TextManager.instance().get("JOBTRAC_LOAD_DEFINITION_DESCRIPTION"), "\n");
        section.addField(new BaseField((BaseComponent)this.jobDefinitions, TextManager.instance().get("FIELD_JOBTRAC_JOB_DEFINITIONS"), true, strExist));
        this.importPanel.addSection(section);
        this.importPanel.buildContentPanel();
    }

    public DataImportVendor.ImportPosition getImportPosition() {
        switch (this.importPanels.ordinal()) {
            case 0: 
            case 5: {
                return DataImportVendor.ImportPosition.START;
            }
            case 1: 
            case 2: 
            case 3: {
                return DataImportVendor.ImportPosition.MIDDLE;
            }
        }
        return DataImportVendor.ImportPosition.END;
    }

    public Component getDefaultFocusedComponent() {
        switch (this.importPanels.ordinal()) {
            case 0: {
                return this.generateNew.isSelected() ? this.generateNew.getComponent() : this.existingData.getComponent();
            }
            case 1: {
                return this.JCLFileName.getComponent();
            }
            case 2: {
                return this.SCLTableWrapper.getComponent();
            }
            case 4: {
                return this.jobDefinitions.getComponent();
            }
        }
        return null;
    }

    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        boolean bOk;
        progressBar.setLabel(TextManager.instance().get("JOBTRAC_PROGRESS_BAR_PROCESSING_FILE"));
        File cauexprFile = new File(this.jobDefinitions.getText());
        try {
            bOk = this.jobtracExecuter.execute(cauexprFile.toString(), destinationFolderPath, progressBar);
        }
        catch (ConvertorCancelClickException e) {
            ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            return FlowGlobals.COMPLETION_MODE.ABORTED;
        }
        return bOk ? FlowGlobals.COMPLETION_MODE.SUCCESS : FlowGlobals.COMPLETION_MODE.FAILURE;
    }

    public BaseContentPanel getNextPanel() {
        switch (this.importPanels.ordinal()) {
            case 0: {
                if (this.generateNew.isValid()) {
                    this.importPanels = ImportPanels.JCL_PARAMS;
                    return this.jclParamsPanel();
                }
                this.importPanels = ImportPanels.DATA_IMPORT;
                return this.importPanel;
            }
            case 1: {
                this.importPanels = ImportPanels.ENVIRONMENT;
                return this.environmentPanel();
            }
            case 2: {
                this.fillJobTracParameters();
                this.jobtracExecuter.generateCollectDataScript(this.jobTracParameters);
                this.importPanels = ImportPanels.INSTRUCTION;
                return this.instructionPanel();
            }
            case 3: {
                this.importPanels = ImportPanels.DATA_IMPORT;
                return this.importPanel;
            }
            case 4: {
                return null;
            }
        }
        this.importPanels = ImportPanels.GENERATE_OR_EXISTING;
        return this.generateOrExistingPanel();
    }

    public BaseContentPanel getPrevPanel() {
        switch (this.importPanels.ordinal()) {
            case 0: {
                return null;
            }
            case 1: {
                this.importPanels = ImportPanels.GENERATE_OR_EXISTING;
                return this.generateOrExistingPanel();
            }
            case 2: {
                this.importPanels = ImportPanels.JCL_PARAMS;
                return this.jclParamsPanel();
            }
            case 3: {
                this.importPanels = ImportPanels.ENVIRONMENT;
                return this.environmentPanel();
            }
            case 4: {
                if (this.generateNew.isValid()) {
                    this.importPanels = ImportPanels.INSTRUCTION;
                    return this.instructionPanel();
                }
                this.importPanels = ImportPanels.GENERATE_OR_EXISTING;
                return this.generateOrExistingPanel();
            }
        }
        this.importPanels = ImportPanels.DATA_IMPORT;
        return this.importPanel;
    }

    private BaseContentPanel generateOrExistingPanel() {
        if (this.generateOrExistingPanel == null) {
            this.generateOrExistingPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("CAPTURE_DATA_TITLE_IMPORT_JOBTRAC")), new BaseFooterPanel(""));
            BaseSection section = new BaseSection();
            BaseButtonGroup buttonsGroup = new BaseButtonGroup();
            this.generateNew = new BaseRadioButton(TextManager.instance().get("FIELD_JOBTRAC_DEFINE_NEW"));
            this.generateNew.setActionCommand(TextManager.instance().get("FIELD_JOBTRAC_DEFINE_NEW"));
            this.generateNew.setSelected(true);
            buttonsGroup.add(this.generateNew);
            String strNew = String.format(TextManager.instance().get("JOBTRAC_DEFINING_NEW_CONVERSION_DESCRIPTION"), "\n", "\n");
            BaseField generateNewField = new BaseField((BaseComponent)this.generateNew, null, strNew);
            generateNewField.fillFieldSize(true);
            section.addField(generateNewField);
            this.existingData = new BaseRadioButton(TextManager.instance().get("FIELD_JOBTRAC_LOAD_EXISTING"));
            this.existingData.setActionCommand(TextManager.instance().get("FIELD_JOBTRAC_LOAD_EXISTING"));
            buttonsGroup.add(this.existingData);
            String strExist = String.format(TextManager.instance().get("JOBTRAC_LOAD_EXISTING_CONVERSION_DESCRIPTION"), "\n");
            BaseField existingDataField = new BaseField((BaseComponent)this.existingData, null, strExist);
            existingDataField.fillFieldSize(true);
            section.addField(existingDataField);
            this.generateOrExistingPanel.addSection(section);
            this.generateOrExistingPanel.buildContentPanel();
            this.generateOrExistingPanel.setValid(true);
        }
        return this.generateOrExistingPanel;
    }

    private BaseContentPanel jclParamsPanel() {
        if (this.jclParamsPanel == null) {
            this.jclParamsPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("CAPTURE_DATA_TITLE_IMPORT_JOBTRAC")), new BaseFooterPanel(""));
            BaseSection generateDataSection = new BaseSection(TextManager.instance().get("SECTION_JCL_PARAMETERS"));
            String JCLFileNameStr = this.jobTracParameters.getJCL();
            this.JCLFileName = new BaseTextField(JCLFileNameStr != null ? JCLFileNameStr : "Jobtrac_collect_data.jcl", new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
            String descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_JCL_CREATED_FILE_DESCRIPTION"), "\n");
            generateDataSection.addField(new BaseField((BaseComponent)this.JCLFileName, TextManager.instance().get("FIELD_JOBTRAC_JCL"), true, descriptionMsg));
            String text = this.jobTracParameters.getOUTPUT_FILE_NAME();
            if (text == null || text.isEmpty()) {
                text = "CTM.JBT.OUT";
            }
            this.outputFileNameData = new BaseTextField(text, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
            this.outputFileNameData.setFieldLimit(44);
            descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_OUTPUT_DATA_FILE_NAME_DESCRIPTION"), "\n", "\n");
            generateDataSection.addField(new BaseField((BaseComponent)this.outputFileNameData, TextManager.instance().get("FIELD_JOBTRAC_OUTPUT_FILE_NAME"), true, descriptionMsg));
            String jobCardStr = this.jobTracParameters.getJOB_CARD();
            this.jobCard = new BaseTextArea(jobCardStr != null ? jobCardStr : "//CTMCONV JOB", new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
            descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_JOB_CARD_DESCRIPTION"), "\n");
            generateDataSection.addField(new BaseField((BaseComponent)this.jobCard, TextManager.instance().get("FIELD_JOBTRAC_JOB_CARD"), true, descriptionMsg));
            this.unit = new BaseTextField(this.jobTracParameters.getUNIT());
            descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_UNIT_DESCRIPTION"), "\n");
            generateDataSection.addField(new BaseField((BaseComponent)this.unit, TextManager.instance().get("FIELD_JOBTRAC_UNIT"), descriptionMsg));
            this.volser = new BaseTextField(this.jobTracParameters.getVOLSER());
            this.volser.setFieldLimit(6);
            generateDataSection.addField(new BaseField((BaseComponent)this.volser, TextManager.instance().get("FIELD_JOBTRAC_VOLSER"), TextManager.instance().get("JOBTRAC_VOLSER_DESCRIPTION")));
            this.data = new BaseTextField(this.jobTracParameters.getSMS_DATA_CLASS());
            generateDataSection.addField(new BaseField((BaseComponent)this.data, TextManager.instance().get("FIELD_JOBTRAC_SMS_DATA_CLASS"), TextManager.instance().get("JOBTRAC_SMS_DATA_CLASS_DESCRIPTION")));
            this.storage = new BaseTextField(this.jobTracParameters.getSMS_STORAGE_CLASS());
            generateDataSection.addField(new BaseField((BaseComponent)this.storage, TextManager.instance().get("FIELD_JOBTRAC_SMS_STORAGE_CLASS"), TextManager.instance().get("JOBTRAC_SMS_STORAGE_CLASS_DESCRIPTION")));
            this.managment = new BaseTextField(this.jobTracParameters.getSMS_MANAGMENT_CLASS());
            generateDataSection.addField(new BaseField((BaseComponent)this.managment, TextManager.instance().get("FIELD_JOBTRAC_SMS_MANAGMENT_CLASS"), TextManager.instance().get("JOBTRAC_SMS_MANAGEMENT_CLASS_DESCRIPTION")));
            String primaryAllocStr = this.jobTracParameters.getPRIMARY_ALLOCATION();
            this.primaryAlloc = new BaseTextField(primaryAllocStr != null ? primaryAllocStr : "100", new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
            generateDataSection.addField(new BaseField((BaseComponent)this.primaryAlloc, TextManager.instance().get("FIELD_JOBTRAC_PRIMARY_ALLOCATION"), true, TextManager.instance().get("JOBTRAC_PRIMARY_ALLOCATION_CYL_DESCRIPTION")));
            String secondaryAllocStr = this.jobTracParameters.getSECONDERY_ALLOCATION();
            this.secondaryAlloc = new BaseTextField(secondaryAllocStr != null ? secondaryAllocStr : "100", new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
            generateDataSection.addField(new BaseField((BaseComponent)this.secondaryAlloc, TextManager.instance().get("FIELD_JOBTRAC_SECONDERY_ALLOCATION"), true, TextManager.instance().get("JOBTRAC_SECONDARY_ALLOCATION_CYL_DESCRIPTION")));
            this.jclParamsPanel.addSection(generateDataSection);
            this.jclParamsPanel.buildContentPanel();
            generateDataSection.setValid(generateDataSection.isValid());
        }
        return this.jclParamsPanel;
    }

    private BaseContentPanel environmentPanel() {
        if (this.environmentPanel == null) {
            String descriptionMsg = null;
            this.environmentPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("CAPTURE_DATA_TITLE_IMPORT_JOBTRAC")), new BaseFooterPanel(""));
            BaseSection enviromentParameters = new BaseSection(TextManager.instance().get("SECTION_JOBTRAC_ENVIRONMENT_PARAMETERS"));
            Object[][] data = this.getDataForTable(this.jobTracParameters.getSCLList());
            Object[] col = new String[]{TextManager.instance().get("JOBTRAC_ENVIRONMENT_SCL_COLUMN")};
            this.SCLTableModel = new DefaultTableModel(data, col);
            this.SCLTableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    DataImportJobtrac.this.environmentPanel.setValid(DataImportJobtrac.this.checkTableValid(DataImportJobtrac.this.SCLTableModel) && DataImportJobtrac.this.checkTableValid(DataImportJobtrac.this.JCLTableModel));
                }
            });
            this.SCLTable = new JTable(this.SCLTableModel);
            this.SCLTableWrapper = new BaseTableAddRemoveWrapper(this.SCLTable);
            BaseField SCLTableWrapperField = new BaseField((BaseComponent)this.SCLTableWrapper, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_SCL"), true, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_SCL_DESCRIPTION"));
            enviromentParameters.addField(SCLTableWrapperField);
            Object[][] data2 = this.getDataForTable(this.jobTracParameters.getJCLList());
            Object[] col2 = new String[]{TextManager.instance().get("JOBTRAC_ENVIRONMENT_JCL_COLUMN")};
            this.JCLTableModel = new DefaultTableModel(data2, col2);
            this.JCLTableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    DataImportJobtrac.this.environmentPanel.setValid(DataImportJobtrac.this.checkTableValid(DataImportJobtrac.this.SCLTableModel) && DataImportJobtrac.this.checkTableValid(DataImportJobtrac.this.JCLTableModel));
                }
            });
            this.JCLTable = new JTable(this.JCLTableModel);
            this.JCLTableWrapper = new BaseTableAddRemoveWrapper(this.JCLTable);
            BaseField JCLTableWrapperField = new BaseField((BaseComponent)this.JCLTableWrapper, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_JCL"), true, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_JCL_DESCRIPTION"));
            enviromentParameters.addField(JCLTableWrapperField);
            this.JMF_textField = new BaseTextField(this.jobTracParameters.getJMF());
            descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_JMF_DESCRIPTION"), "\n");
            enviromentParameters.addField(new BaseField((BaseComponent)this.JMF_textField, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_JMF"), descriptionMsg));
            this.ADI_textField = new BaseTextField(this.jobTracParameters.getADI());
            descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_ADI_DESCRIPTION"), "\n", "\n");
            enviromentParameters.addField(new BaseField((BaseComponent)this.ADI_textField, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_ADI"), descriptionMsg));
            this.CCPF_textField = new BaseTextField(this.jobTracParameters.getCCPF());
            descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_CCPF_DESCRIPTION"), "\n");
            enviromentParameters.addField(new BaseField((BaseComponent)this.CCPF_textField, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_CCPF"), descriptionMsg));
            this.ADR_textField = new BaseTextField(this.jobTracParameters.getADR());
            descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_ADR_DESCRIPTION"), "\n");
            enviromentParameters.addField(new BaseField((BaseComponent)this.ADR_textField, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_ADR"), descriptionMsg));
            this.AMR_textField = new BaseTextField(this.jobTracParameters.getAMR());
            descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_AMR_DESCRIPTION"), "\n");
            enviromentParameters.addField(new BaseField((BaseComponent)this.AMR_textField, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_AMR"), descriptionMsg));
            this.SCS_textField = new BaseTextField(this.jobTracParameters.getSCS());
            descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_SCS_DESCRIPTION"), "\n");
            enviromentParameters.addField(new BaseField((BaseComponent)this.SCS_textField, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_SCS"), descriptionMsg));
            this.RESOURCE_textField = new BaseTextField(this.jobTracParameters.getRESOURCE());
            descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_RESOURCE_DESCRIPTION"), "\n");
            enviromentParameters.addField(new BaseField((BaseComponent)this.RESOURCE_textField, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_RESOURCE"), descriptionMsg));
            this.EXCLPARM_textField = new BaseTextField(this.jobTracParameters.getEXCLPARM());
            descriptionMsg = String.format(TextManager.instance().get("JOBTRAC_EXCLPARM_DESCRIPTION"), "\n", "\n");
            enviromentParameters.addField(new BaseField((BaseComponent)this.EXCLPARM_textField, TextManager.instance().get("FIELD_JOBTRAC_ENVIRONMENT_EXCLPARM"), descriptionMsg));
            this.environmentPanel.addSection(enviromentParameters);
            this.environmentPanel.buildContentPanel();
            if (this.SCLTableModel.getRowCount() > 0 && this.JCLTableModel.getRowCount() > 0) {
                this.environmentPanel.setValid(true);
            } else {
                this.environmentPanel.setValid(false);
            }
        }
        return this.environmentPanel;
    }

    private boolean checkTableValid(DefaultTableModel model) {
        if (model.getRowCount() > 0 && model.getRowCount() > 0) {
            for (int row = 0; row < model.getRowCount(); ++row) {
                String value = (String)model.getValueAt(row, 0);
                if (value == null || value.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private String[][] getDataForTable(List<String> data) {
        String[][] toRet = null;
        if (data != null && data.size() > 0) {
            toRet = new String[data.size()][];
            for (int row = 0; row < data.size(); ++row) {
                toRet[row] = new String[]{data.get(row)};
            }
        }
        return toRet;
    }

    private List<String> getTableData(String tableType) {
        DefaultTableModel tableModel = null;
        if (tableType.equalsIgnoreCase("SCL")) {
            tableModel = (DefaultTableModel)this.SCLTable.getModel();
        } else if (tableType.equalsIgnoreCase("JCL")) {
            tableModel = (DefaultTableModel)this.JCLTable.getModel();
        }
        ArrayList<String> toRet = new ArrayList<String>();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            toRet.add((String)tableModel.getValueAt(i, 0));
        }
        return toRet;
    }

    private void fillJobTracParameters() {
        this.jobTracParameters.setJCL(this.JCLFileName.getText());
        this.jobTracParameters.setOUTPUT_FILE_NAME(this.outputFileNameData.getText());
        this.jobTracParameters.setJOB_CARD(this.jobCard.getText());
        this.jobTracParameters.setUNIT(this.unit.getText());
        this.jobTracParameters.setVOLSER(this.volser.getText());
        this.jobTracParameters.setSMS_DATA_CLASS(this.data.getText());
        this.jobTracParameters.setSMS_STORAGE_CLASS(this.storage.getText());
        this.jobTracParameters.setSMS_MANAGMENT_CLASS(this.managment.getText());
        this.jobTracParameters.setPRIMARY_ALLOCATION(this.primaryAlloc.getText());
        this.jobTracParameters.setSECONDERY_ALLOCATION(this.secondaryAlloc.getText());
        this.jobTracParameters.setSCLList(this.getTableData("SCL"));
        this.jobTracParameters.setJCLList(this.getTableData("JCL"));
        this.jobTracParameters.setJMF(this.JMF_textField.getText());
        this.jobTracParameters.setADI(this.ADI_textField.getText());
        this.jobTracParameters.setCCPF(this.CCPF_textField.getText());
        this.jobTracParameters.setADR(this.ADR_textField.getText());
        this.jobTracParameters.setAMR(this.AMR_textField.getText());
        this.jobTracParameters.setSCS(this.SCS_textField.getText());
        this.jobTracParameters.setRESOURCE(this.RESOURCE_textField.getText());
        this.jobTracParameters.setEXCLPARM(this.EXCLPARM_textField.getText());
        this.jobTracParameters.saveToFile();
    }

    private BaseContentPanel instructionPanel() {
        this.instructionPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("CAPTURE_DATA_TITLE_IMPORT_JOBTRAC")));
        BaseSection instructionSection = new BaseSection("Collect Jobtrac Data Instructions");
        File outputFile = Params.instance().getJobTracOutputFile();
        if (outputFile != null) {
            String text = "1. Transfer the JCL located in:    \"<Output File>\"   to your Jobtrac machine via FTP with ascii mode.\n   When using FTP, you can use the following commands: \n   ftp> ascii \n   ftp> put \"<Output File>\" <Library>(<Member>)\n2. Submit the job that will collect all the required Jobtrac data into one sequential file created with name \"<File Name>\".\n3. After the job finishes successfully, transfer back the output file:\n   \"<File Name>\" from the Jobtrac machine to the conversion machine in ascii mode. \n   When using FTP, you can use the following commands: \n   ftp> ascii \n   ftp> get \"<File Name>\" <local data file> \n4. Continue the conversion. \n".replaceAll("<Output File>", outputFile.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\")).replaceAll("<File Name>", Params.instance().getJobTracFileNameData().toUpperCase());
            BaseTextContainer instruction = new BaseTextContainer(text);
            BaseField instructionField = new BaseField((BaseComponent)instruction);
            instructionField.setFillAllArea(true);
            instructionSection.addField(instructionField);
            this.instructionPanel.addSection(instructionSection);
        }
        this.instructionPanel.buildContentPanel();
        this.instructionPanel.setValid(true);
        return this.instructionPanel;
    }

    public String getHelpTitle() {
        switch (this.importPanels.ordinal()) {
            case 0: 
            case 3: 
            case 4: {
                return "LOAD_DATA_JOBTRAC_NEW_OR_EXISTING";
            }
            case 1: {
                return "LOAD_DATA_JOBTRAC_JCL";
            }
            case 2: {
                return "LOAD_DATA_JOBTRAC_ENVIRONMENT";
            }
        }
        return "";
    }

    public String getFieldsData() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.jobDefinitions.getComponent().getName() + "=" + this.jobDefinitions.getText() + "\n");
        return stringBuilder.toString();
    }

    public static enum ImportPanels {
        GENERATE_OR_EXISTING,
        JCL_PARAMS,
        ENVIRONMENT,
        INSTRUCTION,
        DATA_IMPORT,
        DEFAULT;

    }
}

