/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.jobtrac.ConvertAbstractToCSV;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import java.util.ArrayList;
import java.util.Arrays;

public class ConvertSCSToCSV
extends ConvertAbstractToCSV {
    private static final String m_sCMD = "CMD:";
    private static final String m_sCMDCNT = "CMD(CONT):";
    private static final String m_sINTV = "INTV";
    private static final String m_sSCSTable = "SCS TABLE";
    private static final int m_iNumberOfAttributes = 8;
    private String[] m_sAttributesList = new String[8];
    private static final int m_startIndexCMD = 10;
    private static final int m_startIndexINTV = 4;
    private static final int m_endIndexINTV = 12;
    private static final int m_startIndexRANGE = 17;
    private static final int m_endIndexRANGE = 31;
    private static final int m_startIndexPROCESSPE = 41;
    private static final int m_endIndexPROCESSPE = 53;
    private static final int m_startIndexSYSID = 58;

    @Override
    protected ArrayList<String> setArrayOfColumnNames() {
        return new ArrayList<String>(Arrays.asList(JobTracGlobals.SCS_HEADERS));
    }

    public ConvertSCSToCSV(String inFile, String outFile) {
        super(inFile, outFile);
    }

    @Override
    public ArrayList<ArrayList<String>> convertData(ArrayList<String> sData) {
        ArrayList<String> tempList = new ArrayList<String>();
        ArrayList<ArrayList<String>> resultList = new ArrayList<ArrayList<String>>();
        String sCMD = null;
        String sCMDCONT = null;
        String sINTV = null;
        String sRANGE = null;
        String sPROCESSPE = null;
        String sSYSID = null;
        int indexTable = JobTracGlobals.getIndexOfHeaderInCSV("SCS", "TABLE");
        int indexDate = JobTracGlobals.getIndexOfHeaderInCSV("SCS", "DATE");
        int indexCMD = JobTracGlobals.getIndexOfHeaderInCSV("SCS", "CMD");
        int indexCMDCNT = JobTracGlobals.getIndexOfHeaderInCSV("SCS", "CMDCONT");
        int indexINTV = JobTracGlobals.getIndexOfHeaderInCSV("SCS", m_sINTV);
        int indexRANGE = JobTracGlobals.getIndexOfHeaderInCSV("SCS", "RANGE");
        int indexPROCESSPE = JobTracGlobals.getIndexOfHeaderInCSV("SCS", "PROCESSPE");
        int indexSYSID = JobTracGlobals.getIndexOfHeaderInCSV("SCS", "SYSID");
        int delta = 0;
        for (String text : sData) {
            ++this.m_iRowCounter;
            if (text.toUpperCase().contains("TABLE:")) {
                delta = text.indexOf("TABLE:");
                String[] sArray = text.split("LAST-UPDATED:");
                String sDate = sArray[1].trim();
                String sTableName = sArray[0].split(":")[1];
                this.m_sAttributesList[indexTable] = sTableName = sTableName.replaceAll("\\s+", "");
                this.m_sAttributesList[indexDate] = sDate;
                continue;
            }
            if (text.contains("-------------------------------------------------------------------------------") || text.contains("yy/mm/dd") || text.contains("===>") || text.contains(m_sSCSTable) || text.toUpperCase().contains("TOTAL ENTRIES PRINTED") || text.isEmpty()) continue;
            if (text.toUpperCase().contains(m_sCMD)) {
                sCMD = text.substring(10 + delta, text.length()).trim();
                if (sCMD.isEmpty()) {
                    sCMD = "";
                }
                this.m_sAttributesList[indexCMD] = sCMD;
                continue;
            }
            if (text.toUpperCase().contains(m_sCMDCNT)) {
                sCMDCONT = text.substring(10 + delta, text.length()).trim();
                if (sCMDCONT.isEmpty()) {
                    sCMDCONT = "";
                }
                this.m_sAttributesList[indexCMDCNT] = sCMDCONT;
                continue;
            }
            if (!text.toUpperCase().contains(m_sINTV)) continue;
            sINTV = text.substring(4 + delta, 12 + delta).trim();
            if (sINTV.isEmpty()) {
                sINTV = "";
            }
            this.m_sAttributesList[indexINTV] = sINTV;
            sRANGE = text.substring(17 + delta, 31 + delta).trim();
            if (sRANGE.isEmpty()) {
                sRANGE = "";
            }
            this.m_sAttributesList[indexRANGE] = sRANGE;
            sPROCESSPE = text.substring(41 + delta, 53 + delta).trim();
            if (sPROCESSPE.isEmpty()) {
                sPROCESSPE = "";
            }
            this.m_sAttributesList[indexPROCESSPE] = sPROCESSPE;
            sSYSID = text.substring(58 + delta, text.length()).trim();
            if (sSYSID.isEmpty()) {
                sSYSID = "";
            }
            this.m_sAttributesList[indexSYSID] = sSYSID;
            for (int i = 0; i < 8; ++i) {
                tempList.add(this.m_sAttributesList[i]);
            }
            resultList.add(tempList);
            tempList = new ArrayList();
        }
        return resultList;
    }
}

