/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.jobtrac.ConvertAbstractToCSV;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import java.util.ArrayList;
import java.util.Arrays;

public class ConvertCCPFToCSV
extends ConvertAbstractToCSV {
    private static final String m_sCCPFTable = "CCPF TABLE";
    private static final String m_sLine1 = "PROGRAM   EVENT     STEP      PROCSTEP       CONDCODE  CONDCODE";
    private static final String m_sLine2 = "NAME      NAME      NAME      NAME           OPERATOR  VALUE";
    private static int m_iStartIndexCol1 = 0;
    private static int m_iStartIndexCol2 = m_iStartIndexCol1 + 10;
    private static int m_iStartIndexCol3 = m_iStartIndexCol2 + 10;
    private static int m_iStartIndexCol4 = m_iStartIndexCol3 + 10;
    private static int m_iStartIndexCol5 = m_iStartIndexCol4 + 15;
    private static int m_iStartIndexCol6 = m_iStartIndexCol5 + 10;
    private static final int m_iNumberOfAttributes = 8;
    private String[] m_sAttributesList = new String[8];

    @Override
    protected ArrayList<String> setArrayOfColumnNames() {
        return new ArrayList<String>(Arrays.asList(JobTracGlobals.CCPF_HEADERS));
    }

    public ConvertCCPFToCSV(String inFile, String outFile) {
        super(inFile, outFile);
    }

    @Override
    public ArrayList<ArrayList<String>> convertData(ArrayList<String> sData) {
        ArrayList<String> tempList = new ArrayList<String>();
        ArrayList<ArrayList<String>> resultList = new ArrayList<ArrayList<String>>();
        String sPROGRAMNAME = null;
        String sEVENTNAME = null;
        String sSTEPNAME = null;
        String sPROCSTEPNAME = null;
        String sCONDCODEOPERATOR = null;
        String sCONDCODEVALUE = null;
        int delta = 0;
        for (String text : sData) {
            ++this.m_iRowCounter;
            if (text.contains("-------------------------------------------------------------------------------") || text.contains("yy/mm/dd") || text.contains("===>") || text.contains("TOTAL ENTRIES PRINTED") || text.contains(m_sCCPFTable) || text.contains(m_sLine1) || text.contains(m_sLine2) || text.trim().isEmpty()) continue;
            if (text.toUpperCase().contains("TABLE:")) {
                delta = text.indexOf("TABLE:");
                String[] sArray = text.split("LAST-UPDATED:");
                String sDate = sArray[1].trim();
                String sTableName = sArray[0].split(":")[1];
                this.m_sAttributesList[0] = sTableName = sTableName.replaceAll("\\s+", "");
                this.m_sAttributesList[1] = sDate;
                continue;
            }
            sPROGRAMNAME = text.substring(m_iStartIndexCol1 + delta, m_iStartIndexCol2 + delta).trim();
            if (sPROGRAMNAME.isEmpty()) {
                sPROGRAMNAME = "";
            }
            this.m_sAttributesList[2] = sPROGRAMNAME;
            sEVENTNAME = text.substring(m_iStartIndexCol2 + delta, m_iStartIndexCol3 + delta).trim();
            if (sEVENTNAME.isEmpty()) {
                sEVENTNAME = "";
            }
            this.m_sAttributesList[3] = sEVENTNAME;
            sSTEPNAME = text.substring(m_iStartIndexCol3 + delta, m_iStartIndexCol4 + delta).trim();
            if (sSTEPNAME.isEmpty()) {
                sSTEPNAME = "";
            }
            this.m_sAttributesList[4] = sSTEPNAME;
            sPROCSTEPNAME = text.substring(m_iStartIndexCol4 + delta, m_iStartIndexCol5 + delta).trim();
            if (sPROCSTEPNAME.isEmpty()) {
                sPROCSTEPNAME = "";
            }
            this.m_sAttributesList[5] = sPROCSTEPNAME;
            sCONDCODEOPERATOR = text.substring(m_iStartIndexCol5 + delta, m_iStartIndexCol6 + delta).trim();
            if (sCONDCODEOPERATOR.isEmpty()) {
                sCONDCODEOPERATOR = "";
            }
            this.m_sAttributesList[6] = sCONDCODEOPERATOR;
            sCONDCODEVALUE = text.substring(m_iStartIndexCol6 + delta, text.length()).trim();
            if (sCONDCODEVALUE.isEmpty()) {
                sCONDCODEVALUE = "";
            }
            this.m_sAttributesList[7] = sCONDCODEVALUE;
            for (int i = 0; i < 8; ++i) {
                tempList.add(this.m_sAttributesList[i]);
            }
            resultList.add(tempList);
            tempList = new ArrayList();
        }
        return resultList;
    }
}

