/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.jobtrac.JobTracCSVWriter;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import com.csvreader.CsvWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;

public abstract class ConvertAbstractToCSV {
    protected String m_sInFileName;
    protected String m_sOutFileName;
    protected ArrayList<String> m_arrayOfColumnNames;
    protected CsvWriter m_csvWriter;
    protected int m_iRowCounter;
    protected ArrayList<String> m_messagesList;

    public ConvertAbstractToCSV(String inFile, String outFile) {
        this.m_sInFileName = inFile;
        this.m_sOutFileName = outFile;
        this.m_arrayOfColumnNames = this.setArrayOfColumnNames();
        this.m_iRowCounter = 0;
        this.m_messagesList = new ArrayList();
    }

    public ArrayList<String> getColumnNames() {
        return this.m_arrayOfColumnNames;
    }

    public ArrayList<String> getMessages() {
        return this.m_messagesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doConversion() {
        String sLine = null;
        int iBufferLinesCount = 0;
        ArrayList<ArrayList<String>> convertedData = null;
        ArrayList<String> sBufferList = new ArrayList<String>(JobTracGlobals.MaxBufferLines);
        BufferedReader fileReader = this.openInputFile();
        if (null != fileReader) {
            this.m_csvWriter = new CsvWriter(this.m_sOutFileName);
            JobTracCSVWriter.writeColumnHeadersToCSV(this.m_arrayOfColumnNames, this.m_csvWriter);
            try {
                while ((sLine = fileReader.readLine()) != null) {
                    ++iBufferLinesCount;
                    if (!sLine.isEmpty()) {
                        sBufferList.add(sLine);
                    }
                    if (iBufferLinesCount != JobTracGlobals.MaxBufferLines) continue;
                    convertedData = this.convertData(sBufferList);
                    JobTracCSVWriter.writeToCSV(convertedData, this.m_csvWriter);
                    iBufferLinesCount = 0;
                    sBufferList.clear();
                }
                if (iBufferLinesCount > 0) {
                    convertedData = this.convertData(sBufferList);
                    JobTracCSVWriter.writeToCSV(convertedData, this.m_csvWriter);
                }
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((String)("Error in - doConversion - In File" + this.m_sInFileName + " at Line : " + this.m_iRowCounter));
                ExceptionHandler.writeToExceptionFile((String)("Exception : " + String.valueOf(e)));
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                    if (this.m_csvWriter != null) {
                        this.m_csvWriter.close();
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.writeToExceptionFile((String)("Error in - doConversion - In File" + this.m_sInFileName));
                    ExceptionHandler.writeToExceptionFile((String)("Cannot close file , Exception : " + String.valueOf(e)));
                    return false;
                }
            }
        }
        return true;
    }

    protected BufferedReader openInputFile() {
        File inFileName = new File(this.m_sInFileName);
        if (!inFileName.exists()) {
            ExceptionHandler.writeToExceptionFile((String)"Error in - openInputFile");
            ExceptionHandler.writeToExceptionFile((String)("Input file does not exist : " + this.m_sInFileName));
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(inFileName));
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)("Error in - openInputFile - In File " + this.m_sInFileName));
            ExceptionHandler.writeToExceptionFile((String)("Exception : " + String.valueOf(e)));
            return null;
        }
        return reader;
    }

    protected abstract ArrayList<String> setArrayOfColumnNames();

    protected abstract ArrayList<ArrayList<String>> convertData(ArrayList<String> var1);
}

