/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.jobtrac.ConvertAbstractToCSV;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import java.util.ArrayList;
import java.util.Arrays;

public class ConvertADRToCSV
extends ConvertAbstractToCSV {
    private static final String m_sDSN = "DSN:";
    private static final String m_sADRTable = "ADR TABLE";
    private static final String m_sDefLine1 = "TOD        CREATE    CREATE      TRIGGER   TRIGGER";
    private static final String m_sDefLine2 = "THRESHOLD  EVENT     PROCESS PE  EVENT     PROCESS PE";
    private static final int m_iNumberOfAttributes = JobTracGlobals.ADR_HEADERS.length;
    private String[] m_sAttributesList = new String[m_iNumberOfAttributes];
    private static final int m_iTableSecondLineAttributesIndex = 5;
    private static final int m_startIndexDSN = 8;
    private static final int m_endIndexDSN = 54;
    private static final int m_startIndexCPU = 59;
    private static final int m_endIndexCPU = 64;
    private static final int m_startIndexACT = 69;
    private static final int m_startIndexTodThreshold = 0;
    private static final int m_startIndexCreateEvent = 11;
    private static final int m_startIndexCreateProcessPE = 21;
    private static final int m_startIndexTriggerEvent = 33;
    private static final int m_startIndexTriggerProcessPE = 43;
    private static final int m_lineSize = 74;
    private boolean m_bLastLineIgnored = false;

    @Override
    protected ArrayList<String> setArrayOfColumnNames() {
        return new ArrayList<String>(Arrays.asList(JobTracGlobals.ADR_HEADERS));
    }

    public ConvertADRToCSV(String inFile, String outFile) {
        super(inFile, outFile);
    }

    @Override
    public ArrayList<ArrayList<String>> convertData(ArrayList<String> sData) {
        String[] sArray = null;
        ArrayList<String> tempList = new ArrayList<String>();
        ArrayList<ArrayList<String>> resultList = new ArrayList<ArrayList<String>>();
        String sDSN = null;
        String sCPU = null;
        String sACT = null;
        int delta = 0;
        String sTextTrim = null;
        for (String text : sData) {
            ++this.m_iRowCounter;
            sTextTrim = text.trim();
            if (null == text || text.isEmpty() || sTextTrim.isEmpty()) continue;
            if (text.toUpperCase().contains("TABLE:")) {
                delta = text.indexOf("TABLE:");
                sArray = text.split("LAST-UPDATED:");
                String sDate = sArray[1].trim();
                String sTableName = sArray[0].split(":")[1];
                this.m_sAttributesList[0] = sTableName = sTableName.replaceAll("\\s+", "");
                this.m_sAttributesList[1] = sDate;
                continue;
            }
            if (text.contains("-------------------------------------------------------------------------------") || text.contains("yy/mm/dd") || text.contains("===>") || text.toUpperCase().contains(m_sDefLine1) || text.toUpperCase().contains(m_sDefLine2) || text.contains(m_sADRTable) || text.toUpperCase().contains("TOTAL ENTRIES PRINTED") || text.isEmpty()) continue;
            if (text.toUpperCase().contains(m_sDSN)) {
                for (int i = 5; i < m_iNumberOfAttributes; ++i) {
                    this.m_sAttributesList[i] = "";
                }
                if (text.length() < 74) {
                    this.m_bLastLineIgnored = true;
                    continue;
                }
                sDSN = text.substring(8 + delta, 54 + delta).trim();
                if (sDSN.isEmpty()) {
                    sDSN = "";
                }
                this.m_sAttributesList[2] = sDSN;
                sCPU = text.substring(59 + delta, 64 + delta).trim();
                if (sCPU.isEmpty()) {
                    sCPU = "";
                }
                this.m_sAttributesList[3] = sCPU;
                sACT = text.substring(69 + delta, text.length()).trim();
                if (sACT.isEmpty()) {
                    sACT = "";
                }
                this.m_sAttributesList[4] = sACT;
                continue;
            }
            if (this.m_bLastLineIgnored) {
                this.m_bLastLineIgnored = false;
                continue;
            }
            String sTriggerEvent = "";
            String sTriggerProcessPE = "";
            String sTodThreshold = text.substring(0 + delta, 10 + delta).trim();
            if (sTodThreshold.isEmpty()) {
                sTodThreshold = "";
            }
            this.m_sAttributesList[5] = sTodThreshold;
            String sCreateEvent = text.substring(11 + delta, 20 + delta).trim();
            if (sCreateEvent.isEmpty()) {
                sCreateEvent = "";
            }
            this.m_sAttributesList[6] = sCreateEvent;
            String sCreateProcessPE = text.substring(21 + delta, 32 + delta).trim();
            if (sCreateProcessPE.isEmpty()) {
                sCreateProcessPE = "";
            }
            this.m_sAttributesList[7] = sCreateProcessPE;
            sTriggerEvent = text.length() > 43 + delta ? text.substring(33 + delta, 42 + delta).trim() : text.substring(33 + delta, text.length()).trim();
            if (sTriggerEvent.isEmpty()) {
                sTriggerEvent = "";
            }
            this.m_sAttributesList[8] = sTriggerEvent;
            if (text.length() > 43 + delta) {
                sTriggerProcessPE = text.substring(43 + delta, text.length()).trim();
            }
            if (sTriggerProcessPE.isEmpty()) {
                sTriggerProcessPE = "";
            }
            this.m_sAttributesList[9] = sTriggerProcessPE;
            for (int i = 0; i < m_iNumberOfAttributes; ++i) {
                tempList.add(this.m_sAttributesList[i]);
            }
            resultList.add(tempList);
            tempList = new ArrayList();
        }
        return resultList;
    }
}

