/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.FileOutputStream;
import java.util.ArrayList;

public abstract class CardsFileConvertorAbstract {
    public static final int CARDS_TYPE_ASCII = 0;
    public static final int CARDS_TYPE_EBCDIC = 1;
    public static final String CP1047 = "CP1047";
    public static final String US_ASCII = "US-ASCII";
    protected ArrayList<String> m_messagesList = new ArrayList();

    public ArrayList<String> getMessages() {
        return this.m_messagesList;
    }

    public abstract ArrayList<char[]> doConversion(String var1, String var2, ArrayList<String> var3);

    public final boolean writeCardsToFile(String fileName, int conversionType, ArrayList<char[]> cardsList) {
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            String sType = US_ASCII;
            if (conversionType == 1) {
                sType = CP1047;
            }
            for (char[] card : cardsList) {
                os.write(String.valueOf(card).getBytes(sType));
            }
            os.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in CardsFileConvertorAbstract - writeCardsToFile");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("conversionType : " + conversionType));
            ExceptionHandler.writeToExceptionFile((String)("Exception : " + String.valueOf(e)));
            return false;
        }
        return true;
    }
}

