/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.jobtrac.CardCreatorGlobal;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import java.io.FileOutputStream;
import java.util.ArrayList;

public class CardCreatorJCLForMF {
    private ArrayList<String> m_sTextArray = new ArrayList();

    public void insertCards(String jobCard, String libraryControlO, String libraryCMEM, ArrayList<char[]> listADR, ArrayList<char[]> listAMR, ArrayList<char[]> listSCS, ArrayList<char[]> listRESOURCE) {
        ArrayList<String> jobCardPrefix = null;
        if (null != jobCard && !jobCard.isEmpty()) {
            jobCardPrefix = this.setJOBCARDCommands(jobCard);
        }
        ArrayList<String> controlO = this.setControlOCommands(libraryControlO, listADR, listAMR, listSCS);
        ArrayList<String> cmem = this.setCMEMCommands(libraryCMEM, listRESOURCE);
        if ((null != controlO || null != cmem) && null != jobCardPrefix) {
            this.m_sTextArray.addAll(jobCardPrefix);
        }
        if (null != controlO) {
            this.m_sTextArray.addAll(controlO);
        }
        if (null != cmem) {
            this.m_sTextArray.addAll(cmem);
        }
    }

    private ArrayList<String> setControlOCommands(String sLibraryName, ArrayList<char[]> listADR, ArrayList<char[]> listAMR, ArrayList<char[]> listSCS) {
        if (null != sLibraryName && !sLibraryName.isEmpty()) {
            if (null != listADR && listADR.size() > 0 || null != listAMR && listAMR.size() > 0 || null != listSCS && listSCS.size() > 0) {
                ArrayList<String> sTextArrayControlO = new ArrayList<String>();
                sTextArrayControlO.add("//RULESO EXEC PGM=IEBUPDTE,PARM=NEW                                             ");
                sTextArrayControlO.add("//SYSABEND  DD SYSOUT=*                                                         ");
                sTextArrayControlO.add("//SYSMDUMP  DD SYSOUT=*                                                         ");
                sTextArrayControlO.add("//SYSUDUMP  DD SYSOUT=*                                                         ");
                sTextArrayControlO.add("//SYSPRINT  DD SYSOUT=*                                                         ");
                String sControlO = "//SYSUT2   DD DISP=SHR,DSN=                                                     ";
                char[] chControlO = new char[sControlO.length()];
                chControlO = sControlO.toCharArray();
                CardCreatorGlobal.replaceChars(chControlO, 27, sLibraryName, 52);
                sTextArrayControlO.add(new String(chControlO));
                sTextArrayControlO.add("//SYSIN    DD DATA,DLM=@@                                                       ");
                if (null != listADR && listADR.size() > 0) {
                    sTextArrayControlO.add("./ ADD NAME=ADR                                                                 ");
                    sTextArrayControlO.add(this.getCardsFromList(listADR));
                }
                if (null != listAMR && listAMR.size() > 0) {
                    sTextArrayControlO.add("./ ADD NAME=AMR                                                                 ");
                    sTextArrayControlO.add(this.getCardsFromList(listAMR));
                }
                if (null != listSCS && listSCS.size() > 0) {
                    sTextArrayControlO.add("./ ADD NAME=SCS                                                                 ");
                    sTextArrayControlO.add(this.getCardsFromList(listSCS));
                }
                sTextArrayControlO.add("./ ENDUP                                                                        ");
                sTextArrayControlO.add("@@                                                                              ");
                sTextArrayControlO.add("/*                                                                              ");
                return sTextArrayControlO;
            }
            return null;
        }
        return null;
    }

    private ArrayList<String> setCMEMCommands(String sLibraryName, ArrayList<char[]> listRESOURCE) {
        if (null != sLibraryName && !sLibraryName.isEmpty()) {
            if (null != listRESOURCE && listRESOURCE.size() > 0) {
                ArrayList<String> sTextArrayCMEM = new ArrayList<String>();
                sTextArrayCMEM.add("//CMEM EXEC PGM=IEBUPDTE,PARM=NEW                                               ");
                sTextArrayCMEM.add("//SYSABEND  DD SYSOUT=*                                                         ");
                sTextArrayCMEM.add("//SYSMDUMP  DD SYSOUT=*                                                         ");
                sTextArrayCMEM.add("//SYSUDUMP  DD SYSOUT=*                                                         ");
                sTextArrayCMEM.add("//SYSPRINT  DD SYSOUT=*                                                         ");
                String sCMEM = "//SYSUT2   DD DISP=SHR,DSN=                                                     ";
                char[] chCMEM = new char[sCMEM.length()];
                chCMEM = sCMEM.toCharArray();
                CardCreatorGlobal.replaceChars(chCMEM, 27, sLibraryName, 52);
                sTextArrayCMEM.add(new String(chCMEM));
                sTextArrayCMEM.add("//SYSIN    DD DATA,DLM=@@                                                       ");
                sTextArrayCMEM.add("./ ADD NAME=RESOURCE                                                            ");
                sTextArrayCMEM.add(this.getCardsFromList(listRESOURCE));
                sTextArrayCMEM.add("./ ENDUP                                                                        ");
                sTextArrayCMEM.add("@@                                                                              ");
                sTextArrayCMEM.add("/*                                                                              ");
                sTextArrayCMEM.add("//                                                                              ");
                return sTextArrayCMEM;
            }
            return null;
        }
        return null;
    }

    private String getCardsFromList(ArrayList<char[]> list) {
        if (null == list) {
            return "";
        }
        StringBuilder cardsList = new StringBuilder();
        if (null != list) {
            for (char[] card : list) {
                cardsList.append(card);
            }
        }
        return cardsList.toString();
    }

    private ArrayList<String> setJOBCARDCommands(String jobCard) {
        String[] splitNewLineList;
        if (null == jobCard || jobCard.isEmpty()) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        int iLen = 80;
        String charsLength = "%1$-" + iLen + "s";
        for (String sLine : splitNewLineList = jobCard.split("\n")) {
            ArrayList<String> sSubStrings;
            if (sLine.length() < iLen) {
                sLine = String.format(charsLength, sLine);
                resultList.add(sLine);
                continue;
            }
            if (sLine.length() <= iLen || null == (sSubStrings = JobTracGlobals.breakStringByWidth(sLine, iLen, null))) continue;
            for (String sSub : sSubStrings) {
                if (sSub.length() < iLen) {
                    sSub = String.format(charsLength, sSub);
                }
                resultList.add(sSub);
            }
        }
        return resultList;
    }

    public boolean writeDataToFile(String fileName, int conversionType) {
        if (null != this.m_sTextArray && this.m_sTextArray.size() > 0) {
            try {
                FileOutputStream os = new FileOutputStream(fileName);
                String sType = "US-ASCII";
                if (conversionType == 1) {
                    sType = "CP1047";
                }
                for (String sLine : this.m_sTextArray) {
                    os.write(sLine.getBytes(sType));
                }
                os.close();
            }
            catch (Exception ex) {
                ExceptionHandler.writeToExceptionFile((String)"Error in CardCreatorJCLForMF - writeDataToFile");
                ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
                ExceptionHandler.writeToExceptionFile((String)("conversionType : " + conversionType));
                ExceptionHandler.writeToExceptionFile((String)("Exception : " + String.valueOf(ex)));
                return false;
            }
            return true;
        }
        return false;
    }
}

