/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.jobtrac.CardCreatorGlobal;
import com.bmc.ctmconvert.rules.RuleManager;
import java.util.ArrayList;
import java.util.HashMap;

public class CardBuilderControlO {
    private static final String sEOM = "EOM";
    private static final String sDAILY = "DAILY";
    private static final String sSUNDAY = "SUNDAY";
    private static final String sMONDAY = "MONDAY";
    private static final String sTUESDAY = "TUESDAY";
    private static final String sWEDNESDAY = "WEDNESDAY";
    private static final String sTHURSDAY = "THURSDAY";
    private static final String sFRIDAY = "FRIDAY";
    private static final String sSATURDAY = "SATURDAY";
    private static final String sAstrik = "*";
    private static final String sBlanks = "%%$BLANK";
    private static final String sDSNTRIG = "DSNTRIG";
    private static final String sACT_RUN = "RUN";
    private static final String sACT_ADD = "ADD";
    private static final String sACT_DCNT = "DCNT";
    private static final String sACT_NOND = "NOND";
    private static final String sACT_ALTR = "ALTR";
    private static final String sACT_RPLY = "RPLY";
    private static final String sACT_SUPP = "SUPP";
    private static final String sACT_CMD = "CMD";
    private static final String sErrorACT = "RULE HAS AN UNSUPPORTED ACT: ";
    private static final String sErrorPROCESSPE = "RULE HAS AN UNSUPPORTED PROCESS PE: ";
    private static final String sErrorCMDTOOLONG = "RULE HAS A TOO LONG ";
    private static final String sErrorEXTENDED = "RULE HAS AN UNSOPPRTED EXTENDED VALUE: ";
    private static final String sUnsupportedInterval = "999";
    public static final int iMaxCMDLen = 38;
    public static final int iMaxMSGLen = 47;
    private static final String[] weekDays = new String[]{"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"};

    public static String getProcessPeriodMask(String sProcessPE, boolean bSupportedProcessPE) {
        int i;
        char[] chDays = new char[7];
        for (i = 0; i < chDays.length; ++i) {
            chDays[i] = 48;
        }
        if (!bSupportedProcessPE) {
            return new String(chDays);
        }
        if (!sProcessPE.isEmpty() && sProcessPE.charAt(0) == '=') {
            String sDays = sProcessPE.substring(1, sProcessPE.length());
            for (int i2 = 0; i2 < sDays.length(); ++i2) {
                if (sDays.charAt(i2) == '.') continue;
                chDays[i2] = 49;
            }
        } else if (sProcessPE.equalsIgnoreCase(sDAILY) || sProcessPE.isEmpty()) {
            for (i = 0; i < chDays.length; ++i) {
                chDays[i] = 49;
            }
        } else {
            for (i = 0; i < weekDays.length; ++i) {
                if (!sProcessPE.equalsIgnoreCase(weekDays[i])) continue;
                chDays[i] = 49;
                break;
            }
        }
        return new String(chDays);
    }

    private static boolean isSupportedProcessPE(String sProcessPE) {
        if (sProcessPE.isEmpty()) {
            return true;
        }
        if (sProcessPE.charAt(0) == '=') {
            return true;
        }
        if (sProcessPE.equalsIgnoreCase(sDAILY)) {
            return true;
        }
        for (int i = 0; i < weekDays.length; ++i) {
            if (!sProcessPE.equalsIgnoreCase(weekDays[i])) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<char[]> buildCardsFromEntry(HashMap<String, String> entryAttributes, String entryType, String sOwner, String sJCLLibrary, String sIOAENV, ArrayList<String> errorMessagesList) {
        if (entryType.equalsIgnoreCase("ADR")) {
            return CardBuilderControlO.buildCardsForADR(entryAttributes, sOwner, sJCLLibrary, sIOAENV, errorMessagesList);
        }
        if (entryType.equalsIgnoreCase("AMR")) {
            return CardBuilderControlO.buildCardsForAMR(entryAttributes, sOwner, sJCLLibrary, sIOAENV, errorMessagesList);
        }
        if (entryType.equalsIgnoreCase("SCS")) {
            return CardBuilderControlO.buildCardsForSCS(entryAttributes, sOwner, errorMessagesList);
        }
        return null;
    }

    private static ArrayList<char[]> buildCardsForADR(HashMap<String, String> entryAttributes, String sOwner, String sJCLLibrary, String sIOAENV, ArrayList<String> errorMessagesList) {
        String sDays = entryAttributes.get("TRIGGERPROCESSPE");
        boolean bSupportedProcessPE = CardBuilderControlO.isSupportedProcessPE(sDays);
        String addManualCond = " ";
        ArrayList<char[]> cardsList = new ArrayList<char[]>();
        char[] dCard = CardBuilderControlO.createDCard(sOwner, sDays, "ADR");
        cardsList.add(dCard);
        char[] wCard = CardCreatorGlobal.setWCard(CardBuilderControlO.getProcessPeriodMask(sDays, bSupportedProcessPE));
        cardsList.add(wCard);
        char[] gCard = CardBuilderControlO.createGCard(entryAttributes.get("TODTHRESHOLD"), "", "ADR", errorMessagesList, "");
        cardsList.add(gCard);
        String eventName = entryAttributes.get("CREATEEVENT");
        if (null == eventName || eventName.isEmpty()) {
            eventName = sAstrik;
        }
        String dsName = entryAttributes.get("DSN");
        char[] odCard = CardCreatorGlobal.setODCard(eventName, dsName);
        cardsList.add(odCard);
        String sCPU = entryAttributes.get("CPU");
        char[] oaCard = CardCreatorGlobal.setOACard(sCPU);
        cardsList.add(oaCard);
        String sAction = entryAttributes.get("ACT");
        Object desc = "";
        if (null != dsName) {
            desc = String.format("%-44s", dsName);
        }
        if (null != sAction) {
            desc = (String)desc + " " + sAction;
        }
        char[] hCard = CardCreatorGlobal.setHCard((String)desc);
        cardsList.add(hCard);
        String sInfo = "DSN : " + dsName;
        char[] actionCard = null;
        if (null != sAction) {
            if (sAction.equalsIgnoreCase(sACT_RUN) || sAction.equalsIgnoreCase(sACT_ADD)) {
                String sOverLib = RuleManager.instance().getCurrentRules().getStringRule("Mainframe", new String[]{"OVERLIB"});
                String sTriggerEvent = entryAttributes.get("TRIGGEREVENT");
                addManualCond = sAction.equalsIgnoreCase(sACT_ADD) ? "Y" : "N";
                if (sTriggerEvent.startsWith("0")) {
                    addManualCond = " ";
                    actionCard = CardCreatorGlobal.setTSNCard(sJCLLibrary, sTriggerEvent.substring(1), addManualCond);
                    cardsList.add(actionCard);
                    actionCard = CardCreatorGlobal.setTSNCard2();
                    cardsList.add(actionCard);
                    actionCard = CardCreatorGlobal.setTSNCard3();
                    cardsList.add(actionCard);
                    actionCard = CardCreatorGlobal.setTSNCard4();
                    cardsList.add(actionCard);
                    actionCard = CardCreatorGlobal.setTECard1();
                } else {
                    actionCard = CardCreatorGlobal.setTSNCard(sJCLLibrary, sTriggerEvent, addManualCond);
                    cardsList.add(actionCard);
                    actionCard = CardCreatorGlobal.setTSNCard1(sOverLib);
                    cardsList.add(actionCard);
                    actionCard = CardCreatorGlobal.setTECard();
                }
            } else if (sAction.equalsIgnoreCase(sACT_DCNT)) {
                String sTriggerEvent = entryAttributes.get("TRIGGEREVENT");
                actionCard = CardCreatorGlobal.setTSNCard5(sTriggerEvent);
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTUPCard1();
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTULCard(sIOAENV);
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTSNCard6();
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTUPCard2();
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTULCard(sIOAENV);
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTICard();
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTCCard("DSNTRIG_" + sTriggerEvent);
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTFCard();
            } else {
                cardsList.addAll(CardBuilderControlO.buildCardsForShoutError(sErrorACT + sAction));
                sInfo = sInfo + " . Unsupported - ACT : " + sAction;
                Reporter.addMessage(errorMessagesList, (String)"WRN5001", (String)"$$$_ADR", (String[])new String[]{"ADR", sAction, sInfo});
            }
        }
        if (null != actionCard) {
            cardsList.add(actionCard);
        }
        if (!bSupportedProcessPE) {
            cardsList.addAll(CardBuilderControlO.buildCardsForShoutError(sErrorPROCESSPE + sDays));
            sInfo = sInfo + " . Unsupported - " + sDays;
            Reporter.addMessage(errorMessagesList, (String)"WRN5003", (String)"$$$_ADR", (String[])new String[]{"ADR", sDays, sInfo});
        }
        return cardsList;
    }

    private static ArrayList<char[]> buildCardsForAMR(HashMap<String, String> entryAttributes, String sOwner, String sJCLLibrary, String sIOAENV, ArrayList<String> errorMessagesList) {
        ArrayList<char[]> cardsList = new ArrayList<char[]>();
        String sEventName = entryAttributes.get("CREATEEVENT");
        if (null != sEventName && sEventName.isEmpty()) {
            sEventName = sAstrik;
        }
        String sDays = entryAttributes.get("PROCESSPE");
        char[] dCard = CardBuilderControlO.createDCard(sOwner, sDays, "AMR");
        cardsList.add(dCard);
        boolean bSupportedProcessPE = CardBuilderControlO.isSupportedProcessPE(sDays);
        char[] wCard = CardCreatorGlobal.setWCard(CardBuilderControlO.getProcessPeriodMask(sDays, bSupportedProcessPE));
        cardsList.add(wCard);
        char[] gCard = CardBuilderControlO.createGCard(entryAttributes.get("TODTHRESHOLD"), "", "ADR", errorMessagesList, "");
        cardsList.add(gCard);
        boolean bOSCard1 = false;
        String[] substringsOfMSGTXT = null;
        char[] osCard1 = null;
        char[] onCard = CardCreatorGlobal.setONCard(sEventName);
        String sOFFSET = entryAttributes.get("OFFSET1");
        Object sMSGTEXT = entryAttributes.get("MSGTEXT");
        String sOriginalMSGTXT = sMSGTEXT;
        if (null != sMSGTEXT) {
            String[] sTemp = ((String)sMSGTEXT).replaceAll("'", "");
            if ((sTemp = sTemp.replaceAll("\\s+", "")).isEmpty()) {
                sMSGTEXT = null;
            } else {
                String sXMSG = entryAttributes.get("XMSG");
                if (null != sXMSG && !sXMSG.isEmpty() && ((String)(sMSGTEXT = (String)sMSGTEXT + sXMSG)).length() > 47 && !((String)sMSGTEXT).contains("//")) {
                    cardsList.addAll(CardBuilderControlO.buildCardsForShoutError("RULE HAS AN UNSOPPRTED EXTENDED VALUE: XMSG too long"));
                    String sInfo = "MSGTEXT : " + (String)sMSGTEXT + "XMSG is too long";
                    Reporter.addMessage(errorMessagesList, (String)"WRN5001", (String)"$$$_AMR", (String[])new String[]{"AMR", "XMSG", sInfo});
                }
            }
        }
        if (null == sMSGTEXT) {
            sMSGTEXT = "Blank_Message";
            sOriginalMSGTXT = sMSGTEXT;
            Reporter.addMessage(errorMessagesList, (String)"WRN5001", (String)"$$$_AMR", (String[])new String[]{"AMR", "Triggering Message", "Blank Message. Manual manipulation of the rule is required"});
        } else {
            if (((String)sMSGTEXT).startsWith("'")) {
                sMSGTEXT = ((String)sMSGTEXT).substring(1, ((String)sMSGTEXT).length());
            }
            if (((String)sMSGTEXT).endsWith("'")) {
                sMSGTEXT = ((String)sMSGTEXT).substring(0, ((String)sMSGTEXT).length() - 1);
            }
            if (((String)(sMSGTEXT = ((String)sMSGTEXT).replaceAll("''", "'"))).startsWith("//")) {
                sMSGTEXT = ((String)sMSGTEXT).substring(2, ((String)sMSGTEXT).length());
                bOSCard1 = true;
            } else if (((String)sMSGTEXT).contains("//")) {
                substringsOfMSGTXT = ((String)sMSGTEXT).split("//");
                if (substringsOfMSGTXT != null) {
                    bOSCard1 = true;
                    for (String subString : substringsOfMSGTXT) {
                        if (subString.length() <= 47) continue;
                        cardsList.addAll(CardBuilderControlO.buildCardsForShoutError("RULE HAS AN UNSOPPRTED EXTENDED VALUE: XMSG substring too long"));
                        String sInfo = "MSGTEXT : " + (String)sMSGTEXT + "XMSG , " + subString + " : substring is too long";
                        Reporter.addMessage(errorMessagesList, (String)"WRN5001", (String)"$$$_AMR", (String[])new String[]{"AMR", "XMSG", sInfo});
                    }
                }
            } else {
                if (null != sMSGTEXT && (((String)sMSGTEXT).length() > 10 || ((String)sMSGTEXT).contains(" "))) {
                    bOSCard1 = true;
                }
                if (null != sOFFSET && !sOFFSET.equalsIgnoreCase("000")) {
                    bOSCard1 = true;
                }
            }
        }
        if (bOSCard1) {
            ArrayList<char[]> osCardsList = null;
            String sANDCOL = "";
            String sFROMCOL = "";
            String sTOCOL = "";
            if (null != sOFFSET && !sOFFSET.equalsIgnoreCase("000")) {
                int iOffset = Integer.parseInt(sOFFSET);
                sFROMCOL = Integer.toString(++iOffset);
                sTOCOL = "128";
            }
            if (null != substringsOfMSGTXT) {
                sANDCOL = substringsOfMSGTXT.length > 1 ? "A" : "";
                osCardsList = new ArrayList<char[]>();
                int iLen = substringsOfMSGTXT.length;
                for (int i = 0; i < iLen - 1; ++i) {
                    osCardsList.add(CardCreatorGlobal.setOSCard1(sANDCOL, "", "", substringsOfMSGTXT[i]));
                }
                osCardsList.add(CardCreatorGlobal.setOSCard1("", "", "", substringsOfMSGTXT[iLen - 1]));
            }
            if (null == osCardsList) {
                osCard1 = CardCreatorGlobal.setOSCard1(sANDCOL, sFROMCOL, sTOCOL, (String)sMSGTEXT);
                cardsList.add(osCard1);
                cardsList.add(onCard);
            } else {
                for (char[] osCard2 : osCardsList) {
                    cardsList.add(osCard2);
                    cardsList.add(onCard);
                }
            }
        } else {
            char[] omCard = CardCreatorGlobal.setOMCard((String)sMSGTEXT);
            cardsList.add(omCard);
            cardsList.add(onCard);
        }
        char[] hCard = CardCreatorGlobal.setHCard(sOriginalMSGTXT.equals(sBlanks) ? "" : sOriginalMSGTXT);
        cardsList.add(hCard);
        String sReply = entryAttributes.get("COMMANDREPLY");
        String sACT = entryAttributes.get("TRGACT");
        if (null != sACT) {
            sACT = sACT.replaceAll("\\(", "");
            sACT = sACT.replaceAll(" ", "");
            sACT = sACT.replaceAll("\\)", "");
        }
        boolean bADesciptorIsSet = sACT.equalsIgnoreCase(sACT_NOND);
        String sInfo = "MSGTEXT : " + (String)sMSGTEXT;
        char[] actionCard = null;
        if (sACT.equalsIgnoreCase(sACT_RUN) || sACT.equalsIgnoreCase(sACT_ADD)) {
            String addManualCond = " ";
            String sOverLib = RuleManager.instance().getCurrentRules().getStringRule("Mainframe", new String[]{"OVERLIB"});
            String sTriggerEvent = entryAttributes.get("TRIGGEREVENT");
            actionCard = CardCreatorGlobal.setTSNCard5M(sTriggerEvent);
            cardsList.add(actionCard);
            actionCard = CardCreatorGlobal.setTUPCard1();
            cardsList.add(actionCard);
            actionCard = CardCreatorGlobal.setTULCard(sIOAENV);
            cardsList.add(actionCard);
            actionCard = CardCreatorGlobal.setTICard1();
            cardsList.add(actionCard);
            if (sACT.equalsIgnoreCase(sACT_RUN)) {
                addManualCond = "N";
                actionCard = CardCreatorGlobal.setTCCard("MANUAL-DEP_" + sTriggerEvent);
            }
            if (sACT.equalsIgnoreCase(sACT_ADD)) {
                addManualCond = "Y";
                actionCard = CardCreatorGlobal.setT3Card();
            }
            cardsList.add(actionCard);
            actionCard = CardCreatorGlobal.setTOCard();
            cardsList.add(actionCard);
            if (sTriggerEvent.startsWith("0")) {
                addManualCond = " ";
                actionCard = CardCreatorGlobal.setTSNCard(sJCLLibrary, sTriggerEvent.substring(1), addManualCond);
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTSNCard7();
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTSNCard2();
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTSNCard3();
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTSNCard4M();
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTECard1();
                cardsList.add(actionCard);
            } else {
                actionCard = CardCreatorGlobal.setTSNCard(sJCLLibrary, sTriggerEvent, addManualCond);
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTSNCard7();
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTSNCard8(sOverLib);
                cardsList.add(actionCard);
                actionCard = CardCreatorGlobal.setTECard();
                cardsList.add(actionCard);
            }
            actionCard = CardCreatorGlobal.setTSNCard9();
            cardsList.add(actionCard);
            actionCard = CardCreatorGlobal.setTUPCard3();
            cardsList.add(actionCard);
            actionCard = CardCreatorGlobal.setTULCard(sIOAENV);
            cardsList.add(actionCard);
            actionCard = CardCreatorGlobal.setTFCard();
        } else if (sACT.equalsIgnoreCase(sACT_ALTR) || bADesciptorIsSet) {
            String sXALTTEXT = entryAttributes.get("XALT");
            if (null != sXALTTEXT && !sXALTTEXT.isEmpty()) {
                cardsList.addAll(CardBuilderControlO.buildCardsForShoutError("RULE HAS AN UNSOPPRTED EXTENDED VALUE: XALT"));
                sInfo = sInfo + " . Unsupported - ACT : XALT";
                Reporter.addMessage(errorMessagesList, (String)"WRN5001", (String)"$$$_AMR", (String[])new String[]{"AMR", "XALT", sInfo});
            } else {
                String sDESC = bADesciptorIsSet ? "02" : "";
                String sALTTEXT = entryAttributes.get("ALTEREDTEXT");
                actionCard = CardCreatorGlobal.setTDCard1(sDESC, sALTTEXT);
            }
        } else if (sACT.equalsIgnoreCase(sACT_RPLY)) {
            String sXCMD = entryAttributes.get("XCMD");
            if (null != sXCMD && !sXCMD.isEmpty()) {
                cardsList.addAll(CardBuilderControlO.buildCardsForShoutError("RULE HAS AN UNSOPPRTED EXTENDED VALUE: XCMD"));
                sInfo = sInfo + " . Unsupported - ACT : RPLY . XCMD";
                Reporter.addMessage(errorMessagesList, (String)"WRN5001", (String)"$$$_AMR", (String[])new String[]{"AMR", "XCMD", sInfo});
            } else {
                actionCard = CardCreatorGlobal.setTYCard(sReply);
            }
        } else if (sACT.equalsIgnoreCase(sACT_SUPP)) {
            actionCard = CardCreatorGlobal.setTDCard2();
        } else if (sACT.equalsIgnoreCase(sACT_CMD)) {
            String sXCMD = entryAttributes.get("XCMD");
            if (null != sXCMD && !sXCMD.isEmpty()) {
                cardsList.addAll(CardBuilderControlO.buildCardsForShoutError("RULE HAS AN UNSOPPRTED EXTENDED VALUE: XCMD"));
                sInfo = sInfo + " . Unsupported - ACT : CMD . XCMD";
                Reporter.addMessage(errorMessagesList, (String)"WRN5001", (String)"$$$_AMR", (String[])new String[]{"AMR", "XCMD", sInfo});
            } else if (null != sReply && sReply.length() > 38) {
                cardsList.addAll(CardBuilderControlO.buildCardsForShoutError("RULE HAS A TOO LONG XCMD"));
                sInfo = sInfo + " . Too large : " + sReply;
                Reporter.addMessage(errorMessagesList, (String)"WRN5002", (String)"$$$_AMR", (String[])new String[]{"AMR", sInfo});
            } else {
                actionCard = CardCreatorGlobal.setTPCard(sReply, "");
            }
        } else {
            cardsList.addAll(CardBuilderControlO.buildCardsForShoutError(sErrorACT + sACT));
            sInfo = sInfo + " . Unsupported - ACT : " + sACT;
            Reporter.addMessage(errorMessagesList, (String)"WRN5001", (String)"$$$_AMR", (String[])new String[]{"AMR", sACT, sInfo});
        }
        if (null != actionCard) {
            cardsList.add(actionCard);
        }
        if (!bSupportedProcessPE) {
            cardsList.addAll(CardBuilderControlO.buildCardsForShoutError(sErrorPROCESSPE + sDays));
            sInfo = sInfo + " . Unsupported - " + sDays;
            Reporter.addMessage(errorMessagesList, (String)"WRN5003", (String)"$$$_AMR", (String[])new String[]{"AMR", sDays, sInfo});
        }
        return cardsList;
    }

    private static ArrayList<char[]> buildCardsForSCS(HashMap<String, String> entryAttributes, String sOwner, ArrayList<String> errorMessagesList) {
        ArrayList<char[]> cardsList = new ArrayList<char[]>();
        String sDays = entryAttributes.get("PROCESSPE");
        char[] dCard = CardBuilderControlO.createDCard(sOwner, sDays, "SCS");
        cardsList.add(dCard);
        boolean bSupportedProcessPE = CardBuilderControlO.isSupportedProcessPE(sDays);
        char[] wCard = CardCreatorGlobal.setWCard(CardBuilderControlO.getProcessPeriodMask(sDays, bSupportedProcessPE));
        cardsList.add(wCard);
        String sCMD = entryAttributes.get(sACT_CMD);
        String sCMDCNT = entryAttributes.get("CMDCONT");
        String sRange = entryAttributes.get("RANGE");
        String sInterval = entryAttributes.get("INTV");
        char[] gCard = CardBuilderControlO.createGCard(sRange, sInterval, "SCS", errorMessagesList, sCMD + sCMDCNT);
        cardsList.add(gCard);
        String sTableName = entryAttributes.get("TABLE");
        char[] oeCard = CardCreatorGlobal.setOECard(sTableName);
        cardsList.add(oeCard);
        String sInfo = "CMD : " + sCMD + " . RANGE : " + sRange + " . PROCESSPE : " + sDays;
        char[] hCard = CardCreatorGlobal.setHCard(sCMD);
        cardsList.add(hCard);
        int iCMDLen = 0;
        if (null != sCMD) {
            iCMDLen += sCMD.length();
        }
        if (null != sCMDCNT) {
            iCMDLen += sCMDCNT.length();
        }
        if (iCMDLen <= 38) {
            String sSYSID = entryAttributes.get("SYSID");
            char[] tpCard = CardCreatorGlobal.setTPCard(sCMD, sSYSID);
            cardsList.add(tpCard);
        } else {
            cardsList.addAll(CardBuilderControlO.buildCardsForShoutError("RULE HAS AN UNSOPPRTED EXTENDED VALUE: CMD OR CMD(CONT)"));
            sInfo = sInfo + " . Too large : " + sCMD;
            Reporter.addMessage(errorMessagesList, (String)"WRN5002", (String)"$$$_SCS", (String[])new String[]{"SCS", sInfo});
        }
        if (!bSupportedProcessPE) {
            cardsList.addAll(CardBuilderControlO.buildCardsForShoutError(sErrorPROCESSPE + sDays));
            sInfo = sInfo + " . Unsupported - " + sDays;
            Reporter.addMessage(errorMessagesList, (String)"WRN5003", (String)"$$$_SCS", (String[])new String[]{"SCS", sDays, sInfo});
        }
        return cardsList;
    }

    private static ArrayList<char[]> buildCardsForShoutError(String sErrorMessage) {
        ArrayList<char[]> cardsList = new ArrayList<char[]>();
        char[] twCard1 = CardCreatorGlobal.setTWCard1();
        char[] twCard2 = CardCreatorGlobal.setTWCard2(sErrorMessage);
        cardsList.add(twCard1);
        cardsList.add(twCard2);
        return cardsList;
    }

    private static char[] createDCard(String sOwner, String sProcessPE, String sType) {
        boolean bEOM = false;
        if (null != sProcessPE && (sType.equalsIgnoreCase("ADR") || sType.equalsIgnoreCase("SCS")) && sProcessPE.equalsIgnoreCase(sEOM)) {
            bEOM = true;
        }
        return CardCreatorGlobal.setDCard(sOwner, bEOM);
    }

    private static char[] createGCard(String sRange, String sInterval, String sType, ArrayList<String> errorMessagesList, String sCMD) {
        String splitter = "-";
        if (sType.equalsIgnoreCase("SCS")) {
            if (null != sInterval) {
                sInterval = sInterval.replaceAll(":", "");
            }
            if (null != sRange) {
                sRange = sRange.replaceAll(":", "");
                sRange = sRange.replaceAll(" ", splitter);
            }
        }
        String sFrom = "";
        String sUntil = "";
        String sModifiedInterval = "";
        if (null != sInterval && !sInterval.isEmpty()) {
            int iInterval = Integer.parseInt(sInterval);
            if (iInterval > 999) {
                sModifiedInterval = sUnsupportedInterval;
                String sInfo = "CMD and CMD(CONT) : " + sCMD + " Original Interval: " + sInterval;
                Reporter.addMessage(errorMessagesList, (String)"WRN5004", (String)"$$$_SCS", (String[])new String[]{"SCS", sModifiedInterval, sInfo});
            } else {
                sModifiedInterval = Integer.toString(iInterval);
                if (null != sModifiedInterval && sModifiedInterval.length() > 3) {
                    sModifiedInterval = sModifiedInterval.substring(0, 4);
                }
            }
        }
        if (null != sRange && !sRange.isEmpty()) {
            boolean timeFrom24 = false;
            boolean timeUntil24 = false;
            String[] ranges = sRange.split(splitter);
            sFrom = ranges[0];
            if (ranges.length == 2) {
                sUntil = ranges[1];
            }
            if (!sFrom.isEmpty() && sFrom.equals("0000")) {
                timeFrom24 = true;
            }
            if (!sUntil.isEmpty() && sUntil.equals("2359")) {
                timeUntil24 = true;
            }
            if (sUntil.isEmpty()) {
                sUntil = "2359";
                timeUntil24 = true;
            }
            if (timeFrom24 && timeUntil24) {
                sFrom = "";
                sUntil = "";
            }
        }
        return CardCreatorGlobal.setGCard(sFrom, sUntil, sModifiedInterval);
    }
}

