/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.io.csv.CsvReader;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class CSVReaderTable {
    HashMap<String, HashMap<String, ArrayList<String>>> m_Table_Values;

    public static String getTablePrefix(String tableType) {
        if (tableType.equalsIgnoreCase("AMR")) {
            return "Message";
        }
        if (tableType.equalsIgnoreCase("ADR")) {
            return "DSN";
        }
        if (tableType.equalsIgnoreCase("SCS")) {
            return "Command";
        }
        return null;
    }

    public boolean loadTableFile(String fileName, String tableType) {
        int d = 1;
        String keyPrefix = CSVReaderTable.getTablePrefix(tableType);
        if (null == keyPrefix) {
            ExceptionHandler.writeToExceptionFile((String)"Error in CSVReaderTable - loadTableFile");
            ExceptionHandler.writeToExceptionFile((String)("Table type - " + tableType));
            ExceptionHandler.writeToExceptionFile((String)("Wrong table prefix - " + keyPrefix));
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            return false;
        }
        File file = new File(fileName);
        if (file.exists()) {
            try {
                CsvReader reader = new CsvReader(fileName);
                String sTableName = "";
                String sDate = "";
                String sMsgText = "";
                String msgHeader = "";
                if (tableType.equalsIgnoreCase("ADR")) {
                    msgHeader = "DSN";
                } else if (tableType.equalsIgnoreCase("AMR")) {
                    msgHeader = "MSGTEXT";
                } else if (tableType.equalsIgnoreCase("SCS")) {
                    msgHeader = "CMD";
                }
                int indexTable = JobTracGlobals.getIndexOfHeaderInCSV(tableType, "TABLE");
                int indexDate = JobTracGlobals.getIndexOfHeaderInCSV(tableType, "DATE");
                int indexMsgText = JobTracGlobals.getIndexOfHeaderInCSV(tableType, msgHeader);
                Object sTableKey = "";
                Object sMessageKey = "";
                reader.readRecord();
                ArrayList<String> tempArray = new ArrayList<String>();
                this.m_Table_Values = new HashMap();
                while (reader.readRecord()) {
                    HashMap<String, ArrayList<String>> tempHash;
                    sTableName = reader.getValues()[indexTable].trim();
                    if (null == sTableName || sTableName.isEmpty() || null == (sDate = reader.getValues()[indexDate]) || sDate.isEmpty()) continue;
                    sMsgText = reader.getValues()[indexMsgText];
                    if (null != sMsgText) {
                        String sTemp = sMsgText.replaceAll("'", "");
                        if ((sTemp = sTemp.replaceAll("\\s+", "")).isEmpty()) {
                            sMsgText = "CONVERSION";
                        }
                    }
                    if (null == sMsgText || sMsgText.isEmpty()) {
                        sMsgText = "CONVERSION";
                    }
                    if (null == (tempHash = this.m_Table_Values.get(sTableKey = sTableName + " - " + sDate))) {
                        tempHash = new HashMap();
                    }
                    sMessageKey = keyPrefix + " " + String.format("%04d", d) + " - " + sMsgText.substring(0, Math.min(sMsgText.length(), 16));
                    for (int i = 0; i < reader.getValues().length; ++i) {
                        tempArray.add(reader.getValues()[i]);
                    }
                    tempHash.put((String)sMessageKey, tempArray);
                    this.m_Table_Values.put((String)sTableKey, tempHash);
                    tempArray = new ArrayList();
                    ++d;
                }
                reader.close();
                return true;
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((String)"Error in CSVReaderTable - loadTableFile");
                ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
                ExceptionHandler.writeToExceptionFile((String)("Line : " + d));
                ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
                return false;
            }
        }
        return false;
    }

    public HashMap<String, HashMap<String, ArrayList<String>>> getAllTables() {
        return this.m_Table_Values;
    }

    public ArrayList<String> getAllTablesName() {
        return new ArrayList<String>(this.m_Table_Values.keySet());
    }

    public HashMap<String, ArrayList<String>> getTableContent(String tableName) {
        return this.m_Table_Values.get(tableName);
    }
}

