/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.io.csv.CsvReader;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import java.util.ArrayList;

public class CSVReaderRESOURCE {
    ArrayList<ArrayList<String>> m_valuesArray = new ArrayList();

    public boolean loadTableFile(String fileName) {
        int d = 0;
        try {
            CsvReader reader = new CsvReader(fileName);
            ArrayList<String> tempList = new ArrayList<String>();
            int iRESOURCE = JobTracGlobals.getIndexOfHeaderInCSV("RES", "RES");
            int iRULE = JobTracGlobals.getIndexOfHeaderInCSV("RES", "RULE");
            int iEVENTNAME = JobTracGlobals.getIndexOfHeaderInCSV("RES", "EVENTNAME");
            int iOPERATION = JobTracGlobals.getIndexOfHeaderInCSV("RES", "OPERATION");
            reader.readRecord();
            while (reader.readRecord()) {
                tempList.add(reader.getValues()[iRESOURCE]);
                tempList.add(reader.getValues()[iRULE]);
                tempList.add(reader.getValues()[iEVENTNAME]);
                tempList.add(reader.getValues()[iOPERATION]);
                this.m_valuesArray.add(tempList);
                tempList = new ArrayList();
                ++d;
            }
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in CSVReaderRESOURCE - loadTableFile");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + d));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
            return false;
        }
        return true;
    }

    public ArrayList<ArrayList<String>> getAllData() {
        return this.m_valuesArray;
    }

    public String getEventNameByResource(String sResourceName) {
        String sRet = null;
        if (null != this.m_valuesArray) {
            int iRESOURCE = JobTracGlobals.getIndexOfHeaderInCSV("RES", "RES");
            int iEVENTNAME = JobTracGlobals.getIndexOfHeaderInCSV("RES", "EVENTNAME");
            for (ArrayList<String> row : this.m_valuesArray) {
                if (null == row || !row.get(iRESOURCE).equalsIgnoreCase(sResourceName)) continue;
                return row.get(iEVENTNAME);
            }
        }
        return sRet;
    }

    public String getRuleTypeByResource(String sResourceName) {
        String sRet = null;
        if (null != this.m_valuesArray) {
            int iRESOURCE = JobTracGlobals.getIndexOfHeaderInCSV("RES", "RES");
            int iRULE = JobTracGlobals.getIndexOfHeaderInCSV("RES", "RULE");
            for (ArrayList<String> row : this.m_valuesArray) {
                if (null == row || !row.get(iRESOURCE).equalsIgnoreCase(sResourceName)) continue;
                return row.get(iRULE);
            }
        }
        return sRet;
    }

    public String getOperationTypeByResource(String sResourceName) {
        String sRet = null;
        if (null != this.m_valuesArray) {
            int iRESOURCE = JobTracGlobals.getIndexOfHeaderInCSV("RES", "RES");
            int iOPERATION = JobTracGlobals.getIndexOfHeaderInCSV("RES", "OPERATION");
            for (ArrayList<String> row : this.m_valuesArray) {
                if (null == row || !row.get(iRESOURCE).equalsIgnoreCase(sResourceName)) continue;
                return row.get(iOPERATION);
            }
        }
        return sRet;
    }
}

