/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.io.csv.CsvReader;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import java.util.ArrayList;
import java.util.HashMap;

public class CSVReaderJCL {
    private HashMap<String, ArrayList<ArrayList<String>>> m_eventID_AllList = new HashMap();
    private String m_sFileName = null;

    public ArrayList<String> getAllEventsList() {
        ArrayList<String> resultList = null;
        if (null != this.m_eventID_AllList && this.m_eventID_AllList.keySet().size() > 0) {
            resultList = new ArrayList<String>(this.m_eventID_AllList.keySet());
        }
        return resultList;
    }

    public HashMap<String, ArrayList<ArrayList<String>>> getDataMapOfSteps() {
        return this.m_eventID_AllList;
    }

    public CSVReaderJCL(String sFileName) {
        this.m_sFileName = sFileName;
    }

    public boolean loadTableFile() {
        int d = 0;
        try {
            CsvReader reader = new CsvReader(this.m_sFileName);
            int iMEMBERName = JobTracGlobals.getIndexOfHeaderInCSV("JCL", "JCLmember");
            int iStepName = JobTracGlobals.getIndexOfHeaderInCSV("JCL", "JCLstepname");
            int iStepSeq = JobTracGlobals.getIndexOfHeaderInCSV("JCL", "JCLstepseq");
            int iStepProc = JobTracGlobals.getIndexOfHeaderInCSV("JCL", "JCLproc");
            int iStepPGM = JobTracGlobals.getIndexOfHeaderInCSV("JCL", "JCLpgm");
            reader.readRecord();
            String sEvent = null;
            ArrayList<ArrayList<String>> sExistingStepsList = null;
            while (reader.readRecord()) {
                ArrayList<String> thisStep = new ArrayList<String>();
                sEvent = reader.getValues()[iMEMBERName];
                thisStep.add(reader.getValues()[iStepName]);
                thisStep.add(reader.getValues()[iStepSeq]);
                thisStep.add(reader.getValues()[iStepProc]);
                thisStep.add(reader.getValues()[iStepPGM]);
                sExistingStepsList = this.m_eventID_AllList.get(sEvent);
                if (null == sExistingStepsList) {
                    sExistingStepsList = new ArrayList();
                }
                sExistingStepsList.add(thisStep);
                this.m_eventID_AllList.put(sEvent, sExistingStepsList);
                ++d;
            }
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in CSVReaderJCL - loadTableFile");
            ExceptionHandler.writeToExceptionFile((String)("File : " + this.m_sFileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + d));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
            return false;
        }
        return true;
    }
}

