/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.jobtrac.CSVReaderCCPF;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class CCPFToJSCSFConvertor {
    private InputStream cCPFStream;
    private OutputStream jSCSFStream;
    private int maxCCOK = 0;
    private String cTMPARM;

    public CCPFToJSCSFConvertor(InputStream cCPFStream, OutputStream jSCSFStream, int maxCCOK, String cTMPARM) {
        this.cCPFStream = cCPFStream;
        this.jSCSFStream = jSCSFStream;
        this.maxCCOK = maxCCOK;
        this.cTMPARM = cTMPARM;
    }

    public void doConversion() throws IOException {
        CSVReaderCCPF m_ccpfReader = new CSVReaderCCPF();
        boolean bRead = m_ccpfReader.loadTableFile(this.cCPFStream);
        ArrayList<HashMap<String, String>> listCCPFEntries = m_ccpfReader.getData();
        Object jclCommand = "";
        String newLine = "\n";
        jclCommand = "//JSCSF EXEC PGM=IEBUPDTE,PARM=NEW" + newLine;
        jclCommand = (String)jclCommand + "//SYSPRINT  DD SYSOUT=*" + newLine;
        jclCommand = (String)jclCommand + "//SYSUT2   DD DISP=SHR,DSN=" + this.cTMPARM + newLine;
        jclCommand = (String)jclCommand + "//SYSIN    DD DATA,DLM=@@" + newLine;
        jclCommand = (String)jclCommand + "./ ADD NAME=PGMST" + newLine;
        this.jSCSFStream.write(((String)jclCommand).getBytes());
        for (HashMap<String, String> ccpfEntry : listCCPFEntries) {
            String sAction = "OK";
            String sOPER = "";
            if (ccpfEntry.get("CONDCODEOPERATOR").equals("EQ")) {
                sOPER = "";
            } else if (ccpfEntry.get("CONDCODEOPERATOR").equals("NE")) {
                sOPER = "N";
            } else if (ccpfEntry.get("CONDCODEOPERATOR").equals("LT")) {
                sOPER = "<";
                if (this.maxCCOK > Integer.valueOf(ccpfEntry.get("CONDCODEVALUE"))) {
                    sOPER = ">=";
                    sAction = "NOTOK";
                }
            } else if (ccpfEntry.get("CONDCODEOPERATOR").equals("LE")) {
                sOPER = "<=";
                if (this.maxCCOK > Integer.valueOf(ccpfEntry.get("CONDCODEVALUE"))) {
                    sOPER = ">";
                    sAction = "NOTOK";
                }
            } else if (ccpfEntry.get("CONDCODEOPERATOR").equals("GT")) {
                sOPER = ">";
            } else if (ccpfEntry.get("CONDCODEOPERATOR").equals("GE")) {
                sOPER = ">=";
            }
            String jscsfLine = String.format("%-9s%-2s%-9s%-9s%-9s%-6s%-2s%-5s", ccpfEntry.get("EVENTNAME"), "*", ccpfEntry.get("PROCSTEPNAME"), ccpfEntry.get("STEPNAME"), ccpfEntry.get("PROGRAMNAME"), sAction, "Y", sOPER + "C" + ccpfEntry.get("CONDCODEVALUE") + newLine);
            this.jSCSFStream.write(jscsfLine.getBytes());
        }
        jclCommand = "";
        jclCommand = (String)jclCommand + "./ ENDUP" + newLine;
        jclCommand = (String)jclCommand + "@@" + newLine;
        jclCommand = (String)jclCommand + "/*" + newLine;
        this.jSCSFStream.write(((String)jclCommand).getBytes());
        this.jSCSFStream.close();
    }
}

