/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.StatefulBeanToCsv;
import java.io.Writer;

public class StatefulBeanToCsvBuilder<T> {
    private char separator = (char)44;
    private char quotechar = (char)34;
    private char escapechar = (char)34;
    private String lineEnd = "\n";
    private MappingStrategy<T> mappingStrategy = null;
    private final Writer writer;
    private boolean throwExceptions = true;

    private StatefulBeanToCsvBuilder() {
        throw new IllegalStateException("This class may never be instantiated with the nullary constructor.");
    }

    public StatefulBeanToCsvBuilder(Writer writer) {
        this.writer = writer;
    }

    public StatefulBeanToCsvBuilder withMappingStrategy(MappingStrategy<T> mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
        return this;
    }

    public StatefulBeanToCsvBuilder withSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public StatefulBeanToCsvBuilder withQuotechar(char quotechar) {
        this.quotechar = quotechar;
        return this;
    }

    public StatefulBeanToCsvBuilder withEscapechar(char escapechar) {
        this.escapechar = escapechar;
        return this;
    }

    public StatefulBeanToCsvBuilder withLineEnd(String lineEnd) {
        this.lineEnd = lineEnd;
        return this;
    }

    public StatefulBeanToCsvBuilder withThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
        return this;
    }

    public StatefulBeanToCsv build() {
        return new StatefulBeanToCsv<T>(this.escapechar, this.lineEnd, this.mappingStrategy, this.quotechar, this.separator, this.throwExceptions, this.writer);
    }
}

