/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.scheduling;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TreeNode<T> {
    private final T data;
    private final List<TreeNode<T>> children;

    public TreeNode(T data) {
        this.data = data;
        this.children = new LinkedList<TreeNode<T>>();
    }

    public TreeNode<T> addChild(T child) {
        TreeNode<T> childNode = new TreeNode<T>(child);
        this.children.add(childNode);
        return childNode;
    }

    public Optional<TreeNode<T>> getChildBy(Predicate<TreeNode<T>> query) {
        if (query.test(this)) {
            return Optional.of(this);
        }
        return this.children.stream().filter(query).findFirst();
    }

    public List<TreeNode<T>> getChildrenBy(Predicate<TreeNode<T>> query) {
        ArrayList<TreeNode<T>> result = new ArrayList<TreeNode<T>>();
        if (query.test(this)) {
            result.add(this);
        }
        for (TreeNode<TreeNode<TreeNode>> treeNode : this.children) {
            result.addAll(treeNode.getChildrenBy(query));
        }
        return result;
    }

    public T getData() {
        return this.data;
    }

    public TreeNode<T> getFirstChild() {
        return this.children.get(0);
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public List<TreeNode<T>> getAllNodes() {
        ArrayList<TreeNode<T>> result = new ArrayList<TreeNode<T>>();
        result.add(this);
        for (TreeNode<T> child : this.children) {
            result.addAll(child.getAllNodes());
        }
        return result;
    }

    public String toString() {
        return "TreeNode{data=" + String.valueOf(this.data) + ", children=" + this.children.stream().map(TreeNode::toString).collect(Collectors.joining("\n")) + "}";
    }
}

