/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.scheduling;

import com.bmc.ctmconvert.dSeries.scheduling.EventSchedulingTokenizer;
import com.bmc.ctmconvert.dSeries.scheduling.TreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TokenExtractor {
    private final List<EventSchedulingTokenizer.Token> tokens;
    private final List<EventSchedulingTokenizer.Token> path;

    public TokenExtractor(List<EventSchedulingTokenizer.Token> tokens) {
        this(tokens, new ArrayList<EventSchedulingTokenizer.Token>());
    }

    private TokenExtractor(List<EventSchedulingTokenizer.Token> tokens, List<EventSchedulingTokenizer.Token> path) {
        this.tokens = new ArrayList<EventSchedulingTokenizer.Token>(tokens);
        this.path = path;
    }

    public TokenExtractor get(EventSchedulingTokenizer.TokenType ... type) {
        if (this.hasNext()) {
            EventSchedulingTokenizer.Token token = this.getNext();
            if (List.of(type).contains((Object)token.type())) {
                this.path.add(token);
                return new TokenExtractor(this.tokens.stream().skip(1L).collect(Collectors.toList()), this.path);
            }
        }
        return new EmptyTokenExtractor(this.tokens);
    }

    private boolean hasNext() {
        return !this.tokens.isEmpty();
    }

    private EventSchedulingTokenizer.Token getNext() {
        return this.tokens.get(0);
    }

    public void toTree(TreeNode<EventSchedulingTokenizer.Token> root) {
        TreeNode<EventSchedulingTokenizer.Token> tree = root;
        for (EventSchedulingTokenizer.Token item : this.path) {
            tree = tree.addChild(item);
        }
    }

    public List<EventSchedulingTokenizer.Token> getTokens() {
        return this.tokens;
    }

    public TokenExtractor getOptional(EventSchedulingTokenizer.TokenType ... type) {
        if (this.hasNext()) {
            EventSchedulingTokenizer.Token token = this.getNext();
            if (List.of(type).contains((Object)token.type())) {
                this.path.add(token);
                return new TokenExtractor(this.tokens.stream().skip(1L).collect(Collectors.toList()), this.path);
            }
        }
        return new TokenExtractor(this.tokens, this.path);
    }

    private static class EmptyTokenExtractor
    extends TokenExtractor {
        public EmptyTokenExtractor(List<EventSchedulingTokenizer.Token> tokens) {
            super(tokens);
        }

        @Override
        public void toTree(TreeNode<EventSchedulingTokenizer.Token> root) {
        }
    }
}

