/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.scheduling;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EventSchedulingTokenizer {
    private final String schedulingString;

    public EventSchedulingTokenizer(String schedulingString) {
        this.schedulingString = schedulingString;
    }

    public List<Token> tokens() {
        List schedItems = Stream.of(this.schedulingString.split(" +")).filter(s -> !s.isBlank()).collect(Collectors.toList());
        return schedItems.stream().flatMap(item -> {
            if (this.shouldIgnore((String)item)) {
                return Stream.empty();
            }
            List tokenStream = Stream.of(this.toTimeToken((String)item), this.toTimeZoneToken((String)item), this.toMonthToken((String)item), this.toDayToken((String)item), this.toEveryToken((String)item), this.toPeriodToken((String)item), this.toYearToken((String)item), this.toQuantityToken((String)item), this.toDaily((String)item), this.toHourly((String)item), this.toWeekDays((String)item), this.toOf((String)item), this.firstOf((String)item), this.lastOf((String)item), this.lessOf((String)item), this.toMonthPeriod((String)item), this.toCalendarPeriod((String)item)).filter(t -> !t.isEmpty()).collect(Collectors.toList());
            if (tokenStream.isEmpty()) {
                return Stream.of(EventSchedulingTokenizer.empty(item));
            }
            return tokenStream.stream();
        }).collect(Collectors.toList());
    }

    private Token toYearToken(String item) {
        return this.toToken(Pattern.compile("( 19\\d{2}|20\\d{2})", 2), TokenType.YEAR).apply(item);
    }

    private Token lessOf(String item) {
        return this.toToken(Pattern.compile("(LESS)", 2), TokenType.LESS).apply(item);
    }

    private Token lastOf(String item) {
        return this.toToken(Pattern.compile("(LAST)", 2), TokenType.LAST).apply(item);
    }

    private Token firstOf(String item) {
        return this.toToken(Pattern.compile("(FIRST)", 2), TokenType.FIRST).apply(item);
    }

    private Token toOf(String item) {
        Pattern periodPattern = Pattern.compile("(of)", 2);
        return this.toToken(periodPattern, TokenType.OF).apply(item);
    }

    private Token toWeekDays(String item) {
        Pattern periodPattern = Pattern.compile("(WEEKDAY(S)?)", 2);
        return this.toToken(periodPattern, TokenType.WEEKDAYS).apply(item);
    }

    private Token toHourly(String item) {
        Pattern periodPattern = Pattern.compile(" *(HOURLY) *", 2);
        return this.toToken(periodPattern, TokenType.HOURLY).apply(item);
    }

    private Token toDaily(String item) {
        Pattern periodPattern = Pattern.compile(" *(DAILY) *", 2);
        return this.toToken(periodPattern, TokenType.DAILY).apply(item);
    }

    private Token toQuantityToken(String item) {
        Pattern periodPattern = Pattern.compile("(\\d+)(?:st|nd|rd|th)?", 2);
        if (this.isYear(item)) {
            return EventSchedulingTokenizer.empty(item);
        }
        return this.toToken(periodPattern, TokenType.QUANTITY).apply(item);
    }

    private boolean isYear(String item) {
        return this.toYearToken(item).type() == TokenType.YEAR;
    }

    private boolean shouldIgnore(String item) {
        Pattern pattern = Pattern.compile("(st|nd|rd|th)?", 2);
        return pattern.matcher(item).matches();
    }

    private Token toPeriodToken(String item) {
        Pattern periodPattern = Pattern.compile("(MINUTE(S)?|DAY(S)?|HOUR(S)?)", 2);
        return this.toToken(periodPattern, TokenType.PERIOD).apply(item);
    }

    private Token toMonthPeriod(String item) {
        Pattern periodPattern = Pattern.compile("(MONTH(S)?)", 2);
        return this.toToken(periodPattern, TokenType.MONTH_PERIOD).apply(item);
    }

    private Token toCalendarPeriod(String item) {
        Pattern periodPattern = Pattern.compile("(WORKDAY(s)?|HOLIDAY(S)?|BILLDAY(S)?)", 2);
        return this.toToken(periodPattern, TokenType.CALENDAR_PERIOD).apply(item);
    }

    private Token toEveryToken(String item) {
        Pattern everyPattern = Pattern.compile("(EVERY)", 2);
        Matcher matcher = everyPattern.matcher(item);
        if (matcher.matches()) {
            return new EveryToken();
        }
        return EventSchedulingTokenizer.empty(item);
    }

    private Token toDayToken(String item) {
        Pattern dayPattern = Pattern.compile("(SUNDAY|MONDAY|TUESDAY|WEDNESDAY|THURSDAY|FRIDAY|SATURDAY)", 2);
        return this.toToken(dayPattern, TokenType.DAY).apply(item);
    }

    private Token toTimeToken(String item) {
        Pattern timePattern = Pattern.compile("(\\d{2}:\\d{2})(:\\d{2}\\.\\d{3}.*)?");
        Matcher matcher = timePattern.matcher(item);
        if (matcher.find()) {
            return new TokenImpl(matcher.group(1).replace(":", ""), TokenType.TIME);
        }
        return EventSchedulingTokenizer.empty(item);
    }

    private Token toMonthToken(String item) {
        String fullMonthNames = "January|February|March|April|May|June|July|August|September|October|November|December";
        String shortMonthNames = "Jan|Feb|Mar|Apr|Jun|Jul|Aug|Sep|Oct|Nov|Dec";
        Pattern monthPattern = Pattern.compile("(" + fullMonthNames + "|" + shortMonthNames + ")", 2);
        return this.toToken(monthPattern, TokenType.MONTH).apply(item);
    }

    private Token toTimeZoneToken(String item) {
        Pattern timeZonePattern = Pattern.compile(".*(ATZ|CTZ|ETZ|GMT|MTZ|PTZ|UTC).*", 2);
        return this.toToken(timeZonePattern, TokenType.TIMEZONE).apply(item);
    }

    private Function<String, Token> toToken(Pattern pattern, TokenType type) {
        return input -> {
            Matcher matcher = pattern.matcher((CharSequence)input);
            if (matcher.matches()) {
                return new TokenImpl(matcher.group(1), type);
            }
            return EventSchedulingTokenizer.empty(input);
        };
    }

    public static Token empty(String data) {
        return new TokenImpl(data, TokenType.EMPTY);
    }

    public static enum TokenType {
        EMPTY,
        MONTH,
        TIME,
        TIMEZONE,
        DAY,
        EVERY,
        PERIOD,
        MONTH_PERIOD,
        CALENDAR_PERIOD,
        QUANTITY,
        DAILY,
        HOURLY,
        WEEKDAYS,
        OF,
        FIRST,
        LAST,
        LESS,
        YEAR;

    }

    static interface Token {
        public TokenType type();

        public String data();

        default public Optional<String> displayName() {
            BiFunction<String, Integer, String> getFirstNLettersOf = (input, toTake) -> input.toLowerCase().substring(0, (int)toTake);
            UnaryOperator displayFirst2Letters = input -> (String)getFirstNLettersOf.apply((String)input, 2);
            UnaryOperator displayFirst3Letters = input -> (String)getFirstNLettersOf.apply((String)input, 3);
            String displayName = switch (this.type().ordinal()) {
                default -> throw new MatchException(null, null);
                case 4 -> (String)displayFirst2Letters.apply(this.data());
                case 1 -> (String)displayFirst3Letters.apply(this.data());
                case 0, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> this.data();
                case 5 -> "Every";
            };
            return Optional.ofNullable(displayName).filter(n -> !n.isBlank());
        }

        default public boolean isEmpty() {
            return this.type() == TokenType.EMPTY;
        }
    }

    private static class EveryToken
    implements Token {
        private EveryToken() {
        }

        @Override
        public TokenType type() {
            return TokenType.EVERY;
        }

        @Override
        public String data() {
            return "";
        }
    }

    public static class TokenImpl
    implements Token {
        private final TokenType type;
        private final String data;

        public TokenImpl(String data, TokenType type) {
            this.data = data;
            this.type = type;
        }

        @Override
        public TokenType type() {
            return this.type;
        }

        @Override
        public String data() {
            return this.data;
        }

        public String toString() {
            return "TokenImpl{type=" + String.valueOf((Object)this.type) + ", data='" + this.data() + "'}";
        }
    }
}

