/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.scheduling;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.rbc.DailyRbc;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.dSeries.scheduling.EventSchedulingTokenizer;
import com.bmc.ctmconvert.dSeries.scheduling.TokenExtractor;
import com.bmc.ctmconvert.dSeries.scheduling.TreeExtractor;
import com.bmc.ctmconvert.dSeries.scheduling.TreeNode;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class EventScheduling {
    public static final String WORKDAYS_CALENDAR = "WORKDAYS";
    public static final EventSchedulingTokenizer.TokenImpl ROOT = new EventSchedulingTokenizer.TokenImpl("root", EventSchedulingTokenizer.TokenType.EMPTY);
    private final List<String> scheduleElements;
    private final boolean isManualOrder;
    private final UniqueValueGenerator uniqueValueGenerator;

    public EventScheduling(List<String> scheduleElements) {
        this(scheduleElements, false);
    }

    public EventScheduling(List<String> scheduleElements, boolean isManualOrder) {
        this.scheduleElements = scheduleElements;
        this.isManualOrder = isManualOrder;
        this.uniqueValueGenerator = new UniqueValueGenerator();
    }

    public static UnaryOperator<String> removeIfStatement() {
        return input -> {
            Pattern ifPattern = Pattern.compile("%IF\\(.*?,'?(?<scheduling>.*?)'?\\)");
            Matcher matcher = ifPattern.matcher((CharSequence)input);
            if (matcher.matches()) {
                return matcher.group("scheduling");
            }
            return input;
        };
    }

    private TreeNode<EventSchedulingTokenizer.Token> toTree(List<EventSchedulingTokenizer.Token> tokens, TreeNode<EventSchedulingTokenizer.Token> root) {
        if (tokens.isEmpty()) {
            return root;
        }
        EventSchedulingTokenizer.Token token = this.getNext(tokens);
        switch (token.type()) {
            case EVERY: {
                this.addEveryTokens(tokens, root, token);
                break;
            }
            case QUANTITY: {
                this.addQuantity(tokens, root, token);
                break;
            }
            case PERIOD: {
                this.addPeriodToken(tokens, root, token);
                break;
            }
            case OF: {
                this.addOfToken(tokens, root, token);
                break;
            }
            case LAST: {
                this.addLast(tokens, root, token);
                break;
            }
            case MONTH: {
                this.addMonthToken(tokens, root, token);
                break;
            }
            default: {
                this.addSingleToken(tokens, root, token);
            }
        }
        return root;
    }

    private void addMonthToken(List<EventSchedulingTokenizer.Token> tokens, TreeNode<EventSchedulingTokenizer.Token> root, EventSchedulingTokenizer.Token token) {
        TreeNode<EventSchedulingTokenizer.Token> month = root.addChild(token);
        TokenExtractor tokenExtractor = new TokenExtractor(tokens).get(EventSchedulingTokenizer.TokenType.QUANTITY).get(EventSchedulingTokenizer.TokenType.YEAR);
        tokenExtractor.toTree(month);
        this.toTree(tokenExtractor.getTokens(), root);
    }

    private void addLast(List<EventSchedulingTokenizer.Token> tokens, TreeNode<EventSchedulingTokenizer.Token> root, EventSchedulingTokenizer.Token token) {
        TreeNode<EventSchedulingTokenizer.Token> last = root.addChild(token);
        TokenExtractor tokenExtractor = new TokenExtractor(tokens).get(EventSchedulingTokenizer.TokenType.PERIOD, EventSchedulingTokenizer.TokenType.DAY, EventSchedulingTokenizer.TokenType.CALENDAR_PERIOD).get(EventSchedulingTokenizer.TokenType.OF).get(EventSchedulingTokenizer.TokenType.PERIOD, EventSchedulingTokenizer.TokenType.MONTH_PERIOD).getOptional(EventSchedulingTokenizer.TokenType.LESS).getOptional(EventSchedulingTokenizer.TokenType.QUANTITY).getOptional(EventSchedulingTokenizer.TokenType.PERIOD, EventSchedulingTokenizer.TokenType.CALENDAR_PERIOD);
        tokenExtractor.toTree(last);
        this.toTree(tokenExtractor.getTokens(), root);
    }

    private void addOfToken(List<EventSchedulingTokenizer.Token> tokens, TreeNode<EventSchedulingTokenizer.Token> root, EventSchedulingTokenizer.Token token) {
        TreeNode<EventSchedulingTokenizer.Token> ofToken = root.addChild(token);
        if (this.hasNext(tokens)) {
            this.toTree(tokens, ofToken);
        }
    }

    private void addPeriodToken(List<EventSchedulingTokenizer.Token> tokens, TreeNode<EventSchedulingTokenizer.Token> root, EventSchedulingTokenizer.Token token) {
        root.addChild(token);
        this.toTree(tokens, root);
    }

    public List<Scheduling> parse() {
        try {
            return this.scheduleElements.stream().filter(elem -> !elem.isBlank()).map(elem -> {
                List<String> schedItems = this.normalizeScheduleString((String)elem);
                List<EventSchedulingTokenizer.Token> tokens = schedItems.stream().flatMap(item -> new EventSchedulingTokenizer((String)item).tokens().stream()).collect(Collectors.toList());
                TreeNode<EventSchedulingTokenizer.Token> tree = this.toTree(tokens, new TreeNode<EventSchedulingTokenizer.Token>(ROOT));
                return new Scheduling(this.getCyclicFrom(tree), this.getTimeFrom(tree), this.getCalendarsFrom(tree), this.getNotSupportedFrom(tree), this.scheduleElements, this.isManualOrder);
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return List.of(new EmptyScheduling(this.scheduleElements));
        }
    }

    private boolean hasNext(List<EventSchedulingTokenizer.Token> tokens) {
        return !tokens.isEmpty();
    }

    private void addSingleToken(List<EventSchedulingTokenizer.Token> tokens, TreeNode<EventSchedulingTokenizer.Token> root, EventSchedulingTokenizer.Token token) {
        root.addChild(token);
        tokens.remove(token);
        this.toTree(tokens, root);
    }

    private <T> T getNext(List<T> tokens) {
        return tokens.remove(0);
    }

    private void addEveryTokens(List<EventSchedulingTokenizer.Token> tokens, TreeNode<EventSchedulingTokenizer.Token> root, EventSchedulingTokenizer.Token token) {
        TreeNode<EventSchedulingTokenizer.Token> everyToken = root.addChild(token);
        TreeNode<EventSchedulingTokenizer.Token> quantity = everyToken.addChild(this.getNext(tokens));
        quantity.addChild(this.getNext(tokens));
        this.toTree(tokens, root);
    }

    private List<EventSchedulingTokenizer.Token> getNotSupportedFrom(TreeNode<EventSchedulingTokenizer.Token> tree) {
        return tree.getChildrenBy(x -> ((EventSchedulingTokenizer.Token)x.getData()).type() == EventSchedulingTokenizer.TokenType.EMPTY).stream().map(TreeNode::getData).collect(Collectors.toList());
    }

    private List<String> normalizeScheduleString(String elem) {
        return this.removeStartingSection().andThen(EventScheduling.removeIfStatement().andThen(this.removeComma())).andThen(this.splitSchedules()).apply(elem);
    }

    private Function<String, List<String>> splitSchedules() {
        return schedString -> List.of(schedString.split(" +"));
    }

    private UnaryOperator<String> removeStartingSection() {
        return elem -> elem.contains("STARTING") ? elem.substring(0, elem.indexOf("STARTING")) : elem;
    }

    private UnaryOperator<String> removeComma() {
        return input -> input.replace(",", "");
    }

    private void addQuantity(List<EventSchedulingTokenizer.Token> tokens, TreeNode<EventSchedulingTokenizer.Token> root, EventSchedulingTokenizer.Token token) {
        if (this.hasNext(tokens)) {
            TreeNode<EventSchedulingTokenizer.Token> quantity = root.addChild(token);
            TokenExtractor tokenExtractor = new TokenExtractor(tokens).get(EventSchedulingTokenizer.TokenType.PERIOD, EventSchedulingTokenizer.TokenType.CALENDAR_PERIOD, EventSchedulingTokenizer.TokenType.DAY).get(EventSchedulingTokenizer.TokenType.OF).getOptional(EventSchedulingTokenizer.TokenType.EVERY).get(EventSchedulingTokenizer.TokenType.PERIOD, EventSchedulingTokenizer.TokenType.MONTH_PERIOD).getOptional(EventSchedulingTokenizer.TokenType.LESS).getOptional(EventSchedulingTokenizer.TokenType.QUANTITY).getOptional(EventSchedulingTokenizer.TokenType.PERIOD);
            tokenExtractor.toTree(quantity);
            this.toTree(tokenExtractor.getTokens(), root);
        } else {
            this.addSingleToken(tokens, root, token);
        }
    }

    private String getTimeFrom(TreeNode<EventSchedulingTokenizer.Token> tree) {
        Optional<TreeNode<EventSchedulingTokenizer.Token>> timeFrom = tree.getChildBy(c -> ((EventSchedulingTokenizer.Token)c.getData()).type() == EventSchedulingTokenizer.TokenType.TIME);
        return timeFrom.map(t -> ((EventSchedulingTokenizer.Token)t.getData()).data()).orElse(null);
    }

    private Cyclic getCyclicFrom(TreeNode<EventSchedulingTokenizer.Token> tokenTree) {
        Optional<Cyclic> everyCyclic = this.everyDefinitionToCyclic(tokenTree);
        return everyCyclic.orElse(this.hourlyDefinitionToCyclic(tokenTree));
    }

    private Optional<Cyclic> everyDefinitionToCyclic(TreeNode<EventSchedulingTokenizer.Token> tokenTree) {
        return tokenTree.getChildBy(x -> ((EventSchedulingTokenizer.Token)x.getData()).type() == EventSchedulingTokenizer.TokenType.EVERY).map(e -> {
            TreeNode quantity = e.getFirstChild();
            TreeNode period = quantity.getFirstChild();
            if (((EventSchedulingTokenizer.Token)period.getData()).type() == EventSchedulingTokenizer.TokenType.PERIOD && ((EventSchedulingTokenizer.Token)quantity.getData()).type() == EventSchedulingTokenizer.TokenType.QUANTITY) {
                return new Cyclic(((EventSchedulingTokenizer.Token)quantity.getData()).data(), ((EventSchedulingTokenizer.Token)period.getData()).data());
            }
            return null;
        });
    }

    private Cyclic hourlyDefinitionToCyclic(TreeNode<EventSchedulingTokenizer.Token> tokenTree) {
        return tokenTree.getChildBy(x -> ((EventSchedulingTokenizer.Token)x.getData()).type() == EventSchedulingTokenizer.TokenType.HOURLY).map(h -> new Cyclic("1", PERIOD.HOUR)).orElse(null);
    }

    private List<Properties> getCalendarsFrom(TreeNode<EventSchedulingTokenizer.Token> tree) {
        List ruleBasedCalendar = this.convertDailyCalendar().create(tree).or(() -> this.convertCalendarPeriod().create(tree)).or(() -> this.convertNumberOfCalendar().create(tree)).or(() -> this.convertLastCalendar().create(tree)).or(() -> this.convertNumberOfDayCalendar().create(tree)).or(() -> this.convertLastDayOfMonthCalendar().create(tree)).or(() -> this.convertSpecificCalendar().create(tree)).map(List::of).orElse(new ArrayList());
        List<Properties> staticCalendar = this.convertStaticCalendar(tree);
        return GlobalFunctions.concatLists((List)ruleBasedCalendar, staticCalendar);
    }

    private List<Properties> convertStaticCalendar(TreeNode<EventSchedulingTokenizer.Token> tree) {
        List<Integer> months = this.convertMonths(tree);
        List<Properties> specificDayCalendar = this.createSpecificDayCalendar(tree);
        List<RBC.WEEKDAYS> days = this.convertDays(tree.getChildren());
        List<RBC.WEEKDAYS> weekDays = this.createWeekDays(tree);
        if (!specificDayCalendar.isEmpty()) {
            return specificDayCalendar;
        }
        if (!(months.isEmpty() && days.isEmpty() && weekDays.isEmpty())) {
            RBC rbc = this.createRbcWithNameFrom(tree);
            months.forEach(arg_0 -> ((RBC)rbc).addMonth(arg_0));
            days.forEach(arg_0 -> ((RBC)rbc).addWeekDay(arg_0));
            weekDays.forEach(arg_0 -> ((RBC)rbc).addWeekDay(arg_0));
            if (months.isEmpty()) {
                this.getAllMonths().forEach(arg_0 -> ((RBC)rbc).addMonth(arg_0));
            }
            return List.of(rbc.getRBCWithPreservedName());
        }
        return Collections.emptyList();
    }

    private CalendarCreator convertSpecificCalendar() {
        return tree -> {
            TreeNode period = tree.getFirstChild();
            String data = ((EventSchedulingTokenizer.Token)period.getData()).data();
            if (((EventSchedulingTokenizer.Token)period.getData()).type() == EventSchedulingTokenizer.TokenType.CALENDAR_PERIOD) {
                RBC calendar = new RBC(data);
                calendar.setLevel(RBC.LEVEL.CONTROL_M);
                return Optional.of(calendar.getRBCWithPreservedName());
            }
            return Optional.empty();
        };
    }

    private CalendarCreator convertLastDayOfMonthCalendar() {
        return tree -> {
            TreeExtractor.Route route = new TreeExtractor(tree.getFirstChild()).get(EventSchedulingTokenizer.TokenType.LAST).get(EventSchedulingTokenizer.TokenType.DAY).get(EventSchedulingTokenizer.TokenType.OF).get(EventSchedulingTokenizer.TokenType.MONTH_PERIOD).getOptional(EventSchedulingTokenizer.TokenType.LESS).getOptional(EventSchedulingTokenizer.TokenType.QUANTITY).getOptional(EventSchedulingTokenizer.TokenType.PERIOD).getRoute();
            if (route.isNotEmpty()) {
                RBC calendar = this.createRbcWithNameFrom(tree);
                int appendLessQuantity = this.getAppendLessQuantity(route);
                calendar.setDay(RBC.DAY_TYPE.DAY_FROM_END, 1 + appendLessQuantity);
                IntStream.range(1, 8).forEach(day -> calendar.setDay(RBC.DAY_TYPE.DAY_FROM_END, day));
                List<RBC.WEEKDAYS> weekdays = this.convertDays(List.of(new TreeNode<EventSchedulingTokenizer.Token>(route.get(EventSchedulingTokenizer.TokenType.DAY))));
                weekdays.forEach(arg_0 -> ((RBC)calendar).addWeekDay(arg_0));
                calendar.setDays_and_or(RBC.DAYS_AND_OR.AND);
                return Optional.of(calendar.getRBCWithPreservedName());
            }
            return Optional.empty();
        };
    }

    private int getAppendLessQuantity(TreeExtractor.Route route) {
        int appendLessQuantity = 0;
        if (route.get(EventSchedulingTokenizer.TokenType.LESS).type() == EventSchedulingTokenizer.TokenType.LESS) {
            route.get(EventSchedulingTokenizer.TokenType.QUANTITY);
            appendLessQuantity = Integer.parseInt(route.get(EventSchedulingTokenizer.TokenType.QUANTITY).data());
        }
        return appendLessQuantity;
    }

    private CalendarCreator convertLastCalendar() {
        return tree -> {
            TreeExtractor.Route route = new TreeExtractor(tree.getFirstChild()).get(EventSchedulingTokenizer.TokenType.LAST).get(EventSchedulingTokenizer.TokenType.PERIOD).get(EventSchedulingTokenizer.TokenType.OF).get(EventSchedulingTokenizer.TokenType.PERIOD, EventSchedulingTokenizer.TokenType.MONTH_PERIOD).getOptional(EventSchedulingTokenizer.TokenType.LESS).getOptional(EventSchedulingTokenizer.TokenType.QUANTITY).getOptional(EventSchedulingTokenizer.TokenType.PERIOD).getRoute();
            if (route.isNotEmpty()) {
                RBC calendar = this.createRbcWithNameFrom(tree);
                calendar.setDay(RBC.DAY_TYPE.DAY_FROM_END, 1 + this.getAppendLessQuantity(route));
                calendar.addAllMonths();
                return Optional.of(calendar.getRBCWithPreservedName());
            }
            return Optional.empty();
        };
    }

    private RBC createRbcWithNameFrom(TreeNode<EventSchedulingTokenizer.Token> tree) {
        String calendarName = this.getValidatedCalendarNameFrom(tree);
        return new RBC(calendarName);
    }

    private String getValidatedCalendarNameFrom(TreeNode<EventSchedulingTokenizer.Token> tree) {
        Stream allNodesButRoot = tree.getAllNodes().stream().skip(1L);
        String calendarName = allNodesButRoot.flatMap(c -> ((EventSchedulingTokenizer.Token)c.getData()).displayName().stream()).collect(Collectors.joining("_"));
        String uniqueName = this.uniqueValueGenerator.getUniqueValue("RULE_BASED_CALENDAR", calendarName, 19);
        return FieldValidation.instance().validateAndReturnFixedValue("CAL_NAME", uniqueName);
    }

    private CalendarCreator convertNumberOfDayCalendar() {
        return tree -> {
            TreeExtractor.Route result = new TreeExtractor(tree.getFirstChild()).get(EventSchedulingTokenizer.TokenType.QUANTITY).get(EventSchedulingTokenizer.TokenType.DAY).get(EventSchedulingTokenizer.TokenType.OF).get(EventSchedulingTokenizer.TokenType.MONTH_PERIOD, EventSchedulingTokenizer.TokenType.MONTH).getRoute();
            if (result.isNotEmpty()) {
                RBC calendar = this.createRbcWithNameFrom(tree);
                int quantity = Integer.parseInt(result.get(EventSchedulingTokenizer.TokenType.QUANTITY).data());
                IntStream.range(1, 8).forEach(day -> calendar.setDay(RBC.DAY_TYPE.DAY_FROM_END, day));
                calendar.setDay(RBC.DAY_TYPE.DAY, quantity);
                if (result.get(3).type() == EventSchedulingTokenizer.TokenType.MONTH_PERIOD) {
                    calendar.addAllMonths();
                } else {
                    this.convertMonths(new TreeNode<EventSchedulingTokenizer.Token>(result.get(3))).forEach(arg_0 -> ((RBC)calendar).addMonth(arg_0));
                }
                return Optional.of(calendar.getRBCWithPreservedName());
            }
            return Optional.empty();
        };
    }

    private CalendarCreator convertNumberOfCalendar() {
        return tree -> {
            TreeExtractor.Route result = new TreeExtractor(tree.getFirstChild()).get(EventSchedulingTokenizer.TokenType.QUANTITY).get(EventSchedulingTokenizer.TokenType.PERIOD, EventSchedulingTokenizer.TokenType.MONTH_PERIOD).get(EventSchedulingTokenizer.TokenType.OF).getOptional(EventSchedulingTokenizer.TokenType.EVERY).get(EventSchedulingTokenizer.TokenType.MONTH_PERIOD).getRoute();
            if (result.isNotEmpty()) {
                RBC calendar = this.createRbcWithNameFrom(tree);
                int quantity = Integer.parseInt(result.get(EventSchedulingTokenizer.TokenType.QUANTITY).data());
                calendar.setDay(RBC.DAY_TYPE.DAY, quantity);
                EventSchedulingTokenizer.Token period = result.get(0);
                if (period.type() == EventSchedulingTokenizer.TokenType.MONTH_PERIOD) {
                    calendar.setDayscal(WORKDAYS_CALENDAR);
                    calendar.setDay(RBC.DAY_TYPE.WORKINGDAY, quantity);
                }
                calendar.addAllMonths();
                return Optional.of(calendar.getRBCWithPreservedName());
            }
            return Optional.empty();
        };
    }

    private CalendarCreator convertCalendarPeriod() {
        return tree -> {
            TreeExtractor.Route route = new TreeExtractor(tree.getFirstChild()).get(EventSchedulingTokenizer.TokenType.QUANTITY).get(EventSchedulingTokenizer.TokenType.CALENDAR_PERIOD).get(EventSchedulingTokenizer.TokenType.OF).get(EventSchedulingTokenizer.TokenType.MONTH_PERIOD).getOptional(EventSchedulingTokenizer.TokenType.LESS).getOptional(EventSchedulingTokenizer.TokenType.QUANTITY).getOptional(EventSchedulingTokenizer.TokenType.CALENDAR_PERIOD).getRoute();
            if (route.isNotEmpty()) {
                RBC calendar = this.createRbcWithNameFrom(tree);
                int quantity = Integer.parseInt(route.get(EventSchedulingTokenizer.TokenType.QUANTITY).data());
                EventSchedulingTokenizer.Token calendarPeriod = route.get(EventSchedulingTokenizer.TokenType.CALENDAR_PERIOD);
                calendar.setDayscal(calendarPeriod.data());
                calendar.setDay(RBC.DAY_TYPE.WORKINGDAY, quantity + this.getAppendLessQuantity(route));
                return Optional.of(calendar.getRBCWithPreservedName());
            }
            return Optional.empty();
        };
    }

    private CalendarCreator convertDailyCalendar() {
        return tree -> tree.getChildBy(x -> ((EventSchedulingTokenizer.Token)x.getData()).type() == EventSchedulingTokenizer.TokenType.DAILY).map(d -> new DailyRbc().getProperties());
    }

    private List<RBC.WEEKDAYS> createWeekDays(TreeNode<EventSchedulingTokenizer.Token> tree) {
        List<TreeNode<EventSchedulingTokenizer.Token>> weekDays = tree.getChildrenBy(x -> ((EventSchedulingTokenizer.Token)x.getData()).type() == EventSchedulingTokenizer.TokenType.WEEKDAYS);
        if (!weekDays.isEmpty()) {
            return List.of(RBC.WEEKDAYS.MONDAY, RBC.WEEKDAYS.TUESDAY, RBC.WEEKDAYS.WEDNESDAY, RBC.WEEKDAYS.THURSDAY, RBC.WEEKDAYS.FRIDAY);
        }
        return Collections.emptyList();
    }

    private List<Properties> createSpecificDayCalendar(TreeNode<EventSchedulingTokenizer.Token> tree) {
        TreeExtractor.Route route = new TreeExtractor(tree).get(EventSchedulingTokenizer.TokenType.MONTH).get(EventSchedulingTokenizer.TokenType.QUANTITY).get(EventSchedulingTokenizer.TokenType.YEAR).getRoute();
        if (route.isNotEmpty()) {
            RBC calendar = this.createRbcWithNameFrom(tree);
            String month = String.format("%02d", this.monthToNumber(route.get(EventSchedulingTokenizer.TokenType.MONTH).data()));
            String day = String.format("%02d", Integer.parseInt(route.get(EventSchedulingTokenizer.TokenType.QUANTITY).data()));
            calendar.setDate(month + day);
            return List.of(calendar.getRBCForCalendarFile());
        }
        return Collections.emptyList();
    }

    private List<RBC.WEEKDAYS> convertDays(List<TreeNode<EventSchedulingTokenizer.Token>> tree) {
        Stream<TreeNode> days = tree.stream().filter(x1 -> ((EventSchedulingTokenizer.Token)x1.getData()).type() == EventSchedulingTokenizer.TokenType.DAY);
        return days.map(day -> switch (((EventSchedulingTokenizer.Token)day.getData()).data().toUpperCase()) {
            case "MONDAY" -> RBC.WEEKDAYS.MONDAY;
            case "TUESDAY" -> RBC.WEEKDAYS.TUESDAY;
            case "WEDNESDAY" -> RBC.WEEKDAYS.WEDNESDAY;
            case "THURSDAY" -> RBC.WEEKDAYS.THURSDAY;
            case "FRIDAY" -> RBC.WEEKDAYS.FRIDAY;
            case "SATURDAY" -> RBC.WEEKDAYS.SATURDAY;
            default -> RBC.WEEKDAYS.SUNDAY;
        }).collect(Collectors.toList());
    }

    private List<Integer> convertMonths(TreeNode<EventSchedulingTokenizer.Token> tree) {
        List<TreeNode<EventSchedulingTokenizer.Token>> months = tree.getChildrenBy(x -> ((EventSchedulingTokenizer.Token)x.getData()).type() == EventSchedulingTokenizer.TokenType.MONTH);
        return months.stream().map(month -> this.monthToNumber(((EventSchedulingTokenizer.Token)month.getData()).data().toUpperCase())).collect(Collectors.toList());
    }

    private List<RBC.MONTHS> getAllMonths() {
        return List.of(RBC.MONTHS.values());
    }

    private Integer monthToNumber(String monthName) {
        return switch (monthName.toUpperCase()) {
            case "JANUARY", "JAN" -> 1;
            case "FEBRUARY", "FEB" -> 2;
            case "MARCH", "MAR" -> 3;
            case "APRIL", "APR" -> 4;
            case "MAY" -> 5;
            case "JUNE", "JUN" -> 6;
            case "JULY", "JUL" -> 7;
            case "AUGUST", "AUG" -> 8;
            case "SEPTEMBER", "SEP" -> 9;
            case "OCTOBER", "OCT" -> 10;
            case "NOVEMBER", "NOV" -> 11;
            default -> 12;
        };
    }

    public static class EmptyScheduling
    extends Scheduling {
        public EmptyScheduling(List<String> scheduleCriteria) {
            super(null, null, Collections.emptyList(), Collections.emptyList(), scheduleCriteria, false);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    public static class Cyclic {
        public final String quantity;
        public final PERIOD period;

        public Cyclic(String quantity, String period) {
            this(quantity, PERIOD.from(period));
        }

        public Cyclic(String quantity, PERIOD period) {
            this.quantity = quantity;
            this.period = period;
        }

        public String toString() {
            return "Cyclic{quantity='" + this.quantity + "', period=" + String.valueOf((Object)this.period) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cyclic cyclic = (Cyclic)o;
            return Objects.equals(this.quantity, cyclic.quantity) && this.period == cyclic.period;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.quantity, this.period});
        }
    }

    @FunctionalInterface
    static interface CalendarCreator {
        public Optional<Properties> create(TreeNode<EventSchedulingTokenizer.Token> var1);
    }

    public static enum PERIOD {
        DAY('D'),
        HOUR('H'),
        MINUTE('M');

        private final char name;

        private PERIOD(char name) {
            this.name = name;
        }

        public static PERIOD from(String p) {
            return switch (p.toUpperCase()) {
                case "DAYS", "DAY" -> DAY;
                case "HOUR", "HOURS" -> HOUR;
                default -> MINUTE;
            };
        }

        public char toChar() {
            return this.name;
        }
    }

    public static class Scheduling {
        private final Cyclic cyclic;
        private final String timeFrom;
        private final boolean isInActiveOnly;
        private final List<Properties> ruleBasedCalendars;
        private final List<EventSchedulingTokenizer.Token> notSupported;
        private final List<String> scheduleCriteria;

        public Scheduling(Cyclic cyclic, String timeFrom, List<Properties> ruleBasedCalendars, List<EventSchedulingTokenizer.Token> notSupported, List<String> scheduleCriteria, boolean isInActiveOnly) {
            this.timeFrom = timeFrom;
            this.cyclic = this.getCyclic(cyclic, timeFrom);
            this.ruleBasedCalendars = ruleBasedCalendars;
            this.notSupported = notSupported;
            this.scheduleCriteria = scheduleCriteria;
            this.isInActiveOnly = isInActiveOnly;
        }

        public boolean isInActiveOnly() {
            return this.isInActiveOnly;
        }

        private Cyclic getCyclic(Cyclic cyclic, String timeFrom) {
            return this.every1DayWithTimeFromIsNotCyclic(cyclic, timeFrom);
        }

        private Cyclic every1DayWithTimeFromIsNotCyclic(Cyclic cyclic, String timeFrom) {
            Cyclic every1Day = new Cyclic("1", PERIOD.DAY);
            if (every1Day.equals(cyclic) && !timeFrom.isEmpty()) {
                return null;
            }
            return cyclic;
        }

        public Optional<Cyclic> getCyclic() {
            return Optional.ofNullable(this.cyclic);
        }

        public Optional<String> getTimeFrom() {
            return Optional.ofNullable(this.timeFrom);
        }

        public List<Properties> getRuleBasedCalendars() {
            return this.ruleBasedCalendars;
        }

        public List<String> getNotSupported() {
            return this.notSupported.stream().filter(t -> t != ROOT).map(EventSchedulingTokenizer.Token::data).collect(Collectors.toList());
        }

        public List<String> getScheduleCriteria() {
            return this.scheduleCriteria;
        }

        public static Scheduling from(Scheduling other, UnaryOperator<Properties> transformCalendar, UnaryOperator<Cyclic> transformCyclic, UnaryOperator<String> transformTimeFrom) {
            UnaryOperator calendarsTransformer = rbcs -> rbcs.stream().map(transformCalendar).collect(Collectors.toList());
            return new Scheduling((Cyclic)transformCyclic.apply(other.cyclic), (String)transformTimeFrom.apply(other.timeFrom), (List)calendarsTransformer.apply(other.ruleBasedCalendars), other.notSupported, other.scheduleCriteria, other.isInActiveOnly());
        }

        public boolean isEmpty() {
            return false;
        }

        public String toString() {
            return "Scheduling(\n    Cyclic = %s,\n    timeFrom = %s,\n    ruleBasedCalendars = %s,\n    notSupported = %s,\n    scheduleCriteria = %s,\n    isEmpty = %s\n)".formatted(this.cyclic, this.timeFrom, this.ruleBasedCalendars, this.notSupported, this.scheduleCriteria, this.isEmpty());
        }
    }
}

