/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.scheduling;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.dSeries.scheduling.EventScheduling;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CyclicSchedulingHandler {
    private final SchedEntity job;

    public CyclicSchedulingHandler(SchedEntity job) {
        this.job = job;
    }

    public void processCyclicDefinitions(List<EventScheduling.Scheduling> scheduling) {
        if (scheduling.size() == 1) {
            Optional<EventScheduling.Cyclic> eventSchedule = scheduling.get(0).getCyclic();
            eventSchedule.ifPresent(cyclic -> {
                this.job.addAttribute("INTERVAL", String.format("%05d%c", GlobalFunctions.getNumberFrom((String)cyclic.quantity).orElse(1), Character.valueOf(cyclic.period.toChar())));
                this.setCyclic();
            });
            scheduling.get(0).getTimeFrom().ifPresent(timeFrom -> this.job.addAttribute("TIMEFROM", timeFrom));
        } else if (!scheduling.isEmpty()) {
            this.job.addAttribute("CYCLIC_TYPE", "SpecificTimes");
            Optional<String> sequence = this.getSequenceFrom(scheduling);
            sequence.ifPresent(s -> {
                this.job.addAttribute("CYCLIC_TIMES_SEQUENCE", s);
                this.setCyclic();
            });
        }
    }

    private Optional<String> getSequenceFrom(List<EventScheduling.Scheduling> scheduling) {
        return this.getSequenceFromTimeFrom(scheduling).or(this.sequenceFromCyclicDefinition(scheduling));
    }

    private Optional<String> getSequenceFromTimeFrom(List<EventScheduling.Scheduling> scheduling) {
        return Optional.of(scheduling.stream().flatMap(schedule -> schedule.getTimeFrom().stream()).collect(Collectors.joining(","))).filter(this::notBlank);
    }

    private Supplier<Optional<String>> sequenceFromCyclicDefinition(List<EventScheduling.Scheduling> scheduling) {
        return () -> Optional.of(scheduling.stream().flatMap(schedule -> schedule.getCyclic().stream()).map(cyclic -> String.format("+%s%c", cyclic.quantity, Character.valueOf(cyclic.period.toChar()))).collect(Collectors.joining(","))).filter(this::notBlank);
    }

    private boolean notBlank(String input) {
        return !input.isBlank();
    }

    private void setCyclic() {
        this.job.addAttribute("CYCLIC", "1");
    }

    public boolean isCyclic() {
        return Optional.ofNullable(this.job.getAttr("CYCLIC")).map("1"::equals).orElse(false);
    }
}

