/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.sap.r3;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.dSeries.sap.ISapConvertor;
import com.bmc.ctmconvert.dSeries.sap.SapNodeParser;
import com.bmc.ctmconvert.sap.SapR3CommonWrapper;
import com.bmc.ctmconvert.sap.SapR3CreateWrapper;
import com.bmc.ctmconvert.sap.Step;
import com.bmc.ctmconvert.sap.StepArgs;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Node;

public class SapR3Convertor
implements ISapConvertor {
    @Override
    public void convert(Node sapJobNode, DSeriesJob dSeriesJob) {
        SapNodeParser parser = new SapNodeParser(sapJobNode);
        SapR3CreateWrapper convertToSapJob = SapR3CreateWrapper.convertToSapJob((SchedEntity)dSeriesJob);
        Optional<String> jobclass = parser.getAttrValue("jobclass");
        jobclass.ifPresent(arg_0 -> ((SapR3CreateWrapper)convertToSapJob).setClass(arg_0));
        SapR3CommonWrapper sapR3CommonWrapper = new SapR3CommonWrapper((SchedEntity)dSeriesJob);
        Optional<String> sapuser = parser.getAttrValue("sapuser");
        sapuser.ifPresent(arg_0 -> ((SapR3CommonWrapper)sapR3CommonWrapper).setSapAccount(arg_0));
        Optional<String> sapjobname = parser.getAttrValue("sapjobname");
        sapR3CommonWrapper.setSapJobName(sapjobname.orElse(""));
        Optional<String> startmode = parser.getAttrValue("startmode");
        if (startmode.isPresent() && startmode.get().equals("A")) {
            convertToSapJob.setStartCondition("X");
        } else if (startmode.isPresent() && startmode.get().equals("I")) {
            convertToSapJob.setStartCondition("N");
        } else if (startmode.isPresent()) {
            convertToSapJob.setStartCondition("E");
        }
        StepArgs stepArgs = parser.getStepArgs();
        List stepsList = stepArgs.getNumbers();
        for (Integer stepNumber : stepsList) {
            Step step = this.getStep(stepArgs, stepNumber);
            convertToSapJob.addStep(step);
        }
    }

    private Step getStep(StepArgs stepArgs, Integer stepNumber) {
        Step step = new Step(stepNumber.intValue());
        Optional abapname = stepArgs.get(stepNumber.intValue(), "abapname");
        abapname.ifPresent(arg_0 -> ((Step)step).setProgram(arg_0));
        Optional variant = stepArgs.get(stepNumber.intValue(), "variant");
        variant.ifPresent(arg_0 -> ((Step)step).setVariant(arg_0));
        Optional user = stepArgs.get(stepNumber.intValue(), "stepuser");
        user.ifPresent(arg_0 -> ((Step)step).setOwner(arg_0));
        Optional language = stepArgs.get(stepNumber.intValue(), "abaplanguage");
        language.ifPresent(arg_0 -> ((Step)step).setLang(arg_0));
        Optional printDest = stepArgs.get(stepNumber.intValue(), "printdest");
        printDest.ifPresent(arg_0 -> ((Step)step).setPrintDest(arg_0));
        Optional printCopies = stepArgs.get(stepNumber.intValue(), "printcopies");
        printCopies.ifPresent(arg_0 -> ((Step)step).setPrintCopies(arg_0));
        Optional printpw = stepArgs.get(stepNumber.intValue(), "printpw");
        printpw.ifPresent(arg_0 -> ((Step)step).setPrintAuth(arg_0));
        Optional printSpoolname = stepArgs.get(stepNumber.intValue(), "printspoolname");
        printSpoolname.ifPresent(arg_0 -> ((Step)step).setListName(arg_0));
        Optional printtext = stepArgs.get(stepNumber.intValue(), "printtext");
        printtext.ifPresent(arg_0 -> ((Step)step).setListText(arg_0));
        return step;
    }
}

