/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.file_monitor;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.file_watcher.FileWatcherWrapper;
import com.bmc.ctmconvert.common.transformer.sched_entities.DefaultSchedEntity;
import com.bmc.ctmconvert.dSeries.file_monitor.FileMonitorAttributes;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoForceJob;
import com.bmc.ctmconvert.ondo.OnStatement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;

class FileMonitorJob
extends DefaultSchedEntity {
    private final FileMonitorAttributes fileMonitorAttributes;
    private final LinkedHashMap<String, String> autoEdits;
    private final String parentName;
    private final LinkedHashMap<Properties, List<Properties>> onDoStatements;

    public FileMonitorJob(String jobName, FileMonitorAttributes fileMonitorAttributes, String parentName) {
        super(jobName, SchedEntity.TYPE.JOB);
        this.fileMonitorAttributes = fileMonitorAttributes;
        this.autoEdits = new LinkedHashMap();
        this.onDoStatements = new LinkedHashMap();
        this.parentName = parentName;
    }

    public FileMonitorJob convert() {
        this.convertToFileMonitor();
        this.convertJobAttributes();
        this.createOnDoForceFolder();
        this.createOnFileNotFoundSetOkAndIssueMessage();
        return this;
    }

    private void createOnFileNotFoundSetOkAndIssueMessage() {
        int fileNotFoundCompletionStatus = 7;
        String fileNotFoundMessage = "File(s) not found";
        OnStatement.createOnCompletionStatus((int)fileNotFoundCompletionStatus).addDo(Do.createDoOk()).addDo(Do.createDoShout((String)"EM").setMessage(fileNotFoundMessage)).accept(this.onDoStatements::put);
    }

    private void createOnDoForceFolder() {
        OnStatement.createOnOkStatement().addDo((Do)new DoForceJob(this.fileMonitorAttributes.runApplication, Do.REMOTE.NO, Params.instance().getDatacenterName())).accept(this.onDoStatements::put);
    }

    private void convertJobAttributes() {
        this.addAttribute("TASKTYPE", "Job");
        this.setAgent(this.fileMonitorAttributes.agent);
        this.setRunAs(this.fileMonitorAttributes.executionUser);
    }

    private void convertToFileMonitor() {
        FileWatcherWrapper fileWatcherWrapper = new FileWatcherWrapper((SchedEntity)this);
        fileWatcherWrapper.convert().setPath(this.fileMonitorAttributes.fileName).setType(FileWatcherWrapper.Type.CREATE);
        GlobalFunctions.getNumberFrom((String)this.fileMonitorAttributes.fileSize).ifPresent(value -> fileWatcherWrapper.setMinimumDestinationSize(value.intValue(), FileWatcherWrapper.Unit.BYTES));
        fileWatcherWrapper.setSearchInterval(this.getSearchIntervalInSeconds().intValue());
    }

    private Integer getSearchIntervalInSeconds() {
        return GlobalFunctions.getNumberFrom((String)this.fileMonitorAttributes.fileNoChangeInMinutes).orElse(0) * 60;
    }

    private void setAgent(String agent) {
        this.addAttribute("NODEID", agent);
    }

    public void addAutoEdits(String key, String value) {
        this.autoEdits.put(key, value);
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.autoEdits;
    }

    private void setRunAs(String runAs) {
        this.addAttribute("OWNER", runAs);
    }

    public String getParentName() {
        return this.parentName;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return this.onDoStatements;
    }
}

