/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.file_monitor;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.rbc.NoneRbc;
import com.bmc.ctmconvert.common.transformer.sched_entities.DefaultSchedEntity;
import com.bmc.ctmconvert.dSeries.DseriesDefs;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.file_monitor.EventItem;
import com.bmc.ctmconvert.dSeries.file_monitor.FileMonitorAttributes;
import com.bmc.ctmconvert.dSeries.file_monitor.FileMonitorJob;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;

public class FileMonitorHandler {
    public static final String RUN_APPLICATION = "runApplication";
    public static final String FILESIZE = "filesize";
    public static final String FILENAME = "filename";
    public static final String FILE_NO_CHANGE_MINUTES = "filenochange";
    public static final String AGENT = "agent";
    public static final String EXECUTION_USER = "executionuser";
    public static final String FILE_MONITORING = "filemonitoring";
    private final AttrHolderList topLevelEntities;
    private final Collection<EventItem> eventItems;
    private Map<String, List<FileMonitorAttributes>> fileMonitorGroups;

    public FileMonitorHandler(AttrHolderList topLevelEntities, Collection<EventItem> eventItems) {
        this.topLevelEntities = topLevelEntities;
        this.eventItems = eventItems;
    }

    public FileMonitorHandler handle() {
        this.fileMonitorGroups = this.eventItems.stream().filter(e -> !e.isEmpty()).filter(e -> DseriesGlobals.findChildNodeDFS(e.document, FILE_MONITORING).isPresent()).map(FileMonitorAttributes::from).collect(Collectors.groupingBy(attributes -> this.createFolderName(attributes.runApplication)));
        this.createTopLevelEntities(this.fileMonitorGroups.values());
        return this;
    }

    public SchedEntity createFileWatcherFolder(String folderName, UniqueValueGenerator uniqueValueGenerator) {
        final List children = this.fileMonitorGroups.getOrDefault(folderName, Collections.emptyList()).stream().map(fileMonitorAttributes -> this.toFileWatcherJob((FileMonitorAttributes)fileMonitorAttributes, folderName, uniqueValueGenerator)).collect(Collectors.toList());
        return new DefaultSchedEntity(this, folderName, SchedEntity.TYPE.SMART_TABLE){

            public List<SchedEntity> getChildren() {
                return children;
            }

            public List<Properties> getTags() {
                return List.of(NoneRbc.getProperties());
            }
        };
    }

    private SchedEntity toFileWatcherJob(FileMonitorAttributes fileMonitorAttributes, String parentName, UniqueValueGenerator uniqueValueGenerator) {
        String uniqueJobName = uniqueValueGenerator.getUniqueValue("JOBNAME", fileMonitorAttributes.eventName, 64);
        return new FileMonitorJob(uniqueJobName, fileMonitorAttributes, parentName).convert();
    }

    private void createTopLevelEntities(Collection<List<FileMonitorAttributes>> fileMonitorGroups) {
        for (List<FileMonitorAttributes> fileMonitorGroup : fileMonitorGroups) {
            Optional firstFileMonitor = fileMonitorGroup.stream().findFirst();
            firstFileMonitor.ifPresent(fileMonitor -> this.topLevelEntities.add((Object)this.createTopLevelEntity(fileMonitor.runApplication)));
        }
    }

    private String createFolderName(String applicationName) {
        return applicationName + "_EVENTS";
    }

    private IAttrHolder createTopLevelEntity(String eventName) {
        String name = this.createFolderName(eventName);
        String[] values = new String[]{"FW_FOLDER", name, "appl", ""};
        return new DseriesDefs.DseriesAttrHolder(values, name);
    }

    public boolean isFileWatcherFolder(IAttrHolder attributes) {
        return "FW_FOLDER".equals(attributes.getAttr("FilePath"));
    }
}

