/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.assessment.resources;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Reporter;
import java.util.List;
import java.util.Objects;

public class ResourceData {
    private final String name;
    private final String maxAvailability;
    private final String description;

    public ResourceData(String name, String maxAvailability, String description) {
        this.name = name;
        this.maxAvailability = maxAvailability;
        this.description = description;
    }

    public String getMaxAvailability() {
        return this.maxAvailability;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ResourceData{name='" + this.name + "', maxAvailability='" + this.maxAvailability + "', description='" + this.description + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceData that = (ResourceData)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.maxAvailability, that.maxAvailability) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.maxAvailability, this.description);
    }

    public String getValidatedMaxAvailability(List<String> messages) {
        int maxAllowedResourceSize = 9999;
        return GlobalFunctions.getNumberFrom((String)this.getMaxAvailability()).map(max -> {
            if (max > maxAllowedResourceSize) {
                Reporter.addMessage((List)messages, (String)"WRN16018", (String)this.getName(), (String[])new String[]{this.getMaxAvailability()});
                return String.valueOf(maxAllowedResourceSize);
            }
            return this.getMaxAvailability();
        }).orElse("0");
    }
}

