/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.assessment;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.dSeries.DataReader;
import com.bmc.ctmconvert.dSeries.DseriesData;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.GlobalVariables;
import com.bmc.ctmconvert.dSeries.assessment.resources.ResourceData;
import com.bmc.ctmconvert.dSeries.assessment.resources.ResourceDataExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DSeriesAssessmentReport
extends AbstractAssessmentReport {
    private final DataReader dataReader;
    private final DseriesData dseriesData;
    private HashMap<String, String> nodeId2Description;
    private AssessmentXMLDescriptionReader descriptionXMLReader;
    private TreeMap<String, List<String>> agentsMap;
    private HashMap<String, String> jobInfMap;
    private Properties nodesParameters;
    private int agentWithsLessThan25JobsCount;

    public DSeriesAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
        Path dataDirectory = Paths.get(Params.instance().getDatasourcePath(), new String[0]);
        this.dseriesData = new DseriesData();
        this.dataReader = new DataReader(dataDirectory, this.dseriesData);
    }

    private String nodeToId(DefaultMutableTreeNode node) {
        TreeNode[] pathArr = node.getPath();
        StringBuilder id = new StringBuilder();
        for (TreeNode treeNode : pathArr) {
            id.append(treeNode.toString()).append(";");
        }
        return id.toString().replaceAll("\\s*\\(\\s*[0-9]+\\);", ";");
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.descriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.nodeId2Description = new HashMap();
        this.agentsMap = new TreeMap();
        this.jobInfMap = new HashMap();
        this.nodesParameters = new Properties();
        this.agentWithsLessThan25JobsCount = 0;
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        this.buildApplicationsTree(rootNode);
        this.buildAgentsTree(rootNode);
        this.buildCalendarsTree(rootNode);
        this.buildEventsTree(rootNode);
        this.buildGlobalVariablesTree(rootNode);
        this.buildResourcesTree(rootNode);
        return rootNode;
    }

    private void buildResourcesTree(DefaultMutableTreeNode rootNode) {
        this.dataReader.readResourceFiles();
        Collection<ResourceData> resources = new ResourceDataExtractor(this.dseriesData.getResourceXml()).getResources();
        if (!resources.isEmpty()) {
            DefaultMutableTreeNode resourceNode = new DefaultMutableTreeNode("Resources (" + this.dseriesData.getResourceXml().size() + ")");
            rootNode.add(resourceNode);
            for (ResourceData resource : resources) {
                this.resourceXmlToTreeNode(resource, resourceNode);
            }
            this.nodesParameters.setProperty("#NUMBER_OF_ENTRIES_IN_RESOURCES#", String.valueOf(this.dseriesData.getResourceXml().size()));
        }
    }

    private void resourceXmlToTreeNode(ResourceData resource, DefaultMutableTreeNode rootNode) {
        DefaultMutableTreeNode resourceNode = new DefaultMutableTreeNode(resource.getName());
        rootNode.add(resourceNode);
        String name = this.assessmentFormatForDescription("ResourceName", resource.getName());
        String description = this.assessmentFormatForDescription("ResourceDescription", resource.getDescription());
        String maxAvailability = this.assessmentFormatForDescription("max_availability", resource.getMaxAvailability());
        this.nodeId2Description.put(this.nodeToId(resourceNode), name + description + maxAvailability);
    }

    private void buildGlobalVariablesTree(DefaultMutableTreeNode rootNode) {
        this.dataReader.readVarFiles();
        GlobalVariables globalVariables = new GlobalVariables(this.dseriesData);
        Set<String> contextList = globalVariables.getContextList();
        if (contextList != null && !contextList.isEmpty()) {
            DefaultMutableTreeNode variablesNode = new DefaultMutableTreeNode("Variables (" + contextList.size() + ")");
            rootNode.add(variablesNode);
            for (String context : contextList) {
                Set<String> variablesList = globalVariables.getVarList(context);
                DefaultMutableTreeNode variableNode = new DefaultMutableTreeNode(context + " (" + variablesList.size() + ")");
                variablesNode.add(variableNode);
                StringBuilder sb = new StringBuilder();
                for (String varName : variablesList) {
                    sb.append(this.assessmentFormatForDescription(varName, globalVariables.getVarValue(context, varName)));
                }
                this.nodeId2Description.put(this.nodeToId(variableNode), sb.toString());
            }
            this.nodesParameters.setProperty("#NUMBER_OF_ENTRIES_IN_VARIABLES#", String.valueOf(contextList.size()));
        }
    }

    private void buildEventsTree(DefaultMutableTreeNode rootNode) {
        File[] dataSourceFiles = DseriesData.getInputDir(DseriesGlobals.XML_TYPE.EVT, Paths.get(Params.instance().getDatasourcePath(), new String[0])).toFile().listFiles(file -> file.isFile() && file.getName().toLowerCase().endsWith(".xml"));
        if (dataSourceFiles != null) {
            DefaultMutableTreeNode eventsNode = new DefaultMutableTreeNode("Events (" + dataSourceFiles.length + ")");
            rootNode.add(eventsNode);
            for (File dataSourceFile : dataSourceFiles) {
                this.eventXmlToTreeNode(dataSourceFile, eventsNode);
            }
            this.nodesParameters.setProperty("#NUMBER_OF_ENTRIES_IN_EVENTS#", String.valueOf(dataSourceFiles.length));
        }
    }

    private void eventXmlToTreeNode(File file, DefaultMutableTreeNode eventsNode) {
        XmlElement evtRoot = this.getXmlLoderElement(file);
        if (this.tagNameNotMatching(evtRoot, "(even\\s*:\\s*)?eventenum")) {
            return;
        }
        String eventName = this.getEventName(evtRoot);
        DefaultMutableTreeNode eventNode = new DefaultMutableTreeNode(eventName);
        eventsNode.add(eventNode);
        List eventElementsList = evtRoot.getDirectchildsElementbyName(new String[]{"even:eventsch", "eventsch"});
        if (!eventElementsList.isEmpty()) {
            String eventDescription = this.collectEventDescription("eventsch", eventElementsList);
            this.nodeId2Description.put(this.nodeToId(eventNode), eventDescription);
        } else {
            List agentbasedeventtriggertElementsList = evtRoot.getDirectchildsElementbyName(new String[]{"even:agentbasedeventtrigger", "agentbasedeventtrigger"});
            if (!agentbasedeventtriggertElementsList.isEmpty()) {
                String eventDescription = this.collectEventDescription("agentbasedeventtrigger", agentbasedeventtriggertElementsList);
                this.nodeId2Description.put(this.nodeToId(eventNode), eventDescription);
            }
        }
    }

    private String collectEventDescription(String type, List<XmlElement> agentbasedeventtriggertElementsList) {
        StringBuilder sb = new StringBuilder();
        String itu = agentbasedeventtriggertElementsList.get(0).getAttribute("itu");
        for (XmlElement xmlElement : agentbasedeventtriggertElementsList) {
            sb.append(this.getDescriptionElementInfo(xmlElement, type, itu));
            sb.append(this.getScheduleElementInfo(xmlElement));
            sb.append(this.getActionElementInfo(xmlElement));
            sb.append(this.getPriorityElementInfo(xmlElement));
            sb.append(this.getCommentElementInfo(xmlElement));
            if (!type.equalsIgnoreCase("agentbasedeventtrigger")) continue;
            sb.append(this.getEventTriggerDescription(xmlElement));
        }
        return sb.toString();
    }

    private String getCommentElementInfo(XmlElement xmlElement) {
        List commentElementList = xmlElement.getAllDecnedElementByMultipleName(new String[]{"even:comment", "comment"});
        StringBuilder sb = new StringBuilder();
        for (XmlElement element : commentElementList) {
            sb.append(this.assessmentFormatForDescription("Comment", this.getValueOrEmpty(element)));
        }
        return sb.toString();
    }

    private String getPriorityElementInfo(XmlElement xmlElement) {
        List priorityElementList = xmlElement.getAllDecnedElementByMultipleName(new String[]{"even:priority", "priority"});
        StringBuilder sb = new StringBuilder();
        for (XmlElement element : priorityElementList) {
            sb.append(this.assessmentFormatForDescription("Priority", this.getValueOrEmpty(element)));
        }
        return sb.toString();
    }

    private String getActionElementInfo(XmlElement xmlElement) {
        List actionElementList = xmlElement.getAllDecnedElementByMultipleName(new String[]{"even:action", "action"});
        StringBuilder sb = new StringBuilder();
        for (XmlElement element : actionElementList) {
            sb.append(this.assessmentFormatForDescription("Action", element.getValueOfFirstChildElementByName(new String[]{"even:runApplication", "runApplication"})));
        }
        return sb.toString();
    }

    private String getDescriptionElementInfo(XmlElement xmlElement, String type, String itu) {
        List descElementList = xmlElement.getAllDecnedElementByMultipleName(new String[]{"even:description", "description"});
        StringBuilder sb = new StringBuilder();
        for (XmlElement element : descElementList) {
            String name = element.getValueOfFirstChildElementByName(new String[]{"even:name", "name"});
            String executionuser = element.getValueOfFirstChildElementByName(new String[]{"even:executionuser", "executionuser"});
            String holdcount = element.getValueOfFirstChildElementByName(new String[]{"even:holdcount", "holdcount"});
            String suspendcount = element.getValueOfFirstChildElementByName(new String[]{"even:suspendcount", "suspendcount"});
            sb.append(this.assessmentFormatForDescription("Event Type", type));
            sb.append(this.assessmentFormatForDescription("Event Name", name));
            sb.append(this.assessmentFormatForDescription("Itu", itu));
            sb.append("=============================================\n");
            sb.append(this.assessmentFormatForDescription("Execution User", executionuser));
            sb.append(this.assessmentFormatForDescription("Hold Count", holdcount));
            sb.append(this.assessmentFormatForDescription("Suspend Count", suspendcount));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String getScheduleElementInfo(XmlElement xmlElement) {
        StringBuilder sb = new StringBuilder();
        List scheduleElementList = xmlElement.getAllDecnedElementByMultipleName(new String[]{"even:schedule", "schedule"});
        for (XmlElement element : scheduleElementList) {
            List sElementList = element.getDirectchildsElementbyName(new String[]{"even:scheduleelement", "scheduleelement"});
            for (XmlElement scheduleElement : sElementList) {
                sb.append(this.assessmentFormatForDescription("Original", scheduleElement.getAttribute("original")));
                sb.append(this.assessmentFormatForDescription("Schdule", this.getValueOrEmpty(scheduleElement)));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private String getEventTriggerDescription(XmlElement xmlElement) {
        StringBuilder sb = new StringBuilder();
        List filenameElementList = xmlElement.getAllDecnedElementByMultipleName(new String[]{"even:filename", "filename"});
        List fileownerElementList = xmlElement.getAllDecnedElementByMultipleName(new String[]{"even:fileowner", "fileowner"});
        List filegroupElementList = xmlElement.getAllDecnedElementByMultipleName(new String[]{"even:filegroup", "filegroup"});
        List useridElementList = xmlElement.getAllDecnedElementByMultipleName(new String[]{"even:userid", "userid"});
        List filesizeElementList = xmlElement.getAllDecnedElementByMultipleName(new String[]{"even:filesize", "filesize"});
        List agentElementList = xmlElement.getAllDecnedElementByMultipleName(new String[]{"even:agent", "agent"});
        for (XmlElement element : filenameElementList) {
            sb.append(this.assessmentFormatForDescription("File Name", this.getValueOrEmpty(element)));
        }
        for (XmlElement element : fileownerElementList) {
            sb.append(this.assessmentFormatForDescription("File Owner", this.getValueOrEmpty(element)));
        }
        for (XmlElement element : filegroupElementList) {
            sb.append(this.assessmentFormatForDescription("File Group", this.getValueOrEmpty(element)));
        }
        for (XmlElement element : useridElementList) {
            sb.append(this.assessmentFormatForDescription("User Id", this.getValueOrEmpty(element)));
        }
        for (XmlElement element : filesizeElementList) {
            sb.append(this.assessmentFormatForDescription("File Size", this.getValueOrEmpty(element)));
        }
        for (XmlElement element : agentElementList) {
            sb.append(this.assessmentFormatForDescription("Agent", this.getValueOrEmpty(element)));
        }
        return sb.toString();
    }

    private String getValueOrEmpty(XmlElement element) {
        String value = element.getValue();
        return value != null ? value : "";
    }

    private void buildCalendarsTree(DefaultMutableTreeNode rootNode) {
        File[] dataSourceFiles = DseriesData.getInputDir(DseriesGlobals.XML_TYPE.CAL, Paths.get(Params.instance().getDatasourcePath(), new String[0])).toFile().listFiles(file -> file.isFile() && file.getName().toLowerCase().endsWith(".xml"));
        if (dataSourceFiles != null) {
            DefaultMutableTreeNode calendarsNode = new DefaultMutableTreeNode("Calendars (" + dataSourceFiles.length + ")");
            rootNode.add(calendarsNode);
            for (File dataSourceFile : dataSourceFiles) {
                this.calXmlToTreeNode(dataSourceFile, calendarsNode);
            }
        }
    }

    private void calXmlToTreeNode(File file, DefaultMutableTreeNode calendarsNode) {
        XmlElement calendarNode = this.getXmlLoderElement(file);
        if (this.tagNameNotMatching(calendarNode, "(cal\\s*:\\s*)?calendar")) {
            return;
        }
        String calendarName = this.getCalendarName(calendarNode);
        DefaultMutableTreeNode currentCalendar = new DefaultMutableTreeNode(calendarName);
        for (int i = 0; i < DseriesGlobals.CALENDAR_SECTIONS.length; ++i) {
            List calendarSection = calendarNode.getDirectchildsElementbyName(new String[]{"cal:" + DseriesGlobals.CALENDAR_SECTIONS[i], DseriesGlobals.CALENDAR_SECTIONS[i]});
            if (calendarSection.isEmpty()) continue;
            DefaultMutableTreeNode calendarSectionNode = new DefaultMutableTreeNode(DseriesGlobals.CALENDAR_SECTIONS[i]);
            currentCalendar.add(calendarSectionNode);
            calendarsNode.add(currentCalendar);
            String data = this.collectCalendarDescription(DseriesGlobals.CALENDAR_SECTIONS[i], calendarSection);
            this.nodeId2Description.put(this.nodeToId(calendarSectionNode), data);
        }
    }

    private String getEventName(XmlElement root) {
        String name = null;
        List desc = root.getAllDecnedElementByMultipleName(new String[]{"even:description", "description"});
        for (XmlElement xmlElement : desc) {
            name = xmlElement.getValueOfFirstChildElementByName(new String[]{"even:name", "name"});
        }
        if (name != null) {
            return name;
        }
        return "";
    }

    private String getCalendarName(XmlElement element) {
        XmlElement desc = element.getFirstChildElementByName("description");
        if (desc != null) {
            desc = element.getFirstChildElementByName("cal:description");
        }
        if (desc != null) {
            return desc.getValueOfFirstChildElementByName(new String[]{"cal:name", "name"});
        }
        return "";
    }

    private String collectCalendarDescription(String calendarType, List<XmlElement> calendarSection) {
        StringBuilder sb = new StringBuilder();
        for (XmlElement typeElement : calendarSection) {
            switch (calendarType) {
                case "description": {
                    sb.append(this.getCalendarDescriptionInfo(typeElement));
                    break;
                }
                case "holiday": {
                    sb.append(this.getCalendarHolidayInfo(typeElement));
                    break;
                }
                case "specday": {
                    sb.append(this.getCalendarSpecdayInfo(typeElement));
                }
            }
        }
        return sb.toString();
    }

    private String getCalendarSpecdayInfo(XmlElement typeElement) {
        StringBuilder sb = new StringBuilder();
        List calNameList = typeElement.getDirectchildsElementbyName(new String[]{"cal:sdate", "sdate"});
        for (XmlElement name : calNameList) {
            String calName = name.getValueOfFirstChildElementByName(new String[]{"cal:name", "name"});
            ArrayList starttime = name.getAllDecnedValuesByMultipleName(new String[]{"cal:starttime", "starttime"});
            ArrayList endtime = name.getAllDecnedValuesByMultipleName(new String[]{"cal:endtime", "endtime"});
            sb.append(this.assessmentFormatForDescription("Calendar Name", calName));
            sb.append(this.assessmentFormatForDescription("Start Time", starttime.toString()));
            sb.append(this.assessmentFormatForDescription("End Time", endtime.toString()));
            sb.append("==========================================================\n");
        }
        return sb.toString();
    }

    private String getCalendarHolidayInfo(XmlElement typeElement) {
        StringBuilder sb = new StringBuilder();
        List calNameList = typeElement.getDirectchildsElementbyName(new String[]{"cal:date", "date"});
        for (XmlElement name : calNameList) {
            String calName = name.getValueOfFirstChildElementByName(new String[]{"cal:name", "name"});
            ArrayList startTime = name.getAllDecnedValuesByMultipleName(new String[]{"cal:starttime", "starttime"});
            ArrayList endtime = name.getAllDecnedValuesByMultipleName(new String[]{"cal:endtime", "endtime"});
            sb.append(this.assessmentFormatForDescription("Calendar Name", calName));
            sb.append(this.assessmentFormatForDescription("Start Time", startTime.toString()));
            sb.append(this.assessmentFormatForDescription("End Time", endtime.toString()));
            sb.append("==========================================================\n");
        }
        return sb.toString();
    }

    private String getCalendarDescriptionInfo(XmlElement typeElement) {
        StringBuilder sb = new StringBuilder();
        String calName = typeElement.getValueOfFirstChildElementByName(new String[]{"cal:name", "name"});
        String weekStart = typeElement.getValueOfFirstChildElementByName(new String[]{"cal:weekstart", "weekstart"});
        ArrayList workday = typeElement.getAllDecnedValuesByMultipleName(new String[]{"cal:workday", "workday"});
        sb.append(this.assessmentFormatForDescription("Calendar Name", calName));
        sb.append(this.assessmentFormatForDescription("Start Day Of The Week", weekStart));
        sb.append(this.assessmentFormatForDescription("Working Days", workday.toString()));
        return sb.toString();
    }

    private void buildAgentsTree(DefaultMutableTreeNode rootNode) {
        Map<String, List<String>> agentToJobsMap = this.getAgentsMap();
        int numberofAgents = agentToJobsMap.keySet().size();
        this.nodesParameters.setProperty("#NUMBER_OF_NODES#", String.valueOf(numberofAgents));
        DefaultMutableTreeNode agentsNode = new DefaultMutableTreeNode("Agents (" + numberofAgents + ")");
        rootNode.add(agentsNode);
        StringBuilder agentListLessThan25Jobs = new StringBuilder();
        for (String agent : agentToJobsMap.keySet()) {
            List<String> jobs = agentToJobsMap.get(agent);
            Collections.sort(jobs);
            DefaultMutableTreeNode agentNode = new DefaultMutableTreeNode(agent + " (" + jobs.size() + ")");
            agentsNode.add(agentNode);
            if (jobs.size() <= 25) {
                agentListLessThan25Jobs.append(agent).append("\n");
                ++this.agentWithsLessThan25JobsCount;
            }
            for (String jobName : jobs) {
                DefaultMutableTreeNode jobNameNode = new DefaultMutableTreeNode(jobName);
                agentNode.add(jobNameNode);
                this.nodeId2Description.put(this.nodeToId(jobNameNode), this.jobInfMap.get(jobName));
            }
        }
        this.nodesParameters.setProperty("#NUMBER_OF_NODES_LESS_THAN_25_JOBS#", String.valueOf(this.agentWithsLessThan25JobsCount));
        this.nodesParameters.setProperty("#LIST_NODE_LESS_25_JOBS#", agentListLessThan25Jobs.toString());
    }

    private void buildApplicationsTree(DefaultMutableTreeNode rootNode) {
        int totalCountOfJobs = 0;
        File[] dataSourceFiles = DseriesData.getInputDir(DseriesGlobals.XML_TYPE.APP, Paths.get(Params.instance().getDatasourcePath(), new String[0])).toFile().listFiles(file -> file.isFile() && file.getName().toLowerCase().endsWith(".xml"));
        if (dataSourceFiles != null) {
            DefaultMutableTreeNode applicationNode = new DefaultMutableTreeNode("Applications (" + dataSourceFiles.length + ")");
            rootNode.add(applicationNode);
            for (File dataSourceFile : dataSourceFiles) {
                totalCountOfJobs += this.appXmlToTreeNode(dataSourceFile, applicationNode);
            }
            this.nodesParameters.setProperty("#NUMBER_OF_FILES#", String.valueOf(dataSourceFiles.length));
            this.nodesParameters.setProperty("#TOTAL_COUNT_OF_JOBS#", String.valueOf(totalCountOfJobs));
        }
    }

    int appXmlToTreeNode(File file, DefaultMutableTreeNode appNode) {
        DefaultMutableTreeNode notSupportedJobTypes = null;
        int totalJobCount = 0;
        XmlElement root = this.getXmlLoderElement(file);
        if (this.tagNameNotMatching(root, "(app\\s*:\\s*)?appl")) {
            return 0;
        }
        DefaultMutableTreeNode applicationNode = new DefaultMutableTreeNode(root.getAttribute("name"));
        appNode.add(applicationNode);
        String defaultAgent = this.getDefaultApplicationAgent(root);
        int scriptsCount = this.handleAppScripts(applicationNode, root);
        for (int i = 0; i < DseriesGlobals.DSERIES_JOB_TYPES.length; ++i) {
            List jobTypeList = root.getDirectchildsElementbyName(new String[]{"app:" + DseriesGlobals.DSERIES_JOB_TYPES[i], DseriesGlobals.DSERIES_JOB_TYPES[i]});
            if (jobTypeList.isEmpty()) continue;
            totalJobCount += jobTypeList.size();
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(DseriesGlobals.DSERIES_JOB_TYPES[i] + " (" + jobTypeList.size() + ")");
            if (!DseriesGlobals.isJobTypeSupported(DseriesGlobals.DSERIES_JOB_TYPES[i])) {
                if (notSupportedJobTypes == null) {
                    notSupportedJobTypes = new DefaultMutableTreeNode("Unsupported Types");
                    applicationNode.add(notSupportedJobTypes);
                    this.nodeId2Description.put(this.nodeToId(notSupportedJobTypes), "Job type " + DseriesGlobals.DSERIES_JOB_TYPES[i] + " is not supported!");
                }
                notSupportedJobTypes.add(typeNode);
            } else {
                applicationNode.add(typeNode);
                String description = this.getTypeDescription(DseriesGlobals.DSERIES_JOB_TYPES[i]);
                this.nodeId2Description.put(this.nodeToId(typeNode), description);
            }
            for (XmlElement jobElement : jobTypeList) {
                Object jobName = jobElement.getAttribute("name");
                String jobQualifier = jobElement.getAttribute("qualifier");
                if (!jobQualifier.isEmpty()) {
                    jobName = (String)jobName + "." + jobQualifier;
                }
                DefaultMutableTreeNode jobNode = new DefaultMutableTreeNode(jobName);
                typeNode.add(jobNode);
                this.nodeId2Description.put(this.nodeToId(jobNode), this.getJobDescription(jobElement.getElement(), defaultAgent));
            }
        }
        String desc = this.buildApplicationDescription(root, String.format("Application read from %s.\nA total of %d types of jobs are defined in this application.\nA total of %d jobs.\nA total of %d scripts are defined in this application.\n\n", file.getName(), applicationNode.getChildCount(), totalJobCount, scriptsCount));
        this.nodeId2Description.put(this.nodeToId(applicationNode), desc);
        return totalJobCount;
    }

    private String getDefaultApplicationAgent(XmlElement root) {
        String agent = "";
        List defaultTypeList = root.getDirectchildsElementbyName(new String[]{"app:defaults", "defaults"});
        if (!defaultTypeList.isEmpty()) {
            for (XmlElement jobElement : defaultTypeList) {
                Node attr = DseriesGlobals.findChildNodeDFS(jobElement.getElement(), "agent", null, null);
                if (attr == null) continue;
                try {
                    agent = attr.getTextContent();
                }
                catch (DOMException e) {
                    ConversionLogger.getLogger().info(e.getMessage());
                }
            }
        }
        return agent == null ? "" : agent;
    }

    private int handleAppScripts(DefaultMutableTreeNode applicationNode, XmlElement rootElement) {
        List scriptDefList = new ArrayList();
        List scriptLibList = rootElement.getDirectchildsElementbyName(new String[]{"script_lib", "app:script_lib"});
        for (XmlElement scriptLibElement : scriptLibList) {
            DefaultMutableTreeNode scriptsLibTreeNode = new DefaultMutableTreeNode();
            scriptDefList = scriptLibElement.getDirectchildsElementbyName(new String[]{"script_definition", "app:script_definition"});
            scriptsLibTreeNode.setUserObject("scripts (" + scriptDefList.size() + ")");
            applicationNode.add(scriptsLibTreeNode);
            this.nodeId2Description.put(this.nodeToId(scriptsLibTreeNode), "Application scripts will be stored as CTM Jobs of type Job in the Embedded script field.\nGenerated jobs will be marked as Dummy jobs (CTM Run as Dummy).");
            for (XmlElement scriptDefElement : scriptDefList) {
                DefaultMutableTreeNode scriptDefTreeNode = new DefaultMutableTreeNode(scriptDefElement.getAttribute("name"));
                scriptsLibTreeNode.add(scriptDefTreeNode);
                String scriptDescription = String.format("Script name\t\t: %s%nScript language:\t: %s", scriptDefElement.getAttribute("name"), scriptDefElement.getAttribute("language"));
                this.nodeId2Description.put(this.nodeToId(scriptDefTreeNode), scriptDescription);
            }
        }
        return scriptDefList.size();
    }

    private String buildApplicationDescription(XmlElement root, String format) {
        StringBuilder desc = new StringBuilder();
        String agent = "";
        String schedule = "";
        List defaultTypeList = root.getDirectchildsElementbyName(new String[]{"app:defaults", "defaults"});
        if (!defaultTypeList.isEmpty()) {
            for (XmlElement jobElement : defaultTypeList) {
                Node attr = DseriesGlobals.findChildNodeDFS(jobElement.getElement(), "schedule", null, null);
                if (attr != null) {
                    schedule = attr.getTextContent();
                }
                if ((attr = DseriesGlobals.findChildNodeDFS(jobElement.getElement(), "agent", null, null)) == null) continue;
                agent = attr.getTextContent();
            }
        }
        desc.append(format);
        if (!agent.isEmpty() || !schedule.isEmpty()) {
            desc.append("Default Values:\n");
            if (!agent.isEmpty()) {
                desc.append(this.assessmentFormatForDescription("agent", agent));
            }
            if (!schedule.isEmpty()) {
                desc.append(this.assessmentFormatForDescription("schedule", schedule));
            }
        }
        return desc.toString();
    }

    private XmlElement getXmlLoderElement(File file) {
        XmlLoader xmlLoader = new XmlLoader();
        try {
            xmlLoader.loadFile((InputStream)new FileInputStream(file));
        }
        catch (IOException | SAXException e) {
            ConversionLogger.getLogger().info(e.getMessage());
            throw new RuntimeException("Error in openning file " + String.valueOf(file) + "Error in file " + e.getMessage(), e);
        }
        return xmlLoader.getXmlElement();
    }

    private String getTypeDescription(String jobType) {
        String description = "Job type " + jobType + " will be converted to ";
        description = jobType.equalsIgnoreCase("unix_job") || jobType.equalsIgnoreCase("nt_job") ? description + "an OS job" : (jobType.equalsIgnoreCase("filemon_job") ? description + "a Filewatcher job" : (jobType.equalsIgnoreCase("as400_job") ? description + "an OS400 job" : description + "a dummy job"));
        return description;
    }

    private boolean tagNameNotMatching(XmlElement root, String string) {
        return !root.getTagName().matches(string);
    }

    private String getJobDescription(Node xmlNode, String defaultAgent) {
        boolean haveAgent = false;
        StringBuilder description = new StringBuilder();
        String jobName = this.getJobName(xmlNode);
        description.append(this.assessmentFormatForDescription("Job Name", jobName));
        if (DseriesGlobals.elemntNameMatch(xmlNode, "unix_job") || DseriesGlobals.elemntNameMatch(xmlNode, "nt_job")) {
            this.appendOsAttrs(description, xmlNode);
        } else if (DseriesGlobals.elemntNameMatch(xmlNode, "filemon_job")) {
            this.appendFwAttrs(description, xmlNode);
        }
        for (Node child = xmlNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            String envar;
            if (child.getNodeType() != 1) continue;
            if (DseriesGlobals.elemntNameMatch(child, "comment")) {
                description.append(this.assessmentFormatForDescription("comment", child.getTextContent()));
                continue;
            }
            if (DseriesGlobals.elemntNameMatch(child, "userid")) {
                description.append(this.assessmentFormatForDescription("userid", child.getTextContent()));
                continue;
            }
            if (DseriesGlobals.elemntNameMatch(child, "agent")) {
                haveAgent = true;
                description.append(this.assessmentFormatForDescription("agent", child.getTextContent()));
                this.addJobToAgentList(child.getTextContent(), jobName);
                continue;
            }
            if (DseriesGlobals.elemntNameMatch(child, "dependencies")) {
                String dependencies = this.depsToStr(child);
                if (dependencies.isEmpty()) continue;
                description.append(this.assessmentFormatForDescription("dependencies", ""));
                description.append(dependencies);
                continue;
            }
            if (DseriesGlobals.elemntNameMatch(child, "schedules")) {
                String schedules = this.schedsToStr(child);
                if (schedules.isEmpty()) continue;
                description.append(this.assessmentFormatForDescription("Schedules", ""));
                description.append(schedules);
                continue;
            }
            if (DseriesGlobals.elemntNameMatch(child, "resourcedependencies")) {
                String resource = this.resourcesToStr(child);
                if (resource.isEmpty()) continue;
                description.append(this.assessmentFormatForDescription("resourcedependencies", ""));
                description.append(resource);
                continue;
            }
            if (!DseriesGlobals.elemntNameMatch(child, "envarlist") || (envar = this.varListtoString(child)).isEmpty()) continue;
            description.append(this.assessmentFormatForDescription("envarlist", ""));
            description.append(envar);
        }
        if (DseriesGlobals.isItUnSupportedJob(xmlNode.getNodeName())) {
            description.append("\n\nA dummy job will be created in its stead to preserve job flow\n");
        }
        if (haveAgent) {
            this.jobInfMap.put(jobName, description.toString());
        } else if (!defaultAgent.isEmpty()) {
            description.append(this.assessmentFormatForDescription("agent", defaultAgent));
            this.addJobToAgentList(defaultAgent, jobName);
            this.jobInfMap.put(jobName, description.toString());
        }
        return description.toString();
    }

    private String getJobName(Node xmlNode) {
        Node qualifier = xmlNode.getAttributes().getNamedItem("qualifier");
        Object jobName = xmlNode.getAttributes().getNamedItem("name").getNodeValue();
        if (qualifier != null) {
            jobName = (String)jobName + "." + qualifier.getNodeValue();
        }
        return jobName;
    }

    private void addJobToAgentList(String agentName, String jobName) {
        if (agentName == null) {
            return;
        }
        if (!this.agentsMap.containsKey(agentName)) {
            this.agentsMap.put(agentName, new ArrayList());
        }
        this.agentsMap.get(agentName).add(jobName);
    }

    public Map<String, List<String>> getAgentsMap() {
        return this.agentsMap;
    }

    private String assessmentFormatForDescription(String key, String value) {
        return String.format("%-25s\t: %s%s", key, value, "\n");
    }

    private String varListtoString(Node varList) {
        StringBuilder toRet = new StringBuilder();
        for (Node varNode = varList.getFirstChild(); varNode != null; varNode = varNode.getNextSibling()) {
            if (varNode.getNodeType() != 1 || !DseriesGlobals.elemntNameMatch(varNode, "envar")) continue;
            toRet.append(this.assessmentFormatForDescription(" - " + DseriesGlobals.findChildNodeDFS(varNode, "envarname", null, null).getTextContent(), DseriesGlobals.findChildNodeDFS(varNode, "envarvalue", null, null).getTextContent()));
        }
        return toRet.toString();
    }

    private String resourcesToStr(Node resList) {
        StringBuilder toRet = new StringBuilder();
        toRet.append(this.assessmentFormatForDescription("resource_acquiring_priority", DseriesGlobals.findChildNodeDFS(resList, "resource_acquiring_priority", null, null).getTextContent()));
        toRet.append(this.assessmentFormatForDescription("resource_absorb", DseriesGlobals.findChildNodeDFS(resList, "resource_absorb", null, null).getTextContent()));
        Node ressourceNode = DseriesGlobals.findChildNodeDFS(resList, "resources", null, null);
        if (ressourceNode != null) {
            ressourceNode = ressourceNode.getFirstChild();
        }
        while (ressourceNode != null) {
            if (ressourceNode.getNodeType() == 1 && DseriesGlobals.elemntNameMatch(ressourceNode, "resource")) {
                toRet.append(this.assessmentFormatForDescription(" - resource(quantity)", DseriesGlobals.findChildNodeDFS(ressourceNode, "resource_reference_name", null, null).getTextContent() + "(" + DseriesGlobals.findChildNodeDFS(ressourceNode, "resource_acquiring_quantity", null, null).getTextContent() + ")"));
            }
            ressourceNode = ressourceNode.getNextSibling();
        }
        return toRet.toString();
    }

    private String schedsToStr(Node schedsNode) {
        Node runSched = DseriesGlobals.findChildNodeDFS(schedsNode, "run", null, null);
        if (runSched != null) {
            runSched = runSched.getFirstChild();
        }
        StringBuilder toRet = new StringBuilder();
        while (runSched != null) {
            if (runSched.getNodeType() == 1 && DseriesGlobals.elemntNameMatch(runSched, "schedule")) {
                toRet.append(this.assessmentFormatForDescription("  - run", DseriesGlobals.findChildNodeDFS(runSched, "schedule", null, null).getTextContent()));
            }
            runSched = runSched.getNextSibling();
        }
        Node noRunSched = DseriesGlobals.findChildNodeDFS(schedsNode, "norun", null, null);
        if (noRunSched != null) {
            noRunSched = noRunSched.getFirstChild();
        }
        while (noRunSched != null) {
            if (noRunSched.getNodeType() == 1 && DseriesGlobals.elemntNameMatch(noRunSched, "schedule")) {
                toRet.append(this.assessmentFormatForDescription("  - norun", DseriesGlobals.findChildNodeDFS(noRunSched, "schedule", null, null).getTextContent()));
            }
            noRunSched = noRunSched.getNextSibling();
        }
        return toRet.toString();
    }

    private String depsToStr(Node depsNode) {
        Node relCondNode = DseriesGlobals.findChildNodeDFS(depsNode, "relconditionlist", null, null);
        if (relCondNode != null) {
            relCondNode = relCondNode.getFirstChild();
        }
        StringBuilder toRet = new StringBuilder();
        while (relCondNode != null) {
            if (relCondNode.getNodeType() == 1 && DseriesGlobals.elemntNameMatch(relCondNode, "relcondition")) {
                toRet.append(this.assessmentFormatForDescription(" - successorname(condition)", DseriesGlobals.findChildNodeDFS(relCondNode, "successorname", null, null).getTextContent() + "(" + DseriesGlobals.findChildNodeDFS(relCondNode, "condition", null, null).getTextContent() + ")"));
            }
            relCondNode = relCondNode.getNextSibling();
        }
        return toRet.toString();
    }

    private void appendFwAttrs(StringBuilder desc, Node xmlNode) {
        Node userNode;
        desc.append(this.assessmentFormatForDescription("monitored file", DseriesGlobals.findChildNodeDFS(xmlNode, "filename", null, null).getTextContent()));
        Node createNode = DseriesGlobals.findChildNodeDFS(xmlNode, "filecreate", null, null);
        if (createNode != null) {
            Node changeNode;
            Node sizeNode = DseriesGlobals.findChildNodeDFS(xmlNode, "filesize", null, null);
            if (sizeNode != null && Integer.parseInt(sizeNode.getTextContent().trim()) > 0) {
                desc.append(this.assessmentFormatForDescription("    size", sizeNode.getTextContent()));
            }
            if ((changeNode = DseriesGlobals.findChildNodeDFS(xmlNode, "filenochange", null, null)) != null) {
                desc.append(this.assessmentFormatForDescription("    unchanged", changeNode.getTextContent()));
            }
        }
        if ((userNode = DseriesGlobals.findChildNodeDFS(xmlNode, "user", null, null)) != null && userNode.getTextContent() != null && !userNode.getTextContent().isEmpty()) {
            desc.append(this.assessmentFormatForDescription("user", userNode.getTextContent()));
        }
    }

    private void appendOsAttrs(StringBuilder desc, Node xmlNode) {
        Node argsNode;
        Node commandNode = DseriesGlobals.findChildNodeDFS(xmlNode, "cmdname", null, null);
        if (commandNode != null) {
            desc.append(this.assessmentFormatForDescription("command", commandNode.getTextContent()));
        }
        if ((argsNode = DseriesGlobals.findChildNodeDFS(xmlNode, "args", null, null)) != null) {
            desc.append(this.assessmentFormatForDescription("arguments", argsNode.getTextContent()));
        }
    }

    protected String getJobInfo(String messageID) {
        return this.nodeId2Description.get(messageID.replaceAll("\\s*\\(\\s*[0-9]+\\);", ";"));
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.add("Applications");
        toRet.add("Agents");
        toRet.add("Calendars");
        toRet.add("Events");
        toRet.add("Variables");
        toRet.add("Resources");
        return toRet;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        return null;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        return null;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        LinkedHashMap descriptionMap_NodeName_NodeDesc = this.descriptionXMLReader.getNodeNameNodeDescriptionMap();
        StringBuilder mainSummary = new StringBuilder();
        mainSummary.append("Summary:").append("\n").append("\n");
        if (this.descriptionXMLReader.isAutoBuildMainSummary()) {
            for (String nodeName : descriptionMap_NodeName_NodeDesc.keySet()) {
                String nodeDescription = this.evaluateDescriptionParameters((String)descriptionMap_NodeName_NodeDesc.get(nodeName));
                descriptionMap_NodeName_NodeDesc.put(nodeName, nodeDescription);
                mainSummary.append(nodeDescription).append("\n").append("\n");
            }
        }
        descriptionMap_NodeName_NodeDesc.put(Params.instance().getDatasourceName(), mainSummary.toString());
        return descriptionMap_NodeName_NodeDesc;
    }

    private String evaluateDescriptionParameters(String sDescription) {
        Pattern parametersPattern = Pattern.compile("(#\\S+#)");
        if (sDescription != null && sDescription.contains("#")) {
            Matcher matcher = parametersPattern.matcher(sDescription);
            while (matcher.find()) {
                String sKey = matcher.group(0);
                String sNum = this.nodesParameters.getProperty(sKey);
                if (null == sNum) {
                    sNum = "0";
                }
                sDescription = sDescription.replace(matcher.group(0), sNum);
            }
        }
        return sDescription;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return null;
    }
}

