/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.addControlAndConds;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.w3c.dom.Node;

public class WaitForAncestorHandler {
    public static final String ANYCODE = "****";
    private final RulesDataSet rules;
    private final DSeriesJob dSeriesJob;
    private addControlAndConds addControlAndConds;

    public WaitForAncestorHandler(DSeriesJob dSeriesJob, RulesDataSet rules) {
        this.dSeriesJob = dSeriesJob;
        this.rules = rules;
        this.addControlAndConds = new addControlAndConds(dSeriesJob);
    }

    public void handle() {
        switch (this.dSeriesJob.type()) {
            case SMART_TABLE: 
            case SMART_FOLDER: 
            case SUB_TABLE: {
                this.handleFolder();
                break;
            }
            default: {
                this.handleJob();
            }
        }
    }

    private void handleFolder() {
        this.handle(this::hasFolderWait, ENTITY_TYPE.FOLDER);
    }

    private void handleJob() {
        this.handle(this::getJobAncestorWait, ENTITY_TYPE.JOB);
    }

    private void handle(Supplier<Optional<String>> odateValue, ENTITY_TYPE type) {
        odateValue.get().ifPresent(odate -> {
            if (this.dSeriesJob.isCyclic()) {
                this.addControlAndConds.addControlResource();
            } else if (this.deleteConditions()) {
                this.addControlAndConds.addInCondition((String)odate);
                this.addControlAndConds.addOutCondition((String)odate);
                this.addControlAndConds.addControlResource();
                this.addMessageToAddConditionOnFirstRun(type);
            } else {
                this.addMessageNotConverted(type);
            }
        });
    }

    private void addMessageNotConverted(ENTITY_TYPE type) {
        String messageId = type == ENTITY_TYPE.JOB ? "WRN16019" : "WRN16020";
        this.dSeriesJob.addMessage(messageId, this.addControlAndConds.getJobName(), this.dSeriesJob.getOriginalJobName());
    }

    private void addMessageToAddConditionOnFirstRun(ENTITY_TYPE type) {
        String messageId = type == ENTITY_TYPE.JOB ? "WRN16021" : "WRN16022";
        this.dSeriesJob.addMessage(messageId, this.addControlAndConds.getJobName(), this.dSeriesJob.getOriginalJobName());
    }

    private boolean deleteConditions() {
        return this.rules.getBooleanRule("dSeries rules", new String[]{"CLEAN_UP_CONDITIONS"});
    }

    private Optional<String> getJobAncestorWait() {
        return Optional.ofNullable(this.dSeriesJob.getRootElement().getFirstChildElementByName("job_ancestor_wait")).filter(this.isLatsOrAny()).map(this::toOdate);
    }

    private Optional<String> hasFolderWait() {
        return DseriesGlobals.findChildNodeDFS(this.dSeriesJob.getRootElement().getElement(), "wait").map(Node::getTextContent).filter(v -> v.equalsIgnoreCase("true")).map(x -> "PREV");
    }

    private Predicate<XmlElement> isLatsOrAny() {
        return element -> {
            String text = element.getText().trim();
            return text.equalsIgnoreCase("ANY") || text.equalsIgnoreCase("LAST");
        };
    }

    private String toOdate(XmlElement element) {
        String text = element.getText();
        if (text.equals("ANY")) {
            return ANYCODE;
        }
        return "PREV";
    }

    static enum ENTITY_TYPE {
        JOB,
        FOLDER;

    }
}

