/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.dSeries.ApplResolver;
import com.bmc.ctmconvert.dSeries.GlobalVariables;
import com.bmc.ctmconvert.dSeries.ResolvedString;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringResolver {
    private static final String[] funcs = new String[]{"%VAR", "%IF"};
    private static final String[] supportedfuncs = new String[]{"%VAR", "%IF"};

    private static LinkedHashMap<Integer, Integer> mapParens(String toMap) {
        int parenCount = 0;
        LinkedHashMap<Integer, Integer> toRet = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> matchMap = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < toMap.length(); ++i) {
            Integer opener;
            if (toMap.charAt(i) == '(') {
                matchMap.put(new Integer(parenCount++), new Integer(i));
            }
            if (toMap.charAt(i) != ')' || (opener = (Integer)matchMap.remove(--parenCount)) == null) continue;
            toRet.put(opener, new Integer(i));
        }
        return toRet;
    }

    public static void resolveAllVars(ResolvedString toResolve, GlobalVariables globalVariable) {
        String[] words = toResolve.getCurrentValue().split("\\s+");
        Object toRet = "";
        Object toRetResolved = "";
        Pattern varPattern = Pattern.compile("(?<!%)%((\\((.+?)\\)|[a-zA-Z0-9._]+))");
        for (int i = 0; i < words.length; ++i) {
            Matcher varMatcher = varPattern.matcher(words[i]);
            Object toAdd = words[i];
            Object toAddFullyResolved = words[i];
            while (varMatcher.find()) {
                String originalVariableName = varMatcher.group(1);
                String originalVariableElement = varMatcher.group(0);
                String varName = originalVariableName.replaceAll("^\\(", "").replaceAll("\\)$", "").replace(".", "_");
                ApplResolver applResolver = new ApplResolver(toResolve, varName, globalVariable);
                String varValueResolved = applResolver.getResolvedVariableValue();
                if (varValueResolved != null) {
                    String separator = "";
                    separator = varValueResolved.startsWith("%%") && varMatcher.end() < words[i].length() - 1 ? "." : "";
                    toAddFullyResolved = ((String)toAddFullyResolved).replace(originalVariableElement, varValueResolved + separator);
                }
                String varValueInContext = applResolver.getVariableValueUsingContext();
                String separator = "";
                separator = varValueInContext.startsWith("%%") && varMatcher.end() < words[i].length() - 1 ? "." : "";
                toAdd = ((String)toAdd).replace(originalVariableElement, varValueInContext + separator);
            }
            if (i > 0) {
                toAdd = " " + (String)toAdd;
                toAddFullyResolved = " " + (String)toAddFullyResolved;
            }
            toRet = (String)toRet + (String)toAdd;
            toRetResolved = (String)toRetResolved + (String)toAddFullyResolved;
        }
        toResolve.setCurrentValue((String)toRet);
        toResolve.setResolvedValueImmidiate((String)toRetResolved);
    }

    public static void resolveAllFuncs(ResolvedString toResolve, GlobalVariables globalVariable) {
        if (StringResolver.hasFuncCall(toResolve.getCurrentValue())) {
            toResolve.setCurrentValue(toResolve.getCurrentValue().replaceAll("(%(IF|VAR))\\s*\\(", "$1("));
            boolean done = false;
            while (!done) {
                LinkedHashMap<Integer, Integer> parensMap = StringResolver.mapParens(toResolve.getCurrentValue());
                String func = null;
                for (Integer opener : parensMap.keySet()) {
                    func = StringResolver.getFuncCall(opener, toResolve.getCurrentValue());
                    if (func == null) continue;
                    String[] funcArgs = toResolve.getCurrentValue().substring(opener + 1, parensMap.get(opener)).split(",");
                    for (int i = 0; i < funcArgs.length; ++i) {
                        funcArgs[i] = funcArgs[i].replaceAll("([\"'])(.*)\\1", "$2");
                    }
                    StringResolver.resolveOneFunc(toResolve, func, funcArgs, opener - func.length(), parensMap.get(opener), globalVariable);
                    break;
                }
                done = func == null;
            }
        }
    }

    static boolean hasFuncCall(String string) {
        boolean toRet = false;
        for (int i = 0; i < funcs.length && !toRet; ++i) {
            String func = funcs[i];
            toRet = string.startsWith(func) || string.matches(".*" + func + "\\s*\\(.*");
        }
        return toRet;
    }

    private static void resolveOneFunc(ResolvedString toResolve, String func, String[] args, int beginIdx, int endIdx, GlobalVariables globalVariable) {
        String replacement = "";
        if (StringResolver.isSupportedFunc(func)) {
            if (func.equalsIgnoreCase("%IF")) {
                replacement = args[1];
                toResolve.addMessage("WRN16009", String.format("%s(%s,%s)", func, args[0], args[1]), replacement);
            }
            if (func.equalsIgnoreCase("%VAR")) {
                boolean hasContext = args.length >= 2;
                replacement = String.format("%%%%%s", args[0]);
                String value = hasContext ? globalVariable.getVarValue(args[1], args[0]) : globalVariable.getVarValue(args[0]);
                if (value == null) {
                    value = String.format("#ERR_%s#", args[0]);
                    String varNameForMessage = hasContext ? "'" + args[0] + "', " + args[1] : "'" + args[0] + "'";
                    toResolve.addMessage("WRN16005", String.format("%%VAR(%s)", varNameForMessage), value);
                }
                toResolve.addAutoedit(args[0], value);
            }
        }
        String tmpStr = toResolve.getCurrentValue();
        toResolve.setCurrentValue(String.format("%s%s%s", tmpStr.substring(0, beginIdx), replacement, tmpStr.substring(endIdx + 1)));
    }

    private static boolean isSupportedFunc(String func) {
        boolean toRet = false;
        for (int i = 0; i < supportedfuncs.length && !toRet; ++i) {
            if (!supportedfuncs[i].equals(func)) continue;
            toRet = true;
        }
        return toRet;
    }

    private static String getFuncCall(Integer opener, String string) {
        String toRet = null;
        for (int i = 0; i < funcs.length && toRet == null; ++i) {
            String func = funcs[i];
            if (opener < func.length() || !string.substring(opener - func.length(), opener).equalsIgnoreCase(func)) continue;
            toRet = string.substring(opener - func.length(), opener);
        }
        return toRet;
    }
}

