/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.dSeries.DseriesDefs;
import com.bmc.ctmconvert.dSeries.GlobalVariables;
import com.bmc.ctmconvert.dSeries.StringResolver;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class ResolvedString {
    private String originalValue;
    private String resolvedValueImmidiate;
    private String resolvedValueAutoedits;
    private String currentValue;
    private LinkedHashMap<String, String> autoedits;
    private LinkedHashMap<String, String> localAutoedits;
    private ArrayList<String[]> messages;
    private String applicationName;
    private DseriesDefs defs;

    public String getApplicationName() {
        return this.applicationName;
    }

    public ResolvedString(String original, LinkedHashMap<String, String> autoedits, String applicationName, DseriesDefs defs) {
        this.originalValue = original;
        this.currentValue = original;
        this.autoedits = autoedits;
        this.applicationName = applicationName;
        this.defs = defs;
        this.localAutoedits = new LinkedHashMap();
        GlobalVariables globalVariable = this.defs.getGlobalVariables();
        StringResolver.resolveAllFuncs(this, globalVariable);
        StringResolver.resolveAllVars(this, globalVariable);
        this.resolvedValueAutoedits = this.currentValue;
        this.resolvedValueImmidiate = this.replaceAutoEdits(this.resolvedValueImmidiate);
    }

    public ResolvedString(String original, LinkedHashMap<String, String> autoedits, DseriesDefs defs) {
        this(original, autoedits, "", defs);
    }

    private String replaceAutoEdits(String str) {
        String toRet = str;
        if (this.autoedits != null) {
            for (String autoeditVar : this.autoedits.keySet()) {
                toRet = toRet.replaceAll(autoeditVar + "(\\.|\\s)?", this.autoedits.get(autoeditVar) + "$1");
                toRet = toRet.replaceAll(autoeditVar + "$", this.autoedits.get(autoeditVar));
            }
        }
        for (String autoeditVar : this.localAutoedits.keySet()) {
            toRet = toRet.replaceAll(autoeditVar + "(\\.|\\s)?", this.localAutoedits.get(autoeditVar) + "$1");
            toRet = toRet.replaceAll(autoeditVar + "$", this.localAutoedits.get(autoeditVar));
        }
        return toRet;
    }

    public String getOriginal() {
        return this.originalValue;
    }

    public void setResolvedValueAutoedits(String resolvedValueAutoedits) {
        this.resolvedValueAutoedits = resolvedValueAutoedits;
    }

    public String getResolvedValueAutoedits() {
        return this.resolvedValueAutoedits;
    }

    public void setResolvedValueImmidiate(String resolvedValueImmidiate) {
        this.resolvedValueImmidiate = resolvedValueImmidiate;
    }

    public String getResolvedValueImmidiate() {
        return this.resolvedValueImmidiate;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String newValue) {
        this.currentValue = newValue;
    }

    public void addAutoedit(String name, String value) {
        this.localAutoedits.put("%%" + name, value);
    }

    public String getAutoedit(String name) {
        return this.localAutoedits.get(name);
    }

    public void addMessage(String msgId, String origVal, String newVal) {
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        String[] toAdd = new String[]{msgId, origVal, newVal};
        this.messages.add(toAdd);
    }

    public ArrayList<String[]> getMessages() {
        return this.messages;
    }

    public DseriesDefs getDefs() {
        return this.defs;
    }
}

