/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.rbc.DailyRbc;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.scheduling.EventScheduling;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RbcGenerator {
    public static final UnaryOperator<EventScheduling.Cyclic> REMOVE_EXCLUDED_CYCLIC_DEFINITIONS = cyclic -> null;
    public static final String EMPTY_RBC_NAME = "EMPTY_RBC";
    private final Set<Properties> rbcs = new HashSet<Properties>();
    public static final UnaryOperator<String> REMOVE_TIMEFROM_DEFINITIONS = timeFrom -> null;
    private final Map<String, Map<String, Set<Arguments>>> messageMap = new LinkedHashMap<String, Map<String, Set<Arguments>>>();

    private static String createKeyFromSchedStmt(String statement, String baseCalendar) {
        String normalizedStatement = statement.trim().toLowerCase().replaceAll("\\s+", " ");
        return String.format("%s CAL:%s", normalizedStatement, baseCalendar);
    }

    public static Properties getEmptyRbc() {
        String[] monthsArr;
        Properties toRet = new Properties();
        for (String s : monthsArr = GlobalFunctions.getMonthsArray()) {
            toRet.setProperty(s, "1");
        }
        toRet.setProperty("NAME", EMPTY_RBC_NAME);
        return toRet;
    }

    public static Properties getEveryDayRBC() {
        return new DailyRbc().getProperties();
    }

    public List<EventScheduling.Scheduling> getSchedules(Node schedulesNode) {
        List<String> runSchedNodes = RbcGenerator.extractScheduleFrom(schedulesNode, "run");
        List<String> noRunSchedNodes = RbcGenerator.extractScheduleFrom(schedulesNode, "norun");
        List<EventScheduling.Scheduling> include = new EventScheduling(runSchedNodes).parse();
        List exclude = new EventScheduling(noRunSchedNodes).parse().stream().map(item -> EventScheduling.Scheduling.from(item, RbcGenerator::toExcludeCalendar, REMOVE_EXCLUDED_CYCLIC_DEFINITIONS, REMOVE_TIMEFROM_DEFINITIONS)).collect(Collectors.toList());
        List<EventScheduling.Scheduling> all = Stream.concat(include.stream(), exclude.stream()).collect(Collectors.toList());
        this.rbcs.addAll(all.stream().flatMap(x -> x.getRuleBasedCalendars().stream()).collect(Collectors.toList()));
        return all;
    }

    public Set<Properties> getRbcs(Node schedulesNode) {
        return this.getSchedules(schedulesNode).stream().flatMap(x -> x.getRuleBasedCalendars().stream()).collect(Collectors.toSet());
    }

    public Set<Properties> getControlMLevelRbcs() {
        return this.rbcs.stream().filter(rbc -> "CONTROL-M".equals(rbc.getProperty("LEVEL"))).map(RbcGenerator::fromExcludeCalendar).collect(Collectors.toSet());
    }

    public static List<String> extractScheduleFrom(Node input, String type) {
        return DseriesGlobals.findChildNodeDFS(input, type).map(Element.class::cast).map(element -> {
            NodeList schedule = element.getElementsByTagName("schedule");
            if (schedule == null || schedule.getLength() == 0) {
                return element.getElementsByTagName("app:schedule");
            }
            return schedule;
        }).map(node -> {
            Predicate<String> ignoreNorCalendar = schedulingStatement -> !schedulingStatement.equalsIgnoreCase("now");
            Predicate<Node> hasContent = content -> content.getTextContent() != null && !content.getTextContent().trim().isBlank();
            return IntStream.range(0, node.getLength()).mapToObj(node::item).filter(hasContent).map(Node::getTextContent).filter(ignoreNorCalendar).collect(Collectors.toList());
        }).orElse(Collections.emptyList());
    }

    public void addMessages(Node schedulesNode, List<String> jobMessages, String jobId, String baseCalendarName) {
        NodeList allSchedNodes = ((Element)schedulesNode).getElementsByTagName("schedule");
        if (allSchedNodes == null || allSchedNodes.getLength() == 0) {
            allSchedNodes = ((Element)schedulesNode).getElementsByTagName("app:schedule");
        }
        for (int i = 0; allSchedNodes != null && i < allSchedNodes.getLength(); ++i) {
            String schedule = allSchedNodes.item(i).getTextContent().trim().toLowerCase().replaceAll("\\s+", " ");
            this.addMessages(schedule, jobMessages, jobId, baseCalendarName);
        }
    }

    public void addMessages(String schedStatement, List<String> jobMessages, String jobId, String baseCalendarName) {
        String mapKey = RbcGenerator.createKeyFromSchedStmt(schedStatement, baseCalendarName);
        Map schedMassages = this.messageMap.getOrDefault(mapKey, Collections.emptyMap());
        if (schedMassages != null) {
            for (Map.Entry msg : schedMassages.entrySet()) {
                for (Arguments args : (Set)msg.getValue()) {
                    Reporter.addMessage(jobMessages, (String)((String)msg.getKey()), (String)jobId, (String[])args.getArgs());
                }
            }
        }
    }

    private static Properties toExcludeCalendar(Properties rbc) {
        Properties toRet = (Properties)rbc.clone();
        toRet.setProperty("NAME", "!" + rbc.getProperty("NAME"));
        return toRet;
    }

    private static Properties fromExcludeCalendar(Properties rbc) {
        Properties toRet = (Properties)rbc.clone();
        if (rbc.getProperty("NAME").startsWith("!")) {
            toRet.setProperty("NAME", rbc.getProperty("NAME").replaceAll("^!", ""));
        }
        return toRet;
    }

    public class Arguments {
        private final String[] args;

        public Arguments(String[] args) {
            this.args = args;
        }

        public String[] getArgs() {
            return this.args;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + Arrays.hashCode(this.args);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Arguments other = (Arguments)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return Arrays.equals(this.args, other.args);
        }

        private RbcGenerator getOuterType() {
            return RbcGenerator.this;
        }
    }
}

