/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.PrematureAndOverdueAlertsHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class NotificationsConvertor {
    private final DSeriesJob dSeriesJob;
    private Optional<XmlElement> element = Optional.empty();

    public NotificationsConvertor(DSeriesJob dSeriesJob) {
        this.dSeriesJob = dSeriesJob;
        if (dSeriesJob.getOriginalNode() instanceof Element) {
            this.element = Optional.ofNullable(XmlElement.ofNullable((Element)((Element)dSeriesJob.getOriginalNode())));
        }
    }

    public List<Properties> convert() {
        Integer minute;
        int hour;
        int pm;
        String[] timeArr;
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        String execDueOut = null;
        String submitDueOut = null;
        Node dueOutNode = DseriesGlobals.findChildNodeDFS(this.dSeriesJob.getOriginalNode(), "exec", null, null);
        Node node = dueOutNode = dueOutNode == null ? null : DseriesGlobals.findChildNodeDFS(dueOutNode, "dueout", null, null);
        if (dueOutNode != null && dueOutNode.getParentNode().getParentNode().getParentNode() == this.dSeriesJob.getOriginalNode()) {
            execDueOut = dueOutNode.getTextContent().trim();
        }
        Node node2 = dueOutNode = (dueOutNode = DseriesGlobals.findChildNodeDFS(this.dSeriesJob.getOriginalNode(), "ready", null, null)) == null ? null : DseriesGlobals.findChildNodeDFS(dueOutNode, "dueout", null, null);
        if (dueOutNode != null && dueOutNode.getParentNode().getParentNode().getParentNode() == this.dSeriesJob.getOriginalNode()) {
            submitDueOut = dueOutNode.getTextContent().trim();
        }
        if (execDueOut != null || submitDueOut != null) {
            toRet = new ArrayList();
        }
        if (execDueOut != null) {
            execDueOut = this.dSeriesJob.resolveStrings(execDueOut, false, "<dueout>(exec)");
            execDueOut = execDueOut.trim();
            Properties lateTimeShout = new Properties();
            timeArr = execDueOut.split("\\s+", 2);
            if (timeArr.length > 1) {
                this.dSeriesJob.addMessage("WRN16002", "<dueout>(exec)", execDueOut);
            }
            if (timeArr[0].toLowerCase().matches("(?<startTime>[0-9]+:[0-9]+(:[0-9]+)?)\\s*((?<ampm>[ap]m)|gmt)?")) {
                pm = (timeArr = timeArr[0].split(":"))[timeArr.length - 1].toLowerCase().endsWith("pm") ? 12 : 0;
                hour = Integer.parseInt(timeArr[0]);
                minute = Integer.valueOf(timeArr[1].replaceAll("(?i)[ap]m$", ""));
                lateTimeShout.setProperty("DEST", this.getDestination());
                lateTimeShout.setProperty("URGENCY", NotificationsConvertor.getUrgencyFrom(this.element));
                lateTimeShout.setProperty("WHEN", "LATETIME");
                lateTimeShout.setProperty("TIME", String.format("%02d%02d", hour + pm, minute));
                lateTimeShout.setProperty("MESSAGE", "Submission of job %%JOBNAME in Application %%SCHEDTAB has not ended %%RUNCOUNT odate %%ODATE Sev SEVERITY NODEALIAS:%%NODEID OID:%%ORDERID");
                toRet.add(lateTimeShout);
            } else {
                this.dSeriesJob.addMessage("WRN16003", "dueout(exec)", "hh:mm[:ss][am|pm]", timeArr[0]);
            }
        }
        if (submitDueOut != null) {
            submitDueOut = this.dSeriesJob.resolveStrings(submitDueOut, false, "<dueout>(ready)");
            submitDueOut = submitDueOut.trim();
            Properties lateSubShout = new Properties();
            timeArr = submitDueOut.split("\\s+", 2);
            if (timeArr.length > 1) {
                this.dSeriesJob.addMessage("WRN16002", "<dueout>(ready)", submitDueOut);
            }
            if (timeArr[0].matches("(?<startTime>[0-9]+:[0-9]+(:[0-9]+)?)\\s*((?<ampm>[ap]m)|gmt)?")) {
                pm = (timeArr = timeArr[0].split(":"))[timeArr.length - 1].toLowerCase().endsWith("pm") ? 12 : 0;
                hour = Integer.parseInt(timeArr[0]);
                minute = Integer.valueOf(timeArr[1].replaceAll("(?i)[ap]m$", ""));
                lateSubShout.setProperty("DEST", this.getDestination());
                lateSubShout.setProperty("URGENCY", NotificationsConvertor.getUrgencyFrom(this.element));
                lateSubShout.setProperty("WHEN", "LATESUB");
                lateSubShout.setProperty("TIME", String.format("%02d%02d", hour + pm, minute));
                lateSubShout.setProperty("MESSAGE", "Submission of job %%JOBNAME in Application %%SCHEDTAB has not started %%RUNCOUNT odate %%ODATE Sev SEVERITY NODEALIAS:%%NODEID OID:%%ORDERID");
                toRet.add(lateSubShout);
            } else {
                this.dSeriesJob.addMessage("WRN16003", "dueout(ready)", "hh:mm[:ss]", timeArr[0]);
            }
        }
        return new PrematureAndOverdueAlertsHandler(this.dSeriesJob).handle(toRet);
    }

    private void createNotificationAction(String destination) {
        Map<String, String> action = Map.of("ACTENTTYPE", "SHOUT", "JOBID", this.dSeriesJob.getJobName(), "ACTENTNAME", destination, "ACTSTATUS", "0");
        Reporter.addAction(action);
    }

    private String getDestination() {
        int MAX_DESTINATION_LENGTH = 16;
        return this.getAlertElement(this.element).or(this::getDefaultAlertsElement).map(XmlElement::getText).map(destination -> GlobalFunctions.shorten((String)destination, (int)16)).map(destination -> {
            this.createNotificationAction((String)destination);
            return destination;
        }).orElse("EM");
    }

    private Optional<XmlElement> getDefaultAlertsElement() {
        Optional<XmlElement> defaults = this.element.map(XmlElement::getParent).map(e -> this.getFirstChild((XmlElement)e, "defaults"));
        return this.getAlertElement(defaults);
    }

    private Optional<XmlElement> getAlertElement(Optional<XmlElement> element) {
        return element.map(e -> this.getFirstChild((XmlElement)e, "alert_notifylist")).map(e -> this.getFirstChild((XmlElement)e, "alert_notify")).map(e -> this.getFirstChild((XmlElement)e, "alert"));
    }

    private XmlElement getFirstChild(XmlElement element, String elementName) {
        return Optional.ofNullable(element.getElement()).map(e -> {
            Node child = DseriesGlobals.findChildNodeDFS(e, elementName, null, null);
            return child instanceof Element ? (Element)child : null;
        }).map(XmlElement::new).orElse(null);
    }

    public static String getUrgencyFrom(Optional<XmlElement> element) {
        Optional<XmlElement> onLoad = element.map(e -> e.getFirstChildElementByName("on_load"));
        Optional<XmlElement> scriptDefinition = onLoad.map(e -> e.getFirstChildElementByName("script_definition"));
        return scriptDefinition.map(XmlElement::getText).map(NotificationsConvertor::convertJSSeverityToCtmUrgency).map(NotificationsConvertor::getRepresentingLetterFromElement).orElse("R");
    }

    private static String convertJSSeverityToCtmUrgency(String jsSeverity) {
        Pattern pattern = Pattern.compile(".*?WOB\\.SEV='?(?<severity>[123])'?;.*");
        Matcher matcher = pattern.matcher(jsSeverity);
        if (matcher.find()) {
            return matcher.group("severity");
        }
        return null;
    }

    private static String getRepresentingLetterFromElement(String urgency) {
        return switch (urgency.toLowerCase()) {
            case "1" -> "V";
            case "2" -> "U";
            default -> "R";
        };
    }
}

