/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.integration_factory.wrapper.MicroFocusIntegrationJobWrapper;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import java.util.Optional;
import java.util.function.BiFunction;

public class MicroFocusJobConverter {
    private final XmlElement jobXml;
    private final DSeriesJob dSeriesJob;

    public MicroFocusJobConverter(DSeriesJob dSeriesJob) {
        this.dSeriesJob = dSeriesJob;
        this.jobXml = Optional.ofNullable(dSeriesJob.getRootElement()).orElse(XmlElement.nullXmlElement);
    }

    public void convert() {
        JClPath jclPath = this.getFullJClPathFrom(this.jobXml);
        new MicroFocusIntegrationJobWrapper((SchedEntity)this.dSeriesJob, jclPath.isLinux()).convertDefaults().withJCLFileName(jclPath.fileName()).withJCLFilePath(jclPath.path()).withConnectionProfile(this.getConnectionProfileNameFrom(this.jobXml));
    }

    private String[] addAppTo(String attributeName) {
        return new String[]{attributeName, "app:" + attributeName};
    }

    private String getConnectionProfileNameFrom(XmlElement jobXml) {
        String connectionProfileName = jobXml.getValueOfFirstChildElementByName(this.addAppTo("microfocususer"));
        return this.resolveVariable(connectionProfileName, "Connection Profile Name");
    }

    private String resolveVariable(String field, String usageForMessages) {
        return Optional.ofNullable(field).map(f -> this.dSeriesJob.resolveStrings((String)f, "Micro Focus " + usageForMessages)).orElse(field);
    }

    private JClPath getFullJClPathFrom(XmlElement jobXml) {
        String jclFullPath = jobXml.getValueOfFirstChildElementByName(this.addAppTo("jclcontent"));
        boolean isLinux = jclFullPath.contains("/");
        int indexOfLastSeparator = MicroFocusJobConverter.indexOfLastSeparator(jclFullPath);
        String fileName = jclFullPath.substring(indexOfLastSeparator + 1);
        String path = jclFullPath.substring(0, indexOfLastSeparator);
        return new JClPath(path, fileName, isLinux).withResolvedVariables(this::resolveVariable);
    }

    private static int indexOfLastSeparator(String filename) {
        return Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
    }

    record JClPath(String path, String fileName, boolean isLinux) {
        public JClPath withResolvedVariables(BiFunction<String, String, String> variableResolver) {
            return new JClPath(variableResolver.apply(this.path, "JCL Path"), variableResolver.apply(this.fileName, "JCL File Name"), this.isLinux);
        }
    }
}

