/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dSeries.DataReader;
import com.bmc.ctmconvert.dSeries.DseriesData;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GlobalVariables {
    private LinkedHashMap<String, HashMap<String, String>> contextToVarValues;
    private String defaultContextName = "DEFAULT";

    public GlobalVariables(DseriesData data) {
        try {
            this.load(data);
        }
        catch (ParserConfigurationException e) {
            ConversionLogger.getLogger().severe(String.format("Failed to get doc builder, caught ParserConfigurationException (%s)", e.getMessage()));
        }
        catch (DataReader.VarsIoException | IOException e) {
            ConversionLogger.getLogger().severe(String.format("Failed handleFile IOException (%s)", e.getMessage()));
        }
    }

    private void load(DseriesData data) throws ParserConfigurationException, IOException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        List<InputStream> varXmls = data.getVarXml();
        for (InputStream inputStream : varXmls) {
            this.handleFile(documentBuilder, inputStream);
        }
    }

    private void handleFile(DocumentBuilder documentBuilder, InputStream originalInputStream) {
        try (InputStream inputStream = originalInputStream;){
            Document varDocument = documentBuilder.parse(new InputSource(originalInputStream));
            Element documentElement = varDocument.getDocumentElement();
            this.addContext(documentElement);
        }
        catch (IOException | SAXException e) {
            ConversionLogger.getLogger().warning(String.format("Caught %s (%s) while handling var file %s", e.getClass().getName(), e.getMessage(), originalInputStream));
        }
    }

    private void addContext(Element contextElement) {
        String context = contextElement.getAttribute("name");
        if (this.contextToVarValues == null) {
            this.contextToVarValues = new LinkedHashMap();
        }
        this.contextToVarValues.put(context, new HashMap());
        for (Node varElement = contextElement.getFirstChild(); varElement != null; varElement = varElement.getNextSibling()) {
            Node valueElement;
            if (!varElement.getNodeName().equalsIgnoreCase("variable")) continue;
            String varName = varElement.getAttributes().getNamedItem("name").getTextContent();
            for (valueElement = varElement.getFirstChild(); valueElement != null; valueElement = valueElement.getNextSibling()) {
                if (!valueElement.getNodeName().equalsIgnoreCase("value")) continue;
                this.contextToVarValues.get(context).put(varName, valueElement.getTextContent());
                break;
            }
            if (valueElement != null) continue;
            this.contextToVarValues.get(context).put(varName, "");
        }
    }

    public String getVarValue(String context, String varName) {
        HashMap<String, String> contextVars;
        String toRet = null;
        if (context != null && this.contextToVarValues != null && (contextVars = this.contextToVarValues.get(context)) != null) {
            toRet = contextVars.get(varName);
        }
        return toRet;
    }

    public String getVarValue(String varName) {
        return this.getVarValue(this.defaultContextName, varName);
    }

    public Set<String> getContextList() {
        return this.contextToVarValues != null ? Collections.unmodifiableSet(this.contextToVarValues.keySet()) : Collections.emptySet();
    }

    public Set<String> getVarList(String context) {
        return this.contextToVarValues != null ? Collections.unmodifiableSet(this.contextToVarValues.get(context).keySet()) : Collections.emptySet();
    }
}

