/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FiledEditorValues {
    private HashMap<String, String> competitorValues;
    private static final List<String> editableCtmFields = List.of("JOBNAME", "APPLICATION", "GROUP", "AUTHOR", "OWNER", "SMART_TABLE_NAME");
    public static final String DSERIES_USERID = "userid";
    public static final String DSERIES_JOB_NAME = "jobname";
    public static final String DSERIES_APP_NAME = "appname";
    public static final String DSERIES_EVENT_NAME = "event name";
    public static final String DSERIES_QAULIFIER = "qualifier";
    public static final String DSERIES_SUBAPPL = "subappl";
    private final HashMap<String, String> validatedCTMFields = new HashMap();
    private final ArrayList<String> messages = new ArrayList();
    private final RulesDataSet rules;
    private final String parentFolderName;
    private final UniqueValueGenerator uniqueValueGenerator;

    public FiledEditorValues(RulesDataSet rules, String parentFolderName) {
        this.rules = rules;
        this.parentFolderName = parentFolderName;
        this.uniqueValueGenerator = new UniqueValueGenerator();
        this.uniqueValueGenerator.getUniqueValue("JOBNAME", parentFolderName);
    }

    public void setCompetitorValue(String field, String value) {
        if (this.competitorValues == null) {
            this.competitorValues = new HashMap();
        }
        this.competitorValues.put(field, value);
    }

    public boolean isEditableFieldForType(String ctmField, DseriesGlobals.JOB_TYPES_ENUM jobType) {
        if (this.isAS400Field(ctmField, jobType) || this.isZOSField(jobType)) {
            return false;
        }
        return editableCtmFields.stream().anyMatch(editableCtmField -> editableCtmField.equals(ctmField));
    }

    private boolean isZOSField(DseriesGlobals.JOB_TYPES_ENUM jobType) {
        return jobType.equals((Object)DseriesGlobals.JOB_TYPES_ENUM.ZOS);
    }

    private boolean isAS400Field(String ctmField, DseriesGlobals.JOB_TYPES_ENUM jobType) {
        return jobType.equals((Object)DseriesGlobals.JOB_TYPES_ENUM.AS400) && (ctmField.equals("JOBNAME") || ctmField.equals("OWNER"));
    }

    public String getCompetitorValue(String key) {
        return this.competitorValues.get(key);
    }

    public String getFormattedValue(String ctmField) {
        String preValidatedCtmField = this.rules.getFieldEditor().generateCTMField(ctmField, this.competitorValues);
        if (ctmField.equals("JOBNAME")) {
            if (!this.validatedCTMFields.containsKey(ctmField)) {
                String validatedJobname;
                String qualifier = this.competitorValues.get(DSERIES_QAULIFIER);
                String originalJobname = this.competitorValues.get(DSERIES_JOB_NAME);
                if (qualifier != null) {
                    originalJobname = String.format("%s.%s", originalJobname, qualifier);
                }
                if ((validatedJobname = FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", originalJobname, true, DSERIES_JOB_NAME, this.competitorValues.get(DSERIES_JOB_NAME), this.messages)).equals(this.parentFolderName)) {
                    validatedJobname = this.uniqueValueGenerator.getUniqueValue("JOBNAME", validatedJobname);
                }
                this.validatedCTMFields.put(ctmField, validatedJobname);
            }
        } else {
            this.validatedCTMFields.put(ctmField, preValidatedCtmField);
        }
        return this.validatedCTMFields.get(ctmField);
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void clearMessages() {
        this.messages.clear();
    }
}

