/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.OnStatement;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExitCodeListHandler {
    private final XmlElement dSeriesJobData;
    private static final int DEFAULT_EXIT_CODE_FOR_MALFORMED_DATA = 255;

    public ExitCodeListHandler(XmlElement dSeriesJobData) {
        this.dSeriesJobData = dSeriesJobData;
    }

    public Map<Properties, List<Properties>> handle() {
        LinkedHashMap<Properties, List<Properties>> result = new LinkedHashMap<Properties, List<Properties>>();
        List<ExitCodeRange> exitCodes = this.getExitCodes();
        exitCodes.stream().filter(ExitCodeRange::filterNonDefaultExitCodes).flatMap(exitCode -> {
            List<OnStatement> onStmts = this.createOn((ExitCodeRange)exitCode);
            Do dos = this.createDo((ExitCodeRange)exitCode);
            return onStmts.stream().map(stmt -> stmt.addDo(dos));
        }).forEach(x -> x.accept(result::put));
        return result;
    }

    private Do createDo(ExitCodeRange exitCode) {
        if (exitCode.status == ExitCodeStatus.SUCCESS) {
            return Do.createDoOk();
        }
        return Do.createDoNotOk();
    }

    private List<OnStatement> createOn(ExitCodeRange exitCode) {
        if (!exitCode.isRange()) {
            return List.of(OnStatement.createOnCompletionStatus((int)this.parseInteger(exitCode.range).orElse(255)));
        }
        List<Integer> lst = Stream.of(exitCode.range.split("-")).map(x -> this.parseInteger((String)x).orElse(255)).toList();
        return List.of(OnStatement.createOnCompletionStatusLessThenEquals((int)lst.getLast()), OnStatement.createOnCompletionStatusGreaterThenEquals((int)lst.getFirst()));
    }

    private Optional<Integer> parseInteger(String number) {
        try {
            return Optional.of(new BigInteger(number).intValue());
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    private List<ExitCodeRange> getExitCodes() {
        Optional exitCodeList = this.dSeriesJobData.getAllDecnedElementByMultipleName(new String[]{"exitcodelist", "app:exitcodelist"}).stream().findFirst();
        return exitCodeList.map(lst -> lst.getAllDecnedElementByMultipleName(new String[]{"exitcode", "app:exitcode"}).stream().map(element -> new ExitCodeRange(element.getValueOfFirstChildElementByName(new String[]{"app:exitcoderange", "exitcoderange"}), element.getValueOfFirstChildElementByName(new String[]{"app:exitcodestate", "exitcodestate"}))).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static class ExitCodeRange {
        public final String range;
        public final ExitCodeStatus status;

        public ExitCodeRange(String range, String status) {
            this.range = range.trim();
            this.status = ExitCodeStatus.from(status);
        }

        public boolean filterNonDefaultExitCodes() {
            List<String> ignoreCodes = List.of("1-9999", "1-999");
            boolean isNotCtmDefaultSuccess = this.status == ExitCodeStatus.SUCCESS && !this.range.equals("0");
            boolean isNotCtmDefaultFailure = this.status == ExitCodeStatus.FAILURE && !ignoreCodes.contains(this.range);
            return isNotCtmDefaultSuccess || isNotCtmDefaultFailure;
        }

        private boolean isRange() {
            return !this.range.startsWith("-") && this.range.contains("-");
        }
    }

    static enum ExitCodeStatus {
        SUCCESS,
        FAILURE;


        public static ExitCodeStatus from(String status) {
            if (SUCCESS.toString().equalsIgnoreCase(status)) {
                return SUCCESS;
            }
            return FAILURE;
        }
    }
}

