/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.stream.Stream;

public class EventsVariableHandler {
    private final String eventFilePath;
    private final FileSystem fileSystem;

    EventsVariableHandler(String eventFilePath, FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.eventFilePath = eventFilePath;
    }

    public EventsVariableHandler(String eventFilePath) {
        this(eventFilePath, FileSystems.getDefault());
    }

    public void handle(DSeriesJob dSeriesJob) {
        try {
            XmlElement eventXml = XmlLoader.from((String)Files.readString(this.fileSystem.getPath(this.eventFilePath, new String[0])));
            Stream<EventVariable> variables = eventXml.getAllDecnedElementByName("even:variable").stream().map(EventVariable::new).filter(EventVariable::isNotEmpty);
            variables.forEach(variable -> dSeriesJob.addAutoEdits(variable.name, variable.value));
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private static class EventVariable {
        private final String name;
        private final String value;

        public EventVariable(XmlElement element) {
            this.name = element.getValueOfFirstChildElementByName("even:property");
            this.value = element.getValueOfFirstChildElementByName("even:value");
        }

        public boolean isNotEmpty() {
            return !this.name.isEmpty();
        }
    }
}

