/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.transformer.sched_entities.DefaultSchedEntity;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.dSeries.CalendarConvertor;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.dSeries.DependenciesConvertor;
import com.bmc.ctmconvert.dSeries.DseriesData;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.EventHandler;
import com.bmc.ctmconvert.dSeries.GlobalVariables;
import com.bmc.ctmconvert.dSeries.RbcGenerator;
import com.bmc.ctmconvert.dSeries.assessment.resources.ResourceData;
import com.bmc.ctmconvert.dSeries.file_monitor.EventItem;
import com.bmc.ctmconvert.dSeries.file_monitor.FileMonitorHandler;
import com.bmc.ctmconvert.dSeries.scheduling.EventScheduling;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DseriesDefs
implements SourceDefinitions {
    static final String DEFAULT_CALENDAR = "SYSTEM";
    private final HashMap<String, Document> nameToApplXmlContentMap;
    private final DseriesData data;
    private final Collection<ResourceData> resources;
    private final GlobalVariables globalVariables;
    private final CalendarConvertor calendarConvertor;
    private final EventHandler eventHandler;
    RulesDataSet rules;
    private final XmlLoader xmlLoader;
    private final RbcGenerator rbcGenerator;
    private final ArrayList<String> messages;
    private final UniqueValueGenerator uniqueValueGenerator;
    private FileMonitorHandler fileMonitorHandler;

    private void mapAppXml(String appxmlFileName, InputStream inputStream) {
        try {
            Node rootCandidate;
            Document appXmlDoc = this.xmlLoader.parse(inputStream);
            for (rootCandidate = appXmlDoc.getDocumentElement(); rootCandidate != null && !rootCandidate.getNodeName().toLowerCase().matches("(app\\s*:\\s*)?appl"); rootCandidate = rootCandidate.getNextSibling()) {
            }
            if (rootCandidate == null) {
                return;
            }
            String applName = rootCandidate.getAttributes().getNamedItem("name").getNodeValue();
            this.nameToApplXmlContentMap.put(applName, appXmlDoc);
        }
        catch (IOException | SAXException e) {
            ConversionLogger.getLogger().info("Failed to load file: " + appxmlFileName + "\n" + e.getMessage());
        }
    }

    public DseriesDefs(DseriesData data, CalendarConvertor calendarConvertor, GlobalVariables globalVariables, RulesDataSet rules, Collection<ResourceData> resources) {
        this.data = data;
        this.rules = rules;
        this.rbcGenerator = new RbcGenerator();
        this.calendarConvertor = calendarConvertor;
        this.globalVariables = globalVariables;
        this.xmlLoader = new XmlLoader();
        this.messages = new ArrayList();
        this.eventHandler = new EventHandler(this);
        this.nameToApplXmlContentMap = new HashMap();
        this.uniqueValueGenerator = new UniqueValueGenerator();
        this.resources = resources;
    }

    public void init() throws ConvertorCancelClickException {
        Map<String, InputStream> calXmls = this.data.getCalXml();
        calXmls.forEach(this.calendarConvertor::convertCalendars);
        Map<String, InputStream> appXmls = this.data.getApplXml();
        appXmls.forEach(this::mapAppXml);
        Map<String, InputStream> evtXmls = this.data.getEvtXml();
        List<EventItem> eventsData = evtXmls.entrySet().stream().map(entry -> this.eventHandler.handleEvent((String)entry.getKey(), (InputStream)entry.getValue())).collect(Collectors.toList());
        this.fileMonitorHandler = new FileMonitorHandler(this.getTopLevelEntities(), eventsData).handle();
        appXmls = this.data.getApplXml();
        appXmls.forEach((key, value) -> DependenciesConvertor.instance(this).handleExternalJobs((String)key, (InputStream)value));
        this.createResourceActions();
    }

    private void createResourceActions() {
        this.resources.forEach(resource -> {
            HashMap<String, String> action = new HashMap<String, String>();
            action.put("ACTENTTYPE", "QR");
            action.put("ACTENTNAME", resource.getName());
            action.put("ACTENTQTY", resource.getValidatedMaxAvailability(this.messages));
            action.put("JOBID", "");
            action.put("ACTSTATUS", "0");
            Reporter.addAction(action);
        });
    }

    public AttrHolderList getTopLevelEntities() {
        return this.eventHandler.getTopLevel();
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return new AttrHolderList();
    }

    public void finalize_() {
        try (DefCalFile calendarWriter = this.calendarConvertor.getCalendarWriter();){
            calendarWriter.write(CalendarConvertor.getAllDaysCalendar(), false);
            calendarWriter.writeRBC(CalendarConvertor.getEveryDayCalendar());
            for (Properties rbc : this.rbcGenerator.getControlMLevelRbcs()) {
                rbc.setProperty("DATACENTER", Params.instance().getDatacenterName());
                calendarWriter.writeRBC(rbc);
            }
            DependenciesConvertor.destroy();
        }
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        String evntName = attributes.getAttr("Name");
        String applName = this.getApplName(evntName).orElse("NoApplNameFound");
        if (this.fileMonitorHandler.isFileWatcherFolder(attributes)) {
            return this.fileMonitorHandler.createFileWatcherFolder(evntName, this.uniqueValueGenerator);
        }
        Optional<Node> child = this.getApplNode(applName);
        if (child.isEmpty()) {
            String message = "event " + evntName + " Does not contains the specified application ";
            ConversionLogger.getLogger().info(message);
            Reporter.addMessage(this.messages, (String)"ERR16002", (String)evntName, (String[])new String[]{evntName, applName});
            SchedEntity.TYPE t = SchedEntity.TYPE.SMART_TABLE;
            return new DefaultSchedEntity(this, evntName, t){};
        }
        return new DSeriesJob(child.get(), attributes, this);
    }

    protected List<EventScheduling.Scheduling> getEvtSchedules(String appName) {
        return Optional.ofNullable(this.eventHandler).map(eh -> eh.getSchedBYEvent(appName)).orElse(Collections.emptyList());
    }

    public String getApplicationCalendar(String eventName) {
        Optional<String> toRet = this.eventHandler.getCalendar(eventName);
        return toRet.orElse(DEFAULT_CALENDAR);
    }

    private Optional<String> getApplName(String evntName) {
        return this.eventHandler.getAppByEventName(evntName);
    }

    private Optional<Node> getApplNode(String applName) {
        Document applXml = this.nameToApplXmlContentMap.get(applName);
        if (applXml == null) {
            return Optional.empty();
        }
        Node child = DseriesGlobals.findChildNodeDFS(applXml, "appl", "name", applName);
        if (child == null) {
            return Optional.empty();
        }
        return Optional.of(child);
    }

    public DependenciesConvertor getDependenciesConvertor() {
        return DependenciesConvertor.instance(this);
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder attributes) {
        return null;
    }

    public String getIdFieldName() {
        return "Name";
    }

    public String getEntNameFieldName() {
        return null;
    }

    public String getParentEntFieldName() {
        return null;
    }

    public boolean hasChildren(String entId) {
        return false;
    }

    public void createDependencies(String root) {
    }

    public void applyFilter(String root) {
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        return Collections.emptyList();
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        return Collections.emptyList();
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        return Collections.emptyList();
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return Collections.emptyList();
    }

    public Set<Properties> createTags(String root) {
        return Collections.emptySet();
    }

    public boolean isStandAloneGrouped() {
        return false;
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return entAttr.getAttr("Type").toLowerCase().matches("(app:)?\\s*appl");
    }

    public ArrayList<String> getGeneralMessages() {
        this.addMessagesAboutUnconvertedCalendars();
        return this.messages;
    }

    private void addMessagesAboutUnconvertedCalendars() {
        LinkedHashMap<String, Set<String>> unconverted = this.calendarConvertor.getUnconverted();
        for (Map.Entry<String, Set<String>> entry : unconverted.entrySet()) {
            String calendar = entry.getKey();
            entry.getValue().forEach(innerCalendar -> Reporter.addMessage(this.messages, (String)"WRN16012", (String)("## Calendar Conversion (" + calendar + ")"), (String[])new String[]{calendar, innerCalendar}));
        }
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public RulesDataSet getRules() {
        return this.rules;
    }

    public UniqueValueGenerator getUniqueValueGenerator() {
        return this.uniqueValueGenerator;
    }

    public RbcGenerator getRbcGenerator() {
        return this.rbcGenerator;
    }

    public List<String> getEventsOfApp(String applName) {
        return this.eventHandler.getEventsOfApp(applName);
    }

    public static class DseriesAttrHolder
    extends AttrHolder {
        private final String evtName;
        private static final String[] fakeAttrHeader = new String[]{"FilePath", "Name", "Type", "ParentName"};

        public DseriesAttrHolder(String[] values, String evtName) {
            super(values, DseriesAttrHolder.getHeader());
            this.evtName = evtName;
        }

        public String getEvtName() {
            return this.evtName;
        }

        private static HashMap<String, Integer> getHeader() {
            HashMap<String, Integer> headerMap = new HashMap<String, Integer>();
            for (int i = 0; i < fakeAttrHeader.length; ++i) {
                headerMap.put(fakeAttrHeader[i], i);
            }
            return headerMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DseriesAttrHolder that = (DseriesAttrHolder)((Object)o);
            return Objects.equals(this.evtName, that.evtName);
        }

        public int hashCode() {
            return Objects.hash(this.evtName);
        }
    }
}

