/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dSeries.DseriesData;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataReader {
    private final Path dataDir;
    private final DseriesData dseriesData;

    public DataReader(Path dataDir, DseriesData dseriesData) {
        this.dataDir = dataDir;
        this.dseriesData = dseriesData;
    }

    public void readAppFiles() {
        BiConsumer<String, Supplier<InputStream>> consumer = this.dseriesData::addAppXml;
        DseriesGlobals.XML_TYPE app = DseriesGlobals.XML_TYPE.APP;
        this.readDir(consumer, app);
    }

    private void readDir(BiConsumer<String, Supplier<InputStream>> consumer, DseriesGlobals.XML_TYPE xmlType) {
        Path inputDir = DseriesData.getInputDir(xmlType, this.dataDir);
        if (!Files.isDirectory(inputDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.list(inputDir);){
            List appXmls = files.filter(appXmlPath -> appXmlPath.toUri().toString().endsWith(".xml")).collect(Collectors.toList());
            for (Path path : appXmls) {
                PathInputStreamSupplier inputStreamSuplier = new PathInputStreamSupplier(path);
                consumer.accept(path.toString(), inputStreamSuplier);
            }
        }
        catch (IOException e1) {
            ExceptionHandler.writeToExceptionFile((Exception)e1);
            throw new VarsIoException(e1);
        }
    }

    public void readVarFiles() {
        BiConsumer<String, Supplier<InputStream>> consumer = (path, inputStreamSuplier) -> this.dseriesData.addVarXml((Supplier<InputStream>)inputStreamSuplier);
        DseriesGlobals.XML_TYPE app = DseriesGlobals.XML_TYPE.VAR;
        this.readDir(consumer, app);
    }

    public void readEvtFiles() {
        BiConsumer<String, Supplier<InputStream>> consumer = this.dseriesData::addEvtXml;
        DseriesGlobals.XML_TYPE evt = DseriesGlobals.XML_TYPE.EVT;
        this.readDir(consumer, evt);
    }

    public void readCalFiles() {
        BiConsumer<String, Supplier<InputStream>> consumer = this.dseriesData::addCalXml;
        DseriesGlobals.XML_TYPE cal = DseriesGlobals.XML_TYPE.CAL;
        this.readDir(consumer, cal);
    }

    public void readResourceFiles() {
        BiConsumer<String, Supplier<InputStream>> consumer = this.dseriesData::addResourceXml;
        DseriesGlobals.XML_TYPE cal = DseriesGlobals.XML_TYPE.RESOURCE;
        this.readDir(consumer, cal);
    }

    private static final class PathInputStreamSupplier
    implements Supplier<InputStream> {
        private final Path path;

        private PathInputStreamSupplier(Path path) {
            this.path = path;
        }

        @Override
        public InputStream get() {
            InputStream newInputStream = new ByteArrayInputStream("".getBytes());
            try {
                newInputStream = Files.newInputStream(this.path, new OpenOption[0]);
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info("Failed to load file: " + String.valueOf(this.path) + "\n" + e.getMessage());
            }
            return newInputStream;
        }
    }

    public static class VarsIoException
    extends RuntimeException {
        public VarsIoException(IOException e) {
            super(e);
        }
    }
}

