/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.CtmPriority;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dSeries.CalendarConvertor;
import com.bmc.ctmconvert.dSeries.ConditionalScheduleHandler;
import com.bmc.ctmconvert.dSeries.ConvertedNotification;
import com.bmc.ctmconvert.dSeries.DSeriesFtpConvertor;
import com.bmc.ctmconvert.dSeries.DSeriesRetryHandler;
import com.bmc.ctmconvert.dSeries.DependenciesConvertor;
import com.bmc.ctmconvert.dSeries.DoNotTriggerIfActive;
import com.bmc.ctmconvert.dSeries.DseriesDefs;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.EventsVariableHandler;
import com.bmc.ctmconvert.dSeries.ExitCodeListHandler;
import com.bmc.ctmconvert.dSeries.FiledEditorValues;
import com.bmc.ctmconvert.dSeries.MicroFocusJobConverter;
import com.bmc.ctmconvert.dSeries.NotificationsConvertor;
import com.bmc.ctmconvert.dSeries.PeopleSoftHandler;
import com.bmc.ctmconvert.dSeries.RbcGenerator;
import com.bmc.ctmconvert.dSeries.ResolvedString;
import com.bmc.ctmconvert.dSeries.WaitForAncestorHandler;
import com.bmc.ctmconvert.dSeries.ZOSHandler;
import com.bmc.ctmconvert.dSeries.as400.AS400Convertor;
import com.bmc.ctmconvert.dSeries.database.DbProcedureHandler;
import com.bmc.ctmconvert.dSeries.database.SqlJobHandler;
import com.bmc.ctmconvert.dSeries.sap.SapHandler;
import com.bmc.ctmconvert.dSeries.scheduling.CyclicSchedulingHandler;
import com.bmc.ctmconvert.dSeries.scheduling.EventScheduling;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.ListUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSeriesJob
implements SchedEntity {
    public static final String ENDS_WITH_AM_OR_PM = "(?i)[ap]m$";
    public static final String TIME_FORMAT = "%02d%02d";
    public static final String START_TIME_REGEX = "(?<startTime>[0-9]+:[0-9]+(:[0-9]+)?)\\s*((?<ampm>[ap]m)|gmt)?";
    static final String SMART_TABLE_NAME = "SMART_TABLE_NAME";
    static final String[] delayedConversionElements = new String[]{"applid", "cmdname", "args", "isscript", "agent", "envarlist", "filecreate", "filedelete", "fileexist", "filename", "filenotexist", "fileupdate", "jobname", "user", "states"};
    private static final CtmPriority priorityCalculator = new CtmPriority(0, 99);
    public static final String EMAIL_NOTIFICATION = "notify";
    public static final String ALERT_NOTIFICATION = "alert_notify";
    private final Properties ctmJobAttributes;
    private final ArrayList<String> messages = new ArrayList();
    private final String evntName;
    private boolean isDsJob;
    HashMap<String, Node> defaults;
    Map<String, List<ConvertedNotification>> notifications;
    private IAttrHolder captureAttrs;
    private Node originalNode;
    private final List<SchedEntity> children;
    private ArrayList<AssistingJob> scriptHolders;
    private LinkedHashSet<String> optionalAttrs;
    private LinkedHashMap<String, String> autoedits = new LinkedHashMap();
    private final DSeriesJob parent;
    private Set<Properties> myRbcs;
    private HashSet<Properties> quantitativeResources;
    private RulesDataSet rules;
    protected FiledEditorValues fieldValues;
    private DseriesDefs defs;
    private DependenciesConvertor dependencyConvertor;
    private final CyclicSchedulingHandler cyclicSchedulingHandler = new CyclicSchedulingHandler(this);
    private boolean isValid;
    private final LinkedHashMap<Properties, List<Properties>> onDoStmts = new LinkedHashMap();
    private final List<Properties> controlResources;
    private final List<Properties> inConditions;
    private final List<Properties> outConditions;
    private final Node jobNode;

    public DSeriesJob(Node jobNode, DSeriesJob parent, DseriesDefs defs) {
        this(jobNode, defs, parent.getEventName(), parent);
        this.init();
    }

    public DSeriesJob(Node jobNode, IAttrHolder attributes, DseriesDefs defs) {
        this(jobNode, defs, attributes.getAttr("Name"), null);
        this.captureAttrs = attributes;
        String fixedEventName = FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", this.evntName, true, null, null, this.getMessages());
        this.fieldValues.setCompetitorValue("event name", fixedEventName);
        this.setContext();
        this.init();
        this.createEventVariables(attributes.getAttr("FilePath"));
    }

    private void createEventVariables(String eventFilePath) {
        new EventsVariableHandler(eventFilePath).handle(this);
    }

    public DSeriesJob(Node jobNode, DseriesDefs defs, String eventName, DSeriesJob parent) {
        this.jobNode = jobNode;
        this.parent = parent;
        this.initGlobalJobFields(jobNode, defs);
        this.ctmJobAttributes = new Properties();
        this.evntName = eventName;
        this.isDsJob = true;
        this.children = new ArrayList<SchedEntity>();
        this.isValid = true;
        this.controlResources = new ArrayList<Properties>();
        this.inConditions = new ArrayList<Properties>();
        this.outConditions = new ArrayList<Properties>();
        this.notifications = new LinkedHashMap<String, List<ConvertedNotification>>();
    }

    private static boolean isConverted(Node node) {
        boolean toRet = false;
        for (String delayedConversionElement : delayedConversionElements) {
            if (!DseriesGlobals.elemntNameMatch(node, delayedConversionElement)) continue;
            toRet = true;
            break;
        }
        return toRet;
    }

    public String getEventName() {
        return this.evntName;
    }

    private void initGlobalJobFields(Node jobNode, DseriesDefs defs) {
        this.defs = defs;
        this.rules = this.defs.getRules();
        this.originalNode = jobNode;
        this.dependencyConvertor = this.defs.getDependenciesConvertor();
        String parentFolderName = Optional.ofNullable(this.parent).map(DSeriesJob::getJobName).orElse(null);
        this.fieldValues = new FiledEditorValues(this.rules, parentFolderName);
    }

    public static List<Node> nodeListToList(NodeList childNodes) {
        return IntStream.range(0, childNodes.getLength()).mapToObj(childNodes::item).collect(Collectors.toList());
    }

    private void init() {
        this.initFieldEditorValues();
        Node envVarNode = DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "envarlist", null, null);
        if (envVarNode != null && envVarNode.getParentNode() == this.getOriginalNode()) {
            this.varlistToAutoedits(envVarNode);
        }
        NodeList childNodes = this.getOriginalNode().getChildNodes();
        List<Node> childNodeList = DSeriesJob.nodeListToList(childNodes);
        this.handleChildNodes(childNodeList);
        List<EventScheduling.Scheduling> eventSchedules = this.getEventSchedules();
        boolean hasInActiveOnlyEvent = eventSchedules.stream().anyMatch(EventScheduling.Scheduling::isInActiveOnly);
        switch (this.type()) {
            case JOB: {
                this.ctmJobAttributes.setProperty("MEMNAME", this.getOriginalJobName());
                this.ctmJobAttributes.setProperty("TAG_RELATIONSHIP", "OR");
                this.ctmJobAttributes.setProperty("ACTIVE_FROM", "");
                this.ctmJobAttributes.setProperty("ACTIVE_TILL", "");
                this.convertTaskType();
                new ConditionalScheduleHandler(this).handle();
                this.convertHoldAndDoNotRunToUserConfirmation();
                this.onDoStmts.putAll(new ExitCodeListHandler(this.getRootElement()).handle());
                this.handleExternalOutCondition();
                break;
            }
            case SMART_TABLE: {
                break;
            }
        }
        this.setStartTime();
        this.cyclicSchedulingHandler.processCyclicDefinitions(eventSchedules);
        this.issueUnsupportedSchedulingMessage(eventSchedules);
        this.allowSubmissionPastNewDay();
        this.doNotRunIfOlderGenerationIsRun(hasInActiveOnlyEvent);
        this.addWarningForOnEnterAndOnLoadScripts();
    }

    private void doNotRunIfOlderGenerationIsRun(boolean hasInActiveOnlyEvent) {
        switch (this.type()) {
            case JOB: {
                new WaitForAncestorHandler(this, this.rules).handle();
                break;
            }
            case SMART_TABLE: {
                if (hasInActiveOnlyEvent) {
                    new DoNotTriggerIfActive(this).handle();
                    break;
                }
                new WaitForAncestorHandler(this, this.rules).handle();
            }
        }
    }

    private void handleChildNodes(List<Node> childNodeList) {
        childNodeList.forEach(childNode -> {
            if (childNode.getNodeType() == 1) {
                if (DseriesGlobals.elemntNameMatch(childNode, "comment")) {
                    String commentText = childNode.getTextContent();
                    if (commentText != null) {
                        this.ctmJobAttributes.setProperty("DESCRIPTION", commentText);
                    }
                } else if (DseriesGlobals.elemntNameMatch(childNode, "script_lib")) {
                    if (this.scriptHolders == null) {
                        this.scriptHolders = new ArrayList();
                    }
                    this.scriptHolders.addAll(this.handleScriptsLib((Node)childNode));
                } else if (this.isJobNode((Node)childNode) && this.isFolder()) {
                    DSeriesJob dSeriesJob = new DSeriesJob((Node)childNode, this, this.defs);
                    if (!ExtrnalJobPredicate.isExternalJob(childNode)) {
                        this.children.add(dSeriesJob);
                    }
                } else if (DseriesGlobals.elemntNameMatch(childNode, "userid")) {
                    String userid = childNode.getTextContent();
                    if (userid != null) {
                        this.fieldValues.setCompetitorValue("userid", userid);
                    }
                } else if (DseriesGlobals.elemntNameMatch(childNode, "subappl")) {
                    String subappl = childNode.getTextContent();
                    if (subappl != null) {
                        this.fieldValues.setCompetitorValue("subappl", subappl);
                    }
                } else if (DseriesGlobals.elemntNameMatch(childNode, "dependencies")) {
                    this.getDependenyConvertor().registerConditions(this, (Node)childNode);
                } else if (DseriesGlobals.elemntNameMatch(childNode, "schedules")) {
                    List<EventScheduling.Scheduling> schedules = this.defs.getRbcGenerator().getSchedules((Node)childNode);
                    this.cyclicSchedulingHandler.processCyclicDefinitions(schedules);
                    this.myRbcs = schedules.stream().flatMap(x -> x.getRuleBasedCalendars().stream()).collect(Collectors.toSet());
                    this.issueUnsupportedSchedulingMessage(schedules);
                    this.addRbcsWithMessage(this.myRbcs, schedules);
                    this.defs.getRbcGenerator().addMessages((Node)childNode, (List<String>)this.getMessages(), this.getJobFullPathName(), this.defs.getApplicationCalendar(this.evntName));
                } else if (DseriesGlobals.elemntNameMatch(childNode, "resourcedependencies")) {
                    this.handleResourceNode((Node)childNode);
                } else if (DseriesGlobals.elemntNameMatch(childNode, "notifylist")) {
                    this.addNotifyListToNotifications((Node)childNode, EMAIL_NOTIFICATION, childNodeList);
                } else if (DseriesGlobals.elemntNameMatch(childNode, "alert_notifylist")) {
                    this.addNotifyListToNotifications((Node)childNode, ALERT_NOTIFICATION, childNodeList);
                } else if (DseriesGlobals.elemntNameMatch(childNode, "retry")) {
                    new DSeriesRetryHandler(this);
                } else if (DseriesGlobals.elemntNameMatch(childNode, "defaults")) {
                    this.setDefaults((Node)childNode);
                } else if (!DSeriesJob.isConverted(childNode)) {
                    String origJobType = this.getOriginalNode().getNodeName().trim().replaceAll("^\\s*app:\\s*", "");
                    if (DseriesGlobals.isItUnSupportedJob(origJobType)) {
                        return;
                    }
                    String parentNodeName = "root element";
                    String nodeName = childNode.getNodeName();
                    if (childNode.getParentNode() != null) {
                        parentNodeName = childNode.getParentNode().getNodeName();
                    }
                    this.addMessage("WRN16025", nodeName, parentNodeName);
                }
            }
        });
    }

    private boolean isFolder() {
        return this.type() != SchedEntity.TYPE.JOB;
    }

    private void issueUnsupportedSchedulingMessage(List<EventScheduling.Scheduling> eventSchedules) {
        String notSupported = eventSchedules.stream().flatMap(s -> s.getNotSupported().stream()).filter(scheduling -> !scheduling.isEmpty()).collect(Collectors.joining(" "));
        if (!notSupported.isBlank()) {
            this.addMessage("WRN16023", this.getJobName(), notSupported);
        }
    }

    private void allowSubmissionPastNewDay() {
        boolean isNotCyclic;
        boolean hasTimeFrom = Optional.ofNullable(this.getAttr("TIMEFROM")).filter(s -> !s.isBlank()).isPresent();
        boolean bl = isNotCyclic = !this.cyclicSchedulingHandler.isCyclic();
        if (isNotCyclic && hasTimeFrom) {
            this.addAttribute("TIMETO", ">");
        }
    }

    private void convertHoldAndDoNotRunToUserConfirmation() {
        DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "hold").or(() -> DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "donotrun")).or(this::getHoldFromParentApplicationOptions).map(Node::getTextContent).filter(v -> v.equalsIgnoreCase("true")).ifPresent(value -> this.addAttribute("CONFIRM", "1"));
    }

    private Optional<Node> getHoldFromParentApplicationOptions() {
        Optional<Element> parentElement = Optional.ofNullable(this.getParent().getRootElement()).map(XmlElement::getElement);
        return parentElement.flatMap(element -> DseriesGlobals.findChildNodeDFS(element, "applopts")).flatMap(options -> DseriesGlobals.findChildNodeDFS(options, "hold"));
    }

    public List<EventScheduling.Scheduling> getEventSchedules() {
        return Optional.ofNullable(this.captureAttrs).map(a -> a.getAttr("Name")).map(name -> this.defs.getEvtSchedules((String)name)).orElse(Collections.emptyList());
    }

    private void setContext() {
        String context = this.getApplicationName();
        int indexOfUnder = context.indexOf("_");
        if (indexOfUnder > -1) {
            context = context.substring(0, indexOfUnder);
        }
        this.autoedits.put("%%APPL_CONTEXT", context);
    }

    private void initFieldEditorValues() {
        String tmpJobName = this.parent == null ? this.evntName : this.getOriginalNode().getAttributes().getNamedItem("name").getNodeValue();
        Node qualifier = this.getOriginalNode().getAttributes().getNamedItem("qualifier");
        if (qualifier != null && !qualifier.getNodeValue().isEmpty()) {
            this.fieldValues.setCompetitorValue("qualifier", this.resolveStringsSuppressMessage(qualifier.getNodeValue(), false));
        }
        this.fieldValues.setCompetitorValue("appname", this.getTopLevelName());
        this.fieldValues.setCompetitorValue("jobname", tmpJobName);
        String jobName = this.resolveStrings(tmpJobName, false, "Jobname");
        this.fieldValues.setCompetitorValue("jobname", jobName);
    }

    private void setDefaults(Node node) {
        if (this.defaults == null) {
            this.defaults = new HashMap();
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (childNodes.item(i).getNodeType() != 1) continue;
            this.defaults.put(childNodes.item(i).getNodeName().replaceAll("^app:\\s*", ""), childNodes.item(i));
        }
    }

    public Optional<Node> getDefault(String nodeName) {
        BooleanSupplier alwaysGetParentDefaults = () -> true;
        return this.getDefault(nodeName, alwaysGetParentDefaults);
    }

    private Optional<Node> getDefault(String nodeName, BooleanSupplier shouldGetParentDefaults) {
        Supplier<Optional> getParentDefaults = () -> {
            if (shouldGetParentDefaults.getAsBoolean()) {
                return Optional.ofNullable(this.parent).flatMap(p -> p.getDefault(nodeName));
            }
            return Optional.empty();
        };
        return Optional.ofNullable(this.defaults).map(d -> d.getOrDefault(nodeName, null)).or(getParentDefaults);
    }

    private ArrayList<AssistingJob> handleScriptsLib(Node scriptLibNode) {
        ArrayList<AssistingJob> jobsToReturn = new ArrayList<AssistingJob>();
        if (scriptLibNode != null && scriptLibNode.getNodeType() == 1 && DseriesGlobals.elemntNameMatch(scriptLibNode, "script_lib")) {
            NodeList scriptDefList = scriptLibNode.getChildNodes();
            for (int i = 0; i < scriptDefList.getLength(); ++i) {
                if (scriptDefList.item(i) == null || !DseriesGlobals.elemntNameMatch(scriptDefList.item(i), "script_definition")) continue;
                AssistingJob jobToAdd = new AssistingJob(SchedEntity.TYPE.JOB);
                jobToAdd.setAttribute("JOBNAME", scriptDefList.item(i).getAttributes().getNamedItem("name").getNodeValue());
                jobToAdd.setAttribute("USE_INSTREAM_JCL", "Y");
                jobToAdd.setAttribute("INSTREAM_JCL", scriptDefList.item(i).getTextContent());
                jobToAdd.setAttribute("PARENT_TABLE", this.getJobName());
                jobToAdd.setAttribute("TAG_RELATIONSHIP", "OR");
                jobToAdd.setAttribute("MEMNAME", "DEFAULT_MEMNAME");
                jobToAdd.setAttribute("GROUP", this.getGroup());
                jobToAdd.setAttribute("APPLICATION", this.getApplication());
                if (Params.instance().getGUIVersion().equals("7")) {
                    jobToAdd.setAttribute("TASKTYPE", "Dummy");
                } else {
                    jobToAdd.setAutoedit("%%$BMCWAIORIGTYPE", "Job");
                }
                jobsToReturn.add(jobToAdd);
                this.addMessage("INF16003", scriptDefList.item(i).getAttributes().getNamedItem("name").getNodeValue());
            }
        }
        return jobsToReturn;
    }

    private void varlistToAutoedits(Node node) {
        for (Node varNode = node.getFirstChild(); varNode != null; varNode = varNode.getNextSibling()) {
            if (varNode.getNodeType() != 1 || !DseriesGlobals.elemntNameMatch(varNode, "envar")) continue;
            String varName = null;
            String varValue = null;
            for (Node varChild = varNode.getFirstChild(); varChild != null && (varName == null || varValue == null); varChild = varChild.getNextSibling()) {
                if (varChild.getNodeType() != 1) continue;
                if (DseriesGlobals.elemntNameMatch(varChild, "envarname")) {
                    varName = varChild.getTextContent();
                    continue;
                }
                if (DseriesGlobals.elemntNameMatch(varChild, "envarvalue")) {
                    varValue = varChild.getTextContent();
                    continue;
                }
                this.addMessage("WRN16001", varChild.getNodeName(), varNode.getNodeName());
            }
            if (varName == null || varValue == null) continue;
            this.autoedits.put("%%" + varName, varValue);
        }
    }

    private void handleResourceNode(Node resourcesNode) {
        for (Node currChild = resourcesNode.getFirstChild(); currChild != null; currChild = currChild.getNextSibling()) {
            if (currChild.getNodeType() != 1) continue;
            if (DseriesGlobals.elemntNameMatch(currChild, "resource_acquiring_priority")) {
                int origPriority;
                String priority = null;
                if (currChild.getTextContent() != null && currChild.getTextContent().matches("[0-9]+") && (origPriority = Integer.parseInt(currChild.getTextContent())) >= 0 && origPriority <= 100) {
                    priority = priorityCalculator.calculatePriority(origPriority);
                }
                if (priority == null) continue;
                this.ctmJobAttributes.setProperty("PRIORITY", priority);
                continue;
            }
            if (DseriesGlobals.elemntNameMatch(currChild, "resource_absorb")) {
                if (currChild.getTextContent() == null || !currChild.getTextContent().equalsIgnoreCase("TRUE")) continue;
                this.ctmJobAttributes.setProperty("CRITICAL", "1");
                continue;
            }
            if (DseriesGlobals.elemntNameMatch(currChild, "resources")) {
                this.addQrs(currChild);
                continue;
            }
            this.addMessage("WRN16001", currChild.getNodeName(), resourcesNode.getNodeName());
        }
    }

    private void addQrs(Node node) {
        for (Node qrNode = node.getFirstChild(); qrNode != null; qrNode = qrNode.getNextSibling()) {
            if (qrNode.getNodeType() != 1) continue;
            if (DseriesGlobals.elemntNameMatch(qrNode, "resource")) {
                Properties tmpProps;
                if (this.quantitativeResources == null) {
                    this.quantitativeResources = new HashSet();
                }
                if ((tmpProps = this.node2qr(qrNode)) == null) continue;
                this.quantitativeResources.add(tmpProps);
                continue;
            }
            this.addMessage("WRN16001", qrNode.getNodeName(), node.getNodeName());
        }
    }

    private Properties node2qr(Node qrNode) {
        Properties toRet = null;
        String qrName = null;
        String qrQuant = null;
        for (Node qrElem = qrNode.getFirstChild(); qrElem != null; qrElem = qrElem.getNextSibling()) {
            if (qrElem.getNodeType() != 1) continue;
            if (DseriesGlobals.elemntNameMatch(qrElem, "resource_reference_name")) {
                qrName = qrElem.getTextContent();
                continue;
            }
            if (DseriesGlobals.elemntNameMatch(qrElem, "resource_acquiring_quantity")) {
                qrQuant = qrElem.getTextContent();
                continue;
            }
            this.addMessage("WRN16001", qrElem.getNodeName(), qrNode.getNodeName());
        }
        if (qrName != null && qrQuant != null) {
            toRet = new Properties();
            qrName = this.resolveStrings(qrName, false, "Quantitative Resource");
            String validatedQuantitativeResourceName = FieldValidation.instance().validateAndReturnFixedValue("QUANTITATIVE_RESOURCE_NAME", qrName);
            toRet.setProperty("NAME", validatedQuantitativeResourceName);
            toRet.setProperty("QUANT", qrQuant);
        }
        return toRet;
    }

    public String getTopLevelName() {
        if (this.parent == null) {
            return this.resolveStrings(this.getOriginalNode().getAttributes().getNamedItem("name").getNodeValue(), "Jobname");
        }
        return this.parent.getTopLevelName();
    }

    private void handleCalendarReporterData(HashSet<Properties> propsRBCHashSet) {
        for (Properties localRBCProp : propsRBCHashSet) {
            String daysCal = localRBCProp.getProperty("DAYSCAL");
            String weekscal = localRBCProp.getProperty("WEEKSCAL");
            String confcal = localRBCProp.getProperty("CONFCAL");
            if (daysCal != null && !CalendarConvertor.isCalendarConverted(daysCal)) {
                this.reportCalendarData(daysCal);
            }
            if (weekscal != null && !CalendarConvertor.isCalendarConverted(weekscal)) {
                this.reportCalendarData(weekscal);
            }
            if (confcal == null || CalendarConvertor.isCalendarConverted(confcal)) continue;
            this.reportCalendarData(confcal);
        }
    }

    private void reportCalendarData(String calendarName) {
        HashMap<String, String> calendarAction = new HashMap<String, String>();
        calendarAction.put("ACTENTTYPE", "CAL");
        calendarAction.put("JOBID", this.getJobFullPathName());
        calendarAction.put("ACTENTNAME", calendarName);
        calendarAction.put("ACTENTQTY", "0");
        calendarAction.put("ACTSTATUS", "0");
        Reporter.addAction(calendarAction);
    }

    private void setStartTime() {
        Node startTimeNode = DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "absolute_in_delay", null, null);
        if (startTimeNode != null && startTimeNode.getParentNode().getParentNode().getParentNode() == this.getOriginalNode()) {
            String rawStartTime = startTimeNode.getTextContent().trim();
            rawStartTime = this.resolveStrings(rawStartTime, false, "absolute_in_delay");
            Matcher startTimeMatcher = Pattern.compile(START_TIME_REGEX, 2).matcher(rawStartTime.trim());
            if (startTimeMatcher.find()) {
                String timeFrom = this.convertTimeFrom(startTimeMatcher.group("startTime"), startTimeMatcher.group("ampm"));
                this.ctmJobAttributes.setProperty("TIMEFROM", timeFrom);
            } else {
                this.addMessage("WRN16003", startTimeNode.getNodeName(), "hh:mm[:ss][am|pm|gmt]", rawStartTime);
            }
        }
    }

    private String convertTimeFrom(String startTime, String ampm) {
        String[] tmp = startTime.split(":");
        int pm = Optional.ofNullable(ampm).map(x -> x.toLowerCase().endsWith("pm") ? 12 : 0).orElse(0);
        int hour = Integer.parseInt(tmp[0]);
        Integer minute = Integer.valueOf(tmp[1]);
        int normalizedHour = hour > 12 ? hour : hour + pm;
        return String.format(TIME_FORMAT, normalizedHour, minute);
    }

    private void convertTaskType() {
        String origJobType = this.getOrigJobType();
        DseriesGlobals.JOB_TYPES_ENUM jobType = DseriesGlobals.getJobTypeFromString(origJobType);
        switch (jobType) {
            case OS: {
                this.toOsJob(origJobType);
                break;
            }
            case SAP_JOB: 
            case SAPBW_JOB: {
                SapHandler sapHandler = new SapHandler(this);
                sapHandler.convert(this.getOriginalNode(), jobType);
                break;
            }
            case FILE: {
                this.toFwJob();
                break;
            }
            case FTP: {
                this.toFTPJob(origJobType);
                break;
            }
            case AS400: {
                new AS400Convertor(this).convert();
                break;
            }
            case EXT_JOB: 
            case LINK: 
            case TASK: {
                this.toDummyJob(origJobType);
                break;
            }
            case SQL_JOB: {
                new SqlJobHandler(this).convert();
                break;
            }
            case DBPROC_JOB: {
                new DbProcedureHandler(this).convert();
                break;
            }
            case ZOS: {
                new ZOSHandler(this, this.parent, this.defs.getUniqueValueGenerator()).convert();
                break;
            }
            case PEOPLE_SOFT: {
                new PeopleSoftHandler(this).convert();
                break;
            }
            case MICRO_FOCUS_JOB: {
                new MicroFocusJobConverter(this).convert();
                break;
            }
            default: {
                this.addMessage("ERR16001", origJobType);
                this.toDummyJob(origJobType);
            }
        }
        if (this.rules.getTaskTypeHandler().isToDummy()) {
            this.ctmJobAttributes.setProperty("TASKTYPE", "Dummy");
        }
    }

    private void toFTPJob(String origJobType) {
        DSeriesFtpConvertor dSeriesFtpConvertor = new DSeriesFtpConvertor(this, this.getOriginalNode(), origJobType);
        dSeriesFtpConvertor.convert();
    }

    private void toDummyJob(String origJobType) {
        this.ctmJobAttributes.put("TASKTYPE", "Dummy");
        this.ctmJobAttributes.put("MEMLIB", "Dummy");
        if (origJobType.equalsIgnoreCase("task")) {
            this.ctmJobAttributes.setProperty("CONFIRM", "0");
        }
    }

    boolean isConfiguredToJob(String command) {
        if (this.rules.getTaskTypeHandler().getJobType().equals("JOB")) {
            for (String taskTypeFilter : this.rules.getTaskTypeHandler().getTaskTypeFilters()) {
                if (!command.toUpperCase().contains(taskTypeFilter.toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    private void toFwJob() {
        String user;
        Node fileUser;
        this.resolveNodeName();
        Node fileNameNode = DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "filename", null, null);
        String watchedFile = null;
        if (fileNameNode != null) {
            watchedFile = fileNameNode.getTextContent();
        }
        if ((fileUser = DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "user", null, null)) != null && (user = fileUser.getTextContent()) != null && !user.isEmpty()) {
            this.fieldValues.setCompetitorValue("userid", user);
        }
        Object size = null;
        String staticTime = null;
        Node fileCreateNode = DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "filecreate", null, null);
        if (fileCreateNode != null) {
            for (Node createElement = fileCreateNode.getFirstChild(); createElement != null; createElement = createElement.getNextSibling()) {
                if (createElement.getNodeType() != 1) continue;
                if (DseriesGlobals.elemntNameMatch(createElement, "filesize")) {
                    size = createElement.getTextContent();
                    continue;
                }
                if (DseriesGlobals.elemntNameMatch(createElement, "filenochange")) {
                    staticTime = createElement.getTextContent();
                    continue;
                }
                this.addMessage("WRN16001", createElement.getNodeName(), fileCreateNode.getNodeName());
            }
        }
        this.ctmJobAttributes.setProperty("MEMLIB", "Not in use for File Watcher jobs");
        this.ctmJobAttributes.setProperty("TASKTYPE", "Job");
        if (fileCreateNode == null || watchedFile == null || watchedFile.isEmpty()) {
            Object reason = "";
            if (fileCreateNode == null) {
                reason = (String)reason + "only <filecreate> jobs are currently converted";
            }
            if (watchedFile == null || watchedFile.isEmpty()) {
                if (!((String)reason).isEmpty()) {
                    reason = (String)reason + " and ";
                }
                reason = (String)reason + "watched file was not provided";
            }
            this.addMessage("WRN16004", new String[]{reason});
        } else {
            String staticInterval;
            String staticItereations;
            if (this.autoedits == null) {
                this.autoedits = new LinkedHashMap();
            }
            if (size == null || ((String)size).isEmpty()) {
                size = "1";
            }
            if (!Params.instance().getGUIVersion().equals("7")) {
                size = (String)size + "B";
            }
            if (staticTime == null || staticTime.isEmpty()) {
                staticTime = "0";
            }
            if (staticTime.equals("0") || !staticTime.matches("^[0-9]+$")) {
                staticItereations = "1";
                staticInterval = "0";
            } else {
                staticItereations = Integer.toString(Integer.parseInt(staticTime) * 2);
                staticInterval = "30";
            }
            this.setOptionalAttribute("APPL_FORM", "File Watcher");
            this.setOptionalAttribute("APPL_TYPE", "FileWatch");
            this.setOptionalAttribute("APPL_VER", "9.0.00.300");
            this.setOptionalAttribute("CM_VER", "8.0.00");
            this.autoedits.put("%%FileWatch-FILE_PATH", this.resolveStrings(watchedFile, true, "monitored file name"));
            this.autoedits.put("%%FileWatch-MODE", "CREATE");
            this.autoedits.put("%%FileWatch-MIN_DET_SIZE", (String)size);
            this.autoedits.put("%%FileWatch-INT_FILE_SEARCHES", "60");
            this.autoedits.put("%%FileWatch-INT_FILESIZE_COMPARISON", staticInterval);
            this.autoedits.put("%%FileWatch-NUM_OF_ITERATIONS", staticItereations);
            this.autoedits.put("%%FileWatch-TIME_LIMIT", "0");
            this.autoedits.put("%%FileWatch-START_TIME", "NOW");
            this.autoedits.put("%%FileWatch-STOP_TIME", "0");
            this.autoedits.put("%%FileWatch-MIN_AGE", "NO_MIN_AGE");
            this.autoedits.put("%%FileWatch-MAX_AGE", "NO_MAX_AGE");
            this.autoedits.put("%%FileWatch-PATH", "Not in use for File Watcher jobs");
            this.autoedits.put("%%FileWatch-FILESIZE_WILDCARD", "N");
        }
    }

    private void toOsJob(String origJobType) {
        this.resolveNodeName();
        String cmdLine = this.resolveStrings(DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "cmdname", null, null).getTextContent(), true, "command line");
        Node argsNode = DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "args", null, null);
        String cmdArgs = argsNode == null ? "" : this.resolveStrings(argsNode.getTextContent(), true, "command line argument");
        ArrayList memnameMemlib = GlobalFunctions.string2ArgArr((String)String.format("%s %s", cmdLine, cmdArgs), (boolean)DseriesGlobals.elemntNameMatch(this.getOriginalNode(), "nt_job"));
        String dirSep = DseriesGlobals.elemntNameMatch(this.getOriginalNode(), "nt_job") ? "\\" : "/";
        boolean toCmdline = memnameMemlib == null || memnameMemlib.size() < 2;
        toCmdline = toCmdline || !((String)memnameMemlib.getFirst()).contains(dirSep);
        boolean bl = toCmdline = toCmdline || !this.isConfiguredToJob((String)memnameMemlib.getFirst());
        if (toCmdline) {
            this.ctmJobAttributes.setProperty("TASKTYPE", "Command");
            String commandPrefixesWithShell = this.prependCommandWithShell(cmdLine);
            String commandLine = String.format("%s %s", commandPrefixesWithShell, cmdArgs);
            FieldValidation.instance().cmdLineValidateAndReportMessages(commandLine, this.getJobName(), this.messages);
            this.ctmJobAttributes.setProperty("CMDLINE", commandLine);
        } else {
            this.ctmJobAttributes.setProperty("TASKTYPE", "Job");
            String memname = ((String)memnameMemlib.getFirst()).substring(((String)memnameMemlib.getFirst()).lastIndexOf(dirSep) + 1);
            String memlib = ((String)memnameMemlib.getFirst()).substring(0, ((String)memnameMemlib.getFirst()).lastIndexOf(dirSep));
            this.ctmJobAttributes.setProperty("MEMNAME", memname);
            this.ctmJobAttributes.setProperty("MEMLIB", memlib);
            for (int i = 1; i < memnameMemlib.size(); ++i) {
                if (this.autoedits == null) {
                    this.autoedits = new LinkedHashMap();
                }
                this.autoedits.put(String.format("%%%%PARM%d", i), (String)memnameMemlib.get(i));
            }
        }
        this.addPreCmd(origJobType);
    }

    private void addPreCmd(String origJobType) {
        DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "relative_in_delay").map(Node::getTextContent).flatMap(GlobalFunctions::getNumberFrom).filter(delay -> delay > 0).map(delay -> delay * 60).ifPresent(delay -> {
            String sleepCommand = origJobType.toLowerCase().contains("unix_job") ? "sleep " : "_sleep ";
            this.addAutoEdits("%%PRECMD", sleepCommand + delay);
        });
    }

    private String prependCommandWithShell(String cmdLine) {
        Optional<String> shell = DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "shell").map(Node::getTextContent).filter(s -> !s.isBlank());
        Optional<String> readCommandFromString = DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "isscript").map(Node::getTextContent).filter(s -> s.equals("false")).map(value -> " -c");
        Optional<String> shellPrefix = shell.map(value -> value + readCommandFromString.orElse(""));
        return shellPrefix.map(value -> value + " " + cmdLine).orElse(cmdLine);
    }

    private void resolveNodeName() {
        String nodeId = this.getAgent().or(this::getAgentGroup).or(this::getAgentValueFromApplicationDefaults).orElse("DEFAULT_AGENT");
        String resolvedNodeId = this.resolveStrings(nodeId, "Agent node definition");
        String validatedNodeId = FieldValidation.instance().validateAndReturnFixedValue("NODEID", resolvedNodeId, true, "agent", this.getJobName(), this.getMessages());
        this.ctmJobAttributes.setProperty("NODEID", validatedNodeId);
    }

    private Optional<String> getAgentValueFromApplicationDefaults() {
        return this.getDefault("rununit").map(this::getDefaultAppAgent).filter(value -> !value.equals(""));
    }

    private Optional<String> getAgentGroup() {
        return DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "agentgrp").map(Node::getTextContent);
    }

    private Optional<String> getAgent() {
        return DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "agent").map(Node::getTextContent);
    }

    private void setOptionalAttribute(String name, String value) {
        if (this.optionalAttrs == null) {
            this.optionalAttrs = new LinkedHashSet();
        }
        this.optionalAttrs.add(name);
        this.ctmJobAttributes.setProperty(name, value);
    }

    protected String resolveStrings(String origString, String usage) {
        String toRet = origString;
        if (toRet != null && !toRet.isEmpty()) {
            toRet = this.resolveStrings(origString, false, usage);
        }
        return toRet;
    }

    private String resolveStringsSuppressMessage(String origString, boolean toAutoEdit) {
        return this.resolveStrings(origString, toAutoEdit, null, false);
    }

    protected String resolveStrings(String origString, boolean toAutoEdit, String usage) {
        return this.resolveStrings(origString, toAutoEdit, usage, true);
    }

    private String resolveStrings(String origString, boolean toAutoEdit, String usage, boolean issueMessage) {
        String applicationName = this.getApplicationName();
        ResolvedString resolved = new ResolvedString(origString, this.getAutoedits(), applicationName, this.defs);
        String toRet = toAutoEdit ? resolved.getResolvedValueAutoedits() : resolved.getResolvedValueImmidiate();
        ArrayList<String[]> msgs = resolved.getMessages();
        if (msgs != null && issueMessage) {
            for (String[] msg : msgs) {
                this.addMessage(msg[0], msg[1], usage, msg[2]);
            }
        }
        return toRet;
    }

    public String getApplicationName() {
        return this.parent == null ? this.getOriginalNode().getAttributes().getNamedItem("name").getNodeValue() : this.parent.getTopLevelName();
    }

    public SchedEntity.TYPE type() {
        if (DseriesGlobals.elemntNameMatch(this.getOriginalNode(), "appl")) {
            return SchedEntity.TYPE.SMART_TABLE;
        }
        return SchedEntity.TYPE.JOB;
    }

    public String originalProductID() {
        return null;
    }

    public List<SchedEntity> getChildren() {
        ArrayList<SchedEntity> allChildren = new ArrayList<SchedEntity>();
        if (this.scriptHolders != null && !this.scriptHolders.isEmpty()) {
            for (AssistingJob schedEntity : this.scriptHolders) {
                schedEntity.setAttribute("OWNER", this.getAttr("OWNER"));
                schedEntity.setAttribute("AUTHOR", this.getAttr("AUTHOR"));
            }
            allChildren.addAll(this.scriptHolders);
        }
        if (this.children != null && !this.children.isEmpty()) {
            allChildren.addAll(this.children);
        }
        return allChildren;
    }

    public String toString() {
        return "DSeriesJob [getJobName()=" + this.getJobName() + "]";
    }

    private boolean isJobNode(Node childNode) {
        Supplier<Boolean> hasNameAttribute = () -> Optional.ofNullable(childNode).map(Node::getAttributes).map(a -> a.getNamedItem("name")).isPresent();
        return hasNameAttribute.get();
    }

    public List<AssistingJob> getAssistingJobs() {
        return Collections.emptyList();
    }

    public String getAttr(String attrName) {
        String toRet = this.ctmJobAttributes.getProperty(attrName);
        DseriesGlobals.JOB_TYPES_ENUM jobType = DseriesGlobals.getJobTypeFromString(this.getOrigJobType());
        boolean isEditableField = this.fieldValues.isEditableFieldForType(attrName, jobType);
        if (isEditableField) {
            String formattedValue = this.fieldValues.getFormattedValue(attrName);
            toRet = this.resolveStrings(formattedValue, attrName);
            if (!this.fieldValues.getMessages().isEmpty()) {
                this.getMessages().addAll(this.fieldValues.getMessages());
                this.fieldValues.clearMessages();
            }
        }
        boolean toAutoedit = attrName.equals("CMDLINE");
        if (toRet != null) {
            toRet = this.resolveStrings(toRet, toAutoedit, attrName);
        }
        return toRet;
    }

    public List<Properties> getInConds() {
        return ListUtils.union(this.inConditions, this.getDependenyConvertor().getInconds(this));
    }

    public void addInCondition(Properties inCondition) {
        this.inConditions.add(inCondition);
    }

    private DependenciesConvertor getDependenyConvertor() {
        return this.dependencyConvertor;
    }

    public List<Properties> getOutConds() {
        return ListUtils.union(this.outConditions, this.getDependenyConvertor().getOutconds(this));
    }

    public void addOutCondition(Properties outCondition) {
        this.outConditions.add(outCondition);
    }

    public List<Properties> getTags() {
        HashSet<Properties> tmpProps = new HashSet<Properties>();
        String applicationCalendar = this.defs.getApplicationCalendar(this.evntName);
        this.addSchedulesRbcs(tmpProps, applicationCalendar);
        this.addRbcsOfChildren(tmpProps);
        if (this.type() == SchedEntity.TYPE.SMART_TABLE) {
            this.addEventRbcs(tmpProps);
        } else if (!this.hasIncludeRBCs(tmpProps)) {
            this.useParentSchedulingAsDefault(tmpProps);
        }
        this.handleCalendarReporterData(tmpProps);
        if (this.isEmptyOrHasOnlyEmptyRbc(tmpProps)) {
            if (this.isCyclic()) {
                tmpProps.clear();
                tmpProps.add(RbcGenerator.getEveryDayRBC());
            }
        } else if (tmpProps.isEmpty()) {
            tmpProps.add(RbcGenerator.getEmptyRbc());
        }
        return new ArrayList<Properties>(tmpProps);
    }

    private boolean isEmptyOrHasOnlyEmptyRbc(Set<Properties> calendars) {
        return calendars.isEmpty() || calendars.stream().allMatch(calendar -> "EMPTY_RBC".equals(calendar.getProperty("NAME")));
    }

    private void useParentSchedulingAsDefault(HashSet<Properties> tmpProps) {
        Properties rbcStar = new Properties();
        rbcStar.setProperty("NAME", "*");
        tmpProps.add(rbcStar);
    }

    private void addEventRbcs(HashSet<Properties> rbcs) {
        this.addRbcsWithMessage(rbcs, this.getEventSchedules());
    }

    private void addRbcsWithMessage(Set<Properties> rbcs, List<EventScheduling.Scheduling> schedules) {
        for (EventScheduling.Scheduling schedule : schedules) {
            for (Properties rbc : schedule.getRuleBasedCalendars()) {
                rbcs.add(rbc);
                this.addMessage("INF16002", "event trigger", schedule.getScheduleCriteria().getFirst(), rbc.getProperty("NAME"));
            }
        }
        if (rbcs.isEmpty() && this.isFolder()) {
            rbcs.add(RbcGenerator.getEmptyRbc());
        }
    }

    private void addRbcsOfChildren(HashSet<Properties> tmpProps) {
        List<DSeriesJob> dseriesChildren = Optional.ofNullable(this.children).orElse(Collections.emptyList()).stream().map(DSeriesJob.class::cast).toList();
        for (DSeriesJob child : dseriesChildren) {
            if (child.getMyRbcs() == null) continue;
            Set<Properties> childRbcs = child.getMyRbcs();
            for (Properties childRbc : childRbcs) {
                if (childRbc.getProperty("NAME").startsWith("!")) continue;
                tmpProps.add(childRbc);
            }
        }
    }

    private void addSchedulesRbcs(HashSet<Properties> tmpProps, String applicationCalendar) {
        if (this.myRbcs != null) {
            tmpProps.addAll(this.myRbcs);
        } else if (!this.isJob()) {
            this.getDefault("schedules").ifPresent(defaultSched -> {
                this.myRbcs = this.defs.getRbcGenerator().getRbcs((Node)defaultSched);
                this.defs.getRbcGenerator().addMessages((Node)defaultSched, (List<String>)this.getMessages(), this.getJobFullPathName(), applicationCalendar);
                tmpProps.addAll(this.myRbcs);
            });
        }
    }

    private boolean hasIncludeRBCs(HashSet<Properties> propsRBCHashSet) {
        return propsRBCHashSet.stream().anyMatch(prop -> !prop.getProperty("NAME").startsWith("!"));
    }

    private String getDefaultAppAgent(Node rununitNode) {
        return XmlElement.ofNullable((Element)((Element)rununitNode)).getAllDirectchildsElement().stream().findFirst().map(XmlElement::getText).orElse("");
    }

    private Set<Properties> getMyRbcs() {
        return this.myRbcs;
    }

    public List<Properties> getQuantResources() {
        return this.quantitativeResources == null ? null : new ArrayList<Properties>(this.quantitativeResources);
    }

    public List<Properties> getCtrlResources() {
        return this.controlResources;
    }

    public void addControlResource(Properties controlResource) {
        this.controlResources.add(controlResource);
    }

    public List<Properties> getOnStmt() {
        return Collections.emptyList();
    }

    public List<Properties> getShouts() {
        return new NotificationsConvertor(this).convert();
    }

    public String getJobName() {
        if (this.type() == SchedEntity.TYPE.SMART_TABLE) {
            return this.getAttr(SMART_TABLE_NAME);
        }
        return this.getAttr("JOBNAME");
    }

    public String getOriginalJobName() {
        String toRet = this.fieldValues.getCompetitorValue("jobname");
        String qualifier = this.fieldValues.getCompetitorValue("qualifier");
        if (qualifier != null) {
            toRet = String.format("%s.%s", toRet, qualifier);
        }
        return this.resolveStringsSuppressMessage(toRet, false);
    }

    public String getParentName() {
        if (this.parent == null) {
            return "";
        }
        if (this.isDSJob()) {
            Object parentName = this.parent.getParentName();
            if (!((String)parentName).isEmpty()) {
                parentName = (String)parentName + "/";
            }
            parentName = (String)parentName + this.parent.getJobName();
            return parentName;
        }
        return this.parent.getAttr("FOLDER_MF_NAME");
    }

    public String getTablePathForSons() {
        return null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setNotValid() {
        this.isValid = false;
    }

    public boolean hasWarnings() {
        boolean hasWarnings = false;
        if (this.hasMessages()) {
            for (String msg : this.messages) {
                if (!msg.split(",", 3)[1].equals("W")) continue;
                hasWarnings = true;
                break;
            }
        }
        return hasWarnings;
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public boolean isDSJob() {
        return this.isDsJob;
    }

    public String getTableName() {
        return this.type() == SchedEntity.TYPE.SMART_TABLE || this.parent == null ? this.getJobName() : this.parent.getJobName();
    }

    public boolean isCyclic() {
        return this.cyclicSchedulingHandler.isCyclic();
    }

    public String applyFieldConversion(String field) {
        return null;
    }

    public String getApplication() {
        return this.getAttr("APPLICATION");
    }

    public String getGroup() {
        return this.getAttr("GROUP");
    }

    public LinkedHashMap<String, String> getAutoedits() {
        if (this.autoedits == null) {
            this.autoedits = new LinkedHashMap();
        }
        return this.autoedits;
    }

    public List<String> getOptionalAttributes() {
        ArrayList<String> toRet = null;
        if (this.optionalAttrs != null) {
            toRet = new ArrayList<String>(this.optionalAttrs);
        }
        return toRet;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public String getJobFullPathName() {
        if (this.parent == null) {
            return this.getOriginalJobName();
        }
        return this.parent.getJobFullPathName() + "/" + this.getOriginalJobName();
    }

    public DSeriesJob getParent() {
        return this.parent;
    }

    public String getOrigJobType() {
        return NodeNameGetter.get(this.getOriginalNode());
    }

    private BooleanSupplier shouldGetNotificationDefaultsFromParentFor(String notificationType) {
        String notificationDefaultAttribute = notificationType.equals(ALERT_NOTIFICATION) ? "alert_notifynodefaults" : "notifynodefaults";
        return DseriesGlobals.findChildNodeDFS(this.jobNode, notificationDefaultAttribute).map(node -> node.getTextContent().trim()).map(content -> () -> content.equalsIgnoreCase("false")).orElse(() -> true);
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        this.convertNotificationsToOnDos(EMAIL_NOTIFICATION, "notifylist");
        this.convertNotificationsToOnDos(ALERT_NOTIFICATION, "alert_notifylist");
        Map<Properties, List<Properties>> onDoStatements = this.getDependenyConvertor().getOnDoStatements(this);
        if (onDoStatements != null) {
            for (Map.Entry<Properties, List<Properties>> onDoStatement : onDoStatements.entrySet()) {
                Properties on = onDoStatement.getKey();
                List<Properties> dos = onDoStatement.getValue();
                this.onDoStmts.computeIfAbsent(on, k -> new ArrayList()).addAll(dos);
            }
        }
        this.putJobsNumberOfFailuresOnDoActionsToEnd();
        this.removeDuplicatedActions(this.onDoStmts);
        return this.onDoStmts;
    }

    private void removeDuplicatedActions(LinkedHashMap<Properties, List<Properties>> onDoStmts) {
        for (Map.Entry<Properties, List<Properties>> entry : onDoStmts.entrySet()) {
            Properties on = entry.getKey();
            List uniqueValue = onDoStmts.get(on).stream().distinct().collect(Collectors.toList());
            onDoStmts.put(on, uniqueValue);
        }
    }

    private void putJobsNumberOfFailuresOnDoActionsToEnd() {
        List<Map.Entry> jobsNumberOfFailuresOnDos = this.onDoStmts.entrySet().stream().filter(entry -> Optional.ofNullable(((Properties)entry.getKey()).getProperty("CODE")).filter(code -> code.startsWith("FAILCOUNT=")).isPresent()).toList();
        jobsNumberOfFailuresOnDos.forEach(onDo -> this.onDoStmts.put((Properties)onDo.getKey(), (List)this.onDoStmts.remove(onDo.getKey())));
    }

    public void addOnDoStmts(Map<Properties, List<Properties>> toAdd) {
        this.onDoStmts.putAll(toAdd);
    }

    public XmlElement getRootElement() {
        return new XmlElement((Element)this.getOriginalNode());
    }

    private void convertNotificationsToOnDos(String notificationType, String notificationListType) {
        if (!this.notifications.containsKey(notificationType)) {
            Optional<Node> defNotifyList = this.getDefault(notificationListType, this.shouldGetNotificationDefaultsFromParentFor(notificationType));
            defNotifyList.ifPresent(notifyList -> this.addNotifyListToNotifications((Node)notifyList, notificationType, Collections.emptyList()));
        }
        if (this.notifications.containsKey(notificationType)) {
            for (ConvertedNotification notification : this.notifications.get(notificationType)) {
                Map<Properties, Properties> onDos = notification.getOnDo();
                for (Map.Entry<Properties, Properties> onDo : onDos.entrySet()) {
                    Properties on = onDo.getKey();
                    Properties dos = onDo.getValue();
                    this.onDoStmts.computeIfAbsent(on, k -> new ArrayList()).add(dos);
                }
            }
        }
    }

    private void addNotifyListToNotifications(Node notifyList, String notifyType, List<Node> allNodes) {
        for (Node notifyNode = notifyList.getFirstChild(); notifyNode != null; notifyNode = notifyNode.getNextSibling()) {
            if (notifyNode.getNodeType() != 1 || !DseriesGlobals.elemntNameMatch(notifyNode, notifyType)) continue;
            this.notifications.computeIfAbsent(notifyType, k -> new ArrayList()).add(new ConvertedNotification(notifyNode, notifyType, this, allNodes));
        }
    }

    public RulesDataSet getRules() {
        return this.defs.getRules();
    }

    public void addMessage(String msgid, String ... stringsArr) {
        Reporter.addMessage(this.messages, (String)msgid, (String)this.getJobFullPathName(), (String[])stringsArr);
    }

    public void addAttribute(String key, String value) {
        this.ctmJobAttributes.setProperty(key, value);
    }

    public void addAutoEdits(String key, String value) {
        if (value != null) {
            this.autoedits.put(key, value);
        }
    }

    public void addAllAutoEdits(Map<String, String> newAutoedits) {
        this.autoedits.putAll(newAutoedits);
    }

    public void removeAutoEdits(String key) {
        this.autoedits.remove(key);
    }

    public Properties getCtmJobAttributes() {
        return this.ctmJobAttributes;
    }

    public Node getOriginalNode() {
        return this.originalNode;
    }

    public void setAttribute(String attrName, String attrValue) {
        this.ctmJobAttributes.put(attrName, attrValue);
    }

    public void setMfJob() {
        this.isDsJob = false;
    }

    public void handleExternalOutCondition() {
        if (this.hasExternalAlert()) {
            this.addExternalOutCondition();
        }
    }

    private boolean hasExternalAlert() {
        return DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "alert_notifylist").map(alertNotifylist -> DSeriesJob.nodeListToList(alertNotifylist.getChildNodes())).map(childNodes -> childNodes.stream().flatMap(alertNotify -> DseriesGlobals.findChildNodeDFS(alertNotify, "alert").stream()).map(Node::getTextContent).anyMatch("EXTERNAL"::equals)).orElse(false);
    }

    private void addExternalOutCondition() {
        String predecessorName = this.dependencyConvertor.jobPathOf("", this.getOriginalJobName(), "");
        String conditionName = this.dependencyConvertor.buildConditionName(predecessorName, "$EXTERNAL", "-OK");
        Properties outCondition = this.dependencyConvertor.buildOutCondition(conditionName);
        this.outConditions.add(outCondition);
    }

    private void addWarningForOnEnterAndOnLoadScripts() {
        Optional<String> onEnterScript = DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "on_enter").map(n -> XmlElement.ofNullable((Element)((Element)n))).map(n -> n.getFirstChildElementByName("script_definition")).map(XmlElement::getText);
        Optional<String> onLoadScript = DseriesGlobals.findChildNodeDFS(this.getOriginalNode(), "on_load").map(n -> XmlElement.ofNullable((Element)((Element)n))).map(n -> n.getFirstChildElementByName("script_definition")).map(XmlElement::getText);
        onEnterScript.ifPresent(script -> this.addMessage("WRN16028", this.getJobName(), this.getOriginalJobName(), (String)script));
        onLoadScript.ifPresent(script -> this.addMessage("WRN16027", this.getJobName(), this.getOriginalJobName(), (String)script));
    }

    public static class NodeNameGetter {
        private NodeNameGetter() {
        }

        public static String get(Node originalNode) {
            return originalNode.getNodeName().trim().replaceAll("^\\s*app:\\s*", "").trim();
        }
    }

    public static class ExtrnalJobPredicate
    implements Predicate<Node> {
        public static boolean isExternalJob(Node node) {
            ExtrnalJobPredicate predicate = new ExtrnalJobPredicate();
            return predicate.test(node);
        }

        @Override
        public boolean test(Node node) {
            String origJobType = NodeNameGetter.get(node);
            return List.of(DseriesGlobals.JOB_TYPES_ENUM.EXT_JOB.toString(), DseriesGlobals.JOB_TYPES_ENUM.EXTMON_JOB.toString()).contains(origJobType);
        }
    }
}

