/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.w3c.dom.Node;

public class DSeriesFtpConvertor {
    private LinkedHashMap<String, String> autoedits;
    private DSeriesJob dSeriesJob;
    private Node originalNode;
    private String ftpType;
    private Properties attributes;

    public DSeriesFtpConvertor(DSeriesJob dSeriesJob, Node originalNode, String jobType) {
        this.dSeriesJob = dSeriesJob;
        this.originalNode = originalNode;
        this.autoedits = dSeriesJob.getAutoedits();
        this.attributes = dSeriesJob.getCtmJobAttributes();
        this.ftpType = jobType;
    }

    public void convert() {
        this.addFileTransferDefaultAttribute();
        this.addFileTransferDefaultVariables();
        this.addFileTransferVariables();
        this.addAction();
    }

    private void addFileTransferVariables() {
        this.checkAndInsertAutoedit("%%FTP-TYPE1", this.getFtpMode());
        this.checkAndInsertAutoedit("%%FTP-UPLOAD1", this.getDirection());
        this.checkAndInsertAutoedit("%%FTP-RPATH1", this.getRemote());
        this.checkAndInsertAutoedit("%%FTP-LPATH1", this.getNodeContent("localname"));
        this.checkAndInsertAutoedit("%%FTP-ACCOUNT", this.getConnectionProfile());
    }

    private String getRemote() {
        Object remote = "";
        remote = this.isSFTP() ? this.getNodeContent("remotedir") + this.getNodeContent("remotefile") : this.getNodeContent("remotename");
        return remote;
    }

    private boolean isSFTP() {
        return this.ftpType.equals("sftp_job");
    }

    private String getNodeContent(String nodeType) {
        Node fileNameNode = DseriesGlobals.findChildNodeDFS(this.originalNode, nodeType, null, null);
        return fileNameNode != null ? fileNameNode.getTextContent() : "NULL";
    }

    private String getFtpMode() {
        String type = this.getNodeContent("transfertype");
        if (type.equalsIgnoreCase("b")) {
            type = "I";
        }
        return type;
    }

    private String getConnectionProfile() {
        Object connectionProfile = "";
        String userID = this.getNodeContent("userid");
        String host = this.getNodeContent("serveraddress");
        connectionProfile = userID.equals("NULL") || host.equals("NULL") ? (String)connectionProfile + "DEF_CON_PROFILE" : (String)connectionProfile + this.converteToLegalCP(userID, host);
        return connectionProfile;
    }

    private String getDirection() {
        String direction = this.getNodeContent("transferdirection");
        if ("DOWNLOAD".equals(direction)) {
            direction = "0";
        } else if ("UPLOAD".equals(direction)) {
            direction = "1";
        }
        return direction;
    }

    private void addFileTransferDefaultVariables() {
        this.autoedits.put("%%FTP-TYPE1", "I");
        this.autoedits.put("%%FTP-PATH", "Not in use for application jobs");
        this.autoedits.put("%%FTP-LPASSIVE", "0");
        this.autoedits.put("%%FTP-RPASSIVE", "0");
        this.autoedits.put("%%FTP-UPLOAD1", "1");
        this.autoedits.put("%%FTP-TIMELIMIT_UNIT1", "1");
        this.autoedits.put("%%FTP-TIMELIMIT1", "0");
        this.autoedits.put("%%FTP-ABSTIME1", "0");
        this.autoedits.put("%%FTP-OVERRIDE_WATCH_INTERVAL1", "0");
        this.autoedits.put("%%FTP-WATCH_INTERVAL1", "30");
        this.autoedits.put("%%FTP-IF_EXIST1", "0");
        this.autoedits.put("%%FTP-DSTOPT1", "0");
        this.autoedits.put("%%FTP-UNIQUE1", "0");
        this.autoedits.put("%%FTP-TRIM1", "1");
        this.autoedits.put("%%FTP-FLDS1", "0");
        this.autoedits.put("%%FTP-VERNUM1", "0");
        this.autoedits.put("%%FTP-EXCLUDE_WILDCARD1", "0");
        this.autoedits.put("%%FTP-CASEIFS1", "0");
        this.autoedits.put("%%FTP-TRANSFER_NUM", "1");
        this.autoedits.put("%%FTP-CONT_EXE_NOTOK", "0");
        this.autoedits.put("%%FTP-RPF", "0");
        this.autoedits.put("%%FTP-USE_DEF_NUMRETRIES", "0");
        this.autoedits.put("%%FTP-NUM_RETRIES", "5");
        this.autoedits.put("%%FTP-Is", "5");
        this.autoedits.put("%%FTP-AUTOREFRESH", "False");
    }

    private void addFileTransferDefaultAttribute() {
        this.attributes.setProperty("TASKTYPE", "Job");
        this.attributes.setProperty("APPL_FORM", "AFT");
        this.attributes.setProperty("APPL_TYPE", "FILE_TRANS");
        this.attributes.setProperty("APPL_VER", "6.1.01");
        this.attributes.setProperty("CM_VER", "610");
    }

    private void checkAndInsertAutoedit(String filed, String attr) {
        if (!attr.equals("NULL")) {
            this.autoedits.put(filed, attr);
        }
    }

    private String converteToLegalCP(String localUser, String serverName) {
        String connectionProfile = localUser + "_" + serverName;
        if (this.isSFTP()) {
            connectionProfile = connectionProfile + "_sftp";
        }
        return this.replaceIlleaglCharacters(connectionProfile);
    }

    private void addAction() {
        HashMap<String, String> AFTAction = new HashMap<String, String>();
        AFTAction.put("ACTENTTYPE", "AFTACC");
        AFTAction.put("JOBID", this.dSeriesJob.getAttr("JOBNAME"));
        AFTAction.put("ACTENTNAME", this.getConnectionProfile());
        AFTAction.put("ACTSTATUS", "0");
        Reporter.addAction(AFTAction);
    }

    private String replaceIlleaglCharacters(String connectionProfile) {
        return connectionProfile.replaceAll("[^(A-Za-z0-9\\_)]", "_");
    }
}

