/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.NotificationsConvertor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.w3c.dom.Node;

public class ConvertedNotification {
    static final String partiallySupportedState = "SUBERROR";
    static final List<String> OK_STATES = List.of("COMPLETE", "COMPLETED");
    static final List<String> NOT_OK_STATES = List.of("FAIL", "FAILED", "SUBERROR");
    private static final String DEFAULT_SUBJECT = "Default subject for notifications";
    private static final String DEFAULT_MESSAGE = "Default message for %%JOBNAME";
    private static final List<String> NOTIFICATION_STATES = List.of("OVERDUE", "PREMEND");
    private final List<Node> allNodes;
    Node sourceNode;
    String notifyType;
    DSeriesJob caller;
    HashMap<String, List<String[]>> messages;

    public ConvertedNotification(Node notifyNode, String notifyType, DSeriesJob caller, List<Node> allNodes) {
        this.sourceNode = notifyNode;
        this.notifyType = notifyType;
        this.messages = new HashMap();
        this.caller = caller;
        this.allNodes = allNodes;
    }

    public Map<Properties, Properties> getOnDo() {
        LinkedHashMap<Properties, Properties> toRet = new LinkedHashMap<Properties, Properties>();
        this.getOnDoBy(this.notifyType).ifPresent(doStmt -> {
            for (Properties on : this.notifyToOnList()) {
                toRet.put(on, (Properties)doStmt);
            }
        });
        return toRet;
    }

    private Optional<Properties> getOnDoBy(String notifyType) {
        if (notifyType.equals("notify")) {
            return this.createEmailNotification();
        }
        return this.createAlertNotification();
    }

    private Optional<Properties> createAlertNotification() {
        boolean notifyAlertOnLastFailureOnly = this.shouldNotifyOnlLastFor("last_notify_alerts");
        if (!notifyAlertOnLastFailureOnly) {
            return Optional.of(this.notifyAlertToDoShout());
        }
        return Optional.empty();
    }

    private Optional<Properties> createEmailNotification() {
        boolean notifyEmailOnLastFailureOnly = this.shouldNotifyOnlLastFor("last_notify_email");
        if (!notifyEmailOnLastFailureOnly) {
            return Optional.of(this.notifyToDomailStmts());
        }
        return Optional.empty();
    }

    private boolean shouldNotifyOnlLastFor(String attribute) {
        Optional<Node> retryNode = this.getRetryNode(this.allNodes);
        Optional<Boolean> attributeValue = retryNode.map(node -> DseriesGlobals.findChildNodeDFS(node, attribute, null, null)).map(Node::getTextContent).map(String::trim).map(value -> value.equalsIgnoreCase("true"));
        return attributeValue.orElse(false);
    }

    private Optional<Node> getRetryNode(List<Node> allNodes) {
        return allNodes.stream().filter(n -> n.getNodeName().equals("retry") || n.getNodeName().equals("app:retry")).findFirst();
    }

    private List<Properties> notifyToOnList() {
        return GlobalFunctions.concatLists(this.handleReturnCode(), this.handleMonitorState());
    }

    private List<Properties> handleMonitorState() {
        ArrayList<Properties> onList = new ArrayList<Properties>();
        List<String> states = DseriesGlobals.getChildValues(DseriesGlobals.findChildNodeDFS(this.sourceNode, "monitor_states", null, null), "monitor_state");
        for (String state : states) {
            Optional<String> onCode = this.getOnCodeByMonitorState(state = this.caller.resolveStrings(state, "monitor state").toUpperCase());
            if (onCode.isPresent()) {
                Properties onState = new Properties();
                onState.setProperty("STMT", "*");
                onState.setProperty("CODE", onCode.get());
                if (partiallySupportedState.equals(state)) {
                    Reporter.addMessage(this.caller.getMessages(), (String)"INF16004", (String)this.caller.getJobFullPathName(), (String[])new String[]{state, onCode.get()});
                }
                onList.add(onState);
                continue;
            }
            if (NOTIFICATION_STATES.contains(state)) continue;
            this.issueMessageForNonSupportedMonitorState(state);
        }
        return onList;
    }

    private void issueMessageForNonSupportedMonitorState(String state) {
        if (state.equals("EXEC")) {
            Reporter.addMessage(this.caller.getMessages(), (String)"WRN16013", (String)this.caller.getJobFullPathName(), (String[])new String[]{this.caller.getJobName()});
        } else {
            Reporter.addMessage(this.caller.getMessages(), (String)"INF16006", (String)this.caller.getJobFullPathName(), (String[])new String[]{state});
        }
    }

    private List<Properties> handleReturnCode() {
        String rc = this.getChildNodeValue(this.sourceNode, "returncode");
        if (!rc.isEmpty()) {
            rc = this.caller.resolveStrings(rc, "Notification return code");
            Properties onRc = new Properties();
            onRc.setProperty("CODE", String.format("COMPSTAT EQ %s", rc));
            onRc.setProperty("STMT", "*");
            return List.of(onRc);
        }
        return Collections.emptyList();
    }

    private Properties notifyAlertToDoShout() {
        String dest = this.getChildNodeValue(this.sourceNode, "alert");
        dest = this.caller.resolveStrings(dest, "alert destination");
        Properties doShout = new Properties();
        doShout.setProperty("ACTION", "DOSHOUT");
        doShout.setProperty("DEST", dest);
        doShout.setProperty("MESSAGE", "Alert for %%JOBNAME");
        doShout.setProperty("URGENCY", this.getUrgency());
        HashMap<String, String> shoutAction = new HashMap<String, String>();
        shoutAction.put("ACTENTTYPE", "SHOUT");
        shoutAction.put("JOBID", this.caller.getJobFullPathName());
        shoutAction.put("ACTENTNAME", dest);
        shoutAction.put("ACTSTATUS", "0");
        Reporter.addAction(shoutAction);
        return doShout;
    }

    private Properties notifyToDomailStmts() {
        List<String> recipientsList = DseriesGlobals.getChildValues(DseriesGlobals.findChildNodeDFS(this.sourceNode, "mailaddresslist", null, null), "mailaddress");
        String attachSysout = this.getChildNodeValue(this.sourceNode, "attachspoolfile");
        attachSysout = attachSysout.equalsIgnoreCase("Y") ? "Yes" : (attachSysout.equalsIgnoreCase("N") ? "No" : "Default");
        String subject = this.getChildNodeValue(this.sourceNode, "email_subject");
        subject = this.caller.resolveStrings(subject, true, "notification mail subject");
        String message = this.getChildNodeValue(this.sourceNode, "emailtext");
        message = this.caller.resolveStrings(message, true, "notification mail message");
        StringBuilder recipients = new StringBuilder();
        for (String recipient : recipientsList) {
            recipient = this.caller.resolveStrings(recipient, true, "notification mail recipient");
            if (recipients.length() != 0) {
                recipients.append(";");
            }
            recipients.append(recipient);
        }
        Properties domail = new Properties();
        domail.setProperty("ACTION", "DOMAIL");
        domail.setProperty("DEST", recipients.toString());
        domail.setProperty("URGENCY", this.getUrgency());
        domail.setProperty("SUBJECT", subject.isEmpty() ? DEFAULT_SUBJECT : subject);
        domail.setProperty("MESSAGE", message.isEmpty() ? DEFAULT_MESSAGE : message);
        domail.setProperty("ATTACH_SYSOUT", attachSysout);
        return domail;
    }

    private String getUrgency() {
        return NotificationsConvertor.getUrgencyFrom(Optional.ofNullable(this.caller.getRootElement()));
    }

    private String getChildNodeValue(Node root, String childNodeName) {
        Optional<Node> childNode = DseriesGlobals.findChildNodeDFS(root, childNodeName);
        return childNode.map(Node::getTextContent).orElse("");
    }

    private Optional<String> getOnCodeByMonitorState(String monitorState) {
        if (OK_STATES.contains(monitorState)) {
            return Optional.of("OK");
        }
        if (NOT_OK_STATES.contains(monitorState)) {
            return Optional.of("NOTOK");
        }
        return Optional.empty();
    }
}

