/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConditionalScheduleHandler {
    public static final Pattern EVENT_PATTERN = Pattern.compile("%IF\\s*\\(APPL\\._eventname\\s*(?<operator>==|!=)\\s*'(?<eventName>[^']+)'([^)]+)?\\)");
    public static final Pattern EVENT_NAME_PATTERN = Pattern.compile("(?<applicationName>[^.])\\.(?<eventName>.*)");
    public static final Predicate<String> ALWAYS_MEET_CONDITION = eventName -> true;
    private final DSeriesJob job;

    public ConditionalScheduleHandler(DSeriesJob job) {
        this.job = job;
    }

    public void handle() {
        if (!this.meetsEventCondition()) {
            this.job.setNotValid();
        }
    }

    private boolean meetsEventCondition() {
        Predicate<String> eventCondition = this.getEventCondition();
        String jobEventName = this.getJobEventName();
        return eventCondition.test(jobEventName);
    }

    private Predicate<String> getEventCondition() {
        String condition = this.getCondition();
        Matcher matcher = EVENT_PATTERN.matcher(condition);
        if (matcher.find()) {
            String operation = matcher.group("operator");
            String eventName = matcher.group("eventName");
            return ConditionalScheduleHandler.createEventConditionPredicate(eventName, OPERATOR.from(operation));
        }
        return ALWAYS_MEET_CONDITION;
    }

    private String getJobEventName() {
        String jobEventName = this.job.getEventName();
        Matcher matcher = EVENT_NAME_PATTERN.matcher(jobEventName);
        if (matcher.find()) {
            return matcher.group("eventName");
        }
        return jobEventName;
    }

    private String getCondition() {
        Optional<XmlElement> schedules = Optional.ofNullable(this.job.getRootElement().getFirstChildElementByName("app:schedules"));
        Optional<XmlElement> run = schedules.map(d -> d.getFirstChildElementByName("app:run"));
        return run.map(r -> r.getFirstChildElementByName("app:schedule")).map(XmlElement::getText).orElse("");
    }

    private static Predicate<String> createEventConditionPredicate(String eventName, OPERATOR operator) {
        return inputEventName -> switch (operator.ordinal()) {
            case 0 -> eventName.equals(inputEventName);
            case 1 -> {
                if (!eventName.equals(inputEventName)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    static enum OPERATOR {
        EQUALS,
        NOT_EQUALS,
        NONE;


        public static OPERATOR from(String op) {
            if ("==".equals(op)) {
                return EQUALS;
            }
            if ("!=".equals(op)) {
                return NOT_EQUALS;
            }
            return NONE;
        }
    }
}

