#!/usr/bin/python
#coding=utf8

from typing import AsyncContextManager
import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt
from os.path import isfile, join
from os import listdir
import re
import csv


USAGE= "flow-report.py -i <inputfile> [-s <secondinputfile>] -o <reportfile> [-f <foldername>] [-d <same/no>]"
def main(argv):
    input_file =  'prod\\MF.XML'
    second_input_file = 'prod\\DS.XML'
    output_report = 'flow_report.csv'
    global only_folder
    only_folder = ''
    global exclude_folder_list
    exclude_folder_list = []
    # exclude_folder_list = ['PFSRSPRQ', 'PNSC0529']
    global display_same
    display_same = False
    try:
        opts, args = getopt.getopt(argv,"hi:o:f:s:d:",["ifile=","orep=","folder="])
    except getopt.GetoptError:
        print (USAGE)
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print (USAGE)
            sys.exit()
        elif opt in ("-i", "--ifile"):
            input_file = arg
        elif opt in ("-s"):
            second_input_file = arg
        elif opt in ("-o", "--orep"):
            output_report= arg
        elif opt in ("-f", "--folder"):
            only_folder = arg.upper()
        elif opt == '-d':
            if arg == 'same':
                display_same = True
    print ('Input file from is: ' + input_file)
    if (len(second_input_file) > 0 ):
        print ('second input file is: ' + second_input_file)
    print ('Output report is: ' + output_report)
    if (len(only_folder) > 0 ):
        print ('Only folder is: ' + only_folder)

    tree = ET.parse(input_file); print("Read the input file: " + input_file)
    root = tree.getroot()

    if (len(second_input_file) > 0 ):
        tree_second = ET.parse(second_input_file); print("Read the second input file: " + second_input_file)
        root_second = tree_second.getroot()
        merge_trees(root, root_second)

    header = ['folder-name', 'jobname','level', 'job-type','same', 'schedule', 'Successor', 'Successor-folder', 'Successor-type', 'Successor-schedule', 'Successor-Description', 'Description']
    with open(output_report, 'w', encoding='UTF8', newline='') as csv_report:
        csv_writer = csv.writer(csv_report)
        csv_writer.writerow(header)
        process_all_folders(root, csv_writer)

def process_all_folders(root, csv_writer):
    in_cond_dict = build_in_cond_dict(root); print("in cond dict created")
    for folder in root.iter('SMART_FOLDER'):
        process_folder(folder, root, csv_writer, in_cond_dict)
    for folder in root.iter('FOLDER'):
        process_folder(folder, root, csv_writer, in_cond_dict)
    return

def process_folder(folder, root, csv_writer, in_cond_dict):
    global only_folder
    global exclude_folder_list
    folder_name = folder.attrib['FOLDER_NAME']
    if (len(only_folder) > 0 ): 
        if (folder_name != only_folder):
            return
    if folder_name in exclude_folder_list:
        return
    jobs_with_no_condition_list = get_jobs_with_no_condition_list(folder)
    for job in jobs_with_no_condition_list:
        # print(get_jobname(job))
        processed_items = []
        process_job(job, root, 0, folder, csv_writer, processed_items, in_cond_dict)

    return
def process_job(job, root, level, folder, csv_writer, processed_items, in_cond_dict):
    global display_same
    folder_name = folder.attrib['FOLDER_NAME']
    folder_type = folder.attrib['PLATFORM']
    successor_job_list: Successor =[]
    job_scheduling_criteria = get_scheduling_criteria(job)
    processed_items.append(get_jobname(job) + '+' + folder_name)
    out_cond_list = get_out_cond_list(job)
    for cond in out_cond_list:
        try:
            sjl = in_cond_dict[get_cond_name(cond)]
        except KeyError:
            # print("No job with in-cond for {} of job {}".format(get_cond_name(cond), get_jobname(job)))
            sjl = []
        successor_job_list.extend(sjl)
    for successor in successor_job_list:
        successor_job = successor.job
        successor_folder = successor.folder

        # print('level {} folder {} job {} type {} has {} as successor'.format(level, folder_name, get_jobname(job),folder_type, get_jobname(successor_job)))
        successor_job_scheduling_criteria = get_scheduling_criteria(successor_job)
        description = ''
        try:
            description = job.attrib['DESCRIPTION']
        except KeyError:
            description = ''
        successor_description = ''
        try:
            successor_description = successor_job.attrib['DESCRIPTION']
        except KeyError:
            successor_description = ''
        successor_folder_name = successor_folder.attrib['FOLDER_NAME']
        # if (successor_folder_name == folder_name):
        #     successor_folder_name = ''
        successor_folder_type = successor_folder.attrib['PLATFORM']
        # if (successor_folder_type == folder_type):
        #     successor_folder_type = ''

        same = ''
        job_scheduling_criteria_display = job_scheduling_criteria
        if (job_scheduling_criteria == successor_job_scheduling_criteria):
            same = 'same'
            job_scheduling_criteria_display = ''
            successor_job_scheduling_criteria = ''
        else: 
            if (level == 0):
                same = 'Level1 / Level2'
        if same != 'same' or display_same:
            csv_writer.writerow([folder_name, get_jobname(job), level,  folder_type, same, \
                job_scheduling_criteria_display, get_jobname(successor_job),\
                successor_folder_name, successor_folder_type, successor_job_scheduling_criteria, \
                successor_description, description])

        if (get_jobname(successor_job) + '+' + successor_folder_name in processed_items):
            print('when processing job {} in folder {}, Job {} in folder {} skipped since it had been processed earlier '.format(get_jobname(job), folder_name, get_jobname(successor_job), successor_folder_name))
            return
        process_job(successor_job, root, level + 1, successor_folder, csv_writer, processed_items, in_cond_dict)
    return

def get_scheduling_criteria(job):
    scheduling_criteria = ''
    for rbc in job.iter('RULE_BASED_CALENDARS'):
        scheduling_criteria = scheduling_criteria + 'RBC=' + rbc.attrib['NAME'] + ' '
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'DAYS')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'DAYSCAL')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'DAYS_AND_OR')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'WEEKDAYS')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'WEEKSCAL')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'CONFCAL')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'SHIFT')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'SHIFTNUM')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'JAN')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'FEB')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'MAR')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'APR')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'MAY')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'JUN')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'JUL')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'AUG')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'SEP')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'OCT')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'NOV')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'DEC')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'SAC')
    scheduling_criteria = scheduling_criteria + get_scheduling_attribute(job,'RULE_BASED_CALENDAR_RELATIONSHIP')
    
    return scheduling_criteria.strip()

def get_scheduling_attribute(job,attr):
    try:
        attr_and_value = attr + '=' + job.attrib[attr] + ' '
    except KeyError:
        attr_and_value = ''
    return attr_and_value

def build_in_cond_dict(root):
    in_cond_dict = {}
    for folder in root.iter('SMART_FOLDER'):
        for job in folder.iter('JOB'):
            for in_cond in job.iter('INCOND'):
                cond_name = get_cond_name(in_cond)
                if not (cond_name in in_cond_dict):
                    in_cond_dict[cond_name] = []
                in_cond_dict[cond_name].append(Successor(job, folder))
    for folder in root.iter('FOLDER'):
        for job in folder.iter('JOB'):
            for in_cond in job.iter('INCOND'):
                cond_name = get_cond_name(in_cond)
                if not in_cond_dict.has_key(cond_name):
                    in_cond_dict[cond_name] = []
                in_cond_dict[cond_name].append(Successor(job, folder))
    return in_cond_dict

def get_cond_name(cond):
    return cond.attrib['NAME'] + '+' + cond.attrib['ODATE']



def get_out_cond_list(job):
    out_cond_list = []
    for cond in job.iter('OUTCOND'):
        if (cond.attrib['SIGN'] == '+' or cond.attrib['SIGN'].startswith('A')):
            out_cond_list.append(cond)
    return out_cond_list

def get_jobs_with_no_condition_list(folder):
    jobs_with_no_condition_list = []
    for job in folder.iter('JOB'):
        job_has_no_in_cond: bool  = True
        for cond in job.iter('INCOND'):
            # print('incond:{}'.format(cond.attrib['NAME']))
            job_has_no_in_cond = False
        if (job_has_no_in_cond):
            jobs_with_no_condition_list.append(job)
        # else:
        #     print('job with incond:{}'.format(get_jobname(job)))
    return jobs_with_no_condition_list

def get_jobname(job):
    job_name = ''
    try:
        job_name = job.attrib['JOBNAME']
    except KeyError:
        job_name = job.attrib['MEMNAME']
    return job_name

def merge_trees(root, root_ds):
    for folder in root_ds.iter('SMART_FOLDER'):
        root.append(folder)
    for folder in root_ds.iter('FOLDER'):
        root.append(folder)
    return

class Successor:
    def __init__(self, job, folder):
        self.job = job
        self.folder = folder
    def __eq__(self, obj):
        return (get_jobname(self.job) == get_jobname(obj.job)) and (self.folder.attrib['FOLDER_NAME'] == obj.folder.attrib['FOLDER_NAME'])


start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")