import csv
import os
import sys

def summarize_csv(csv_filename, csv_messages_path, output_allCount, output_wrnCount):
    MSGID_counts = {}
    WRN0002_types_count ={}
    messages_texts ={}

    with open(csv_messages_path, "r", newline="") as csvfile:
        csvreader = csv.reader(csvfile)
        next(csvreader)
        for row in csvreader:
            messages_texts[row[1]] = row[4]

    with open(csv_filename, "r", newline="") as csvfile:
        csvreader = csv.reader(csvfile)
        next(csvreader)
        for row in csvreader:
            MSGID = row[1]
            if len(row) >= 11:
                attrName = row[9]
                value = row[10]
            MSGID_counts[MSGID] = MSGID_counts.get(MSGID, 0) + 1
            if MSGID == "WRN0002":
                  WRN0002_types_count[attrName+"#"+value] = WRN0002_types_count.get(attrName+"#"+value, 0) + 1

    # write to a new CSV file
    with open(output_allCount, "w", newline="") as outfile:
        csvwriter = csv.writer(outfile)
        csvwriter.writerow(["MSGID", "MSGTEXT", "Count"])

        for MSGID, count in MSGID_counts.items():
            csvwriter.writerow([MSGID, messages_texts[MSGID], count])

    with open(output_wrnCount, "w", newline="") as outfile:
        csvwriter = csv.writer(outfile)
        csvwriter.writerow(["Attribute_name#value", "Count"])

        for type, count in WRN0002_types_count.items():
            csvwriter.writerow([type, count])

if __name__ == "__main__":
    if len(sys.argv) != 5:
        print("Usage: python count_results_messages.py <csv_path> <output_csv> <output_csv>")
    else:
        csv_path = sys.argv[1]
        csv_messages_path = sys.argv[2]
        output_allCount = sys.argv[3]
        output_wrnCount = sys.argv[4]

        if not os.path.isfile(csv_path):
            print("Error: The specified path is not a valid file.")
        else:
            summarize_csv(csv_path, csv_messages_path, output_allCount, output_wrnCount)
            print(f"Summary written to {output_allCount}, and WRN0002 Summary written to {output_wrnCount}")