@echo off

SET CURRENT_DIR=%CD%
SET BATCH_DIR=%~dp0
CD %BATCH_DIR%..\..\..
SET ROOT_DIR=%CD%
CD %CURRENT_DIR%

SETLOCAL

set "VerifySchedulingResults_jarFile=%ROOT_DIR%\lib\Tools\ConversionVerification-ctmconvert-jar-with-dependencies.jar"
IF NOT EXIST "%VerifySchedulingResults_jarFile%" (
    echo.
    echo "%CD%"
    echo The file "%VerifySchedulingResults_jarFile%" was not found
    echo.
)
CD %BATCH_DIR%

IF NOT EXIST "%ROOT_DIR%\JRE" (GOTO PATH_JAVA)

IF "%RUN_MY_JAVA%"=="" GOTO CONVERSION_JAVA
IF %RUN_MY_JAVA% NEQ RUN_MY_JAVA goto CONVERSION_JAVA
GOTO PATH_JAVA

:CONVERSION_JAVA
:: echo using Java from conversion
:: echo 64-bit...
"%ROOT_DIR%\JRE\jre_64\bin\java.exe" -jar "%VerifySchedulingResults_jarFile%" %*
GOTO EXIT

:PATH_JAVA
echo using Java from PATH
java -version >NUL 2>&1
IF %ERRORLEVEL% NEQ 0 goto NO_JAVA

::echo RUN_MY_JAVA = %RUN_MY_JAVA%
java.exe -jar "%VerifySchedulingResults_jarFile%" %*
goto EXIT

:EXIT
ENDLOCAL
SET RC=%errorLevel%
CD %CURRENT_DIR%
echo.
exit /B %RC%

:NO_JAVA
  echo.
  echo This utility requires Java Runtime Environment version 15 or higher.
  echo Make sure Java is installed and configured before rerunning the utility.
  echo.
  pause
  goto EXIT